/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.ModifierPanel;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ModifierEditor
extends JPanel
implements ExPropertyEditor {
    private ModifierPanel panel;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    static final long serialVersionUID = 6324048239020120791L;
    private int mask;
    private int modifier = 0;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$editors$ModifierEditor;

    public ModifierEditor() {
        this(1535);
    }

    public ModifierEditor(int mask) {
        this.setMask(mask & 0x5FF);
        HelpCtx.setHelpIDString((JComponent)this, (String)(class$org$openide$explorer$propertysheet$editors$ModifierEditor == null ? (class$org$openide$explorer$propertysheet$editors$ModifierEditor = ModifierEditor.class$("org.openide.explorer.propertysheet.editors.ModifierEditor")) : class$org$openide$explorer$propertysheet$editors$ModifierEditor).getName());
        this.getAccessibleContext().setAccessibleDescription(ModifierEditor.getString("ACSD_ModifierPanel"));
    }

    public void addNotify() {
        this.setLayout(new BorderLayout());
        this.panel = new ModifierPanel(this);
        this.add((Component)this.panel, "Center");
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        this.remove(this.panel);
        this.panel = null;
    }

    int getMask() {
        return this.mask;
    }

    public void setMask(int mask) {
        if (this.mask != mask) {
            int oldMask = this.mask;
            this.mask = mask & 0x5FF;
            this.support.firePropertyChange("mask", new Integer(oldMask), new Integer(mask));
            this.setModifier(this.modifier & mask);
        }
    }

    int getModifier() {
        return this.modifier;
    }

    void setModifier(int modifier) {
        if (this.modifier != modifier) {
            int oldModifier = this.modifier;
            this.modifier = modifier;
            this.support.firePropertyChange("modifier", new Integer(oldModifier), new Integer(modifier));
            this.support.firePropertyChange("modifiers", new Integer(oldModifier), new Integer(modifier));
        }
    }

    public void setValue(Object object) throws IllegalArgumentException {
        if (object == null) {
            this.setModifier(0);
            return;
        }
        if (!(object instanceof Integer)) {
            throw new IllegalArgumentException();
        }
        this.setModifier((Integer)object);
    }

    public String getJavaInitializationString() {
        return new Integer(this.getModifier()).toString();
    }

    public Object getValue() {
        return new Integer(this.getModifier());
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics g, Rectangle rectangle) {
    }

    public String getAsText() {
        return Modifier.toString(this.getModifier());
    }

    public void setAsText(String string) throws IllegalArgumentException {
        int newValue = 0;
        int oldValue = this.modifier;
        StringTokenizer tukac = new StringTokenizer(string, ", ", false);
        while (tukac.hasMoreTokens()) {
            String token = tukac.nextToken();
            boolean known = false;
            int i = 0;
            while (i < ModifierPanel.MODIFIER_COUNT) {
                if ((ModifierPanel.MODIFIER_VALUES[i] & this.mask) != 0 && token.equals(ModifierPanel.MODIFIER_NAMES[i])) {
                    if (ModifierPanel.MODIFIER_VALUES[i] == 16 && (newValue & 0x400) != 0 || ModifierPanel.MODIFIER_VALUES[i] == 1024 && (newValue & 0x10) != 0) break;
                    newValue |= ModifierPanel.MODIFIER_VALUES[i];
                    known = true;
                    break;
                }
                ++i;
            }
            if ((newValue & 7) == 0) {
                int i2 = 1;
                while (i2 <= 3) {
                    if ((ModifierPanel.ACCESS_VALUES[i2] & this.mask) != 0 && token.equals(ModifierPanel.ACCESS_NAMES[i2])) {
                        newValue |= ModifierPanel.ACCESS_VALUES[i2];
                        known = true;
                        break;
                    }
                    ++i2;
                }
            }
            if (known) continue;
            IllegalArgumentException x = new IllegalArgumentException("Invalid modifier: " + token);
            String message = MessageFormat.format(ModifierEditor.getString("MSG_IllegalModifierString"), token);
            ErrorManager.getDefault().annotate((Throwable)x, 256, null, message, null, null);
            throw x;
        }
        if (oldValue != newValue) {
            this.modifier = newValue;
            this.support.firePropertyChange("modifier", new Integer(oldValue), new Integer(this.modifier));
        }
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.getValue();
    }

    public void attachEnv(PropertyEnv env) {
    }

    private static String getString(String key) {
        return NbBundle.getBundle((String)"org.openide.explorer.propertysheet.editors.Bundle2", (Locale)Locale.getDefault(), (ClassLoader)(class$org$openide$explorer$propertysheet$editors$ModifierEditor == null ? (class$org$openide$explorer$propertysheet$editors$ModifierEditor = ModifierEditor.class$("org.openide.explorer.propertysheet.editors.ModifierEditor")) : class$org$openide$explorer$propertysheet$editors$ModifierEditor).getClassLoader()).getString(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

