/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import java.lang.reflect.Modifier;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.ElementFormat;
import org.openide.src.ElementPrinter;
import org.openide.src.ElementPrinterInterruptException;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.InitializerElement;
import org.openide.src.JavaDoc;
import org.openide.src.JavaDocSupport;
import org.openide.src.MemberElement;
import org.openide.src.MemoryCollection;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.NbBundle;

public final class ClassElement
extends MemberElement {
    public static final boolean CLASS = true;
    public static final boolean INTERFACE = false;
    public static final Identifier ROOT_OBJECT = Identifier.create("java.lang.Object", "Object");
    private static final ElementFormat[] HEADER_FORMAT = new ElementFormat[]{new ElementFormat("{m,,\" \"}class {n}{s,\" extends \",}{i,\" implements \",}"), new ElementFormat("{m,,\" \"}interface {n}{i,\" extends \",}")};
    private SourceElement source;
    static final long serialVersionUID = 1692944638104452533L;
    private static List finders = new LinkedList();
    static /* synthetic */ Class class$org$openide$src$ElementFormat;
    static /* synthetic */ Class class$org$openide$src$ClassElement;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie;

    public ClassElement() {
        this(new Memory(), null, null);
    }

    public ClassElement(Impl impl, ClassElement clazz) {
        this(impl, clazz, clazz.getSource());
    }

    public ClassElement(Impl impl, SourceElement source) {
        this(impl, null, source);
    }

    private ClassElement(Impl impl, ClassElement clazz, SourceElement source) {
        super(impl, clazz);
        this.source = source;
    }

    public Object clone() {
        Memory mem = new Memory(this);
        ClassElement el = new ClassElement(mem, null, null);
        mem.copyFrom(this);
        return el;
    }

    final Impl getClassImpl() {
        return (Impl)this.impl;
    }

    void updateConstructorsNames(Identifier name) throws SourceException {
        ConstructorElement[] c = this.getConstructors();
        Identifier constrName = Identifier.create(name.getName());
        int i = 0;
        while (i < c.length) {
            c[i].setName(constrName);
            ++i;
        }
        ClassElement[] classes = this.getClasses();
        String prefix = this.getName().getFullName() + ".";
        int i2 = 0;
        while (i2 < classes.length) {
            String simpleName = classes[i2].getName().getName();
            StringBuffer sb = new StringBuffer(prefix);
            sb.append(simpleName);
            Identifier id = Identifier.create(sb.toString(), simpleName);
            classes[i2].setName(id);
            ++i2;
        }
    }

    public SourceElement getSource() {
        return this.source;
    }

    public void setClassOrInterface(boolean isClass) throws SourceException {
        this.getClassImpl().setClassOrInterface(isClass);
    }

    public boolean isClassOrInterface() {
        return this.getClassImpl().isClassOrInterface();
    }

    public boolean isClass() {
        return this.getClassImpl().isClassOrInterface();
    }

    public boolean isInterface() {
        return !this.getClassImpl().isClassOrInterface();
    }

    public boolean isInner() {
        return this.getDeclaringClass() != null;
    }

    public int getModifiersMask() {
        int ret = 1025;
        if (this.isClass()) {
            ret |= 0x10;
        }
        if (this.isInner()) {
            ret |= 0xE;
        }
        return ret;
    }

    public final void setName(Identifier name) throws SourceException {
        ClassElement c1;
        String sn = name.getName();
        String fn = name.getFullName();
        if (!name.getSourceName().equals(sn)) {
            name = Identifier.create(fn, sn);
        }
        ClassElement c = this.getDeclaringClass();
        String msg = null;
        if (c != null) {
            ClassElement c12 = c.getClass(name);
            if (c12 != null && c12 != this) {
                msg = NbBundle.getMessage((Class)(class$org$openide$src$ElementFormat == null ? (class$org$openide$src$ElementFormat = ClassElement.class$("org.openide.src.ElementFormat")) : class$org$openide$src$ElementFormat), (String)"FMT_EXC_RenameClass", (Object)c.getName().getName(), (Object)name);
            }
        } else if (this.source != null && (c1 = this.source.getClass(name)) != null && c1 != this) {
            msg = NbBundle.getMessage((Class)(class$org$openide$src$ElementFormat == null ? (class$org$openide$src$ElementFormat = ClassElement.class$("org.openide.src.ElementFormat")) : class$org$openide$src$ElementFormat), (String)"FMT_EXC_RenameClassInSource", (Object)name);
        }
        if (msg != null) {
            this.throwSourceException(msg);
        }
        super.setName(name);
    }

    public final String getSignature() {
        return this.getVMName().replace('.', '/');
    }

    public final String getVMName() {
        Identifier n = this.getName();
        if (!this.isInner()) {
            return n.getFullName();
        }
        StringBuffer sb = new StringBuffer(n.getFullName());
        ClassElement c = this;
        int index = sb.length();
        while (true) {
            sb.setCharAt(index -= n.getSourceName().length() + 1, '$');
            c = c.getDeclaringClass();
            if (!c.isInner()) break;
            n = c.getName();
        }
        return sb.toString();
    }

    public void setSuperclass(Identifier superClass) throws SourceException {
        this.getClassImpl().setSuperclass(superClass);
    }

    public Identifier getSuperclass() {
        return this.getClassImpl().getSuperclass();
    }

    public void addInitializer(InitializerElement el) throws SourceException {
        this.getClassImpl().changeInitializers(new InitializerElement[]{el}, 1);
    }

    public void addInitializers(InitializerElement[] els) throws SourceException {
        this.getClassImpl().changeInitializers(els, 1);
    }

    public void removeInitializer(InitializerElement el) throws SourceException {
        this.getClassImpl().changeInitializers(new InitializerElement[]{el}, -1);
    }

    public void removeInitializers(InitializerElement[] els) throws SourceException {
        this.getClassImpl().changeInitializers(els, -1);
    }

    public void setInitializers(InitializerElement[] els) throws SourceException {
        this.getClassImpl().changeInitializers(els, 0);
    }

    public InitializerElement[] getInitializers() {
        return this.getClassImpl().getInitializers();
    }

    public void addField(FieldElement el) throws SourceException {
        if (this.getField(el.getName()) != null) {
            this.throwAddException("FMT_EXC_AddField", el);
        }
        this.getClassImpl().changeFields(new FieldElement[]{el}, 1);
    }

    public void addFields(FieldElement[] els) throws SourceException {
        int i = 0;
        while (i < els.length) {
            if (this.getField(els[i].getName()) != null) {
                this.throwAddException("FMT_EXC_AddField", els[i]);
            }
            ++i;
        }
        this.getClassImpl().changeFields(els, 1);
    }

    public void removeField(FieldElement el) throws SourceException {
        this.getClassImpl().changeFields(new FieldElement[]{el}, -1);
    }

    public void removeFields(FieldElement[] els) throws SourceException {
        this.getClassImpl().changeFields(els, -1);
    }

    public void setFields(FieldElement[] els) throws SourceException {
        this.getClassImpl().changeFields(els, 0);
    }

    public FieldElement[] getFields() {
        return this.getClassImpl().getFields();
    }

    public FieldElement getField(Identifier name) {
        return this.getClassImpl().getField(name);
    }

    public void addMethod(MethodElement el) throws SourceException {
        this.testMethod(el);
        this.getClassImpl().changeMethods(new MethodElement[]{el}, 1);
    }

    public void addMethods(MethodElement[] els) throws SourceException {
        int i = 0;
        while (i < els.length) {
            this.testMethod(els[i]);
            ++i;
        }
        this.getClassImpl().changeMethods(els, 1);
    }

    private void testMethod(MethodElement el) throws SourceException {
        MethodParameter[] params = el.getParameters();
        Type[] types = new Type[params.length];
        int i = 0;
        while (i < types.length) {
            types[i] = params[i].getType();
            ++i;
        }
        if (this.getMethod(el.getName(), types) != null) {
            this.throwAddException("FMT_EXC_AddMethod", el);
        }
    }

    public void removeMethod(MethodElement el) throws SourceException {
        this.getClassImpl().changeMethods(new MethodElement[]{el}, -1);
    }

    public void removeMethods(MethodElement[] els) throws SourceException {
        this.getClassImpl().changeMethods(els, -1);
    }

    public void setMethods(MethodElement[] els) throws SourceException {
        this.getClassImpl().changeMethods(els, 0);
    }

    public MethodElement[] getMethods() {
        return this.getClassImpl().getMethods();
    }

    public MethodElement getMethod(Identifier name, Type[] arguments) {
        return this.getClassImpl().getMethod(name, arguments);
    }

    public void addConstructor(ConstructorElement el) throws SourceException {
        this.testConstructor(el);
        this.getClassImpl().changeConstructors(new ConstructorElement[]{el}, 1);
    }

    public void addConstructors(ConstructorElement[] els) throws SourceException {
        int i = 0;
        while (i < els.length) {
            this.testConstructor(els[i]);
            ++i;
        }
        this.getClassImpl().changeConstructors(els, 1);
    }

    private void testConstructor(ConstructorElement el) throws SourceException {
        MethodParameter[] params = el.getParameters();
        Type[] types = new Type[params.length];
        int i = 0;
        while (i < types.length) {
            types[i] = params[i].getType();
            ++i;
        }
        if (this.getConstructor(types) != null) {
            this.throwAddException("FMT_EXC_AddConstructor", el);
        }
    }

    public void removeConstructor(ConstructorElement el) throws SourceException {
        this.getClassImpl().changeConstructors(new ConstructorElement[]{el}, -1);
    }

    public void removeConstructors(ConstructorElement[] els) throws SourceException {
        this.getClassImpl().changeConstructors(els, -1);
    }

    public void setConstructors(ConstructorElement[] els) throws SourceException {
        this.getClassImpl().changeConstructors(els, 0);
    }

    public ConstructorElement[] getConstructors() {
        return this.getClassImpl().getConstructors();
    }

    public ConstructorElement getConstructor(Type[] arguments) {
        return this.getClassImpl().getConstructor(arguments);
    }

    public void addClass(ClassElement el) throws SourceException {
        Identifier id = Identifier.create(el.getName().getName());
        if (this.getClass(id) != null) {
            this.throwAddException("FMT_EXC_AddClass", el);
        }
        this.getClassImpl().changeClasses(new ClassElement[]{el}, 1);
    }

    public void addClasses(ClassElement[] els) throws SourceException {
        int i = 0;
        while (i < els.length) {
            Identifier id = Identifier.create(els[i].getName().getName());
            if (this.getClass(id) != null) {
                this.throwAddException("FMT_EXC_AddClass", els[i]);
            }
            ++i;
        }
        this.getClassImpl().changeClasses(els, 1);
    }

    public void removeClass(ClassElement el) throws SourceException {
        this.getClassImpl().changeClasses(new ClassElement[]{el}, -1);
    }

    public void removeClasses(ClassElement[] els) throws SourceException {
        this.getClassImpl().changeClasses(els, -1);
    }

    public void setClasses(ClassElement[] els) throws SourceException {
        this.getClassImpl().changeClasses(els, 0);
    }

    public ClassElement[] getClasses() {
        return this.getClassImpl().getClasses();
    }

    public ClassElement getClass(Identifier name) {
        return this.getClassImpl().getClass(name);
    }

    public void addInterface(Identifier in) throws SourceException {
        this.getClassImpl().changeInterfaces(new Identifier[]{in}, 1);
    }

    public void addInterfaces(Identifier[] ins) throws SourceException {
        this.getClassImpl().changeInterfaces(ins, 1);
    }

    public void removeInterface(Identifier in) throws SourceException {
        this.getClassImpl().changeInterfaces(new Identifier[]{in}, -1);
    }

    public void removeInterfaces(Identifier in) throws SourceException {
        this.removeInterface(in);
    }

    public void removeInterfaces(Identifier[] ins) throws SourceException {
        this.getClassImpl().changeInterfaces(ins, -1);
    }

    public void removeInterface(Identifier[] ins) throws SourceException {
        this.removeInterfaces(ins);
    }

    public void setInterfaces(Identifier[] ids) throws SourceException {
        this.getClassImpl().changeInterfaces(ids, 0);
    }

    public Identifier[] getInterfaces() {
        return this.getClassImpl().getInterfaces();
    }

    public JavaDoc.Class getJavaDoc() {
        return this.getClassImpl().getJavaDoc();
    }

    public void print(ElementPrinter printer) throws ElementPrinterInterruptException {
        printer.markClass(this, 0);
        JavaDoc.Class doc = this.getJavaDoc();
        if (doc != null && !doc.isEmpty()) {
            printer.markClass(this, 2);
            Element.printJavaDoc(doc, printer);
            printer.markClass(this, 3);
            printer.println("");
        }
        printer.markClass(this, 4);
        printer.print(this.isClass() ? HEADER_FORMAT[0].format(this) : HEADER_FORMAT[1].format(this));
        printer.markClass(this, 5);
        printer.print(" {");
        printer.markClass(this, 6);
        printer.println("");
        if (Element.print(this.getInitializers(), printer)) {
            printer.println("");
            printer.println("");
        }
        if (Element.print(this.getFields(), printer)) {
            printer.println("");
            printer.println("");
        }
        if (Element.print(this.getConstructors(), printer)) {
            printer.println("");
            printer.println("");
        }
        if (Element.print(this.getMethods(), printer)) {
            printer.println("");
            printer.println("");
        }
        Element.print(this.getClasses(), printer);
        printer.println("");
        printer.markClass(this, 7);
        printer.print("}");
        printer.markClass(this, 1);
    }

    private void throwAddException(String formatKey, MemberElement element) throws SourceException {
        String msg = NbBundle.getMessage((Class)(class$org$openide$src$ElementFormat == null ? (class$org$openide$src$ElementFormat = ClassElement.class$("org.openide.src.ElementFormat")) : class$org$openide$src$ElementFormat), (String)formatKey, (Object)this.getName().getName(), (Object)element.getName().getName());
        this.throwSourceException(msg);
    }

    public boolean hasMainMethod() {
        MethodElement[] methods = this.getMethods();
        Identifier mainId = Identifier.create("main");
        int i = 0;
        while (i < methods.length) {
            Type typ;
            MethodParameter[] params;
            MethodElement m = methods[i];
            if (m.getName().equals(mainId) && m.getReturn() == Type.VOID && (m.getModifiers() & 0xFFFFFFEF) == 9 && (params = m.getParameters()).length == 1 && (typ = params[0].getType()).isArray() && (typ = typ.getElementType()).isClass() && typ.getClassName().getFullName().equals("java.lang.String")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isDeclaredAsJavaBean() {
        if (Modifier.isPublic(this.getModifiers()) && !Modifier.isAbstract(this.getModifiers()) && this.isClass()) {
            ConstructorElement[] constructors = this.getConstructors();
            int i = 0;
            while (i < constructors.length) {
                if (constructors[i].getParameters().length == 0 && Modifier.isPublic(constructors[i].getModifiers())) {
                    return true;
                }
                ++i;
            }
            return constructors.length == 0;
        }
        return false;
    }

    public boolean isDeclaredAsApplet() {
        Identifier superclass;
        if (this.isClass() && (superclass = this.getSuperclass()) != null) {
            String name = superclass.getFullName();
            return name.equals("java.applet.Applet") || name.equals("javax.swing.JApplet");
        }
        return false;
    }

    public static void register(Finder f) {
        List list = finders;
        synchronized (list) {
            finders.add(f);
        }
    }

    public static void unregister(Finder f) {
        List list = finders;
        synchronized (list) {
            finders.remove(f);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static ClassElement forName(String name) {
        var4_1 = ClassElement.finders;
        synchronized (var4_1) {
            it = new ArrayList<E>(ClassElement.finders).iterator();
            // MONITOREXIT @DISABLED, blocks:[0, 4] lbl5 : MonitorExitStatement: MONITOREXIT : var4_1
            if (true) ** GOTO lbl12
        }
        do {
            if ((el = ((Finder)it.next()).find(name)) == null) continue;
            return el;
lbl12:
            // 2 sources

        } while (it.hasNext());
        rep = Repository.getDefault();
        index = name.lastIndexOf(46);
        if (index >= 0 && index <= name.length()) {
            p = name.substring(0, index);
            n = name.substring(index + 1);
        } else {
            p = "";
            n = name;
        }
        fo = rep.find(p, n, "class");
        element = ClassElement.testFileForName(fo, n);
        if (element != null) {
            return element;
        }
        index = n.indexOf(36);
        if (index != -1) {
            fo = rep.find(p, n.substring(0, index), "java");
            element = ClassElement.testFileForName(fo, n);
            if (element != null) {
                return element;
            }
        } else {
            nn = n;
            while (true) {
                if ((element = ClassElement.testFileForName(fo = rep.find(p, nn, "java"), n)) != null) {
                    return element;
                }
                if (p.length() == 0) break;
                index2 = p.lastIndexOf(46);
                nn = p.substring(index2 + 1);
                n = nn + "." + n;
                if (index2 >= 0) {
                    p = p.substring(0, index2);
                    continue;
                }
                p = "";
            }
        }
        loader = (ClassElement.class$org$openide$src$ClassElement == null ? (ClassElement.class$org$openide$src$ClassElement = ClassElement.class$("org.openide.src.ClassElement")) : ClassElement.class$org$openide$src$ClassElement).getClassLoader();
        try {
            try {
                clazz = Class.forName(name, true, loader);
                return ClassElement.forClass(clazz);
            }
            catch (ClassNotFoundException e) {
                if (index != -1) {
                    return null;
                }
                sb = new StringBuffer(name);
                index = name.lastIndexOf(46);
                ** while (index > 0)
            }
lbl-1000:
            // 1 sources

            {
                sb.setCharAt(index, '$');
                index = name.lastIndexOf(46, index - 1);
                try {
                    p = index < 1 ? "" : sb.substring(0, index);
                    n = sb.substring(index + 1);
                    fob = rep.find(p, n, "class");
                    element = ClassElement.testFileForName(fob, n);
                    if (element != null) {
                        return element;
                    }
                    clazz = Class.forName(sb.toString(), true, loader);
                    return ClassElement.forClass(clazz);
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
                continue;
lbl70:
                // 1 sources

            }
        }
        catch (LinkageError err) {
            // empty catch block
        }
        return null;
    }

    private static ClassElement testFileForName(FileObject fo, String name) {
        if (fo != null) {
            try {
                DataObject obj = DataObject.find((FileObject)fo);
                SourceCookie sc = (SourceCookie)obj.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = ClassElement.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie);
                if (sc != null) {
                    ClassElement[] arr = sc.getSource().getClasses();
                    StringTokenizer tukac = new StringTokenizer(name, "$.");
                    while (tukac.hasMoreTokens()) {
                        String token = tukac.nextToken();
                        ClassElement c = null;
                        int i = 0;
                        while (i < arr.length) {
                            Identifier id = arr[i].getName();
                            if (id.getName().equals(token)) {
                                if (!tukac.hasMoreTokens()) {
                                    return arr[i];
                                }
                                c = arr[i];
                                break;
                            }
                            ++i;
                        }
                        if (c == null) {
                            return null;
                        }
                        arr = c.getClasses();
                    }
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClassElement forClass(Class clazz) {
        Iterator it;
        List list = finders;
        synchronized (list) {
            it = ((AbstractList)new ArrayList(finders)).iterator();
        }
        while (it.hasNext()) {
            ClassElement el = ((Finder)it.next()).find(clazz);
            if (el == null) continue;
            return el;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class Memory
    extends MemberElement.Memory
    implements Impl {
        private Identifier superClass;
        private boolean isClass;
        private MemoryCollection interfaces;
        private MemoryCollection.Initializer initializers;
        private MemoryCollection.Constructor constructors;
        private MemoryCollection.Method methods;
        private MemoryCollection.Field fields;
        private MemoryCollection.Class classes;
        JavaDoc.Class javaDoc = null;
        static final long serialVersionUID = 6058485742932189851L;

        public Memory() {
            this.superClass = null;
            this.isClass = true;
            this.javaDoc = JavaDocSupport.createClassJavaDoc(null);
        }

        public Memory(ClassElement el) {
            super(el);
            this.superClass = el.getSuperclass();
            this.isClass = el.isClassOrInterface();
            this.javaDoc = el.getJavaDoc().isEmpty() ? JavaDocSupport.createClassJavaDoc(null) : JavaDocSupport.createClassJavaDoc(el.getJavaDoc().getRawText());
        }

        void updateNameToParent() {
            MemberElement me = (MemberElement)this.element;
            if (me.getDeclaringClass() == null) {
                return;
            }
            StringBuffer fullName = new StringBuffer();
            fullName.append(me.getDeclaringClass().getName().getFullName());
            fullName.append('.');
            String simpleName = this.getName().getName();
            fullName.append(simpleName);
            this.setName(Identifier.create(fullName.toString(), simpleName));
        }

        void initialize(ClassElement model) {
            this.updateNameToParent();
            this.copyFrom(model);
        }

        public void copyFrom(ClassElement copyFrom) {
            this.changeInterfaces(copyFrom.getInterfaces(), 0);
            this.changeConstructors(copyFrom.getConstructors(), 0);
            this.changeMethods(copyFrom.getMethods(), 0);
            this.changeFields(copyFrom.getFields(), 0);
            this.changeClasses(copyFrom.getClasses(), 0);
        }

        public void setSuperclass(Identifier superClass) throws SourceException {
            Identifier old = this.superClass;
            this.superClass = superClass;
            this.firePropertyChange("superclass", old, superClass);
        }

        public Identifier getSuperclass() {
            return this.superClass;
        }

        public void setClassOrInterface(boolean isClass) {
            boolean old = this.isClass;
            this.isClass = isClass;
            this.firePropertyChange("classOrInterface", old ? Boolean.TRUE : Boolean.FALSE, isClass ? Boolean.TRUE : Boolean.FALSE);
        }

        public boolean isClassOrInterface() {
            return this.isClass;
        }

        public synchronized void changeInitializers(InitializerElement[] elems, int action) {
            this.initInitializers();
            this.initializers.change(elems, action);
        }

        public synchronized InitializerElement[] getInitializers() {
            this.initInitializers();
            return (InitializerElement[])this.initializers.toArray();
        }

        void initInitializers() {
            if (this.initializers == null) {
                this.initializers = new MemoryCollection.Initializer(this);
            }
        }

        public synchronized void changeFields(FieldElement[] elems, int action) {
            this.initFields();
            this.fields.change(elems, action);
        }

        public synchronized FieldElement[] getFields() {
            this.initFields();
            return (FieldElement[])this.fields.toArray();
        }

        public synchronized FieldElement getField(Identifier name) {
            this.initFields();
            return (FieldElement)this.fields.find(name, null);
        }

        void initFields() {
            if (this.fields == null) {
                this.fields = new MemoryCollection.Field(this);
            }
        }

        public synchronized void changeMethods(MethodElement[] elems, int action) {
            this.initMethods();
            this.methods.change(elems, action);
        }

        public MethodElement[] getMethods() {
            this.initMethods();
            return (MethodElement[])this.methods.toArray();
        }

        public synchronized MethodElement getMethod(Identifier name, Type[] arguments) {
            this.initMethods();
            return (MethodElement)this.methods.find(name, arguments);
        }

        void initMethods() {
            if (this.methods == null) {
                this.methods = new MemoryCollection.Method(this);
            }
        }

        public synchronized void changeConstructors(ConstructorElement[] elems, int action) {
            this.initConstructors();
            this.constructors.change(elems, action);
        }

        public synchronized ConstructorElement[] getConstructors() {
            this.initConstructors();
            return (ConstructorElement[])this.constructors.toArray();
        }

        public synchronized ConstructorElement getConstructor(Type[] arguments) {
            this.initConstructors();
            return (ConstructorElement)this.constructors.find(null, arguments);
        }

        void initConstructors() {
            if (this.constructors == null) {
                this.constructors = new MemoryCollection.Constructor(this);
            }
        }

        public synchronized void changeClasses(ClassElement[] elems, int action) {
            this.initClasses();
            this.classes.change(elems, action);
        }

        public synchronized ClassElement[] getClasses() {
            this.initClasses();
            return (ClassElement[])this.classes.toArray();
        }

        public synchronized ClassElement getClass(Identifier name) {
            this.initClasses();
            return (ClassElement)this.classes.find(name, null);
        }

        void initClasses() {
            if (this.classes == null) {
                this.classes = new MemoryCollection.Class(this);
            }
        }

        public synchronized void changeInterfaces(Identifier[] ids, int action) {
            this.initInterfaces();
            this.interfaces.change(ids, action);
        }

        public synchronized Identifier[] getInterfaces() {
            this.initInterfaces();
            return (Identifier[])this.interfaces.toArray();
        }

        void initInterfaces() {
            if (this.interfaces == null) {
                this.interfaces = new MemoryCollection.Interface(this);
            }
        }

        void markCurrent(Element marker, boolean after) {
            MemoryCollection col;
            if (marker instanceof InitializerElement) {
                col = this.initializers;
            } else if (marker instanceof ClassElement) {
                col = this.classes;
            } else if (marker instanceof FieldElement) {
                col = this.fields;
            } else if (marker instanceof MethodElement) {
                col = this.methods;
            } else if (marker instanceof ConstructorElement) {
                col = this.constructors;
            } else {
                throw new IllegalArgumentException();
            }
            col.markCurrent(marker, after);
        }

        public JavaDoc.Class getJavaDoc() {
            return this.javaDoc;
        }

        final ClassElement getClassElement() {
            return (ClassElement)this.element;
        }

        public Object readResolve() {
            return new ClassElement((Impl)this, (SourceElement)null);
        }
    }

    public static interface Impl
    extends MemberElement.Impl {
        public static final int ADD = 1;
        public static final int REMOVE = -1;
        public static final int SET = 0;
        public static final long serialVersionUID = 2564194659099459416L;

        public void setSuperclass(Identifier var1) throws SourceException;

        public Identifier getSuperclass();

        public void setClassOrInterface(boolean var1) throws SourceException;

        public boolean isClassOrInterface();

        public void changeInitializers(InitializerElement[] var1, int var2) throws SourceException;

        public InitializerElement[] getInitializers();

        public void changeFields(FieldElement[] var1, int var2) throws SourceException;

        public FieldElement[] getFields();

        public FieldElement getField(Identifier var1);

        public void changeMethods(MethodElement[] var1, int var2) throws SourceException;

        public MethodElement[] getMethods();

        public MethodElement getMethod(Identifier var1, Type[] var2);

        public void changeConstructors(ConstructorElement[] var1, int var2) throws SourceException;

        public ConstructorElement[] getConstructors();

        public ConstructorElement getConstructor(Type[] var1);

        public void changeClasses(ClassElement[] var1, int var2) throws SourceException;

        public ClassElement[] getClasses();

        public ClassElement getClass(Identifier var1);

        public void changeInterfaces(Identifier[] var1, int var2) throws SourceException;

        public Identifier[] getInterfaces();

        public JavaDoc.Class getJavaDoc();
    }

    public static interface Finder {
        public ClassElement find(Class var1);

        public ClassElement find(String var1);
    }
}

