/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import org.openide.src.JavaDocMemoryImpl;
import org.openide.src.JavaDocTag;

class JavaDocTagMemoryImpl
implements JavaDocTag {
    String name;
    String text;

    JavaDocTagMemoryImpl(String name, String text) {
        this.name = name;
        this.text = JavaDocMemoryImpl.convertNewLines(text);
    }

    public String toString() {
        return this.name + " " + this.text;
    }

    public String name() {
        return this.name;
    }

    public String kind() {
        return this.name;
    }

    public String text() {
        return this.text;
    }

    String[] divideAtWhite() {
        String[] sa = new String[2];
        int len = this.text.length();
        sa[0] = this.text;
        sa[1] = "";
        int inx = 0;
        block0: while (inx < len) {
            char ch = this.text.charAt(inx);
            if (Character.isWhitespace(ch)) {
                sa[0] = this.text.substring(0, inx);
                while (inx < len) {
                    ch = this.text.charAt(inx);
                    if (!Character.isWhitespace(ch)) {
                        sa[1] = this.text.substring(inx, len);
                        break block0;
                    }
                    ++inx;
                }
                break;
            }
            ++inx;
        }
        return sa;
    }

    static class SerialField
    extends JavaDocTagMemoryImpl
    implements JavaDocTag.SerialField {
        private String fieldName;
        private String fieldType;
        private String description;

        SerialField(String name, String text) {
            super(name, text);
            this.parseSerialFieldString(text);
        }

        public String fieldName() {
            return this.fieldName;
        }

        public String fieldType() {
            return this.fieldType;
        }

        public String description() {
            return this.description;
        }

        public String kind() {
            return "@serialField";
        }

        public String toString() {
            return this.name + " " + this.fieldName() + " " + this.fieldType() + " " + this.description();
        }

        /*
         * Unable to fully structure code
         */
        private void parseSerialFieldString(String text) {
            len = text.length();
            inx = 0;
            while (inx < len && Character.isWhitespace(text.charAt(inx))) {
                ++inx;
            }
            if (inx == len) {
                this.fieldName = "";
                this.fieldType = "";
                this.description = "";
                return;
            }
            first = inx;
            last = inx;
            if (Character.isJavaIdentifierStart(text.charAt(inx))) ** GOTO lbl16
            return;
lbl-1000:
            // 1 sources

            {
                ++inx;
lbl16:
                // 2 sources

                ** while (inx < len && Character.isJavaIdentifierPart((char)text.charAt((int)inx)))
            }
lbl17:
            // 1 sources

            if (inx < len && !Character.isWhitespace(text.charAt(inx))) {
                return;
            }
            last = inx;
            this.fieldName = text.substring(first, last);
            while (inx < len && Character.isWhitespace(text.charAt(inx))) {
                ++inx;
            }
            first = inx;
            last = inx;
            while (inx < len && !Character.isWhitespace(text.charAt(inx))) {
                ++inx;
            }
            if (inx < len && !Character.isWhitespace(text.charAt(inx))) {
                return;
            }
            last = inx;
            this.fieldType = text.substring(first, last);
            while (inx < len && Character.isWhitespace(text.charAt(inx))) {
                ++inx;
            }
            this.description = text.substring(inx);
        }
    }

    static class Throws
    extends JavaDocTagMemoryImpl
    implements JavaDocTag.Throws {
        private String exceptionName;
        private String exceptionComment;

        Throws(String name, String text) {
            super(name, text);
            String[] sa = this.divideAtWhite();
            this.exceptionName = sa[0];
            this.exceptionComment = sa[1];
        }

        public String exceptionName() {
            return this.exceptionName;
        }

        public String exceptionComment() {
            return this.exceptionComment;
        }

        public String kind() {
            return "@throws";
        }

        public String toString() {
            return this.name + " " + this.exceptionName() + " " + this.exceptionComment();
        }
    }

    static class Param
    extends JavaDocTagMemoryImpl
    implements JavaDocTag.Param {
        private String parameterName;
        private String parameterComment;

        Param(String name, String text) {
            super(name, text);
            String[] sa = this.divideAtWhite();
            this.parameterName = sa[0];
            this.parameterComment = sa[1];
        }

        public String parameterName() {
            return this.parameterName;
        }

        public String parameterComment() {
            return this.parameterComment;
        }

        public String kind() {
            return "@param";
        }

        public String toString() {
            return this.name + " " + this.parameterName() + " " + this.parameterComment();
        }
    }

    static class See
    extends JavaDocTagMemoryImpl
    implements JavaDocTag.See {
        private String label = "";
        private String where;
        private String what;

        See(String name, String text) {
            super(name, text);
            this.parseSeeString();
        }

        public String label() {
            return this.label;
        }

        public String referencedClassName() {
            return this.where;
        }

        public String referencedMemberName() {
            return this.what;
        }

        public String kind() {
            return "@see";
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(100);
            sb.append(this.name).append(" ").append(this.text);
            return sb.toString();
        }

        private void parseSeeString() {
            int start;
            int len = this.text.length();
            if (len == 0) {
                return;
            }
            switch (this.text.charAt(0)) {
                case '\"': 
                case '<': {
                    return;
                }
            }
            int parens = 0;
            int commentstart = 0;
            int i = start = 0;
            while (i < len) {
                char ch = this.text.charAt(i);
                switch (ch) {
                    case '(': {
                        ++parens;
                        break;
                    }
                    case ')': {
                        --parens;
                        break;
                    }
                    case '#': 
                    case '.': 
                    case '[': 
                    case ']': {
                        break;
                    }
                    case ',': {
                        if (parens > 0) break;
                        return;
                    }
                    case '\t': 
                    case '\n': 
                    case ' ': {
                        if (parens != 0) break;
                        commentstart = i;
                        i = len;
                        break;
                    }
                    default: {
                        if (Character.isJavaIdentifierPart(ch)) break;
                        return;
                    }
                }
                ++i;
            }
            if (parens != 0) {
                return;
            }
            String seetext = "";
            String labeltext = "";
            if (commentstart > 0) {
                seetext = this.text.substring(start, commentstart);
                labeltext = this.text.substring(commentstart + 1);
                int i2 = 0;
                while (i2 < labeltext.length()) {
                    char ch = labeltext.charAt(i2);
                    if (ch != ' ' && ch != '\t' && ch != '\n') {
                        this.label = labeltext.substring(i2);
                        break;
                    }
                    ++i2;
                }
            } else {
                seetext = this.text;
                this.label = "";
            }
            int sharp = seetext.indexOf(35);
            if (sharp >= 0) {
                this.where = seetext.substring(0, sharp);
                this.what = seetext.substring(sharp + 1);
            } else if (seetext.indexOf(40) >= 0) {
                this.where = "";
                this.what = seetext;
            } else {
                this.where = seetext;
                this.what = null;
            }
        }
    }
}

