/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.Identifier;
import org.openide.src.SourceException;

public abstract class MemberElement
extends Element
implements Cloneable {
    private ClassElement declaringClass;
    static final long serialVersionUID = 7896378970641663987L;

    protected MemberElement(Impl impl, ClassElement declaringClass) {
        super(impl);
        this.declaringClass = declaringClass;
    }

    final Impl getMemberImpl() {
        return (Impl)this.impl;
    }

    public final int getModifiers() {
        return this.getMemberImpl().getModifiers();
    }

    public final void setModifiers(int mod) throws SourceException {
        this.getMemberImpl().setModifiers(mod);
    }

    public abstract int getModifiersMask();

    boolean isDeclaredInInterface() {
        return this.declaringClass != null && this.declaringClass.isInterface();
    }

    public final Identifier getName() {
        return this.getMemberImpl().getName();
    }

    public void setName(Identifier name) throws SourceException {
        this.getMemberImpl().setName(name);
        this.updateConstructorsNames(name);
    }

    void updateConstructorsNames(Identifier name) throws SourceException {
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public final ClassElement getDeclaringClass() {
        return this.declaringClass;
    }

    static abstract class Memory
    extends Element.Memory
    implements Impl {
        private int mod;
        private Identifier name;
        static final long serialVersionUID = 1876531129266668488L;
        static /* synthetic */ Class class$org$openide$src$ClassElement$Memory;

        public Memory() {
        }

        public Memory(MemberElement el) {
            this.mod = el.getModifiers();
            this.name = el.getName();
        }

        public int getModifiers() {
            return this.mod;
        }

        public void setModifiers(int mod) {
            int old = this.mod;
            this.mod = mod;
            this.firePropertyChange("modifiers", new Integer(old), new Integer(mod));
        }

        public synchronized Identifier getName() {
            if (this.name == null) {
                this.name = Identifier.create("");
            }
            return this.name;
        }

        public synchronized void setName(Identifier name) {
            Identifier old = this.name;
            this.name = name;
            this.firePropertyChange("name", old, name);
        }

        public void markCurrent(boolean after) {
            ClassElement decl = ((MemberElement)this.element).getDeclaringClass();
            if (decl == null) {
                throw new IllegalStateException();
            }
            ((ClassElement.Memory)decl.getCookie(class$org$openide$src$ClassElement$Memory == null ? (class$org$openide$src$ClassElement$Memory = Memory.class$("org.openide.src.ClassElement$Memory")) : class$org$openide$src$ClassElement$Memory)).markCurrent(this.element, after);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static interface Impl
    extends Element.Impl {
        public static final long serialVersionUID = 2037286733482347462L;

        public int getModifiers();

        public void setModifiers(int var1) throws SourceException;

        public Identifier getName();

        public void setName(Identifier var1) throws SourceException;
    }
}

