/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.openide.cookies.FilterCookie;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.FieldElement;
import org.openide.src.InitializerElement;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.nodes.ClassElementFilter;
import org.openide.src.nodes.DefaultFactory;
import org.openide.src.nodes.ElementNodeFactory;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;

public class ClassChildren
extends Children.Keys
implements FilterCookie {
    private static int PPP_MASK = 7;
    protected static HashMap propToFilter;
    private static Comparator comparator;
    protected ClassElement element;
    protected ClassElementFilter filter;
    protected ElementNodeFactory factory;
    private PropertyChangeListener wPropL;
    private ElementListener propL;
    protected Collection[] cpl;
    private boolean nodesInited = false;
    static /* synthetic */ Class class$org$openide$src$nodes$ClassElementFilter;
    static /* synthetic */ Class class$org$openide$src$MemberElement;

    public ClassChildren(ClassElement element) {
        this(DefaultFactory.READ_WRITE, element);
    }

    public ClassChildren(ElementNodeFactory factory, ClassElement element) {
        this.element = element;
        this.factory = factory;
        this.filter = null;
    }

    public Class getFilterClass() {
        return class$org$openide$src$nodes$ClassElementFilter == null ? (class$org$openide$src$nodes$ClassElementFilter = ClassChildren.class$("org.openide.src.nodes.ClassElementFilter")) : class$org$openide$src$nodes$ClassElementFilter;
    }

    public Object getFilter() {
        return this.filter;
    }

    public void setFilter(Object filter) {
        if (!(filter instanceof ClassElementFilter)) {
            throw new IllegalArgumentException();
        }
        this.filter = (ClassElementFilter)filter;
        if (this.nodesInited) {
            this.refreshAllKeys();
        }
    }

    protected void addNotify() {
        if (this.wPropL == null) {
            this.propL = new ElementListener(this);
            this.wPropL = WeakListener.propertyChange((PropertyChangeListener)this.propL, (Object)this.element);
        }
        this.refreshAllKeys();
        this.element.addPropertyChangeListener(this.wPropL);
        this.nodesInited = true;
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        this.nodesInited = false;
    }

    private Node hookNodeName(Node n) {
        MemberElement el = (MemberElement)n.getCookie(class$org$openide$src$MemberElement == null ? (class$org$openide$src$MemberElement = ClassChildren.class$("org.openide.src.MemberElement")) : class$org$openide$src$MemberElement);
        if (el != null) {
            el.addPropertyChangeListener(this.propL);
        }
        return n;
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof MethodElement) {
            return new Node[]{this.hookNodeName(this.factory.createMethodNode((MethodElement)key))};
        }
        if (key instanceof FieldElement) {
            return new Node[]{this.hookNodeName(this.factory.createFieldNode((FieldElement)key))};
        }
        if (key instanceof ConstructorElement) {
            return new Node[]{this.hookNodeName(this.factory.createConstructorNode((ConstructorElement)key))};
        }
        if (key instanceof ClassElement) {
            return new Node[]{this.hookNodeName(this.factory.createClassNode((ClassElement)key))};
        }
        if (key instanceof InitializerElement) {
            return new Node[]{this.hookNodeName(this.factory.createInitializerNode((InitializerElement)key))};
        }
        return new Node[0];
    }

    protected void refreshAllKeys() {
        this.cpl = new Collection[this.getOrder().length];
        this.refreshKeys(255);
    }

    protected void refreshKeys(int filter) {
        int[] order = this.getOrder();
        LinkedList keys = new LinkedList();
        int i = 0;
        while (i < order.length) {
            if ((order[i] & filter) != 0 || this.cpl[i] == null) {
                this.cpl[i] = this.getKeysOfType(order[i]);
                keys.addAll(this.cpl[i]);
            } else {
                keys.addAll(this.cpl[i]);
            }
            ++i;
        }
        ElementListener l = this.propL;
        if (l != null) {
            l.updateElements(keys);
        }
        this.setKeys(keys);
    }

    protected Collection getKeysOfType(int elementType) {
        LinkedList<Serializable> keys = new LinkedList<Serializable>();
        if ((elementType & 0x40) != 0) {
            keys.add(this.element.getSuperclass());
        }
        if ((elementType & 0x80) != 0) {
            keys.addAll(Arrays.asList(this.element.getInterfaces()));
        }
        if ((elementType & 0x10) != 0) {
            this.filterModifiers(this.element.getFields(), keys);
        }
        if ((elementType & 8) != 0) {
            this.filterModifiers(this.element.getConstructors(), keys);
            keys.addAll(Arrays.asList(this.element.getInitializers()));
        }
        if ((elementType & 0x20) != 0) {
            this.filterModifiers(this.element.getMethods(), keys);
        }
        if ((elementType & 6) != 0) {
            this.filterClassModifiers(this.element.getClasses(), keys, elementType);
        }
        if (this.filter == null || this.filter.isSorted()) {
            Collections.sort(keys, comparator);
        }
        return keys;
    }

    protected int[] getOrder() {
        return this.filter == null || this.filter.getOrder() == null ? ClassElementFilter.DEFAULT_ORDER : this.filter.getOrder();
    }

    private int getModifierFilter() {
        if (this.filter == null) {
            return 65543;
        }
        return this.filter.getModifiers();
    }

    private void filterModifiers(MemberElement[] elements, Collection keys) {
        int ff = this.getModifierFilter();
        int k = elements.length;
        int i = 0;
        while (i < k) {
            int f = elements[i].getModifiers();
            if ((f & PPP_MASK) == 0) {
                f += 65536;
            }
            if ((f & ff) != 0) {
                keys.add(elements[i]);
            }
            ++i;
        }
    }

    private void filterClassModifiers(ClassElement[] elements, Collection keys, int filter) {
        int ff = this.getModifierFilter();
        int k = elements.length;
        int i = 0;
        while (i < k) {
            int f = elements[i].getModifiers();
            if ((f & PPP_MASK) == 0) {
                f += 65536;
            }
            if ((f & ff) != 0) {
                if (elements[i].isClass()) {
                    if ((filter & 2) != 0) {
                        keys.add(elements[i]);
                    }
                } else if ((filter & 4) != 0) {
                    keys.add(elements[i]);
                }
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof MemberElement) {
                    if (o2 instanceof MemberElement) {
                        return ((MemberElement)o1).getName().getName().compareToIgnoreCase(((MemberElement)o2).getName().getName());
                    }
                    return -1;
                }
                if (o2 instanceof MemberElement) {
                    return 1;
                }
                return 0;
            }
        };
        propToFilter = new HashMap();
        propToFilter.put("classes", new Integer(6));
        propToFilter.put("methods", new Integer(32));
        propToFilter.put("fields", new Integer(16));
        propToFilter.put("constructors", new Integer(8));
        propToFilter.put("initializers", new Integer(8));
    }

    private static final class ElementListener
    extends WeakReference
    implements Runnable,
    PropertyChangeListener {
        Collection elements;
        Element celem;

        ElementListener(ClassChildren cc) {
            super(cc, Utilities.activeReferenceQueue());
            this.celem = cc.element;
        }

        ClassChildren getClassChildren() {
            Object o = this.get();
            return (ClassChildren)((Object)o);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void propertyChange(PropertyChangeEvent evt) {
            int filter;
            Object src = evt.getSource();
            String propName = evt.getPropertyName();
            ClassChildren cc = this.getClassChildren();
            if (cc == null) {
                return;
            }
            if (src != cc.element) {
                if (!(src instanceof MemberElement) || propName != null && "name" != propName) return;
                filter = src instanceof MethodElement ? 32 : (src instanceof ConstructorElement ? 8 : (src instanceof FieldElement ? 16 : 6));
            } else {
                Integer i = (Integer)propToFilter.get(propName);
                if (i == null) {
                    return;
                }
                filter = i;
            }
            cc.refreshKeys(filter);
        }

        void updateElements(Collection c) {
            this.elements = c;
        }

        public void run() {
            Iterator it = this.elements.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof Element)) continue;
                Element el = (Element)o;
                el.removePropertyChangeListener(this);
            }
        }
    }
}

