/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyEditor;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.explorer.propertysheet.editors.ModifierEditor;
import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.Identifier;
import org.openide.src.SourceException;
import org.openide.src.nodes.ElementBeanModel;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ClassCustomizer
extends JPanel {
    static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$openide$src$nodes$ClassCustomizer == null ? (class$org$openide$src$nodes$ClassCustomizer = ClassCustomizer.class$("org.openide.src.nodes.ClassCustomizer")) : class$org$openide$src$nodes$ClassCustomizer));
    private static final String[] COMMON_TYPES = new String[]{"java.lang.Object", "java.awt.Component", "javax.swing.JComponent", "javax.swing.JPanel"};
    ClassElement element;
    boolean isOK = true;
    private JPanel classPanel;
    private JLabel jLabel1;
    private JTextField nameTextField;
    private JLabel jLabel2;
    private JComboBox superClassCombo;
    private JPanel typePanel;
    private JRadioButton classRadioButton;
    private JRadioButton interfaceRadioButton;
    private JPanel jPanel3;
    private JPanel modifierPanel;
    private JPanel interfacesPanel;
    static /* synthetic */ Class class$org$openide$src$nodes$ClassCustomizer;

    public ClassCustomizer(ClassElement element) {
        this.element = element;
        this.initComponents();
        this.classPanel.setBorder(new CompoundBorder(new TitledBorder(bundle.getString("CTL_ClassFrame")), new EmptyBorder(new Insets(5, 5, 5, 5))));
        this.typePanel.setBorder(new TitledBorder(bundle.getString("CTL_ClassType")));
        this.modifierPanel.setBorder(new TitledBorder(bundle.getString("CTL_Modifiers")));
        this.interfacesPanel.setBorder(new TitledBorder(bundle.getString("CTL_Interfaces")));
        PropertyPanel modifEditor = new PropertyPanel((PropertyModel)new ElementBeanModel((Element)element, "modifiers"), 2);
        this.modifierPanel.add((Component)modifEditor, "Center");
        PropertyEditor propEdit = modifEditor.getPropertyEditor();
        if (propEdit instanceof ModifierEditor) {
            ((ModifierEditor)((Object)propEdit)).setMask(element.getModifiersMask());
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.classRadioButton);
        group.add(this.interfaceRadioButton);
        Identifier superclassId = element.getSuperclass();
        this.superClassCombo.setSelectedItem(superclassId == null ? "" : superclassId.getFullName());
        if (element.isClass()) {
            this.classRadioButton.setSelected(true);
        } else {
            this.interfaceRadioButton.setSelected(true);
            this.superClassCombo.setEnabled(false);
        }
        this.classRadioButton.setEnabled(false);
        this.interfaceRadioButton.setEnabled(false);
        this.nameTextField.setText(element.getName().getName());
        this.interfacesPanel.add((Component)new PropertyPanel((PropertyModel)new ElementBeanModel((Element)element, "interfaces"), 2), "Center");
        HelpCtx.setHelpIDString((JComponent)this, (String)"java.class.customizer");
        this.jLabel1.setDisplayedMnemonic(bundle.getString("CTL_Name_Mnemonic").charAt(0));
        this.jLabel2.setDisplayedMnemonic(bundle.getString("CTL_Type_Mnemonic").charAt(0));
        this.classRadioButton.setMnemonic(bundle.getString("CTL_Class_Mnemonic").charAt(0));
        this.interfaceRadioButton.setMnemonic(bundle.getString("CTL_Interface_Mnemonic").charAt(0));
        this.initAccessibility();
    }

    public void addNotify() {
        super.addNotify();
        int l = this.nameTextField.getText().length();
        this.nameTextField.setCaretPosition(0);
        this.nameTextField.moveCaretPosition(l);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ClassCustomizer.this.nameTextField.requestFocus();
            }
        });
    }

    private void initComponents() {
        this.classPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.nameTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.superClassCombo = new JComboBox<String>(COMMON_TYPES);
        this.typePanel = new JPanel();
        this.classRadioButton = new JRadioButton();
        this.interfaceRadioButton = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.modifierPanel = new JPanel();
        this.interfacesPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(6, 6, 6, 6)));
        this.classPanel.setLayout(new GridBagLayout());
        this.jLabel1.setText(bundle.getString("CTL_Name"));
        this.jLabel1.setLabelFor(this.nameTextField);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(12, 0, 0, 8);
        gridBagConstraints2.anchor = 13;
        this.classPanel.add((Component)this.jLabel1, gridBagConstraints2);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                ClassCustomizer.this.nameTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        this.classPanel.add((Component)this.nameTextField, gridBagConstraints2);
        this.jLabel2.setText(bundle.getString("CTL_Superclass"));
        this.jLabel2.setLabelFor(this.superClassCombo);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(8, 0, 0, 8);
        gridBagConstraints2.anchor = 13;
        this.classPanel.add((Component)this.jLabel2, gridBagConstraints2);
        this.superClassCombo.setEditable(true);
        this.superClassCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClassCustomizer.this.superClassComboActionPerformed(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(8, 0, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        this.classPanel.add((Component)this.superClassCombo, gridBagConstraints2);
        this.typePanel.setLayout(new GridBagLayout());
        this.classRadioButton.setText(bundle.getString("CTL_Class"));
        this.classRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClassCustomizer.this.switchClassAndInterface(evt);
            }
        });
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(4, 8, 4, 4);
        this.typePanel.add((Component)this.classRadioButton, gridBagConstraints3);
        this.interfaceRadioButton.setText(bundle.getString("CTL_Interface"));
        this.interfaceRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClassCustomizer.this.switchClassAndInterface(evt);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(4, 4, 4, 8);
        this.typePanel.add((Component)this.interfaceRadioButton, gridBagConstraints3);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(8, 0, 0, 0);
        gridBagConstraints2.weighty = 1.0;
        this.classPanel.add((Component)this.typePanel, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.fill = 3;
        this.classPanel.add((Component)this.jPanel3, gridBagConstraints2);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 1.0;
        this.add((Component)this.classPanel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.modifierPanel, gridBagConstraints1);
        this.interfacesPanel.setLayout(new BorderLayout());
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.interfacesPanel, gridBagConstraints1);
    }

    private void superClassComboActionPerformed(ActionEvent evt) {
        boolean ok;
        String oldValueStr;
        block7: {
            Identifier oldValue = this.element.getSuperclass();
            oldValueStr = oldValue == null ? "" : oldValue.getFullName();
            Object item = this.superClassCombo.getSelectedItem();
            if (item == null) {
                this.superClassCombo.setSelectedItem(oldValueStr);
                return;
            }
            final String newValueStr = item.toString();
            ok = false;
            Object x = null;
            try {
                if (!oldValueStr.equals(newValueStr)) {
                    try {
                        SourceEditSupport.runAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

                            public void run() throws SourceException {
                                ClassCustomizer.this.element.setSuperclass(newValueStr.equals("") ? null : Identifier.create(newValueStr));
                            }
                        });
                        ok = true;
                    }
                    catch (SourceException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                    break block7;
                }
                return;
            }
            catch (IllegalArgumentException e) {
                ErrorManager.getDefault().annotate((Throwable)e, 256, null, bundle.getString("MSG_Not_Valid_Type"), null, null);
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        this.isOK = ok;
        if (!ok) {
            this.superClassCombo.setSelectedItem(oldValueStr);
        }
    }

    private void switchClassAndInterface(ActionEvent evt) {
    }

    private void updateSuperClassEnable() {
        this.superClassCombo.setEnabled(this.classRadioButton.isSelected());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void nameTextFieldFocusLost(FocusEvent evt) {
        void var5_9;
        if (evt != null && evt.isTemporary()) {
            return;
        }
        String newName = this.nameTextField.getText();
        String oldName = this.element.getName().getName();
        boolean ok = false;
        Object var5_5 = null;
        if (Utilities.isJavaIdentifier((String)newName)) {
            if (oldName.equals(newName)) return;
            final Identifier id = Identifier.create(newName);
            try {
                SourceEditSupport.runAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

                    public void run() throws SourceException {
                        ClassCustomizer.this.element.setName(id);
                    }
                });
                ok = true;
            }
            catch (SourceException e) {
                SourceException sourceException = e;
            }
        } else {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid name");
            ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, bundle.getString("MSG_Not_Valid_Identifier"), null, null);
        }
        this.isOK = ok;
        if (!ok) {
            this.nameTextField.setText(oldName);
        }
        if (var5_9 == null) return;
        ErrorManager.getDefault().notify((Throwable)var5_9);
    }

    private void initAccessibility() {
        this.nameTextField.getAccessibleContext().setAccessibleName(bundle.getString("ACS_ClassNameTextField"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_ClassNameTextField"));
        this.getAccessibleContext().setAccessibleDescription("ACSD_ClassCustomizerDialog");
    }

    public boolean isOK() {
        this.superClassComboActionPerformed(null);
        this.nameTextFieldFocusLost(null);
        return this.isOK;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

