/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.awt.Component;
import java.beans.FeatureDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.src.ConstructorElement;
import org.openide.src.ElementFormat;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.nodes.ElementNode;
import org.openide.src.nodes.MemberElementNode;
import org.openide.src.nodes.MethodCustomizer;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.HelpCtx;

public class ConstructorElementNode
extends MemberElementNode {
    static /* synthetic */ Class array$Lorg$openide$src$MethodParameter;
    static /* synthetic */ Class array$Lorg$openide$src$Identifier;

    public ConstructorElementNode(ConstructorElement element, boolean writeable) {
        super(element, Children.LEAF, writeable);
        this.setElementFormat0(ElementNode.sourceOptions.getConstructorElementFormat());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.openide.src.ConstructorNode");
    }

    protected String resolveIconBase() {
        int modif = ((ConstructorElement)this.element).getModifiers();
        if (Modifier.isPrivate(modif)) {
            return "org/openide/src/resources/constructorPrivate";
        }
        if (Modifier.isProtected(modif)) {
            return "org/openide/src/resources/constructorProtected";
        }
        if (Modifier.isPublic(modif)) {
            return "org/openide/src/resources/constructorPublic";
        }
        return "org/openide/src/resources/constructorPackage";
    }

    protected ElementFormat getHintElementFormat() {
        return ElementNode.sourceOptions.getConstructorElementLongFormat();
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get("properties");
        ps.put(this.createModifiersProperty(this.writeable));
        ps.put(this.createNameProperty(false));
        ps.put(this.createParametersProperty(this.writeable));
        ps.put(this.createExceptionsProperty(this.writeable));
        ps.setValue("helpID", "org.openide.src.ConstructorProperties");
        return sheet;
    }

    public void destroy() throws IOException {
        if (!(this.element instanceof MethodElement)) {
            SourceEditSupport.invokeAtomicAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

                public void run() throws SourceException {
                    ConstructorElement el = (ConstructorElement)ConstructorElementNode.this.element;
                    el.getDeclaringClass().removeConstructor(el);
                }
            });
        }
        super.destroy();
    }

    public boolean canRename() {
        return false;
    }

    public Component getCustomizer() {
        return new MethodCustomizer((ConstructorElement)this.element);
    }

    public boolean hasCustomizer() {
        return this.isWriteable();
    }

    protected Node.Property createParametersProperty(boolean canW) {
        ElementNode.ElementProp p = new ElementNode.ElementProp("parameters", array$Lorg$openide$src$MethodParameter == null ? (array$Lorg$openide$src$MethodParameter = ConstructorElementNode.class$("[Lorg.openide.src.MethodParameter;")) : array$Lorg$openide$src$MethodParameter, canW){

            public Object getValue() {
                return ((ConstructorElement)ConstructorElementNode.this.element).getParameters();
            }

            public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                if (!(val instanceof MethodParameter[])) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(ConstructorElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(this, val){
                    private final /* synthetic */ Object val$val;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$val = val$val;
                    }

                    public void run() throws SourceException {
                        ((ConstructorElement)2.access$000(this.this$1).element).setParameters((MethodParameter[])this.val$val);
                    }
                });
            }

            static /* synthetic */ ConstructorElementNode access$000(2 x0) {
                return x0.ConstructorElementNode.this;
            }
        };
        ((FeatureDescriptor)((Object)p)).setValue("changeImmediate", Boolean.FALSE);
        return p;
    }

    protected Node.Property createExceptionsProperty(boolean canW) {
        ElementNode.ElementProp p = new ElementNode.ElementProp("exceptions", array$Lorg$openide$src$Identifier == null ? (array$Lorg$openide$src$Identifier = ConstructorElementNode.class$("[Lorg.openide.src.Identifier;")) : array$Lorg$openide$src$Identifier, canW){

            public Object getValue() {
                return ((ConstructorElement)ConstructorElementNode.this.element).getExceptions();
            }

            public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                if (!(val instanceof Identifier[])) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(ConstructorElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(this, val){
                    private final /* synthetic */ Object val$val;
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$val = val$val;
                    }

                    public void run() throws SourceException {
                        ((ConstructorElement)4.access$100(this.this$1).element).setExceptions((Identifier[])this.val$val);
                    }
                });
            }

            static /* synthetic */ ConstructorElementNode access$100(4 x0) {
                return x0.ConstructorElementNode.this;
            }
        };
        ((FeatureDescriptor)((Object)p)).setValue("changeImmediate", Boolean.FALSE);
        return p;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

