/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.src.ElementFormat;
import org.openide.src.InitializerElement;
import org.openide.src.SourceException;
import org.openide.src.nodes.ElementNode;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.HelpCtx;

public class InitializerElementNode
extends ElementNode {
    private static final String[] ICON_AFFECTING_PROPERTIES = new String[]{"static"};

    public InitializerElementNode(InitializerElement element, boolean writeable) {
        super(element, Children.LEAF, writeable);
        this.setElementFormat0(ElementNode.sourceOptions.getInitializerElementFormat());
        this.superSetName("<initializer>");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.openide.src.nodes.InitializerNode");
    }

    protected String resolveIconBase() {
        return ((InitializerElement)this.element).isStatic() ? "org/openide/src/resources/initializerSt" : "org/openide/src/resources/initializer";
    }

    protected String[] getIconAffectingProperties() {
        return ICON_AFFECTING_PROPERTIES;
    }

    protected ElementFormat getHintElementFormat() {
        return ElementNode.sourceOptions.getInitializerElementLongFormat();
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get("properties");
        ps.put(this.createStaticProperty(this.writeable));
        ps.setValue("helpID", "org.openide.src.InitializerProperties");
        return sheet;
    }

    public boolean canRename() {
        return false;
    }

    public void destroy() throws IOException {
        SourceEditSupport.invokeAtomicAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

            public void run() throws SourceException {
                InitializerElement el = (InitializerElement)InitializerElementNode.this.element;
                el.getDeclaringClass().removeInitializer(el);
            }
        });
        super.destroy();
    }

    protected Node.Property createStaticProperty(boolean canW) {
        return new ElementNode.ElementProp("static", Boolean.TYPE, canW){

            public Object getValue() {
                return ((InitializerElement)InitializerElementNode.this.element).isStatic() ? Boolean.TRUE : Boolean.FALSE;
            }

            public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                if (!(val instanceof Boolean)) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(InitializerElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(this, val){
                    private final /* synthetic */ Object val$val;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$val = val$val;
                    }

                    public void run() throws SourceException {
                        ((InitializerElement)2.access$000(this.this$1).element).setStatic((Boolean)this.val$val);
                    }
                });
            }

            static /* synthetic */ InitializerElementNode access$000(2 x0) {
                return x0.InitializerElementNode.this;
            }
        };
    }
}

