/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.beans.FeatureDescriptor;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.editors.ModifierEditor;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.Identifier;
import org.openide.src.MemberElement;
import org.openide.src.SourceException;
import org.openide.src.nodes.ElementNode;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.Utilities;

public abstract class MemberElementNode
extends ElementNode {
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;

    public MemberElementNode(MemberElement element, Children children, boolean writeable) {
        super(element, children, writeable);
        this.superSetName(element.getName().getName());
    }

    public void setName(final String str) {
        try {
            if (this.testJavaId(str)) {
                SourceEditSupport.invokeAtomicAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

                    public void run() throws SourceException {
                        ((MemberElement)MemberElementNode.this.element).setName(Identifier.create(str));
                        MemberElementNode.this.superSetName(str);
                    }
                });
            }
        }
        catch (IOException e) {
            MessageFormat fmt = new MessageFormat(ElementNode.bundle.getString("MSG_ElementCantRename"));
            String[] params = new String[]{((MemberElement)this.element).getName().toString(), e.getMessage()};
            if (params[1] == null) {
                params[1] = "";
            }
            IllegalArgumentException ex = new IllegalArgumentException("Invalid name");
            ErrorManager.getDefault().annotate((Throwable)ex, 256, null, fmt.format(params), (Throwable)e, null);
            throw ex;
        }
    }

    boolean testJavaId(String str) throws IllegalArgumentException {
        boolean ok = Utilities.isJavaIdentifier((String)str);
        if (!ok) {
            IllegalArgumentException ex = new IllegalArgumentException("Invalid identifier");
            ErrorManager.getDefault().annotate((Throwable)ex, 256, null, ElementNode.bundle.getString("MSG_Not_Valid_Identifier"), null, null);
            throw ex;
        }
        return ok;
    }

    protected Node.Property createModifiersProperty(boolean canW) {
        ElementNode.ElementProp p = new ElementNode.ElementProp("modifiers", class$java$lang$Integer == null ? (class$java$lang$Integer = MemberElementNode.class$("java.lang.Integer")) : class$java$lang$Integer, canW){

            public Object getValue() {
                return new Integer(((MemberElement)MemberElementNode.this.element).getModifiers());
            }

            public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                if (!(val instanceof Integer)) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(MemberElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(this, val){
                    private final /* synthetic */ Object val$val;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$val = val$val;
                    }

                    public void run() throws SourceException {
                        ((MemberElement)2.access$000(this.this$1).element).setModifiers((Integer)this.val$val);
                    }
                });
            }

            public PropertyEditor getPropertyEditor() {
                return new ModifierEditor(((MemberElement)MemberElementNode.this.element).getModifiersMask());
            }

            static /* synthetic */ MemberElementNode access$000(2 x0) {
                return x0.MemberElementNode.this;
            }
        };
        ((FeatureDescriptor)((Object)p)).setValue("changeImmediate", Boolean.FALSE);
        return p;
    }

    protected Node.Property createNameProperty(boolean canW) {
        return new ElementNode.ElementProp("name", class$java$lang$String == null ? (class$java$lang$String = MemberElementNode.class$("java.lang.String")) : class$java$lang$String, canW){

            public Object getValue() {
                return ((MemberElement)MemberElementNode.this.element).getName().getName();
            }

            public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                if (!(val instanceof String)) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(MemberElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(this, val){
                    private final /* synthetic */ Object val$val;
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$val = val$val;
                    }

                    public void run() throws SourceException {
                        String sourceName;
                        String fullName = sourceName = ((String)this.val$val).trim();
                        String prevName = ((MemberElement)4.access$100(this.this$1).element).getName().getFullName();
                        int dot = prevName.lastIndexOf(".");
                        if (dot != -1) {
                            fullName = prevName.substring(0, dot + 1) + sourceName;
                        }
                        if (4.access$100(this.this$1).testJavaId(sourceName)) {
                            ((MemberElement)4.access$100(this.this$1).element).setName(Identifier.create(fullName, sourceName));
                        }
                    }
                });
            }

            static /* synthetic */ MemberElementNode access$100(4 x0) {
                return x0.MemberElementNode.this;
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

