/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.event.EnhancedMessageEvent;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.file.DefaultFileHandler;
import org.netbeans.lib.cvsclient.file.FileDetails;
import org.netbeans.lib.cvsclient.file.FileHandler;
import org.netbeans.lib.cvsclient.file.GzippedFileHandler;
import org.netbeans.lib.cvsclient.request.CaseRequest;
import org.netbeans.lib.cvsclient.request.GzipFileContentsRequest;
import org.netbeans.lib.cvsclient.request.Request;
import org.netbeans.lib.cvsclient.request.UnconfiguredRequestException;
import org.netbeans.lib.cvsclient.request.UseUnchangedRequest;
import org.netbeans.lib.cvsclient.request.ValidRequestsRequest;
import org.netbeans.lib.cvsclient.request.ValidResponsesRequest;
import org.netbeans.lib.cvsclient.response.Response;
import org.netbeans.lib.cvsclient.response.ResponseException;
import org.netbeans.lib.cvsclient.response.ResponseFactory;
import org.netbeans.lib.cvsclient.response.ResponseServices;
import org.netbeans.lib.cvsclient.util.BugLog;
import org.netbeans.lib.cvsclient.util.DefaultIgnoreFileFilter;
import org.netbeans.lib.cvsclient.util.IgnoreFileFilter;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;
import org.netbeans.lib.cvsclient.util.Logger;

public class Client
implements ClientServices,
ResponseServices {
    private Connection connection;
    private FileHandler transmitFileHandler;
    private FileHandler gzipFileHandler = new GzippedFileHandler();
    private FileHandler uncompFileHandler = new DefaultFileHandler();
    private boolean dontUseGzipFileHandler;
    private Date modifiedDate;
    private AdminHandler adminHandler;
    private String localPath;
    private boolean isFirstCommand = true;
    private final EventManager eventManager = new EventManager();
    private GlobalOptions globalOptions;
    private boolean abort;
    private ResponseFactory responseFactory;
    private IgnoreFileFilter ignoreFileFilter;

    public Client(Connection connection, AdminHandler adminHandler) {
        this.setConnection(connection);
        this.setAdminHandler(adminHandler);
        this.ignoreFileFilter = new DefaultIgnoreFileFilter();
        this.dontUseGzipFileHandler = false;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
        this.setIsFirstCommand(true);
    }

    public AdminHandler getAdminHandler() {
        return this.adminHandler;
    }

    public void setAdminHandler(AdminHandler adminHandler) {
        this.adminHandler = adminHandler;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        if ((localPath = localPath.replace('\\', '/')).endsWith("/")) {
            localPath = localPath.substring(0, localPath.length() - 1);
        }
        this.localPath = localPath;
    }

    public boolean isFirstCommand() {
        return this.isFirstCommand;
    }

    public void setIsFirstCommand(boolean isFirstCommand) {
        this.isFirstCommand = isFirstCommand;
    }

    public FileHandler getUncompressedFileHandler() {
        return this.uncompFileHandler;
    }

    public void setUncompressedFileHandler(FileHandler uncompFileHandler) {
        this.uncompFileHandler = uncompFileHandler;
    }

    public FileHandler getGzipFileHandler() {
        return this.gzipFileHandler;
    }

    public void setGzipFileHandler(FileHandler gzipFileHandler) {
        this.gzipFileHandler = gzipFileHandler;
    }

    public void dontUseGzipFileHandler() {
        this.setGzipFileHandler(new DefaultFileHandler());
        this.dontUseGzipFileHandler = true;
    }

    public void ensureConnection() throws AuthenticationException {
        BugLog.getInstance().assertNotNull(this.getConnection());
        if (this.getConnection().isOpen()) {
            return;
        }
        this.getConnection().open();
    }

    public void processRequests(List requests) throws IOException, UnconfiguredRequestException, ResponseException, CommandAbortedException {
        if (requests == null || requests.size() == 0) {
            throw new IllegalArgumentException("[processRequests] requests was either null or empty.");
        }
        if (this.abort) {
            throw new CommandAbortedException("Aborted during request processing", CommandException.getLocalMessage("Client.commandAborted", null));
        }
        if (this.isFirstCommand()) {
            this.setIsFirstCommand(false);
            Iterator it = this.globalOptions.createRequestList().iterator();
            while (it.hasNext()) {
                Request request = (Request)it.next();
                requests.add(1, request);
            }
            if (this.globalOptions.isUseGzip()) {
                requests.add(1, new GzipFileContentsRequest());
            }
            if (System.getProperty("os.name").startsWith("Windows")) {
                requests.add(1, new CaseRequest());
            }
            requests.add(1, new UseUnchangedRequest());
            requests.add(1, new ValidRequestsRequest());
            requests.add(1, new ValidResponsesRequest());
        } else if (System.getProperty("javacvs.multiple_commands_warning") == null) {
            System.err.println("WARNING TO DEVELOPERS:");
            System.err.println("Please be warned that attempting to reuse one open connection for more commands is not supported by cvs servers very well.");
            System.err.println("You are advised to open a new Connection each time.");
            System.err.println("If you still want to proceed, please do: System.setProperty(\"javacvs.multiple_commands_warning\", \"false\")");
            System.err.println("That will disable this message.");
        }
        boolean fireEnhancedEvents = this.getEventManager().isFireEnhancedEventSet();
        int fileDetailRequestCount = 0;
        if (fireEnhancedEvents) {
            Iterator it = requests.iterator();
            while (it.hasNext()) {
                Request request = (Request)it.next();
                FileDetails fileDetails = request.getFileForTransmission();
                if (fileDetails == null || !fileDetails.getFile().exists()) continue;
                ++fileDetailRequestCount;
            }
            EnhancedMessageEvent event = new EnhancedMessageEvent((Object)this, "Requests_Count", new Integer(fileDetailRequestCount));
            this.getEventManager().fireCVSEvent(event);
        }
        LoggedDataOutputStream dos = this.connection.getOutputStream();
        LinkedList<Request> streamModifierRequests = new LinkedList<Request>();
        this.transmitFileHandler = this.getUncompressedFileHandler();
        Iterator it = requests.iterator();
        while (it.hasNext()) {
            File file;
            if (this.abort) {
                throw new CommandAbortedException("Aborted during request processing", CommandException.getLocalMessage("Client.commandAborted", null));
            }
            Request request = (Request)it.next();
            if (request instanceof GzipFileContentsRequest && this.dontUseGzipFileHandler) continue;
            String requestString = request.getRequestString();
            dos.writeBytes(requestString);
            request.modifyOutputStream(this.connection);
            if (request.modifiesInputStream()) {
                streamModifierRequests.add(request);
            }
            dos = this.connection.getOutputStream();
            FileDetails fileDetails = request.getFileForTransmission();
            if (fileDetails != null && (file = fileDetails.getFile()).exists()) {
                EnhancedMessageEvent event;
                Logger.logOutput("<Sending file: " + file.getAbsolutePath() + ">\n");
                if (fireEnhancedEvents) {
                    event = new EnhancedMessageEvent((Object)this, "File_Sent_To_Server", file);
                    this.getEventManager().fireCVSEvent(event);
                    --fileDetailRequestCount;
                }
                if (fileDetails.isBinary()) {
                    this.transmitFileHandler.transmitBinaryFile(file, dos);
                } else {
                    this.transmitFileHandler.transmitTextFile(file, dos);
                }
                if (fireEnhancedEvents && fileDetailRequestCount == 0) {
                    event = new EnhancedMessageEvent((Object)this, "All_Requests_Were_Sent", "Ok");
                    this.getEventManager().fireCVSEvent(event);
                }
            }
            if (!request.isResponseExpected()) continue;
            dos.flush();
            Iterator modifiers = streamModifierRequests.iterator();
            while (modifiers.hasNext()) {
                System.err.println("Modifying the inputstream...");
                Request smRequest = (Request)modifiers.next();
                System.err.println("Request is a: " + smRequest.getClass().getName());
                smRequest.modifyInputStream(this.connection);
            }
            streamModifierRequests.clear();
            this.handleResponse();
        }
        dos.flush();
        this.transmitFileHandler = null;
    }

    private ResponseFactory getResponseFactory() {
        if (this.responseFactory == null) {
            this.responseFactory = new ResponseFactory();
        }
        return this.responseFactory;
    }

    private void handleResponse() throws ResponseException, CommandAbortedException {
        try {
            LoggedDataInputStream dis = this.connection.getInputStream();
            byte ch = dis.readByte();
            while (ch != -1) {
                StringBuffer responseNameBuffer = new StringBuffer();
                while (ch != -1 && (char)ch != '\n' && (char)ch != ' ') {
                    responseNameBuffer.append((char)ch);
                    ch = dis.readByte();
                }
                String responseString = responseNameBuffer.toString();
                Response response = this.getResponseFactory().createResponse(responseString);
                response.process(dis, this);
                if (response.isTerminalResponse() || this.abort) break;
                ch = dis.readByte();
            }
            if (this.abort) {
                String localMsg = CommandException.getLocalMessage("Client.commandAborted", null);
                throw new CommandAbortedException("Aborted during request processing", localMsg);
            }
        }
        catch (EOFException ex) {
            throw new ResponseException(ex, CommandException.getLocalMessage("CommandException.EndOfFile", null));
        }
        catch (IOException ex) {
            throw new ResponseException(ex);
        }
    }

    public void executeCommand(Command command, GlobalOptions globalOptions) throws CommandException, CommandAbortedException, AuthenticationException {
        BugLog.getInstance().assertNotNull(command);
        BugLog.getInstance().assertNotNull(globalOptions);
        this.globalOptions = globalOptions;
        this.getUncompressedFileHandler().setGlobalOptions(globalOptions);
        this.getGzipFileHandler().setGlobalOptions(globalOptions);
        try {
            this.eventManager.addCVSListener(command);
            command.execute(this, this.eventManager);
            Object var4_3 = null;
            this.eventManager.removeCVSListener(command);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.eventManager.removeCVSListener(command);
            throw throwable;
        }
    }

    public String convertPathname(String localDirectory, String repository) {
        int lastIndexOfSlash = repository.lastIndexOf(47);
        String filename = repository.substring(lastIndexOfSlash + 1);
        if (localDirectory.startsWith("./")) {
            localDirectory = localDirectory.substring(1);
        }
        if (localDirectory.startsWith("/")) {
            localDirectory = localDirectory.substring(1);
        }
        return this.getLocalPath() + '/' + localDirectory + filename;
    }

    public String getRepository() {
        return this.connection.getRepository();
    }

    public void updateAdminData(String localDirectory, String repositoryPath, Entry entry) throws IOException {
        String absolutePath = this.localPath + '/' + localDirectory;
        repositoryPath = repositoryPath.substring(this.getRepository().length() + 1);
        this.adminHandler.updateAdminData(absolutePath, repositoryPath, entry, this.globalOptions);
    }

    public void setNextFileDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public Date getNextFileDate() {
        Date copy = this.modifiedDate;
        this.modifiedDate = null;
        return copy;
    }

    public Entry getEntry(File f) throws IOException {
        return this.adminHandler.getEntry(f);
    }

    public Iterator getEntries(File directory) throws IOException {
        return this.adminHandler.getEntries(directory);
    }

    public String getRepositoryForDirectory(String directory) throws IOException {
        if ((directory = directory.replace('\\', '/')).endsWith("/")) {
            directory = directory.substring(0, directory.length() - 1);
        }
        try {
            String repository = this.adminHandler.getRepositoryForDirectory(directory, this.getRepository());
            return repository;
        }
        catch (IOException ex) {
            int localPathLength = this.getLocalPath().length();
            String repository = this.getRepository() + directory.substring(localPathLength);
            return repository;
        }
    }

    public void setEntry(File file, Entry entry) throws IOException {
        this.adminHandler.setEntry(file, entry);
    }

    public void removeEntry(File file) throws IOException {
        this.adminHandler.removeEntry(file);
    }

    public void removeLocalFile(String pathname) throws IOException {
        this.transmitFileHandler.removeLocalFile(pathname);
    }

    public void removeLocalFile(String pathName, String repositoryName) throws IOException {
        int ind = repositoryName.lastIndexOf(47);
        if (ind <= 0) {
            return;
        }
        String fileName = repositoryName.substring(ind + 1);
        String localFile = pathName + fileName;
        File fileToDelete = new File(this.getLocalPath(), localFile);
        this.removeLocalFile(fileToDelete.getAbsolutePath());
        this.removeEntry(fileToDelete);
    }

    public void renameLocalFile(String pathname, String newName) throws IOException {
        this.transmitFileHandler.renameLocalFile(pathname, newName);
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public synchronized void abort() {
        this.abort = true;
    }

    public Set getAllFiles(File directory) throws IOException {
        return this.adminHandler.getAllFiles(directory);
    }

    public void setIgnoreFileFilter(IgnoreFileFilter ignoreFileFilter) {
        this.ignoreFileFilter = ignoreFileFilter;
    }

    public IgnoreFileFilter getIgnoreFileFilter() {
        return this.ignoreFileFilter;
    }

    public boolean shouldBeIgnored(File directory, String noneCvsFile) {
        if (this.ignoreFileFilter != null) {
            return this.ignoreFileFilter.shouldBeIgnored(directory, noneCvsFile);
        }
        return false;
    }

    public String getStickyTagForDirectory(File directory) {
        return this.adminHandler.getStickyTagForDirectory(directory);
    }
}

