/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.admin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.GlobalOptions;

public class StandardAdminHandler
implements AdminHandler {
    public void updateAdminData(String localDirectory, String repositoryPath, Entry entry, GlobalOptions globalOptions) throws IOException {
        File entriesFile;
        File repositoryFile;
        File CVSdir = new File(localDirectory, "CVS");
        CVSdir.mkdirs();
        File rootFile = new File(CVSdir, "Root");
        if (!rootFile.exists()) {
            BufferedWriter w = new BufferedWriter(new FileWriter(rootFile));
            w.write(globalOptions.getCVSRoot());
            ((Writer)w).close();
        }
        if (!(repositoryFile = new File(CVSdir, "Repository")).exists()) {
            BufferedWriter w = new BufferedWriter(new FileWriter(repositoryFile));
            if (repositoryPath.endsWith("/")) {
                repositoryPath = repositoryPath.substring(0, repositoryPath.length() - 1);
            }
            if (repositoryPath.length() == 0) {
                repositoryPath = ".";
            }
            w.write(repositoryPath);
            ((Writer)w).close();
        }
        if ((entriesFile = new File(CVSdir, "Entries")).createNewFile()) {
            this.addDirectoryToParentEntriesFile(CVSdir);
            BufferedWriter w = new BufferedWriter(new FileWriter(entriesFile));
            w.write("D");
            ((Writer)w).close();
        }
        if (entry != null) {
            this.updateEntriesFile(entriesFile, entry);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addDirectoryToParentEntriesFile(File CVSdir) throws IOException {
        File parentCVSEntries = new File(CVSdir.getParentFile().getParentFile(), "CVS/Entries");
        if (parentCVSEntries.exists()) {
            String line;
            File directory = parentCVSEntries.getParentFile();
            File tempFile = new File(directory, "Entries.Backup");
            tempFile.createNewFile();
            BufferedReader reader = new BufferedReader(new FileReader(parentCVSEntries));
            BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));
            boolean written = false;
            Entry directoryEntry = new Entry();
            directoryEntry.setName(CVSdir.getParentFile().getName());
            directoryEntry.setDirectory(true);
            while ((line = reader.readLine()) != null) {
                void var7_9;
                if (var7_9.trim().equals("D")) continue;
                Entry currentEntry = new Entry((String)var7_9);
                if (currentEntry.getName() != null && currentEntry.getName().equals(directoryEntry.getName())) {
                    writer.write(directoryEntry.toString());
                    written = true;
                } else {
                    writer.write((String)var7_9);
                }
                writer.newLine();
            }
            if (!written) {
                writer.write(directoryEntry.toString());
                writer.newLine();
            }
            writer.close();
            reader.close();
            File temp2 = new File(directory, "Entries.Backup2");
            parentCVSEntries.renameTo(temp2);
            tempFile.renameTo(parentCVSEntries);
            temp2.delete();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateEntriesFile(File originalFile, Entry entry) throws IOException {
        String line;
        File directory = originalFile.getParentFile();
        File tempFile = new File(directory, "Entries.Backup");
        tempFile.createNewFile();
        BufferedReader reader = new BufferedReader(new FileReader(originalFile));
        BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));
        boolean written = false;
        while ((line = reader.readLine()) != null) {
            void var7_8;
            Entry currentEntry = new Entry((String)var7_8);
            if (currentEntry.getName() != null && currentEntry.getName().equals(entry.getName())) {
                writer.write(entry.toString());
                written = true;
            } else {
                writer.write((String)var7_8);
            }
            writer.newLine();
        }
        if (!written) {
            writer.write(entry.toString());
            writer.newLine();
        }
        writer.close();
        reader.close();
        File temp2 = new File(directory, "Entries.Backup2");
        originalFile.renameTo(temp2);
        tempFile.renameTo(originalFile);
        temp2.delete();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Entry getEntry(File file) throws IOException {
        boolean found;
        Entry entry;
        block7: {
            File entriesFile = new File(file.getParent(), "CVS/Entries");
            if (entriesFile == null || !entriesFile.exists()) {
                return null;
            }
            this.processEntriesDotLog(new File(file.getParent(), "CVS"));
            BufferedReader reader = null;
            entry = null;
            found = false;
            try {
                reader = new BufferedReader(new FileReader(entriesFile));
                while (true) {
                    void var6_6;
                    block10: {
                        block9: {
                            if (found) break block9;
                            String line = reader.readLine();
                            if (line != null) break block10;
                        }
                        Object var8_7 = null;
                        if (reader == null) break block7;
                        break;
                    }
                    entry = new Entry((String)var6_6);
                    if (entry.getName() == null) continue;
                    found = entry.getName().equals(file.getName());
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (reader != null) {
                    reader.close();
                }
                throw throwable;
            }
            reader.close();
        }
        if (!found) {
            return null;
        }
        return entry;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Entry[] getEntriesAsArray(File directory) throws IOException {
        LinkedList<Entry> entries;
        block5: {
            entries = new LinkedList<Entry>();
            File entriesFile = new File(directory, "CVS/Entries");
            if (entriesFile == null) return new Entry[0];
            if (!entriesFile.exists()) {
                return new Entry[0];
            }
            this.processEntriesDotLog(new File(directory, "CVS"));
            BufferedReader reader = null;
            Entry entry = null;
            try {
                reader = new BufferedReader(new FileReader(entriesFile));
                while (true) {
                    void var6_6;
                    String line;
                    if ((line = reader.readLine()) == null) {
                        Object var8_7 = null;
                        if (reader == null) break block5;
                        break;
                    }
                    entry = new Entry((String)var6_6);
                    if (entry.getName() == null) continue;
                    entries.add(entry);
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (reader == null) throw throwable;
                reader.close();
                throw throwable;
            }
            reader.close();
        }
        Entry[] toReturnArray = new Entry[entries.size()];
        return entries.toArray(toReturnArray);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Iterator getEntries(File directory) throws IOException {
        LinkedList<Entry> entries = new LinkedList<Entry>();
        File entriesFile = new File(directory, "CVS/Entries");
        if (entriesFile == null || !entriesFile.exists()) {
            return entries.iterator();
        }
        this.processEntriesDotLog(new File(directory, "CVS"));
        BufferedReader reader = null;
        Entry entry = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(entriesFile));
            while ((line = reader.readLine()) != null) {
                void var6_6;
                entry = new Entry((String)var6_6);
                if (entry.getName() == null) continue;
                entries.add(entry);
            }
            Object var8_7 = null;
            if (reader == null) return entries.iterator();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (reader == null) throw throwable;
            reader.close();
            throw throwable;
        }
        reader.close();
        return entries.iterator();
    }

    public void setEntry(File file, Entry entry) throws IOException {
        String parent = file.getParent();
        File entriesFile = new File(parent, "CVS/Entries");
        this.processEntriesDotLog(new File(parent, "CVS"));
        this.updateEntriesFile(entriesFile, entry);
    }

    /*
     * WARNING - void declaration
     */
    public void removeEntry(File file) throws IOException {
        String line;
        File entriesFile = new File(file.getParent(), "CVS/Entries");
        if (entriesFile == null || !entriesFile.exists()) {
            return;
        }
        this.processEntriesDotLog(new File(file.getParent(), "CVS"));
        File directory = file.getParentFile();
        File tempFile = new File(directory, "Entries.Backup");
        tempFile.createNewFile();
        BufferedReader reader = new BufferedReader(new FileReader(entriesFile));
        BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));
        boolean directoriesExist = false;
        while ((line = reader.readLine()) != null) {
            void var7_8;
            Entry currentEntry = new Entry((String)var7_8);
            if (currentEntry.getName() == null || currentEntry.getName().equals(file.getName())) continue;
            writer.write(currentEntry.toString());
            writer.newLine();
            boolean bl = directoriesExist = directoriesExist || currentEntry.isDirectory();
        }
        if (!directoriesExist) {
            writer.write("D");
            writer.newLine();
        }
        writer.close();
        reader.close();
        File temp2 = new File(directory, "Entries.Backup2");
        entriesFile.renameTo(temp2);
        tempFile.renameTo(entriesFile);
        temp2.delete();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getRepositoryForDirectory(String directory, String repository) throws IOException {
        String fileRepository;
        String repositoryDirs;
        block9: {
            BufferedReader reader;
            File repositoryFile = null;
            repositoryDirs = "";
            File dirFile = new File(directory);
            while (true) {
                if (dirFile == null || dirFile.getName().length() == 0 || !dirFile.exists()) {
                    throw new FileNotFoundException("Repository file not found for directory " + directory);
                }
                repositoryFile = new File(dirFile, "CVS/Repository");
                if (repositoryFile.exists()) {
                    reader = null;
                    fileRepository = null;
                    try {
                        reader = new BufferedReader(new FileReader(repositoryFile));
                        fileRepository = reader.readLine();
                        Object var9_8 = null;
                        if (reader != null) {
                            break;
                        }
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        if (reader != null) {
                            reader.close();
                        }
                        throw throwable;
                    }
                }
                repositoryDirs = '/' + dirFile.getName() + repositoryDirs;
                dirFile = dirFile.getParentFile();
            }
            reader.close();
        }
        if (fileRepository == null) {
            fileRepository = "";
        }
        if ((fileRepository = fileRepository + repositoryDirs).startsWith("/")) {
            return fileRepository;
        }
        return repository + '/' + fileRepository;
    }

    /*
     * WARNING - void declaration
     */
    private void processEntriesDotLog(File directory) throws IOException {
        String line;
        File entriesDotLogFile = new File(directory, "Entries.Log");
        if (!entriesDotLogFile.exists()) {
            return;
        }
        BufferedReader reader = new BufferedReader(new FileReader(entriesDotLogFile));
        LinkedList<Entry> additionsList = new LinkedList<Entry>();
        HashSet<String> removalSet = new HashSet<String>();
        while ((line = reader.readLine()) != null) {
            Entry entry;
            void var6_6;
            if (var6_6.startsWith("A ")) {
                entry = new Entry(var6_6.substring(2));
                additionsList.add(entry);
                continue;
            }
            if (!var6_6.startsWith("R ")) continue;
            entry = new Entry(var6_6.substring(2));
            removalSet.add(entry.getName());
        }
        reader.close();
        if (additionsList.size() > 0 || removalSet.size() > 0) {
            File backup = new File(directory, "Entries.Backup");
            BufferedWriter writer = new BufferedWriter(new FileWriter(backup));
            File entriesFile = new File(directory, "Entries");
            reader = new BufferedReader(new FileReader(entriesFile));
            int directoryCount = 0;
            while ((line = reader.readLine()) != null) {
                if (line.trim().equals("D")) continue;
                Entry entry = new Entry(line);
                if (entry.isDirectory()) {
                    ++directoryCount;
                }
                if (removalSet.contains(entry.getName())) continue;
                writer.write(entry.toString());
                writer.newLine();
                if (!entry.isDirectory()) continue;
                --directoryCount;
            }
            Iterator it = additionsList.iterator();
            while (it.hasNext()) {
                Entry entry = (Entry)it.next();
                if (entry.isDirectory()) {
                    ++directoryCount;
                }
                writer.write(entry.toString());
                writer.newLine();
            }
            if (directoryCount == 0) {
                writer.write("D");
                writer.newLine();
            }
            reader.close();
            writer.close();
            File temp2 = new File(directory, "Entries.Backup2");
            entriesFile.renameTo(temp2);
            backup.renameTo(entriesFile);
            temp2.delete();
        }
        entriesDotLogFile.delete();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set getAllFiles(File directory) throws IOException {
        BufferedReader reader;
        TreeSet<File> fileSet;
        block6: {
            TreeSet<File> treeSet;
            block5: {
                fileSet = new TreeSet<File>();
                reader = null;
                try {
                    File entriesFile = new File(directory, "CVS/Entries");
                    if (!entriesFile.exists()) {
                        treeSet = fileSet;
                        Object var9_7 = null;
                        if (reader == null) return treeSet;
                        break block5;
                    }
                    reader = new BufferedReader(new FileReader(entriesFile));
                    while (true) {
                        File f;
                        void var5_6;
                        String line;
                        if ((line = reader.readLine()) == null) {
                            break block6;
                        }
                        Entry entry = new Entry((String)var5_6);
                        if (entry.getName() == null || (f = new File(directory, entry.getName())).isDirectory()) continue;
                        fileSet.add(f);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (reader == null) throw throwable;
                    reader.close();
                    throw throwable;
                }
            }
            reader.close();
            return treeSet;
        }
        Object var9_8 = null;
        if (reader == null) return fileSet;
        reader.close();
        return fileSet;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getStickyTagForDirectory(File directory) {
        reader = null;
        tagFile = new File(directory, "CVS/Tag");
        try {
            try {
                reader = new BufferedReader(new FileReader(tagFile));
                var5_6 = tag = reader.readLine();
                var7_7 = null;
                if (reader == null) return var5_6;
            }
            catch (IOException ex) {
                var7_8 = null;
                if (reader == null) return null;
                try {
                    reader.close();
                    return null;
                }
                catch (IOException ex) {
                    return null;
                }
            }
        }
        catch (Throwable var6_13) {
            var7_9 = null;
            if (reader == null) throw var6_13;
            ** try [egrp 2[TRYBLOCK] [2 : 67->74)] { 
lbl25:
            // 1 sources

            reader.close();
            throw var6_13;
lbl27:
            // 1 sources

            catch (IOException ex) {
                // empty catch block
            }
            throw var6_13;
        }
        ** try [egrp 2[TRYBLOCK] [2 : 67->74)] { 
lbl32:
        // 1 sources

        reader.close();
        return var5_6;
lbl34:
        // 1 sources

        catch (IOException ex) {
            // empty catch block
        }
        return var5_6;
    }
}

