/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.DateComparator;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BuildableCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.EntryRequest;
import org.netbeans.lib.cvsclient.request.ModifiedRequest;
import org.netbeans.lib.cvsclient.request.QuestionableRequest;
import org.netbeans.lib.cvsclient.request.Request;
import org.netbeans.lib.cvsclient.request.RootRequest;
import org.netbeans.lib.cvsclient.request.StickyRequest;
import org.netbeans.lib.cvsclient.request.UnchangedRequest;

public abstract class BasicCommand
extends BuildableCommand {
    protected List requests = new LinkedList();
    protected ClientServices clientServices;
    private boolean recursive = true;
    protected File[] files;

    public boolean getRecursive() {
        return this.recursive;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void setFiles(File[] theFiles) {
        if (theFiles == null) {
            this.files = theFiles;
            return;
        }
        this.files = new File[theFiles.length];
        int fileCount = 0;
        int dirCount = 0;
        int totalCount = theFiles.length;
        int index = 0;
        while (index < totalCount) {
            File currentFile = theFiles[index];
            if (currentFile.isDirectory()) {
                this.files[totalCount - (1 + dirCount)] = currentFile;
                ++dirCount;
            } else {
                this.files[fileCount] = currentFile;
                ++fileCount;
            }
            ++index;
        }
    }

    public File[] getFiles() {
        return this.files;
    }

    public File getXthFile(int index) {
        if (index < 0 || index >= this.files.length) {
            return null;
        }
        File file = this.files[index];
        if (!file.isFile()) {
            return null;
        }
        return file;
    }

    public File getFileEndingWith(String ending) {
        String locEnding = ending.replace('\\', '/');
        String localDir = this.getLocalDirectory().replace('\\', '/');
        int index = 0;
        index = 0;
        while (index < this.files.length) {
            String path = this.files[index].getAbsolutePath();
            String parentPath = this.files[index].getParentFile().getAbsolutePath().replace('\\', '/');
            if ((path = path.replace('\\', '/')).endsWith(locEnding) && locEnding.indexOf(47) >= 0 || this.files[index].getName().equals(locEnding) && parentPath.equals(localDir)) {
                return this.files[index];
            }
            ++index;
        }
        return null;
    }

    private void addRequests(File path) throws FileNotFoundException, IOException {
        if (path == null) {
            throw new IllegalArgumentException("Cannot add requests for a null path.");
        }
        if (!path.exists() || path.isFile()) {
            this.addRequestsForFile(path);
        } else {
            this.addRequestsForDirectory(path);
        }
    }

    protected boolean doesCheckFileTime() {
        return true;
    }

    protected void sendEntryAndModifiedRequests(Entry entry, File file) {
        if (entry == null) {
            return;
        }
        if (file != null && !file.exists() && entry.isNewUserFile()) {
            return;
        }
        Date entryLastModified = entry.getLastModified();
        boolean hadConflicts = entry.hadConflicts();
        if (!hadConflicts) {
            entry.setConflict(null);
        }
        this.addRequest(new EntryRequest(entry));
        if (file == null || !file.exists() || entry.isUserFileToBeRemoved()) {
            return;
        }
        if (this.doesCheckFileTime() && !hadConflicts && entryLastModified != null && DateComparator.getInstance().equals(file.lastModified(), entryLastModified.getTime())) {
            this.addRequest(new UnchangedRequest(file.getName()));
            return;
        }
        this.addRequest(new ModifiedRequest(file, entry.isBinary()));
    }

    protected void addRequestsForDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        this.addDirectoryRequest(directory);
        List localFiles = this.createLocalFileList(directory);
        LinkedList<File> subDirectories = null;
        if (this.isRecursive()) {
            subDirectories = new LinkedList<File>();
        }
        Iterator it = this.clientServices.getEntries(directory);
        while (it.hasNext()) {
            Entry entry = (Entry)it.next();
            if (entry.isDirectory()) {
                if (!this.isRecursive()) continue;
                subDirectories.add(new File(directory, entry.getName()));
                continue;
            }
            File file = new File(directory, entry.getName());
            this.addRequestForFile(file, entry);
            localFiles.remove(file);
        }
        Iterator it2 = localFiles.iterator();
        while (it2.hasNext()) {
            String localFileName = ((File)it2.next()).getName();
            if (this.clientServices.shouldBeIgnored(directory, localFileName)) continue;
            this.addRequest(new QuestionableRequest(localFileName));
        }
        if (this.isRecursive()) {
            Iterator it3 = subDirectories.iterator();
            while (it3.hasNext()) {
                File subdirectory = (File)it3.next();
                File cvsSubDir = new File(subdirectory, "CVS");
                if (!cvsSubDir.exists()) continue;
                this.addRequestsForDirectory(subdirectory);
            }
        }
    }

    private List createLocalFileList(File directory) {
        LinkedList<File> localFiles = new LinkedList<File>();
        File[] files = directory.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (!files[i].isDirectory()) {
                    localFiles.add(files[i]);
                }
                ++i;
            }
        }
        return localFiles;
    }

    protected void addRequestForFile(File file, Entry entry) {
        this.sendEntryAndModifiedRequests(entry, file);
    }

    protected void addRequestsForFile(File file) throws IOException {
        this.addDirectoryRequest(file.getParentFile());
        try {
            Entry entry = this.clientServices.getEntry(file);
            if (entry != null) {
                this.addRequestForFile(file, entry);
            }
        }
        catch (IOException ex) {
            System.err.println("An error occurred getting the Entry for file " + file + ": " + ex);
            ex.printStackTrace();
        }
    }

    protected final void addDirectoryRequest(File directory) {
        String dir = this.getRelativeToLocalPathInUnixStyle(directory);
        try {
            String repository = this.clientServices.getRepositoryForDirectory(directory.getAbsolutePath());
            this.addRequest(new DirectoryRequest(dir, repository));
            String tag = this.clientServices.getStickyTagForDirectory(directory);
            if (tag != null) {
                this.addRequest(new StickyRequest(tag));
            }
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
            System.err.println("An error occurred reading the respository for the directory " + dir + ": " + ex);
            ex.printStackTrace();
        }
    }

    protected void addArgumentRequests() {
        if (this.files == null) {
            return;
        }
        int i = 0;
        while (i < this.files.length) {
            File file = this.files[i];
            String relativePath = this.getRelativeToLocalPathInUnixStyle(file);
            this.addRequest(new ArgumentRequest(relativePath));
            ++i;
        }
    }

    public void execute(ClientServices client, EventManager em) throws CommandException, AuthenticationException {
        this.requests.clear();
        super.execute(client, em);
        this.clientServices = client;
        if (client.isFirstCommand()) {
            this.addRequest(new RootRequest(client.getRepository()));
        }
        this.addFileRequests();
    }

    private void addFileRequests() throws CommandException {
        try {
            if (this.files != null && this.files.length > 0) {
                int i = 0;
                while (i < this.files.length) {
                    this.addRequests(this.files[i]);
                    ++i;
                }
            } else if (this.assumeLocalPathWhenUnspecified()) {
                this.addRequests(new File(this.getLocalDirectory()));
            }
        }
        catch (Exception ex) {
            throw new CommandException(ex, ex.getLocalizedMessage());
        }
    }

    protected boolean assumeLocalPathWhenUnspecified() {
        return true;
    }

    protected final void addRequest(Request request) {
        this.requests.add(request);
    }

    protected final void addRequestForWorkingDirectory(ClientServices clientServices) throws IOException {
        this.addRequest(new DirectoryRequest(".", clientServices.getRepositoryForDirectory(this.getLocalDirectory())));
    }

    protected final void addArgumentRequest(boolean value, String argument) {
        if (!value) {
            return;
        }
        this.addRequest(new ArgumentRequest(argument));
    }

    protected final void appendFileArguments(StringBuffer buffer) {
        File[] files = this.getFiles();
        if (files == null) {
            return;
        }
        int index = 0;
        while (index < files.length) {
            if (index > 0) {
                buffer.append(' ');
            }
            buffer.append(files[index].getName());
            ++index;
        }
    }
}

