/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EnhancedMessageEvent;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.event.TerminationEvent;

public abstract class BuildableCommand
extends Command {
    protected Builder builder;
    private final StringBuffer taggedLineBuffer = new StringBuffer();
    private boolean builderSet;

    public void execute(ClientServices client, EventManager eventManager) throws CommandException, AuthenticationException {
        super.execute(client, eventManager);
        if (this.builder == null && !this.isBuilderSet()) {
            this.builder = this.createBuilder(eventManager);
        }
    }

    public Builder createBuilder(EventManager eventManager) {
        return null;
    }

    public void messageSent(MessageEvent e) {
        if (this.builder == null) {
            return;
        }
        if (e instanceof EnhancedMessageEvent) {
            EnhancedMessageEvent eEvent = (EnhancedMessageEvent)e;
            this.builder.parseEnhancedMessage(eEvent.getKey(), eEvent.getValue());
            return;
        }
        if (e.isTagged()) {
            String message = MessageEvent.parseTaggedMessage(this.taggedLineBuffer, e.getMessage());
            if (message != null) {
                this.builder.parseLine(message, false);
                this.taggedLineBuffer.setLength(0);
            }
        } else {
            if (this.taggedLineBuffer.length() > 0) {
                this.builder.parseLine(this.taggedLineBuffer.toString(), false);
                this.taggedLineBuffer.setLength(0);
            }
            this.builder.parseLine(e.getMessage(), e.isError());
        }
    }

    protected boolean isBuilderSet() {
        return this.builderSet;
    }

    public void setBuilder(Builder builder) {
        this.builder = builder;
        this.builderSet = true;
    }

    public void commandTerminated(TerminationEvent e) {
        if (this.builder == null) {
            return;
        }
        if (this.taggedLineBuffer.length() > 0) {
            this.builder.parseLine(this.taggedLineBuffer.toString(), false);
            this.taggedLineBuffer.setLength(0);
        }
        this.builder.outputDone();
    }
}

