/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.request.GlobalOptionRequest;
import org.netbeans.lib.cvsclient.request.Request;
import org.netbeans.lib.cvsclient.request.SetRequest;

public class GlobalOptions
implements Cloneable {
    private List variables = new ArrayList();
    private boolean doNoChanges;
    private boolean checkedOutFilesReadOnly;
    private String cvsRoot;
    private boolean useGzip = true;
    private boolean noHistoryLogging;
    private boolean moderatelyQuiet;
    private boolean veryQuiet;
    private boolean traceExecution;

    public List createRequestList() {
        LinkedList<Request> requestList = new LinkedList<Request>();
        if (this.variables.size() > 0) {
            Iterator it = this.variables.iterator();
            while (it.hasNext()) {
                String keyValue = it.next().toString();
                requestList.add(new SetRequest(keyValue));
            }
        }
        if (this.isNoHistoryLogging()) {
            requestList.add(new GlobalOptionRequest("-l"));
        }
        if (this.isDoNoChanges()) {
            requestList.add(new GlobalOptionRequest("-n"));
        }
        if (this.isModeratelyQuiet()) {
            requestList.add(new GlobalOptionRequest("-q"));
        }
        if (this.isVeryQuiet()) {
            requestList.add(new GlobalOptionRequest("-Q"));
        }
        if (this.isTraceExecution()) {
            requestList.add(new GlobalOptionRequest("-t"));
        }
        return requestList;
    }

    public String getOptString() {
        return "nd:lqQtrs:";
    }

    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'n') {
            this.setDoNoChanges(true);
        } else if (opt == 'd') {
            this.setCVSRoot(optArg);
        } else if (opt == 'l') {
            this.setNoHistoryLogging(true);
        } else if (opt == 'q') {
            this.setModeratelyQuiet(true);
        } else if (opt == 'Q') {
            this.setVeryQuiet(true);
        } else if (opt == 't') {
            this.setTraceExecution(true);
        } else if (opt == 't') {
            this.setTraceExecution(true);
        } else if (opt == 'r') {
            this.setCheckedOutFilesReadOnly(true);
        } else if (opt == 's') {
            this.setCvsVariable(optArg);
        } else {
            return false;
        }
        return true;
    }

    public void resetCVSCommand() {
        this.setCheckedOutFilesReadOnly(false);
        this.setDoNoChanges(false);
        this.setModeratelyQuiet(false);
        this.setNoHistoryLogging(false);
        this.setTraceExecution(false);
        this.setUseGzip(true);
        this.setVeryQuiet(false);
        this.setCVSRoot("");
        this.clearCvsVariables();
    }

    public String getCVSCommand() {
        StringBuffer switches = new StringBuffer();
        if (this.isDoNoChanges()) {
            switches.append("-n ");
        }
        if (this.isNoHistoryLogging()) {
            switches.append("-l ");
        }
        if (this.isModeratelyQuiet()) {
            switches.append("-q ");
        }
        if (this.isVeryQuiet()) {
            switches.append("-Q ");
        }
        if (this.isTraceExecution()) {
            switches.append("-t ");
        }
        if (this.isCheckedOutFilesReadOnly()) {
            switches.append("-r ");
        }
        if (this.variables.size() > 0) {
            Iterator it = this.variables.iterator();
            while (it.hasNext()) {
                String keyValue = it.next().toString();
                switches.append("-s " + keyValue + " ");
            }
        }
        return switches.toString();
    }

    public void setCvsVariable(String variable) {
        this.variables.add(variable);
    }

    public void clearCvsVariables() {
        this.variables.clear();
    }

    public void setCvsVariables(String[] variables) {
        this.clearCvsVariables();
        int i = 0;
        while (i < variables.length) {
            String variable = variables[i];
            this.variables.add(variable);
            ++i;
        }
    }

    public String[] getCvsVariables() {
        String[] vars = new String[this.variables.size()];
        vars = this.variables.toArray(vars);
        return vars;
    }

    public void setDoNoChanges(boolean doNoChanges) {
        this.doNoChanges = doNoChanges;
    }

    public boolean isDoNoChanges() {
        return this.doNoChanges;
    }

    public boolean isCheckedOutFilesReadOnly() {
        return this.checkedOutFilesReadOnly;
    }

    public void setCheckedOutFilesReadOnly(boolean readOnly) {
        this.checkedOutFilesReadOnly = readOnly;
    }

    public String getCVSRoot() {
        return this.cvsRoot;
    }

    public void setCVSRoot(String cvsRoot) {
        this.cvsRoot = cvsRoot;
    }

    public void setUseGzip(boolean useGzip) {
        this.useGzip = useGzip;
    }

    public boolean isUseGzip() {
        return this.useGzip;
    }

    public boolean isNoHistoryLogging() {
        return this.noHistoryLogging;
    }

    public void setNoHistoryLogging(boolean noHistoryLogging) {
        this.noHistoryLogging = noHistoryLogging;
    }

    public boolean isModeratelyQuiet() {
        return this.moderatelyQuiet;
    }

    public void setModeratelyQuiet(boolean moderatelyQuiet) {
        this.moderatelyQuiet = moderatelyQuiet;
    }

    public boolean isVeryQuiet() {
        return this.veryQuiet;
    }

    public void setVeryQuiet(boolean veryQuiet) {
        this.veryQuiet = veryQuiet;
    }

    public boolean isTraceExecution() {
        return this.traceExecution;
    }

    public void setTraceExecution(boolean traceExecution) {
        this.traceExecution = traceExecution;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }
}

