/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import java.io.File;
import java.io.IOException;
import org.netbeans.lib.cvsclient.command.BuildableCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.PipedFileInformation;
import org.netbeans.lib.cvsclient.command.TemporaryFileCreator;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;

public class PipedFilesBuilder
implements Builder {
    private static final String ERR_START = "=======";
    private static final String ERR_CHECK = "Checking out ";
    private static final String ERR_RCS = "RCS:  ";
    private static final String ERR_VERS = "VERS: ";
    private static final String EXAM_DIR = "server: Updating";
    private PipedFileInformation fileInformation;
    private EventManager eventManager;
    private String fileDirectory;
    private BuildableCommand command;
    private TemporaryFileCreator tempFileCreator;

    public PipedFilesBuilder(EventManager eventManager, BuildableCommand command, TemporaryFileCreator tempFileCreator) {
        this.eventManager = eventManager;
        this.command = command;
        this.tempFileCreator = tempFileCreator;
    }

    public void outputDone() {
        if (this.fileInformation == null) {
            return;
        }
        try {
            this.fileInformation.closeTempFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.fileInformation));
        this.fileInformation = null;
    }

    public void parseLine(String line, boolean isErrorMessage) {
        if (isErrorMessage) {
            if (line.indexOf(EXAM_DIR) >= 0) {
                this.fileDirectory = line.substring(line.indexOf(EXAM_DIR) + EXAM_DIR.length()).trim();
            } else if (line.startsWith(ERR_CHECK)) {
                this.processFile(line);
            } else if (line.startsWith(ERR_RCS)) {
                if (this.fileInformation != null) {
                    String repositoryName = line.substring(ERR_RCS.length()).trim();
                    this.fileInformation.setRepositoryFileName(repositoryName);
                }
            } else if (line.startsWith(ERR_VERS) && this.fileInformation != null) {
                String repositoryRevision = line.substring(ERR_RCS.length()).trim();
                this.fileInformation.setRepositoryRevision(repositoryRevision);
            }
        } else if (this.fileInformation != null) {
            try {
                this.fileInformation.addToTempFile(line);
            }
            catch (IOException exc) {
                this.outputDone();
            }
        }
    }

    private void processFile(String line) {
        this.outputDone();
        String filename = line.substring(ERR_CHECK.length());
        try {
            File temporaryFile = this.tempFileCreator.createTempFile(filename);
            this.fileInformation = new PipedFileInformation(temporaryFile);
        }
        catch (IOException ex) {
            this.fileInformation = null;
            return;
        }
        this.fileInformation.setFile(this.createFile(filename));
    }

    private File createFile(String fileName) {
        File file = new File(this.command.getLocalDirectory(), fileName);
        return file;
    }

    public void parseEnhancedMessage(String key, Object value) {
    }
}

