/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.edit;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.Watch;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.NotifyRequest;

public class EditCommand
extends BasicCommand {
    private boolean checkThatUnedited;
    private boolean forceEvenIfEdited;
    private Watch temporaryWatch;
    private transient ClientServices clientServices;

    public static File getEditBackupFile(File file) {
        return new File(file.getParent(), "CVS/Base/" + file.getName());
    }

    public EditCommand() {
        this.resetCVSCommand();
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException {
        block7: {
            this.clientServices = clientServices;
            try {
                try {
                    clientServices.ensureConnection();
                    super.execute(clientServices, eventManager);
                    this.addArgumentRequest(this.isCheckThatUnedited(), "-c");
                    this.addArgumentRequest(this.isForceEvenIfEdited(), "-f");
                    this.addRequestForWorkingDirectory(clientServices);
                    this.addRequest(CommandRequest.NOOP);
                    clientServices.processRequests(this.requests);
                }
                catch (AuthenticationException ex) {
                    Object var8_4 = null;
                    this.requests.clear();
                    this.clientServices = null;
                    break block7;
                }
                catch (CommandException ex) {
                    throw ex;
                }
                catch (EOFException ex) {
                    throw new CommandException(ex, CommandException.getLocalMessage("CommandException.EndOfFile", null));
                }
                catch (Exception ex) {
                    throw new CommandException(ex, ex.getLocalizedMessage());
                }
                Object var8_3 = null;
                this.requests.clear();
                this.clientServices = null;
            }
            catch (Throwable throwable) {
                Object var8_5 = null;
                this.requests.clear();
                this.clientServices = null;
                throw throwable;
            }
        }
    }

    protected void addRequestForFile(File file, Entry entry) {
        String temporaryWatch = Watch.getWatchString(this.getTemporaryWatch());
        this.requests.add(new NotifyRequest(file, "E", temporaryWatch));
        try {
            this.editFile(this.clientServices, file);
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public void commandTerminated(TerminationEvent e) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public String getCVSCommand() {
        StringBuffer cvsCommandLine = new StringBuffer("edit ");
        cvsCommandLine.append(this.getCVSArguments());
        this.appendFileArguments(cvsCommandLine);
        return cvsCommandLine.toString();
    }

    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'R') {
            this.setRecursive(true);
        } else if (opt == 'l') {
            this.setRecursive(false);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "Rl";
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setCheckThatUnedited(false);
        this.setForceEvenIfEdited(true);
        this.setTemporaryWatch(null);
    }

    public String getCVSArguments() {
        StringBuffer cvsArguments = new StringBuffer();
        if (!this.isRecursive()) {
            cvsArguments.append("-l ");
        }
        return cvsArguments.toString();
    }

    public boolean isCheckThatUnedited() {
        return this.checkThatUnedited;
    }

    public void setCheckThatUnedited(boolean checkThatUnedited) {
        this.checkThatUnedited = checkThatUnedited;
    }

    public boolean isForceEvenIfEdited() {
        return this.forceEvenIfEdited;
    }

    public void setForceEvenIfEdited(boolean forceEvenIfEdited) {
        this.forceEvenIfEdited = forceEvenIfEdited;
    }

    public Watch getTemporaryWatch() {
        return this.temporaryWatch;
    }

    public void setTemporaryWatch(Watch temporaryWatch) {
        this.temporaryWatch = temporaryWatch;
    }

    private void editFile(ClientServices clientServices, File file) throws IOException {
        this.addBaserevEntry(clientServices, file);
        FileUtils.copyFile(file, EditCommand.getEditBackupFile(file));
        FileUtils.setFileReadOnly(file, false);
    }

    /*
     * Loose catch block
     */
    private void addBaserevEntry(ClientServices clientServices, File file) throws IOException {
        File backupFile;
        File baserevFile;
        block26: {
            IOException ex222;
            String entryStart;
            boolean writeFailed;
            boolean append;
            BufferedWriter writer;
            BufferedReader reader;
            Entry entry;
            block24: {
                entry = clientServices.getEntry(file);
                if (entry == null || entry.getRevision() == null || entry.isNewUserFile() || entry.isUserFileToBeRemoved()) {
                    throw new IllegalArgumentException("File does not have an Entry or Entry is invalid!");
                }
                baserevFile = new File(file.getParentFile(), "CVS/Baserev");
                backupFile = new File(baserevFile.getAbsolutePath() + '~');
                reader = null;
                writer = null;
                append = true;
                writeFailed = true;
                entryStart = 'B' + file.getName() + '/';
                writer = new BufferedWriter(new FileWriter(backupFile));
                writeFailed = false;
                reader = new BufferedReader(new FileReader(baserevFile));
                String line = reader.readLine();
                while (line != null) {
                    if (line.startsWith(entryStart)) {
                        append = false;
                    }
                    writeFailed = true;
                    writer.write(line);
                    writer.newLine();
                    writeFailed = false;
                    line = reader.readLine();
                }
                Object var13_13 = null;
                if (reader == null) break block24;
                try {
                    reader.close();
                }
                catch (IOException ex222) {
                    // empty catch block
                }
            }
            if (writer != null) {
                if (append && !writeFailed) {
                    writer.write(entryStart + entry.getRevision() + '/');
                    writer.newLine();
                }
                try {
                    writer.close();
                }
                catch (IOException ex222) {}
            }
            break block26;
            {
                catch (IOException ex3) {
                    IOException ex222;
                    if (writeFailed) {
                        throw ex3;
                    }
                    Object var13_14 = null;
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ex222) {
                            // empty catch block
                        }
                    }
                    if (writer != null) {
                        if (append && !writeFailed) {
                            writer.write(entryStart + entry.getRevision() + '/');
                            writer.newLine();
                        }
                        try {
                            writer.close();
                        }
                        catch (IOException ex222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException ex222;
                Object var13_15 = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex222) {
                        // empty catch block
                    }
                }
                if (writer != null) {
                    if (append && !writeFailed) {
                        writer.write(entryStart + entry.getRevision() + '/');
                        writer.newLine();
                    }
                    try {
                        writer.close();
                    }
                    catch (IOException ex222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        baserevFile.delete();
        backupFile.renameTo(baserevFile);
    }
}

