/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.export;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.command.export.ExportBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.event.ModuleExpansionEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.ExpandModulesRequest;
import org.netbeans.lib.cvsclient.request.RootRequest;

public class ExportCommand
extends BasicCommand {
    private final Set emptyDirectories = new HashSet();
    private final List modules = new LinkedList();
    private final List expandedModules = new LinkedList();
    private boolean pruneDirectories;
    private KeywordSubstitutionOptions keywordSubstitutionOptions;
    private String exportByDate;
    private String exportByRevision;
    private String exportDirectory;
    private boolean useHeadIfNotFound;

    public ExportCommand() {
        this.resetCVSCommand();
    }

    public KeywordSubstitutionOptions getKeywordSubstitutionOptions() {
        return this.keywordSubstitutionOptions;
    }

    public void setKeywordSubstitutionOptions(KeywordSubstitutionOptions keywordSubstitutionOptions) {
        this.keywordSubstitutionOptions = keywordSubstitutionOptions;
    }

    public void setPruneDirectories(boolean pruneDirectories) {
        this.pruneDirectories = pruneDirectories;
    }

    public boolean isPruneDirectories() {
        return this.pruneDirectories;
    }

    public void setModule(String module) {
        this.modules.add(module);
    }

    public void clearModules() {
        this.modules.clear();
    }

    public void setModules(String[] modules) {
        this.clearModules();
        if (modules == null) {
            return;
        }
        int i = 0;
        while (i < modules.length) {
            String module = modules[i];
            this.modules.add(module);
            ++i;
        }
    }

    public String[] getModules() {
        String[] mods = new String[this.modules.size()];
        mods = this.modules.toArray(mods);
        return mods;
    }

    private void processExistingModules(String localPath) {
        if (this.expandedModules.size() == 0) {
            return;
        }
        String[] directories = new String[this.expandedModules.size()];
        directories = this.expandedModules.toArray(directories);
        this.setModules(directories);
    }

    public void execute(ClientServices client, EventManager em) throws CommandException, AuthenticationException {
        client.ensureConnection();
        this.requests = new LinkedList();
        if (client.isFirstCommand()) {
            this.requests.add(new RootRequest(client.getRepository()));
        }
        Iterator it = this.modules.iterator();
        while (it.hasNext()) {
            String module = (String)it.next();
            this.requests.add(new ArgumentRequest(module));
        }
        this.expandedModules.clear();
        this.requests.add(new DirectoryRequest(".", client.getRepository()));
        this.requests.add(new ExpandModulesRequest());
        try {
            client.processRequests(this.requests);
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CommandException(ex, ex.getLocalizedMessage());
        }
        this.requests.clear();
        this.postExpansionExecute(client, em);
    }

    public void moduleExpanded(ModuleExpansionEvent e) {
        this.expandedModules.add(e.getModule());
    }

    private void postExpansionExecute(ClientServices client, EventManager em) throws CommandException, AuthenticationException {
        this.processExistingModules(client.getLocalPath());
        super.execute(client, em);
        boolean FIRST_INDEX = false;
        boolean SECOND_INDEX = true;
        if (!this.isRecursive()) {
            this.requests.add(0, new ArgumentRequest("-l"));
        }
        if (this.useHeadIfNotFound) {
            this.requests.add(0, new ArgumentRequest("-f"));
        }
        if (this.exportDirectory != null && !this.exportDirectory.equals("")) {
            this.requests.add(0, new ArgumentRequest("-d"));
            this.requests.add(1, new ArgumentRequest(this.getExportDirectory()));
        }
        if (this.exportByDate != null && this.exportByDate.length() > 0) {
            this.requests.add(0, new ArgumentRequest("-D"));
            this.requests.add(1, new ArgumentRequest(this.getExportByDate()));
        }
        if (this.exportByRevision != null && this.exportByRevision.length() > 0) {
            this.requests.add(0, new ArgumentRequest("-r"));
            this.requests.add(1, new ArgumentRequest(this.getExportByRevision()));
        }
        if (this.getKeywordSubstitutionOptions() != null) {
            this.requests.add(new ArgumentRequest("-k" + this.getKeywordSubstitutionOptions()));
        }
        Iterator it = this.modules.iterator();
        while (it.hasNext()) {
            String module = (String)it.next();
            this.requests.add(new ArgumentRequest(module));
        }
        this.requests.add(new DirectoryRequest(".", client.getRepository()));
        this.requests.add(CommandRequest.EXPORT);
        try {
            client.processRequests(this.requests);
            if (this.pruneDirectories) {
                this.pruneEmptyDirectories();
            }
            this.requests.clear();
        }
        catch (CommandException ex) {
            this.removeAllCVSAdminFiles();
            throw ex;
        }
        catch (Exception ex) {
            this.removeAllCVSAdminFiles();
            throw new CommandException(ex, ex.getLocalizedMessage());
        }
        this.removeAllCVSAdminFiles();
    }

    private void removeAllCVSAdminFiles() {
        File rootDirect = null;
        if (this.getExportDirectory() != null) {
            rootDirect = new File(this.getLocalDirectory(), this.getExportDirectory());
            this.deleteCVSSubDirs(rootDirect);
        } else {
            rootDirect = new File(this.getLocalDirectory());
            Iterator mods = this.modules.iterator();
            while (mods.hasNext()) {
                String mod = mods.next().toString();
                File modRoot = new File(rootDirect.getAbsolutePath(), mod);
                this.deleteCVSSubDirs(modRoot);
            }
        }
    }

    private void deleteCVSSubDirs(File root) {
        if (root.isDirectory()) {
            File[] subDirs = root.listFiles();
            if (subDirs == null) {
                return;
            }
            int i = 0;
            while (i < subDirs.length) {
                if (subDirs[i].isDirectory()) {
                    if (subDirs[i].getName().equalsIgnoreCase("CVS")) {
                        File[] adminFiles = subDirs[i].listFiles();
                        int j = 0;
                        while (j < adminFiles.length) {
                            adminFiles[j].delete();
                            ++j;
                        }
                        subDirs[i].delete();
                    } else {
                        this.deleteCVSSubDirs(subDirs[i]);
                    }
                }
                ++i;
            }
        }
    }

    public String getCVSCommand() {
        StringBuffer toReturn = new StringBuffer("export ");
        toReturn.append(this.getCVSArguments());
        if (this.modules != null && this.modules.size() > 0) {
            Iterator it = this.modules.iterator();
            while (it.hasNext()) {
                String module = (String)it.next();
                toReturn.append(module);
                toReturn.append(' ');
            }
        } else {
            String localizedMsg = CommandException.getLocalMessage("ExportCommand.moduleEmpty.text");
            toReturn.append(" ");
            toReturn.append(localizedMsg);
        }
        return toReturn.toString();
    }

    public String getCVSArguments() {
        StringBuffer toReturn = new StringBuffer("");
        if (!this.isRecursive()) {
            toReturn.append("-l ");
        }
        if (this.isUseHeadIfNotFound()) {
            toReturn.append("-f ");
        }
        if (this.getExportByDate() != null) {
            toReturn.append("-D ");
            toReturn.append(this.getExportByDate());
            toReturn.append(" ");
        }
        if (this.getExportByRevision() != null) {
            toReturn.append("-r ");
            toReturn.append(this.getExportByRevision());
            toReturn.append(" ");
        }
        if (this.isPruneDirectories()) {
            toReturn.append("-P ");
        }
        if (this.getExportDirectory() != null) {
            toReturn.append("-d ");
            toReturn.append(this.getExportDirectory());
            toReturn.append(" ");
        }
        if (this.getKeywordSubstitutionOptions() != null) {
            toReturn.append("-k");
            toReturn.append(this.getKeywordSubstitutionOptions().toString());
            toReturn.append(" ");
        }
        return toReturn.toString();
    }

    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'k') {
            this.setKeywordSubstitutionOptions(KeywordSubstitutionOptions.findKeywordSubstOption(optArg));
        } else if (opt == 'r') {
            this.setExportByRevision(optArg);
        } else if (opt == 'f') {
            this.setUseHeadIfNotFound(true);
        } else if (opt == 'D') {
            this.setExportByDate(optArg);
        } else if (opt == 'd') {
            this.setExportDirectory(optArg);
        } else if (opt == 'P') {
            this.setPruneDirectories(true);
        } else if (opt == 'l') {
            this.setRecursive(false);
        } else if (opt == 'R') {
            this.setRecursive(true);
        } else {
            return false;
        }
        return true;
    }

    public void resetCVSCommand() {
        this.setModules(null);
        this.setKeywordSubstitutionOptions(null);
        this.setPruneDirectories(false);
        this.setRecursive(true);
        this.setExportByDate(null);
        this.setExportByRevision(null);
        this.setExportDirectory(null);
        this.setUseHeadIfNotFound(false);
    }

    public String getOptString() {
        return "k:r:D:PlRd:f";
    }

    public Builder createBuilder(EventManager eventManager) {
        return new ExportBuilder(eventManager, this);
    }

    public void messageSent(MessageEvent e) {
        super.messageSent(e);
        if (this.pruneDirectories && e.getMessage().startsWith("cvs server: Exporting ")) {
            File file = new File(this.getLocalDirectory(), e.getMessage().substring(21));
            this.emptyDirectories.add(file);
        }
    }

    private boolean pruneEmptyDirectory(File directory) throws IOException {
        boolean empty = true;
        File[] contents = directory.listFiles();
        if (contents != null) {
            File entriesFile;
            int i = 0;
            while (i < contents.length) {
                if (contents[i].isFile()) {
                    empty = false;
                } else if (!contents[i].getName().equals("CVS")) {
                    empty = this.pruneEmptyDirectory(contents[i]);
                }
                if (!empty) break;
                ++i;
            }
            if (empty && (entriesFile = new File(directory, "CVS/Entries")).exists()) {
                File adminDir = new File(directory, "CVS");
                File[] adminFiles = adminDir.listFiles();
                int i2 = 0;
                while (i2 < adminFiles.length) {
                    adminFiles[i2].delete();
                    ++i2;
                }
                adminDir.delete();
                directory.delete();
            }
        }
        return empty;
    }

    private void pruneEmptyDirectories() throws IOException {
        Iterator it = this.emptyDirectories.iterator();
        while (it.hasNext()) {
            File dir = (File)it.next();
            if (!dir.exists()) continue;
            this.pruneEmptyDirectory(dir);
        }
        this.emptyDirectories.clear();
    }

    public String getExportByDate() {
        return this.exportByDate;
    }

    public void setExportByDate(String exportByDate) {
        this.exportByDate = exportByDate;
    }

    public String getExportByRevision() {
        return this.exportByRevision;
    }

    public void setExportByRevision(String exportByRevision) {
        this.exportByRevision = exportByRevision;
    }

    public String getExportDirectory() {
        return this.exportDirectory;
    }

    public void setExportDirectory(String exportDirectory) {
        this.exportDirectory = exportDirectory;
    }

    public boolean isUseHeadIfNotFound() {
        return this.useHeadIfNotFound;
    }

    public void setUseHeadIfNotFound(boolean useHeadIfNotFound) {
        this.useHeadIfNotFound = useHeadIfNotFound;
    }
}

