/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.status;

import java.io.File;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.status.StatusBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;

public class StatusCommand
extends BasicCommand {
    private EventManager eventManager;
    private boolean includeTags;

    public Builder createBuilder(EventManager eventManager) {
        return new StatusBuilder(eventManager, this);
    }

    public void execute(ClientServices client, EventManager em) throws CommandException, AuthenticationException {
        client.ensureConnection();
        this.eventManager = em;
        super.execute(client, em);
        try {
            try {
                if (this.includeTags) {
                    this.requests.add(1, new ArgumentRequest("-v"));
                }
                this.addRequestForWorkingDirectory(client);
                this.addArgumentRequests();
                this.addRequest(CommandRequest.STATUS);
                client.processRequests(this.requests);
            }
            catch (CommandException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new CommandException(e, e.getLocalizedMessage());
            }
            Object var6_3 = null;
            this.requests.clear();
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.requests.clear();
            throw throwable;
        }
    }

    public boolean isIncludeTags() {
        return this.includeTags;
    }

    public void setIncludeTags(boolean inclTags) {
        this.includeTags = inclTags;
    }

    public void commandTerminated(TerminationEvent e) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public String getCVSCommand() {
        StringBuffer toReturn = new StringBuffer("status ");
        toReturn.append(this.getCVSArguments());
        File[] files = this.getFiles();
        if (files != null) {
            int index = 0;
            while (index < files.length) {
                toReturn.append(files[index].getName());
                toReturn.append(' ');
                ++index;
            }
        }
        return toReturn.toString();
    }

    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'R') {
            this.setRecursive(true);
        } else if (opt == 'l') {
            this.setRecursive(false);
        } else if (opt == 'v') {
            this.setIncludeTags(true);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "Rlv";
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setIncludeTags(false);
    }

    public String getCVSArguments() {
        StringBuffer toReturn = new StringBuffer("");
        if (this.isIncludeTags()) {
            toReturn.append("-v ");
        }
        if (!this.isRecursive()) {
            toReturn.append("-l ");
        }
        return toReturn.toString();
    }
}

