/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.unedit;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.Watch;
import org.netbeans.lib.cvsclient.command.edit.EditCommand;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.NotifyRequest;

public class UneditCommand
extends BasicCommand {
    private Watch temporaryWatch;

    public UneditCommand() {
        this.resetCVSCommand();
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        clientServices.ensureConnection();
        try {
            try {
                super.execute(clientServices, eventManager);
                this.addRequestForWorkingDirectory(clientServices);
                this.addRequest(CommandRequest.NOOP);
                clientServices.processRequests(this.requests);
            }
            catch (CommandException ex) {
                throw ex;
            }
            catch (EOFException ex) {
                throw new CommandException(ex, CommandException.getLocalMessage("CommandException.EndOfFile", null));
            }
            catch (Exception ex) {
                throw new CommandException(ex, ex.getLocalizedMessage());
            }
            Object var7_3 = null;
            this.requests.clear();
        }
        catch (Throwable throwable) {
            Object var7_4 = null;
            this.requests.clear();
            throw throwable;
        }
    }

    protected void addRequestForFile(File file, Entry entry) {
        String temporaryWatch = Watch.getWatchString(this.getTemporaryWatch());
        this.requests.add(new NotifyRequest(file, "U", temporaryWatch));
        try {
            this.uneditFile(file);
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public void commandTerminated(TerminationEvent e) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public String getCVSCommand() {
        StringBuffer cvsCommandLine = new StringBuffer("unedit ");
        cvsCommandLine.append(this.getCVSArguments());
        this.appendFileArguments(cvsCommandLine);
        return cvsCommandLine.toString();
    }

    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'R') {
            this.setRecursive(true);
        } else if (opt == 'l') {
            this.setRecursive(false);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "Rl";
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
    }

    public String getCVSArguments() {
        StringBuffer cvsArguments = new StringBuffer();
        if (!this.isRecursive()) {
            cvsArguments.append("-l ");
        }
        return cvsArguments.toString();
    }

    public Watch getTemporaryWatch() {
        return this.temporaryWatch;
    }

    public void setTemporaryWatch(Watch temporaryWatch) {
        this.temporaryWatch = temporaryWatch;
    }

    private void uneditFile(File file) throws IOException {
        this.removeBaserevEntry(file);
        EditCommand.getEditBackupFile(file).delete();
        FileUtils.setFileReadOnly(file, true);
    }

    /*
     * Loose catch block
     */
    private void removeBaserevEntry(File file) throws IOException {
        File backupFile;
        File baserevFile;
        block23: {
            IOException ex222;
            BufferedWriter writer;
            BufferedReader reader;
            block21: {
                baserevFile = new File(file.getParentFile(), "CVS/Baserev");
                backupFile = new File(baserevFile.getAbsolutePath() + '~');
                reader = null;
                writer = null;
                String entryStart = 'B' + file.getName() + '/';
                writer = new BufferedWriter(new FileWriter(backupFile));
                reader = new BufferedReader(new FileReader(baserevFile));
                String line = reader.readLine();
                while (line != null) {
                    if (!line.startsWith(entryStart)) {
                        writer.write(line);
                        writer.newLine();
                    }
                    line = reader.readLine();
                }
                Object var9_9 = null;
                if (writer == null) break block21;
                try {
                    writer.close();
                }
                catch (IOException ex222) {
                    // empty catch block
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex222) {}
            }
            break block23;
            {
                catch (FileNotFoundException ex3) {
                    IOException ex222;
                    Object var9_10 = null;
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException ex222) {
                            // empty catch block
                        }
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ex222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException ex222;
                Object var9_11 = null;
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException ex222) {
                        // empty catch block
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        baserevFile.delete();
        if (backupFile.length() > 0L) {
            backupFile.renameTo(baserevFile);
        } else {
            backupFile.delete();
        }
    }
}

