/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.watch;

import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.Watch;
import org.netbeans.lib.cvsclient.command.watch.WatchMode;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;

public class WatchCommand
extends BasicCommand {
    private WatchMode watchMode;
    private Watch watch;

    public WatchCommand() {
        this.resetCVSCommand();
    }

    public void execute(ClientServices client, EventManager eventManager) throws CommandException, AuthenticationException {
        this.checkState();
        client.ensureConnection();
        try {
            try {
                super.execute(client, eventManager);
                if (this.getWatchMode().isWatchOptionAllowed()) {
                    String[] arguments = this.getWatchNotNull().getArguments();
                    int i = 0;
                    while (i < arguments.length) {
                        this.addRequest(new ArgumentRequest("-a"));
                        this.addRequest(new ArgumentRequest(arguments[i]));
                        ++i;
                    }
                }
                this.addRequestForWorkingDirectory(client);
                this.addArgumentRequests();
                this.addRequest(this.getWatchMode().getCommand());
                client.processRequests(this.requests);
            }
            catch (CommandException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CommandException(ex, ex.getLocalizedMessage());
            }
            Object var6_7 = null;
            this.requests.clear();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.requests.clear();
            throw throwable;
        }
    }

    public void commandTerminated(TerminationEvent e) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'R') {
            this.setRecursive(true);
        } else if (opt == 'l') {
            this.setRecursive(false);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "Rl";
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setWatch(null);
    }

    public String getCVSCommand() {
        StringBuffer cvsCommand = new StringBuffer("watch ");
        cvsCommand.append(this.getCVSArguments());
        this.appendFileArguments(cvsCommand);
        return cvsCommand.toString();
    }

    public String getCVSArguments() {
        this.checkState();
        StringBuffer cvsArguments = new StringBuffer();
        cvsArguments.append(this.getWatchMode().toString());
        cvsArguments.append(' ');
        if (!this.isRecursive()) {
            cvsArguments.append("-l ");
        }
        if (this.getWatchMode().isWatchOptionAllowed()) {
            cvsArguments.append("-a ");
            cvsArguments.append(this.getWatchNotNull().toString());
        }
        return cvsArguments.toString();
    }

    public WatchMode getWatchMode() {
        return this.watchMode;
    }

    public void setWatchMode(WatchMode watchMode) {
        this.watchMode = watchMode;
    }

    public Watch getWatch() {
        return this.watch;
    }

    private Watch getWatchNotNull() {
        if (this.watch == null) {
            return Watch.ALL;
        }
        return this.watch;
    }

    public void setWatch(Watch watch) {
        this.watch = watch;
    }

    private void checkState() {
        if (this.getWatchMode() == null) {
            throw new IllegalStateException("Watch mode expected!");
        }
    }
}

