/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.watchers;

import java.io.File;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.watchers.WatchersBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.request.CommandRequest;

public class WatchersCommand
extends BasicCommand {
    public WatchersCommand() {
        this.resetCVSCommand();
    }

    public Builder createBuilder(EventManager eventManager) {
        return new WatchersBuilder(eventManager, this.getLocalDirectory());
    }

    public void execute(ClientServices client, EventManager eventManager) throws CommandException, AuthenticationException {
        client.ensureConnection();
        super.execute(client, eventManager);
        try {
            try {
                this.addRequestForWorkingDirectory(client);
                this.addArgumentRequests();
                this.addRequest(CommandRequest.WATCHERS);
                client.processRequests(this.requests);
            }
            catch (CommandException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CommandException(ex, ex.getLocalizedMessage());
            }
            Object var6_3 = null;
            this.requests.clear();
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.requests.clear();
            throw throwable;
        }
    }

    public void commandTerminated(TerminationEvent e) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public String getCVSCommand() {
        StringBuffer toReturn = new StringBuffer("watchers ");
        toReturn.append(this.getCVSArguments());
        File[] files = this.getFiles();
        if (files != null) {
            int index = 0;
            while (index < files.length) {
                toReturn.append(files[index].getName());
                toReturn.append(' ');
                ++index;
            }
        }
        return toReturn.toString();
    }

    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'R') {
            this.setRecursive(true);
        } else if (opt == 'l') {
            this.setRecursive(false);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "Rl";
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
    }

    public String getCVSArguments() {
        StringBuffer toReturn = new StringBuffer();
        if (!this.isRecursive()) {
            toReturn.append("-l ");
        }
        return toReturn.toString();
    }
}

