/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.commandLine;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.commandLine.BasicListener;
import org.netbeans.lib.cvsclient.commandLine.CommandFactory;
import org.netbeans.lib.cvsclient.commandLine.GetOpt;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.PServerConnection;
import org.netbeans.lib.cvsclient.connection.ServerConnection;
import org.netbeans.lib.cvsclient.connection.StandardScrambler;

public class CVSCommand {
    private String repository;
    private String localPath;
    private Connection connection;
    private Client client;
    private GlobalOptions globalOptions;

    public void executeCommand(Command command) throws CommandException, AuthenticationException {
        this.client.executeCommand(command, this.globalOptions);
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public void setGlobalOptions(GlobalOptions globalOptions) {
        this.globalOptions = globalOptions;
    }

    private void connectToServer(PrintStream stdout, PrintStream stderr) throws AuthenticationException {
        ServerConnection c = new ServerConnection();
        this.connection = c;
        c.setRepository(this.repository);
        c.open();
        this.client = new Client(c, new StandardAdminHandler());
        this.client.setLocalPath(this.localPath);
        this.client.getEventManager().addCVSListener(new BasicListener(stdout, stderr));
    }

    private void connectToServer(String userName, String encodedPassword, String hostName, int port, PrintStream stdout, PrintStream stderr) throws AuthenticationException {
        PServerConnection c = new PServerConnection();
        this.connection = c;
        c.setUserName(userName);
        c.setEncodedPassword(encodedPassword);
        c.setHostName(hostName);
        c.setRepository(this.repository);
        c.setPort(port);
        c.open();
        this.client = new Client(c, new StandardAdminHandler());
        this.client.setLocalPath(this.localPath);
        this.client.getEventManager().addCVSListener(new BasicListener(stdout, stderr));
    }

    private void close(PrintStream stderr) {
        try {
            this.connection.close();
        }
        catch (IOException e) {
            stderr.println("Unable to close connection: " + e);
        }
    }

    /*
     * Loose catch block
     */
    private static String getCVSRoot() {
        String root;
        block13: {
            BufferedReader r;
            block12: {
                root = null;
                r = null;
                File f = new File(System.getProperty("user.dir"));
                File rootFile = new File(f, "CVS/Root");
                if (!rootFile.exists()) break block12;
                r = new BufferedReader(new FileReader(rootFile));
                root = r.readLine();
            }
            Object var5_5 = null;
            try {
                if (r != null) {
                    r.close();
                }
                break block13;
            }
            catch (IOException e2) {
                System.err.println("Warning: could not close CVS/Root file!");
            }
            break block13;
            {
                catch (IOException e) {
                    Object var5_6 = null;
                    try {
                        if (r != null) {
                            r.close();
                        }
                        break block13;
                    }
                    catch (IOException e2) {
                        System.err.println("Warning: could not close CVS/Root file!");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (r != null) {
                        r.close();
                    }
                }
                catch (IOException e2) {
                    System.err.println("Warning: could not close CVS/Root file!");
                }
                throw throwable;
            }
        }
        if (root == null) {
            root = System.getProperty("cvs.root");
        }
        return root;
    }

    private static int processGlobalOptions(String[] args, GlobalOptions globalOptions, PrintStream stderr) {
        String getOptString = "Hrwd:z:";
        GetOpt go = new GetOpt(args, "Hrwd:z:");
        int ch = -1;
        boolean usagePrint = false;
        while ((ch = go.getopt()) != -1) {
            if ((char)ch == 'H') {
                usagePrint = true;
                continue;
            }
            if ((char)ch == 'r') {
                globalOptions.setCheckedOutFilesReadOnly(true);
                continue;
            }
            if ((char)ch == 'w') {
                globalOptions.setCheckedOutFilesReadOnly(false);
                continue;
            }
            if ((char)ch == 'd') {
                globalOptions.setCVSRoot(go.optArgGet());
                continue;
            }
            if ((char)ch == 'z') {
                globalOptions.setUseGzip(true);
                go.optArgGet();
                continue;
            }
            usagePrint = true;
        }
        if (usagePrint) {
            CVSCommand.showUsage(stderr);
            return -10;
        }
        return go.optIndexGet();
    }

    private static void showUsage(PrintStream stderr) {
        stderr.println("Usage: cvs [global options] command [options]");
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private static boolean performLogin(String userName, String hostName, String repository, int port, GlobalOptions globalOptions) {
        block22: {
            BufferedReader reader;
            BufferedWriter writer;
            File passFile;
            block21: {
                String line;
                PServerConnection c = new PServerConnection();
                c.setUserName(userName);
                String password = null;
                try {
                    BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                    System.out.print("Enter password: ");
                    password = in.readLine();
                }
                catch (IOException e) {
                    System.err.println("Could not read password: " + e);
                    return false;
                }
                String encodedPassword = StandardScrambler.getInstance().scramble(password);
                c.setEncodedPassword(encodedPassword);
                c.setHostName(hostName);
                c.setRepository(repository);
                c.setPort(port);
                try {
                    c.verify();
                }
                catch (AuthenticationException e) {
                    System.err.println("Could not login to host " + hostName);
                    return false;
                }
                passFile = new File(System.getProperty("cvs.passfile", System.getProperty("user.home") + "/.cvspass"));
                writer = null;
                reader = null;
                if (passFile.createNewFile()) {
                    writer = new BufferedWriter(new FileWriter(passFile));
                    writer.write(globalOptions.getCVSRoot() + " " + encodedPassword);
                    writer.close();
                    break block21;
                }
                File tempFile = File.createTempFile("cvs", "tmp");
                reader = new BufferedReader(new FileReader(passFile));
                writer = new BufferedWriter(new FileWriter(tempFile));
                while ((line = reader.readLine()) != null) {
                    void var12_15;
                    if (var12_15.startsWith(globalOptions.getCVSRoot())) {
                        writer.write(globalOptions.getCVSRoot() + " " + encodedPassword);
                        continue;
                    }
                    writer.write((String)var12_15);
                }
                reader.close();
                writer.close();
                File temp2File = File.createTempFile("cvs", "tmp");
                passFile.renameTo(temp2File);
                tempFile.renameTo(passFile);
                temp2File.delete();
                tempFile.delete();
            }
            Object var15_18 = null;
            try {
                if (writer != null) {
                    writer.close();
                }
                if (reader != null) {
                    reader.close();
                }
                break block22;
            }
            catch (Exception e2) {}
            break block22;
            {
                catch (IOException e) {
                    System.err.println("Error: could not write password file to " + passFile);
                    boolean bl = false;
                    Object var15_19 = null;
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var15_20 = null;
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        System.err.println("Logged in successfully to repository " + repository + " on host " + hostName);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static String lookupPassword(String CVSRoot, PrintStream stderr) {
        block12: {
            passFile = new File(System.getProperty("cvs.passfile", System.getProperty("user.home") + "/.cvspass"));
            reader = null;
            password = null;
            try {
                reader = new BufferedReader(new FileReader(passFile));
                while ((line = reader.readLine()) != null) {
                    if (!var5_5.startsWith(CVSRoot)) continue;
                    password = var5_5.substring(CVSRoot.length() + 1);
                }
lbl11:
                // 2 sources

                var8_7 = null;
                ** if (reader == null) goto lbl-1000
            }
            catch (Throwable var7_14) {
                var8_9 = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        stderr.println("Warning: could not close password file.");
                    }
                }
                throw var7_14;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    stderr.println("Warning: could not close password file.");
                }
            }
lbl-1000:
            // 2 sources

            {
                break block12;
                catch (IOException e) {
                    stderr.println("Could not read password for host: " + e);
                    var6_13 = null;
                    var8_8 = null;
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            stderr.println("Warning: could not close password file.");
                        }
                    }
                    return var6_13;
                }
            }
            ** GOTO lbl11
        }
        return password;
    }

    public static void main(String[] args) {
        if (CVSCommand.processCommand(args, null, System.getProperty("user.dir"), System.out, System.err)) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    public static boolean processCommand(String[] args, File[] files, String localPath, PrintStream stdout, PrintStream stderr) {
        GlobalOptions globalOptions = new GlobalOptions();
        globalOptions.setCVSRoot(CVSCommand.getCVSRoot());
        int commandIndex = -1;
        try {
            commandIndex = CVSCommand.processGlobalOptions(args, globalOptions, stderr);
            if (commandIndex == -10) {
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            stderr.println("Invalid argument: " + e);
            return false;
        }
        if (globalOptions.getCVSRoot() == null) {
            stderr.println("No CVS root is set. Use the cvs.root property, e.g. java -Dcvs.root=\":pserver:user@host:/usr/cvs\" or start the application in a directory containing a CVS subdirectory or use the -d command switch.");
            return false;
        }
        CVSRoot root = null;
        String cvsRoot = globalOptions.getCVSRoot();
        try {
            root = new CVSRoot(cvsRoot);
        }
        catch (IllegalArgumentException e) {
            stderr.println("Incorrect format for CVSRoot: " + cvsRoot + "\nThe correct format is: :<connection-type>:user@host:<repository path>" + "\nwhere <connection-type> is pserver and <repository path> is the " + "path to the cvs repository on the server.");
            return false;
        }
        if (commandIndex >= args.length) {
            CVSCommand.showUsage(stderr);
            return false;
        }
        String command = args[commandIndex];
        if (command.equals("login")) {
            if (root.connectionType.equals("pserver")) {
                return CVSCommand.performLogin(root.user, root.host, root.repository, root.port, globalOptions);
            }
            stderr.println("login does not apply for connection type '" + root.connectionType + "'");
            return false;
        }
        Command c = null;
        try {
            c = CommandFactory.getCommand(command, args, ++commandIndex);
        }
        catch (IllegalArgumentException e) {
            stderr.println("Illegal argument: " + e.getMessage());
            return false;
        }
        if (files != null && c instanceof BasicCommand) {
            ((BasicCommand)c).setFiles(files);
        }
        String password = null;
        if (root.connectionType.equals("pserver")) {
            password = CVSCommand.lookupPassword(cvsRoot, stderr);
        }
        CVSCommand cvsCommand = new CVSCommand();
        cvsCommand.setGlobalOptions(globalOptions);
        cvsCommand.setRepository(root.repository);
        cvsCommand.setLocalPath(localPath);
        try {
            try {
                if (root.connectionType.equals("pserver")) {
                    cvsCommand.connectToServer(root.user, password, root.host, root.port, stdout, stderr);
                } else {
                    cvsCommand.connectToServer(stdout, stderr);
                }
                cvsCommand.executeCommand(c);
            }
            catch (Exception t) {
                stderr.println("Error: " + t);
                t.printStackTrace(stderr);
                boolean bl = false;
                Object var16_17 = null;
                if (cvsCommand != null) {
                    cvsCommand.close(stderr);
                }
                return bl;
            }
            Object var16_16 = null;
            if (cvsCommand != null) {
                cvsCommand.close(stderr);
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            if (cvsCommand != null) {
                cvsCommand.close(stderr);
            }
            throw throwable;
        }
        return true;
    }

    private static class CVSRoot {
        public String connectionType;
        public String user;
        public String host;
        public String repository;
        public int port = 2401;

        public CVSRoot(String root) throws IllegalArgumentException {
            if (!root.startsWith(":")) {
                throw new IllegalArgumentException();
            }
            int oldColonPosition = 0;
            int colonPosition = root.indexOf(58, 1);
            if (colonPosition == -1) {
                throw new IllegalArgumentException();
            }
            this.connectionType = root.substring(oldColonPosition + 1, colonPosition);
            oldColonPosition = colonPosition;
            if ((colonPosition = root.indexOf(64, colonPosition + 1)) == -1) {
                throw new IllegalArgumentException();
            }
            this.user = root.substring(oldColonPosition + 1, colonPosition);
            oldColonPosition = colonPosition;
            if ((colonPosition = root.indexOf(58, colonPosition + 1)) == -1) {
                throw new IllegalArgumentException();
            }
            this.host = root.substring(oldColonPosition + 1, colonPosition);
            this.repository = root.substring(colonPosition + 1);
            boolean isNumber = true;
            int index = 0;
            String numString = "";
            while (isNumber) {
                try {
                    int num = Integer.parseInt(this.repository.substring(index, index + 1));
                    numString = numString + Integer.toString(num);
                    ++index;
                }
                catch (NumberFormatException exc) {
                    isNumber = false;
                }
            }
            if (numString.length() > 0) {
                try {
                    this.port = Integer.parseInt(numString);
                    this.repository = root.substring(numString.length());
                }
                catch (NumberFormatException exc) {
                    // empty catch block
                }
            }
            if (this.connectionType == null || this.user == null || this.host == null || this.repository == null) {
                throw new IllegalArgumentException();
            }
        }
    }
}

