/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.connection;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.text.MessageFormat;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.ConnectionModifier;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;

public class PServerConnection
implements Connection {
    protected static final String OPEN_PREAMBLE = "BEGIN AUTH REQUEST\n";
    protected static final String OPEN_POSTAMBLE = "END AUTH REQUEST\n";
    protected static final String VERIFY_PREAMBLE = "BEGIN VERIFICATION REQUEST\n";
    protected static final String VERIFY_POSTAMBLE = "END VERIFICATION REQUEST\n";
    protected static final String AUTHENTICATION_SUCCEEDED_RESPONSE = "I LOVE YOU";
    protected static final String AUTHENTICATION_FAILED_RESPONSE = "I HATE YOU";
    protected String repository;
    protected String userName;
    protected String encodedPassword;
    public static final int DEFAULT_PORT = 2401;
    protected int port = 2401;
    protected String hostName;
    protected Socket socket;
    protected LoggedDataInputStream inputStream;
    protected LoggedDataOutputStream outputStream;

    public LoggedDataInputStream getInputStream() {
        return this.inputStream;
    }

    public LoggedDataOutputStream getOutputStream() {
        return this.outputStream;
    }

    private void openConnection(String preamble, String postamble) throws AuthenticationException {
        if (this.hostName == null) {
            String locMessage = AuthenticationException.getBundleString("AuthenticationException.HostIsNull");
            throw new AuthenticationException("HostIsNull", locMessage);
        }
        try {
            this.socket = new Socket(this.hostName, this.port);
            BufferedOutputStream bos = new BufferedOutputStream(this.socket.getOutputStream(), 32768);
            this.outputStream = new LoggedDataOutputStream(bos);
            BufferedInputStream bis = new BufferedInputStream(this.socket.getInputStream(), 32768);
            this.inputStream = new LoggedDataInputStream(bis);
            this.outputStream.writeBytes(preamble);
            this.outputStream.writeBytes(this.repository + "\n");
            this.outputStream.writeBytes(this.userName + "\n");
            this.outputStream.writeBytes(this.getEncodedPasswordNotNull() + "\n");
            this.outputStream.writeBytes(postamble);
            this.outputStream.flush();
            String response = this.inputStream.readLine();
            if (AUTHENTICATION_SUCCEEDED_RESPONSE.equals(response)) {
                return;
            }
            if (AUTHENTICATION_FAILED_RESPONSE.equals(response)) {
                String localizedMsg = this.getLocalMessage("AuthenticationException.badPassword", null);
                throw new AuthenticationException("AuthenticationFailed", localizedMsg);
            }
            if (response == null) {
                response = "";
            }
            String locMessage = this.getLocalMessage("AuthenticationException.AuthenticationFailed", new Object[]{response});
            throw new AuthenticationException("AuthenticationFailed", locMessage);
        }
        catch (AuthenticationException ex) {
            this.reset();
            throw ex;
        }
        catch (ConnectException ex) {
            this.reset();
            String locMessage = this.getLocalMessage("AuthenticationException.ConnectException", new Object[]{this.hostName});
            throw new AuthenticationException("ConnectException", ex, locMessage);
        }
        catch (NoRouteToHostException ex) {
            this.reset();
            String locMessage = this.getLocalMessage("AuthenticationException.NoRouteToHostException", new Object[]{this.hostName});
            throw new AuthenticationException("NoRouteToHostException", ex, locMessage);
        }
        catch (IOException ex) {
            this.reset();
            String locMessage = this.getLocalMessage("AuthenticationException.IOException", new Object[]{this.hostName});
            throw new AuthenticationException("IOException", ex, locMessage);
        }
    }

    private void reset() {
        this.socket = null;
        this.inputStream = null;
        this.outputStream = null;
    }

    public void verify() throws AuthenticationException {
        this.openConnection(VERIFY_PREAMBLE, VERIFY_POSTAMBLE);
        if (this.socket == null) {
            return;
        }
        try {
            try {
                this.socket.close();
            }
            catch (IOException exc) {
                String locMessage = AuthenticationException.getBundleString("AuthenticationException.Throwable");
                throw new AuthenticationException("General error", exc, locMessage);
            }
            Object var4_1 = null;
            this.reset();
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            this.reset();
            throw throwable;
        }
    }

    public void open() throws AuthenticationException {
        this.openConnection(OPEN_PREAMBLE, OPEN_POSTAMBLE);
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getEncodedPassword() {
        return this.encodedPassword;
    }

    private String getEncodedPasswordNotNull() {
        if (this.encodedPassword == null) {
            return "";
        }
        return this.encodedPassword;
    }

    public void setEncodedPassword(String encodedPassword) {
        this.encodedPassword = encodedPassword;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void close() throws IOException {
        if (!this.isOpen()) {
            return;
        }
        try {
            this.socket.close();
            Object var2_1 = null;
            this.reset();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.reset();
            throw throwable;
        }
    }

    public void modifyInputStream(ConnectionModifier modifier) throws IOException {
        modifier.modifyInputStream(this.inputStream);
    }

    public void modifyOutputStream(ConnectionModifier modifier) throws IOException {
        modifier.modifyOutputStream(this.outputStream);
    }

    private String getLocalMessage(String key, Object[] arguments) {
        String locMessage = AuthenticationException.getBundleString(key);
        if (locMessage == null) {
            return null;
        }
        locMessage = MessageFormat.format(locMessage, arguments);
        return locMessage;
    }

    public boolean isOpen() {
        return this.socket != null;
    }
}

