/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.connection;

import java.io.IOException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.ConnectionModifier;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;

public class ServerConnection
implements Connection {
    protected String repository;
    protected LoggedDataInputStream inputStream;
    protected LoggedDataOutputStream outputStream;
    protected Process process;

    public ServerConnection() {
        this.reset();
    }

    public LoggedDataInputStream getInputStream() {
        return this.inputStream;
    }

    public LoggedDataOutputStream getOutputStream() {
        return this.outputStream;
    }

    private void openConnection() throws AuthenticationException {
        try {
            this.process = Runtime.getRuntime().exec("cvs server");
            this.outputStream = new LoggedDataOutputStream(this.process.getOutputStream());
            this.inputStream = new LoggedDataInputStream(this.process.getInputStream());
        }
        catch (IOException t) {
            this.reset();
            String locMessage = AuthenticationException.getBundleString("AuthenticationException.ServerConnection");
            throw new AuthenticationException("Connection error", t, locMessage);
        }
    }

    private void reset() {
        this.process = null;
        this.inputStream = null;
        this.outputStream = null;
    }

    public void verify() throws AuthenticationException {
        try {
            try {
                this.process = Runtime.getRuntime().exec("cvs server");
                this.process.destroy();
            }
            catch (Exception e) {
                String locMessage = AuthenticationException.getBundleString("AuthenticationException.ServerVerification");
                throw new AuthenticationException("Verification error", e, locMessage);
            }
            Object var4_1 = null;
            this.reset();
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            this.reset();
            throw throwable;
        }
    }

    public void open() throws AuthenticationException {
        this.openConnection();
    }

    public boolean isOpen() {
        return this.process != null;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String theRepository) {
        this.repository = theRepository;
    }

    public void close() throws IOException {
        try {
            if (this.process != null) {
                this.process.destroy();
            }
            Object var2_1 = null;
            this.reset();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.reset();
            throw throwable;
        }
    }

    public void modifyInputStream(ConnectionModifier modifier) throws IOException {
        modifier.modifyInputStream(this.inputStream);
    }

    public void modifyOutputStream(ConnectionModifier modifier) throws IOException {
        modifier.modifyOutputStream(this.outputStream);
    }
}

