/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.event;

import org.netbeans.lib.cvsclient.event.CVSEvent;
import org.netbeans.lib.cvsclient.event.CVSListener;

public class EventManager {
    private CVSListener[] listeners;
    private boolean fireEnhancedEventSet = true;

    public synchronized void addCVSListener(CVSListener listener) {
        if (this.listeners == null || this.listeners.length == 0) {
            this.listeners = new CVSListener[1];
        } else {
            CVSListener[] l = new CVSListener[this.listeners.length + 1];
            int i = 0;
            while (i < this.listeners.length) {
                l[i] = this.listeners[i];
                ++i;
            }
            this.listeners = l;
        }
        this.listeners[this.listeners.length - 1] = listener;
    }

    public synchronized void removeCVSListener(CVSListener listener) {
        if (this.listeners.length == 1) {
            this.listeners = null;
        } else {
            CVSListener[] l = new CVSListener[this.listeners.length - 1];
            int i = 0;
            while (i < l.length) {
                if (this.listeners[i] == listener) {
                    int j = i + 1;
                    while (j < this.listeners.length) {
                        l[j - 1] = this.listeners[j];
                        ++j;
                    }
                    break;
                }
                l[i] = this.listeners[i];
                ++i;
            }
            this.listeners = l;
        }
    }

    public void fireCVSEvent(CVSEvent e) {
        if (this.listeners == null || this.listeners.length == 0) {
            return;
        }
        CVSListener[] l = null;
        CVSListener[] cVSListenerArray = this.listeners;
        synchronized (cVSListenerArray) {
            l = new CVSListener[this.listeners.length];
            System.arraycopy(this.listeners, 0, l, 0, l.length);
        }
        int i = 0;
        while (i < l.length) {
            e.fireEvent(l[i]);
            ++i;
        }
    }

    public boolean isFireEnhancedEventSet() {
        return this.fireEnhancedEventSet;
    }

    public void setFireEnhancedEventSet(boolean fireEnhancedEventSet) {
        this.fireEnhancedEventSet = fireEnhancedEventSet;
    }
}

