/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.response;

import java.io.EOFException;
import java.io.IOException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.response.Response;
import org.netbeans.lib.cvsclient.response.ResponseException;
import org.netbeans.lib.cvsclient.response.ResponseServices;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;

class MessageResponse
implements Response {
    private String firstWord;

    public MessageResponse() {
    }

    public MessageResponse(String initialWord) {
        this.firstWord = initialWord;
    }

    public void process(LoggedDataInputStream dis, ResponseServices services) throws ResponseException {
        try {
            String line = dis.readLine();
            if (this.firstWord != null) {
                line = this.firstWord + " " + line;
            }
            MessageEvent event = new MessageEvent(this, line, false);
            services.getEventManager().fireCVSEvent(event);
        }
        catch (EOFException ex) {
            throw new ResponseException(ex, CommandException.getLocalMessage("CommandException.EndOfFile", null));
        }
        catch (IOException ex) {
            throw new ResponseException(ex);
        }
    }

    public boolean isTerminalResponse() {
        return false;
    }
}

