/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.generator;

import java.awt.Dialog;
import java.awt.Dimension;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.xml.core.DTDDataObject;
import org.netbeans.modules.xml.core.lib.FileUtilities;
import org.netbeans.modules.xml.core.lib.GuiUtil;
import org.netbeans.modules.xml.tax.cookies.TreeEditorCookie;
import org.netbeans.modules.xml.tools.generator.ElementBindings;
import org.netbeans.modules.xml.tools.generator.ElementDeclarations;
import org.netbeans.modules.xml.tools.generator.GenerateSupportUtils;
import org.netbeans.modules.xml.tools.generator.ParsletBindings;
import org.netbeans.modules.xml.tools.generator.SAXBindingsGenerator;
import org.netbeans.modules.xml.tools.generator.SAXBindingsHandlerImpl;
import org.netbeans.modules.xml.tools.generator.SAXBindingsParser;
import org.netbeans.modules.xml.tools.generator.SAXGeneratorAbstractPanel;
import org.netbeans.modules.xml.tools.generator.SAXGeneratorModel;
import org.netbeans.modules.xml.tools.generator.Util;
import org.netbeans.modules.xml.tools.generator.XMLGenerateCookie;
import org.netbeans.tax.TreeDTDRoot;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeElementDecl;
import org.netbeans.tax.TreeException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.JavaDoc;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.NbBundle;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class SAXGeneratorSupport
implements XMLGenerateCookie {
    private static final String JAVA_EXT = "java";
    private static final String SAX_PACKAGE = "";
    private static final String SAX_EXCEPTION = "SAXException";
    private static final String SAX_DOCUMENT_HANDLER = "DocumentHandler";
    private static final String SAX2_CONTENT_HANDLER = "ContentHandler";
    private static final String SAX_LOCATOR = "Locator";
    private static final String SAX_ATTRIBUTE_LIST = "AttributeList";
    private static final String SAX2_ATTRIBUTES = "Attributes";
    private static final String SAX_INPUT_SOURCE = "InputSource";
    private static final String JAXP_PACKAGE = "javax.xml.parsers.";
    private static final String JAXP_PARSER_CONFIGURATION_EXCEPTION = "javax.xml.parsers.ParserConfigurationException";
    private static final String JAXP_FACTORY_CONFIGURATION_ERROR = "javax.xml.parsers.FactoryConfigurationRrror";
    private static final String JAVA_IOEXCEPTION = "java.io.IOException";
    private static final String M_SET_DOCUMENT_LOCATOR = "setDocumentLocator";
    private static final String M_START_DOCUMENT = "startDocument";
    private static final String M_END_DOCUMENT = "endDocument";
    private static final String M_START_ELEMENT = "startElement";
    private static final String M_END_ELEMENT = "endElement";
    private static final String M_CHARACTERS = "characters";
    private static final String M_IGNORABLE_WHITESPACE = "ignorableWhitespace";
    private static final String M_PROCESSING_INSTRUCTION = "processingInstruction";
    private static final String M_SKIPPED_ENTITY = "skippedEntity";
    private static final String M_START_PREFIX_MAPPING = "startPrefixMapping";
    private static final String M_END_PREFIX_MAPPING = "endPrefixMapping";
    private static final String EMMIT_BUFFER = "dispatch";
    private static final String M_PARSE = "parse";
    private static final String HANDLE_PREFIX = "handle_";
    private static final String START_PREFIX = "start_";
    private static final String END_PREFIX = "end_";
    private static final String FILE_COMMENT_MARK = "Mark";
    private static final Type Type_STRING = Type.createFromClass((Class)(class$java$lang$String == null ? (class$java$lang$String = SAXGeneratorSupport.class$("java.lang.String")) : class$java$lang$String));
    private static final MethodParameter[] STRING_PARAM = new MethodParameter[]{new MethodParameter("data", Type.createFromClass((Class)(class$java$lang$String == null ? (class$java$lang$String = SAXGeneratorSupport.class$("java.lang.String")) : class$java$lang$String)), true)};
    private static final Identifier[] JAXP_PARSE_EXCEPTIONS = new Identifier[]{Identifier.create((String)"SAXException"), Identifier.create((String)"javax.xml.parsers.ParserConfigurationException"), Identifier.create((String)"java.io.IOException")};
    private static final String JAXP_PARSE_EXCEPTIONS_DOC = "@throws java.io.IOException on I/O error.\n@throws SAXException propagated exception thrown by a DocumentHandler.\n@throws javax.xml.parsers.ParserConfigurationException a parser satisfining requested configuration can not be created.\n@throws javax.xml.parsers.FactoryConfigurationRrror if the implementation can not be instantiated.\n";
    private DataObject DO;
    private TreeDTDRoot dtd;
    private ElementBindings elementMapping = new ElementBindings();
    private ParsletBindings parsletsMap = new ParsletBindings();
    private int sax = 1;
    private SAXGeneratorModel model;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport;
    static /* synthetic */ Class class$org$netbeans$modules$xml$tools$generator$SAXGeneratorVersionPanel;
    static /* synthetic */ Class class$org$netbeans$modules$xml$tools$generator$SAXGeneratorMethodPanel;
    static /* synthetic */ Class class$org$netbeans$modules$xml$tools$generator$SAXGeneratorParsletPanel;
    static /* synthetic */ Class class$org$netbeans$modules$xml$tools$generator$SAXGeneratorFilePanel;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie;
    static /* synthetic */ Class class$java$lang$StringBuffer;
    static /* synthetic */ Class class$java$util$Stack;
    static /* synthetic */ Class class$org$netbeans$modules$xml$tax$cookies$TreeEditorCookie;

    public SAXGeneratorSupport(DTDDataObject DO) {
        this((DataObject)DO, null);
    }

    public SAXGeneratorSupport(DataObject DO, TreeDTDRoot dtd) {
        if (DO == null) {
            throw new IllegalArgumentException("null");
        }
        this.DO = DO;
        this.dtd = dtd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate() {
        block22: {
            block21: {
                Class clazz;
                block23: {
                    block19: {
                        block20: {
                            try {
                                try {
                                    this.dtd = null;
                                    if (this.getDTD() == null) {
                                        String msg = NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport == null ? (class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport = SAXGeneratorSupport.class$("org.netbeans.modules.xml.tools.generator.SAXGeneratorSupport")) : class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport), (String)"MSG_invalid_dtd");
                                        GuiUtil.notifyWarning((String)msg);
                                        Object var27_4 = null;
                                        if (class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport != null) break block19;
                                        break block20;
                                    }
                                    FileObject primFile = this.DO.getPrimaryFile();
                                    String rawName = primFile.getName();
                                    String name = rawName.substring(0, 1).toUpperCase() + rawName.substring(1);
                                    FileObject folder = primFile.getParent();
                                    String packageName = folder.getPackageName('.');
                                    this.elementMapping.clear();
                                    this.parsletsMap.clear();
                                    this.initMappings();
                                    this.model = new SAXGeneratorModel(name, new ElementDeclarations(this.dtd.getElementDeclarations().iterator()), this.elementMapping, this.parsletsMap);
                                    this.loadPrevious(folder);
                                    WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{new SAXGeneratorAbstractPanel.WizardStep(class$org$netbeans$modules$xml$tools$generator$SAXGeneratorVersionPanel == null ? (class$org$netbeans$modules$xml$tools$generator$SAXGeneratorVersionPanel = SAXGeneratorSupport.class$("org.netbeans.modules.xml.tools.generator.SAXGeneratorVersionPanel")) : class$org$netbeans$modules$xml$tools$generator$SAXGeneratorVersionPanel), new SAXGeneratorAbstractPanel.WizardStep(class$org$netbeans$modules$xml$tools$generator$SAXGeneratorMethodPanel == null ? (class$org$netbeans$modules$xml$tools$generator$SAXGeneratorMethodPanel = SAXGeneratorSupport.class$("org.netbeans.modules.xml.tools.generator.SAXGeneratorMethodPanel")) : class$org$netbeans$modules$xml$tools$generator$SAXGeneratorMethodPanel), new SAXGeneratorAbstractPanel.WizardStep(class$org$netbeans$modules$xml$tools$generator$SAXGeneratorParsletPanel == null ? (class$org$netbeans$modules$xml$tools$generator$SAXGeneratorParsletPanel = SAXGeneratorSupport.class$("org.netbeans.modules.xml.tools.generator.SAXGeneratorParsletPanel")) : class$org$netbeans$modules$xml$tools$generator$SAXGeneratorParsletPanel), new SAXGeneratorAbstractPanel.WizardStep(class$org$netbeans$modules$xml$tools$generator$SAXGeneratorFilePanel == null ? (class$org$netbeans$modules$xml$tools$generator$SAXGeneratorFilePanel = SAXGeneratorSupport.class$("org.netbeans.modules.xml.tools.generator.SAXGeneratorFilePanel")) : class$org$netbeans$modules$xml$tools$generator$SAXGeneratorFilePanel)};
                                    int i = 0;
                                    while (true) {
                                        if (i >= panels.length) {
                                            WizardDescriptor descriptor = new WizardDescriptor(panels, (Object)this.model);
                                            descriptor.setTitle(Util.THIS.getString("SAXGeneratorSupport.title"));
                                            descriptor.putProperty("WizardPanel_contentDisplayed", (Object)Boolean.TRUE);
                                            descriptor.putProperty("WizardPanel_contentNumbered", (Object)Boolean.TRUE);
                                            descriptor.putProperty("WizardPanel_autoWizardStyle", (Object)Boolean.TRUE);
                                            descriptor.putProperty("WizardPanel_leftDimension", (Object)new Dimension(500, 400));
                                            descriptor.putProperty("WizardPanel_contentData", (Object)new String[]{Util.THIS.getString("SAXGeneratorVersionPanel.step"), Util.THIS.getString("SAXGeneratorMethodPanel.step"), Util.THIS.getString("SAXGeneratorParsletPanel.step"), Util.THIS.getString("SAXGeneratorFilePanel.step")});
                                            String fmt = Util.THIS.getString("SAXGeneratorSupport.subtitle");
                                            descriptor.setTitleFormat(new MessageFormat(fmt));
                                            Dialog dlg = DialogDisplayer.getDefault().createDialog((DialogDescriptor)descriptor);
                                            dlg.show();
                                            if (!NotifyDescriptor.CANCEL_OPTION.equals(descriptor.getValue())) {
                                                if (!NotifyDescriptor.CLOSED_OPTION.equals(descriptor.getValue())) break;
                                            }
                                            break block21;
                                        }
                                        ((SAXGeneratorAbstractPanel.WizardStep)panels[i]).setBean(this.model);
                                        ((SAXGeneratorAbstractPanel.WizardStep)panels[i]).setIndex(i);
                                        ++i;
                                    }
                                    GuiUtil.setStatusText((String)Util.THIS.getString("MSG_sax_progress_1"));
                                    if (Util.THIS.isLoggable()) {
                                        Util.THIS.debug(this.model.toString());
                                    }
                                    this.sax = this.model.getSAXversion();
                                    DataObject stubDataObject = FileUtilities.createDataObject((FileObject)folder, (String)this.model.getStub(), (String)JAVA_EXT, (boolean)true);
                                    SourceElement stubSrc = this.openSource(stubDataObject);
                                    DataObject interfaceImplDataObject = FileUtilities.createDataObject((FileObject)folder, (String)this.model.getHandlerImpl(), (String)JAVA_EXT, (boolean)false);
                                    SourceElement interfaceImplSrc = this.openSource(interfaceImplDataObject);
                                    DataObject interfaceDataObject = FileUtilities.createDataObject((FileObject)folder, (String)this.model.getHandler(), (String)JAVA_EXT, (boolean)true);
                                    SourceElement interfaceSrc = this.openSource(interfaceDataObject);
                                    DataObject parsletsDataObject = null;
                                    DataObject parsletsImplDataObject = null;
                                    SourceElement parsletsSrc = null;
                                    SourceElement parsletsImplSrc = null;
                                    if (this.model.hasParslets()) {
                                        parsletsImplDataObject = FileUtilities.createDataObject((FileObject)folder, (String)this.model.getParsletImpl(), (String)JAVA_EXT, (boolean)false);
                                        parsletsImplSrc = this.openSource(parsletsImplDataObject);
                                        parsletsDataObject = FileUtilities.createDataObject((FileObject)folder, (String)this.model.getParslet(), (String)JAVA_EXT, (boolean)true);
                                        parsletsSrc = this.openSource(parsletsDataObject);
                                    }
                                    GuiUtil.setStatusText((String)Util.THIS.getString("MSG_sax_progress_1_5"));
                                    StubGenerator stubGenerator = new StubGenerator(this.model.getStub(), this.model.getHandler(), this.model.getParslet());
                                    this.generateCode(stubGenerator, stubSrc, packageName);
                                    InterfaceGenerator interfaceGenerator = new InterfaceGenerator(this.model.getHandler());
                                    this.generateCode(interfaceGenerator, interfaceSrc, packageName);
                                    InterfaceImplGenerator interfaceImplGenerator = new InterfaceImplGenerator(this.model.getHandlerImpl());
                                    this.generateCode(interfaceImplGenerator, interfaceImplSrc, packageName);
                                    if (this.model.hasParslets()) {
                                        ParsletGenerator parsletsGenerator = new ParsletGenerator(this.model.getParslet());
                                        this.generateCode(parsletsGenerator, parsletsSrc, packageName);
                                        ParsletImplGenerator parsletsImplGenerator = new ParsletImplGenerator(this.model.getParsletImpl());
                                        this.generateCode(parsletsImplGenerator, parsletsImplSrc, packageName);
                                    }
                                    DataObject settingsDataObject = null;
                                    String settings = "<!-- failed -->";
                                    if (this.model.getBindings() != null) {
                                        settingsDataObject = FileUtilities.createDataObject((FileObject)folder, (String)this.model.getBindings(), (String)"xml", (boolean)true);
                                        settings = SAXBindingsGenerator.toXML(this.model);
                                    }
                                    GuiUtil.setStatusText((String)Util.THIS.getString("MSG_sax_progress_2"));
                                    this.trySave(stubDataObject, null);
                                    this.trySave(interfaceDataObject, null);
                                    this.trySave(interfaceImplDataObject, null);
                                    if (this.model.hasParslets()) {
                                        this.trySave(parsletsDataObject, null);
                                        this.trySave(parsletsImplDataObject, null);
                                    }
                                    if (this.model.getBindings() != null) {
                                        this.trySave(settingsDataObject, settings);
                                    }
                                    GuiUtil.setStatusText((String)Util.THIS.getString("MSG_sax_progress_3"));
                                    if (this.model.hasParslets()) {
                                        GuiUtil.performDefaultAction((FileObject)folder.getFileObject(this.model.getParsletImpl(), JAVA_EXT));
                                    }
                                    GuiUtil.performDefaultAction((FileObject)folder.getFileObject(this.model.getHandlerImpl(), JAVA_EXT));
                                    break block22;
                                }
                                catch (FileStateInvalidException e) {
                                    String msg = Util.THIS.getString("MSG_wizard_fail", (Object)e);
                                    GuiUtil.notifyWarning((String)msg);
                                    Object var27_7 = null;
                                    String msg2 = NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport == null ? (class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport = SAXGeneratorSupport.class$("org.netbeans.modules.xml.tools.generator.SAXGeneratorSupport")) : class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport), (String)"MSG_sax_progress_done");
                                    GuiUtil.setStatusText((String)msg2);
                                    return;
                                }
                                catch (SourceException e) {
                                    String msg = Util.THIS.getString("MSG_wizard_fail", (Object)e);
                                    GuiUtil.notifyWarning((String)msg);
                                    Object var27_8 = null;
                                    String msg2 = NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport == null ? (class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport = SAXGeneratorSupport.class$("org.netbeans.modules.xml.tools.generator.SAXGeneratorSupport")) : class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport), (String)"MSG_sax_progress_done");
                                    GuiUtil.setStatusText((String)msg2);
                                    return;
                                }
                                catch (TreeException e) {
                                    String msg = Util.THIS.getString("MSG_wizard_fail", (Object)e);
                                    GuiUtil.notifyWarning((String)msg);
                                    Object var27_9 = null;
                                    String msg2 = NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport == null ? (class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport = SAXGeneratorSupport.class$("org.netbeans.modules.xml.tools.generator.SAXGeneratorSupport")) : class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport), (String)"MSG_sax_progress_done");
                                    GuiUtil.setStatusText((String)msg2);
                                    return;
                                }
                                catch (IOException e) {
                                    String msg = Util.THIS.getString("MSG_wizard_fail", e);
                                    GuiUtil.notifyWarning((String)msg);
                                    Object var27_10 = null;
                                    String msg2 = NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport == null ? (class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport = SAXGeneratorSupport.class$("org.netbeans.modules.xml.tools.generator.SAXGeneratorSupport")) : class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport), (String)"MSG_sax_progress_done");
                                    GuiUtil.setStatusText((String)msg2);
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var27_11 = null;
                                String msg2 = NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport == null ? (class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport = SAXGeneratorSupport.class$("org.netbeans.modules.xml.tools.generator.SAXGeneratorSupport")) : class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport), (String)"MSG_sax_progress_done");
                                GuiUtil.setStatusText((String)msg2);
                                throw throwable;
                            }
                        }
                        clazz = class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport = SAXGeneratorSupport.class$("org.netbeans.modules.xml.tools.generator.SAXGeneratorSupport");
                        break block23;
                    }
                    clazz = class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport;
                }
                String msg2 = NbBundle.getMessage((Class)clazz, (String)"MSG_sax_progress_done");
                GuiUtil.setStatusText((String)msg2);
                return;
            }
            Object var27_5 = null;
            String msg2 = NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport == null ? (class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport = SAXGeneratorSupport.class$("org.netbeans.modules.xml.tools.generator.SAXGeneratorSupport")) : class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport), (String)"MSG_sax_progress_done");
            GuiUtil.setStatusText((String)msg2);
            return;
        }
        Object var27_6 = null;
        String msg2 = NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport == null ? (class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport = SAXGeneratorSupport.class$("org.netbeans.modules.xml.tools.generator.SAXGeneratorSupport")) : class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport), (String)"MSG_sax_progress_done");
        GuiUtil.setStatusText((String)msg2);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadPrevious(FileObject folder) {
        block19: {
            block18: {
                block17: {
                    in = null;
                    try {
                        try {
                            previous = folder.getFileObject(this.model.getBindings(), "xml");
                            if (previous == null) {
                                var9_5 = null;
                                break block17;
                            }
                            if (previous.isVirtual()) {
                                break block18;
                            }
                            in = previous.getInputStream();
                            input = new InputSource(previous.getURL().toExternalForm());
                            input.setByteStream(in);
                            handler = new SAXBindingsHandlerImpl();
                            parser = new SAXBindingsParser(handler);
                            reader = XMLUtil.createXMLReader((boolean)true);
                            reader.setEntityResolver((EntityResolver)EntityCatalog.getDefault());
                            reader.setContentHandler(parser);
                            reader.parse(input);
                            this.model.loadElementBindings(handler.getElementBindings());
                            this.model.loadParsletBindings(handler.getParsletBindings());
                            break block19;
                        }
                        catch (IOException ex) {
                            if (Util.THIS.isLoggable()) {
                                Util.THIS.debug("Cannot read settings", ex);
                            }
                            var9_8 = null;
                            try {
                                if (in == null) return;
                                in.close();
                                return;
                            }
                            catch (IOException e) {
                                return;
                            }
                        }
                        catch (SAXException ex) {
                            if (Util.THIS.isLoggable()) {
                                Util.THIS.debug("Cannot read settings", ex);
                            }
                            var9_9 = null;
                            try {}
                            catch (IOException e) {
                                return;
                            }
                            if (in == null) return;
                            in.close();
                            return;
                        }
                    }
                    catch (Throwable var8_22) {
                        var9_10 = null;
                        ** try [egrp 2[TRYBLOCK] [3 : 208->219)] { 
lbl50:
                        // 1 sources

                        if (in == null) throw var8_22;
                        in.close();
                        throw var8_22;
lbl53:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        throw var8_22;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [3 : 208->219)] { 
lbl58:
                // 1 sources

                if (in == null) return;
                in.close();
                return;
lbl61:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return;
            }
            var9_6 = null;
            ** try [egrp 2[TRYBLOCK] [3 : 208->219)] { 
lbl67:
            // 1 sources

            if (in == null) return;
            in.close();
            return;
lbl70:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        var9_7 = null;
        try {}
        catch (IOException e) {}
        if (in == null) return;
        in.close();
        return;
    }

    private void trySave(DataObject obj, String data) throws IOException {
        if (obj == null) {
            return;
        }
        try {
            EditorCookie editor = (EditorCookie)obj.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = SAXGeneratorSupport.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
            StyledDocument doc = editor.openDocument();
            if (data == null) {
                data = GenerateSupportUtils.getJavaFileHeader(obj.getName(), null) + "\n";
            } else {
                doc.remove(0, doc.getLength());
            }
            doc.insertString(0, data, null);
        }
        catch (IOException ex) {
        }
        catch (BadLocationException ex) {
            // empty catch block
        }
        SaveCookie cake = (SaveCookie)obj.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = SAXGeneratorSupport.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
        if (cake != null) {
            cake.save();
        }
    }

    private SourceElement openSource(DataObject obj) {
        if (obj == null) {
            return null;
        }
        SourceCookie cake = null;
        while (cake == null) {
            cake = (SourceCookie)obj.getCookie(class$org$openide$cookies$SourceCookie == null ? SAXGeneratorSupport.class$("org.openide.cookies.SourceCookie") : class$org$openide$cookies$SourceCookie);
        }
        return cake.getSource();
    }

    private void generateCode(CodeGenerator factory, SourceElement target, String packageName) throws IOException, SourceException {
        if (target == null) {
            return;
        }
        if (target.getClasses().length > 0) {
            target.removeClasses(target.getClasses());
        }
        if (packageName != null && packageName.length() > 0) {
            target.setPackage(Identifier.create((String)packageName));
        }
        target.setImports(new Import[]{new Import(Identifier.create((String)"org.xml.sax"), true)});
        factory.generate(target);
    }

    private ClassElement generateStub(String name, String face, String let) throws SourceException {
        ClassElement clazz = new ClassElement();
        clazz.setModifiers(1);
        clazz.setName(Identifier.create((String)name));
        clazz.setInterfaces(new Identifier[]{this.getSAXHandlerInterface()});
        clazz.getJavaDoc().setRawText("\nThe class reads XML documents according to specified DTD and \ntranslates all related events into " + face + " events." + "\n<p>Usage sample:\n" + "<pre>\n" + "    " + name + " parser = new " + name + "(...);\n" + "    parser.parse(new InputSource(\"...\"));\n" + "</pre>\n" + "<p><b>Warning:</b> the class is machine generated. DO NOT MODIFY</p>\n");
        ConstructorElement constructor = new ConstructorElement();
        constructor.setModifiers(1);
        if (this.model.hasParslets()) {
            constructor.setParameters(new MethodParameter[]{new MethodParameter("handler", Type.parse((String)face), true), new MethodParameter("resolver", Type.parse((String)"EntityResolver"), true), new MethodParameter("parslet", Type.parse((String)let), true)});
        } else {
            constructor.setParameters(new MethodParameter[]{new MethodParameter("handler", Type.parse((String)face), true), new MethodParameter("resolver", Type.parse((String)"EntityResolver"), true)});
        }
        String parsletInit = this.model.hasParslets() ? "\nthis.parslet = parslet;" : SAX_PACKAGE;
        constructor.setBody(parsletInit + "\nthis.handler = handler;\n" + "this.resolver = resolver;\n" + "buffer = new StringBuffer(111);\ncontext = new java.util.Stack();\n");
        String docText = "\nCreates a parser instance.\n@param handler handler interface implementation (never <code>null</code>\n@param resolver SAX entity resolver implementation or <code>null</code>.\nIt is recommended that it could be able to resolve at least the DTD.";
        if (this.model.hasParslets()) {
            docText = docText + "@param parslet convertors implementation (never <code>null</code>\n";
        }
        constructor.getJavaDoc().setRawText(docText);
        clazz.addConstructor(constructor);
        clazz.addField(SAXGeneratorSupport.createField("buffer", (class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = SAXGeneratorSupport.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer).getName()));
        if (this.model.hasParslets()) {
            clazz.addField(SAXGeneratorSupport.createField("parslet", let));
        }
        clazz.addField(SAXGeneratorSupport.createField("handler", face));
        clazz.addField(SAXGeneratorSupport.createField("context", (class$java$util$Stack == null ? (class$java$util$Stack = SAXGeneratorSupport.class$("java.util.Stack")) : class$java$util$Stack).getName()));
        clazz.addField(SAXGeneratorSupport.createField("resolver", "EntityResolver"));
        this.genStubClass(clazz);
        return clazz;
    }

    private ClassElement generateInterface(String name) throws SourceException {
        ClassElement clazz = new ClassElement();
        clazz.setModifiers(1);
        clazz.setName(Identifier.create((String)name));
        if (this.model.isPropagateSAX()) {
            clazz.setInterfaces(new Identifier[]{this.getSAXHandlerInterface()});
        }
        clazz.setClassOrInterface(false);
        Iterator it = this.model.getElementBindings().values().iterator();
        while (it.hasNext()) {
            JavaDoc.Method jdoc;
            MethodParameter[] params;
            String methodName;
            ElementBindings.Entry next = (ElementBindings.Entry)it.next();
            MethodElement method = null;
            MethodElement startMethod = null;
            MethodElement endMethod = null;
            String handler = next.getType();
            if ("IGNORE".equals(handler)) continue;
            if ("EMPTY".equals(handler)) {
                methodName = HANDLE_PREFIX + next.getMethod();
                params = new MethodParameter[]{new MethodParameter("meta", Type.parse((String)this.getSAXAttributes()), true)};
                method = SAXGeneratorSupport.createInterfaceMethod(methodName, params, SAX_EXCEPTION);
                jdoc = method.getJavaDoc();
                jdoc.setRawText("\nAn empty element event handling method.\n@param data value or null\n");
            }
            if ("DATA".equals(handler) || "MIXED".equals(handler)) {
                methodName = HANDLE_PREFIX + next.getMethod();
                params = new MethodParameter[]{this.parsletsMap.getReturnAsParameter(next.getParslet()), new MethodParameter("meta", Type.parse((String)this.getSAXAttributes()), true)};
                method = SAXGeneratorSupport.createInterfaceMethod(methodName, params, SAX_EXCEPTION);
                jdoc = method.getJavaDoc();
                jdoc.setRawText("\nA data element event handling method.\n@param data value or null \n@param meta attributes\n");
            }
            if ("CONTAINER".equals(handler) || "MIXED".equals(handler)) {
                methodName = START_PREFIX + next.getMethod();
                params = new MethodParameter[]{new MethodParameter("meta", Type.parse((String)this.getSAXAttributes()), true)};
                startMethod = SAXGeneratorSupport.createInterfaceMethod(methodName, params, SAX_EXCEPTION);
                jdoc = startMethod.getJavaDoc();
                jdoc.setRawText("\nA container element start event handling method.\n@param meta attributes\n");
                methodName = END_PREFIX + next.getMethod();
                endMethod = SAXGeneratorSupport.createInterfaceMethod(methodName, null, SAX_EXCEPTION);
                jdoc = endMethod.getJavaDoc();
                jdoc.setRawText("\nA container element end event handling method.\n");
            }
            if (startMethod != null) {
                clazz.addMethod(startMethod);
            }
            if (method != null) {
                clazz.addMethod(method);
            }
            if (endMethod == null) continue;
            clazz.addMethod(endMethod);
        }
        return clazz;
    }

    private ClassElement generateInterfaceImpl(String name) throws SourceException {
        ClassElement clazz = new ClassElement();
        clazz.setModifiers(1);
        clazz.setName(Identifier.create((String)name));
        clazz.setInterfaces(new Identifier[]{Identifier.create((String)this.model.getHandler())});
        FieldElement field = new FieldElement();
        field.setName(Identifier.create((String)"DEBUG"));
        field.setInitValue("false");
        field.setModifiers(25);
        field.setType(Type.BOOLEAN);
        clazz.addField(field);
        Iterator it = this.model.getElementBindings().values().iterator();
        while (it.hasNext()) {
            MethodParameter[] params;
            String methodName;
            ElementBindings.Entry next = (ElementBindings.Entry)it.next();
            MethodElement method = null;
            MethodElement startMethod = null;
            MethodElement endMethod = null;
            String handler = next.getType();
            if ("IGNORE".equals(handler)) continue;
            if ("EMPTY".equals(handler)) {
                methodName = HANDLE_PREFIX + next.getMethod();
                params = new MethodParameter[]{new MethodParameter("meta", Type.parse((String)this.getSAXAttributes()), true)};
                method = SAXGeneratorSupport.createInterfaceMethod(methodName, params, SAX_EXCEPTION);
                method.setBody("\nif (DEBUG) System.err.println(\"" + methodName + ": \" + meta);\n");
            }
            if ("DATA".equals(handler) || "MIXED".equals(handler)) {
                methodName = HANDLE_PREFIX + next.getMethod();
                params = new MethodParameter[]{this.parsletsMap.getReturnAsParameter(next.getParslet()), new MethodParameter("meta", Type.parse((String)this.getSAXAttributes()), true)};
                method = SAXGeneratorSupport.createInterfaceMethod(methodName, params, SAX_EXCEPTION);
                method.setBody("\nif (DEBUG) System.err.println(\"" + methodName + ": \" + data);\n");
            }
            if ("CONTAINER".equals(handler) || "MIXED".equals(handler)) {
                methodName = START_PREFIX + next.getMethod();
                params = new MethodParameter[]{new MethodParameter("meta", Type.parse((String)this.getSAXAttributes()), true)};
                startMethod = SAXGeneratorSupport.createInterfaceMethod(methodName, params, SAX_EXCEPTION);
                startMethod.setBody("\nif (DEBUG) System.err.println(\"" + methodName + ": \" + meta);\n");
                methodName = END_PREFIX + next.getMethod();
                endMethod = SAXGeneratorSupport.createInterfaceMethod(methodName, null, SAX_EXCEPTION);
                endMethod.setBody("\nif (DEBUG) System.err.println(\"" + methodName + "()\");\n");
            }
            if (startMethod != null) {
                clazz.addMethod(startMethod);
            }
            if (method != null) {
                clazz.addMethod(method);
            }
            if (endMethod == null) continue;
            clazz.addMethod(endMethod);
        }
        return clazz;
    }

    private ClassElement generateParslet(String name) throws SourceException {
        ClassElement clazz = new ClassElement();
        clazz.setModifiers(1);
        clazz.setName(Identifier.create((String)name));
        clazz.setClassOrInterface(false);
        ParsletBindings parslets = this.model.getParsletBindings();
        Iterator it = parslets.keySet().iterator();
        while (it.hasNext()) {
            clazz.addMethod(parslets.getMethod((String)it.next()));
        }
        return clazz;
    }

    private ClassElement generateParsletImpl(String name) throws SourceException {
        ClassElement clazz = new ClassElement();
        clazz.setModifiers(1);
        clazz.setName(Identifier.create((String)name));
        clazz.setInterfaces(new Identifier[]{Identifier.create((String)this.model.getParslet())});
        MethodElement method = null;
        String code = null;
        Iterator it = this.parsletsMap.keySet().iterator();
        while (it.hasNext()) {
            method = this.parsletsMap.getMethod((String)it.next());
            code = this.createParsletCode(method);
            method.setBody(code);
            clazz.addMethod(method);
        }
        return clazz;
    }

    private String createParsletCode(MethodElement parslet) throws SourceException {
        String returnType = parslet.getReturn().getFullString();
        String fragment = SAX_PACKAGE;
        String exception = "new SAXException(\"" + parslet.getName() + "(\" + data.trim() + \")\", ex)";
        String catchBlock = "\n} catch (IllegalArgumentException ex) {\n throw " + exception + ";\n}";
        if ("int".equals(returnType)) {
            fragment = "try {";
            fragment = fragment + "\nreturn Integer.parseInt(data.trim());";
            fragment = fragment + catchBlock;
        } else if ("boolean".equals(returnType)) {
            fragment = "return \"true\".equals(data.trim());";
        } else if ("long".equals(returnType)) {
            fragment = "try {\nreturn Long.parseLong(data.trim());";
            fragment = fragment + catchBlock;
        } else if ("java.util.Date".equals(returnType)) {
            fragment = "try {";
            fragment = fragment + "\nreturn java.text.DateFormat.getDateInstance().parse(data.trim());";
            fragment = fragment + "\n}catch(java.text.ParseException ex) {";
            fragment = fragment + "\nthrow " + exception + ";\n}";
        } else if ("java.net.URL".equals(returnType)) {
            fragment = "try {";
            fragment = fragment + "\n  return new java.net.URL(data.trim());";
            fragment = fragment + "\n} catch (java.net.MalformedURLException ex) {";
            fragment = fragment + "\n throw " + exception + ";\n}";
        } else if ("java.lang.String[]".equals(returnType)) {
            fragment = "java.util.StringTokenizer tokenizer = new java.util.StringTokenizer(data.trim());";
            fragment = fragment + "\njava.util.ArrayList list = new java.util.ArrayList();";
            fragment = fragment + "\nwhile (tokenizer.hasMoreTokens()) {";
            fragment = fragment + "\nlist.add(tokenizer.nextToken());";
            fragment = fragment + "\n}";
            fragment = fragment + "\nreturn (String[]) list.toArray(new String[0]);";
        } else {
            fragment = "throw new SAXException(\"Not implemented yet.\");";
        }
        return "\n" + fragment + "\n";
    }

    private void initMappings() {
        try {
            this.getDTD();
            Iterator it = this.dtd.getElementDeclarations().iterator();
            while (it.hasNext()) {
                TreeElementDecl next = (TreeElementDecl)it.next();
                this.addElementMapping(next);
            }
        }
        catch (IOException ex) {
        }
        catch (TreeException treeException) {
            // empty catch block
        }
    }

    private void addElementMapping(TreeElementDecl decl) {
        String name = decl.getName();
        String javaName = GenerateSupportUtils.getJavaName(name);
        String defaultMapping = "DATA";
        if (decl.isMixed()) {
            defaultMapping = "MIXED";
        } else if (decl.allowElements()) {
            defaultMapping = "CONTAINER";
        } else if (decl.isEmpty()) {
            defaultMapping = "EMPTY";
        }
        this.elementMapping.put(name, javaName, null, defaultMapping);
    }

    private MethodElement genStartElementMethod() throws SourceException {
        MethodElement method = null;
        if (this.sax == 1) {
            method = SAXGeneratorSupport.createImplementationMethod(M_START_ELEMENT, new MethodParameter[]{new MethodParameter("name", Type_STRING, false), new MethodParameter("attrs", Type.parse((String)this.getSAXAttributes()), false)}, SAX_EXCEPTION);
            StringBuffer code = new StringBuffer();
            code.append("\ndispatch(true);");
            code.append("\ncontext.push(new Object[] {name, new org.xml.sax.helpers.AttributeListImpl(attrs)});");
            code.append(this.createStartEndEvents(START_PREFIX, "attrs", HANDLE_PREFIX));
            if (this.model.isPropagateSAX()) {
                code.append("\nhandler.startElement(name, attrs);");
            }
            code.append("\n");
            method.setBody(code.toString());
        } else if (this.sax == 2) {
            method = SAXGeneratorSupport.createImplementationMethod(M_START_ELEMENT, new MethodParameter[]{new MethodParameter("ns", Type_STRING, false), new MethodParameter("name", Type_STRING, false), new MethodParameter("qname", Type_STRING, false), new MethodParameter("attrs", Type.parse((String)this.getSAXAttributes()), false)}, SAX_EXCEPTION);
            StringBuffer code = new StringBuffer();
            code.append("\ndispatch(true);");
            code.append("\ncontext.push(new Object[] {qname, new org.xml.sax.helpers.AttributesImpl(attrs)});");
            code.append(this.createStartEndEvents(START_PREFIX, "attrs", HANDLE_PREFIX));
            if (this.model.isPropagateSAX()) {
                code.append("\nhandler.startElement(ns, name, qname, attrs);");
            }
            code.append("\n");
            method.setBody(code.toString());
        }
        return method;
    }

    private MethodElement genEndElementMethod() throws SourceException {
        MethodElement method = null;
        if (this.sax == 1) {
            method = SAXGeneratorSupport.createImplementationMethod(M_END_ELEMENT, new MethodParameter[]{new MethodParameter("name", Type_STRING, false)}, SAX_EXCEPTION);
            StringBuffer code = new StringBuffer();
            code.append("\ndispatch(false);");
            code.append("\ncontext.pop();");
            code.append(this.createStartEndEvents(END_PREFIX, SAX_PACKAGE, null));
            if (this.model.isPropagateSAX()) {
                code.append("\nhandler.endElement(name);");
            }
            code.append("\n");
            method.setBody(code.toString());
        } else if (this.sax == 2) {
            method = SAXGeneratorSupport.createImplementationMethod(M_END_ELEMENT, new MethodParameter[]{new MethodParameter("ns", Type_STRING, false), new MethodParameter("name", Type_STRING, false), new MethodParameter("qname", Type_STRING, false)}, SAX_EXCEPTION);
            StringBuffer code = new StringBuffer();
            code.append("\ndispatch(false);");
            code.append("\ncontext.pop();");
            code.append(this.createStartEndEvents(END_PREFIX, SAX_PACKAGE, null));
            if (this.model.isPropagateSAX()) {
                code.append("\nhandler.endElement(ns, name, qname);");
            }
            code.append("\n");
            method.setBody(code.toString());
        }
        return method;
    }

    private String createStartEndEvents(String methodPrefix, String meta, String emptyPrefix) {
        StringBuffer code = new StringBuffer(233);
        Iterator it = this.model.getElementBindings().values().iterator();
        String prefix = "\nif";
        while (it.hasNext()) {
            String name;
            ElementBindings.Entry next = (ElementBindings.Entry)it.next();
            String handling = next.getType();
            String string = name = this.sax == 1 ? "name" : "qname";
            if ("CONTAINER".equals(handling) || "MIXED".equals(handling)) {
                code.append(prefix + " (\"" + next.getElement() + "\".equals(" + name + ")) {");
                code.append("\nhandler." + methodPrefix + next.getMethod() + "(" + meta + ");");
                code.append("\n}");
                prefix = " else if";
                continue;
            }
            if (emptyPrefix == null || !"EMPTY".equals(handling)) continue;
            code.append(prefix + " (\"" + next.getElement() + "\".equals(" + name + ")) {");
            code.append("\nhandler." + emptyPrefix + next.getMethod() + "(" + meta + ");");
            code.append("\n}");
            prefix = " else if";
        }
        return code.toString();
    }

    private MethodElement genStartPrefixMappingMethod() throws SourceException {
        MethodElement method = null;
        if (this.sax == 2) {
            method = SAXGeneratorSupport.createImplementationMethod(M_START_PREFIX_MAPPING, new MethodParameter[]{new MethodParameter("prefix", Type_STRING, true), new MethodParameter("uri", Type_STRING, true)}, SAX_EXCEPTION);
            if (this.model.isPropagateSAX()) {
                method.setBody("\nhandler.startPrefixMapping(prefix, uri);\n");
            }
        }
        return method;
    }

    private MethodElement genEndPrefixMappingMethod() throws SourceException {
        MethodElement method = null;
        if (this.sax == 2) {
            method = SAXGeneratorSupport.createImplementationMethod(M_END_PREFIX_MAPPING, new MethodParameter[]{new MethodParameter("prefix", Type_STRING, true)}, SAX_EXCEPTION);
            if (this.model.isPropagateSAX()) {
                method.setBody("\nhandler.endPrefixMapping(prefix);\n");
            }
        }
        return method;
    }

    private MethodElement genSkippedEntityMethod() throws SourceException {
        MethodElement method = null;
        if (this.sax == 2) {
            method = SAXGeneratorSupport.createImplementationMethod(M_SKIPPED_ENTITY, new MethodParameter[]{new MethodParameter("name", Type_STRING, false)}, SAX_EXCEPTION);
            if (this.model.isPropagateSAX()) {
                method.setBody("\nhandler.skippedEntity(name);\n");
            }
        }
        return method;
    }

    private ClassElement genStubClass(ClassElement clazz) throws SourceException {
        MethodElement method = SAXGeneratorSupport.createImplementationMethod(M_SET_DOCUMENT_LOCATOR, new MethodParameter[]{new MethodParameter("locator", Type.parse((String)SAX_LOCATOR), false)}, null);
        if (this.model.isPropagateSAX()) {
            method.setBody("\nhandler.setDocumentLocator(locator);\n");
        }
        clazz.addMethod(method);
        method = SAXGeneratorSupport.createImplementationMethod(M_START_DOCUMENT, null, SAX_EXCEPTION);
        if (this.model.isPropagateSAX()) {
            method.setBody("\nhandler.startDocument();\n");
        }
        clazz.addMethod(method);
        method = SAXGeneratorSupport.createImplementationMethod(M_END_DOCUMENT, null, SAX_EXCEPTION);
        if (this.model.isPropagateSAX()) {
            method.setBody("\nhandler.endDocument();\n");
        }
        clazz.addMethod(method);
        method = this.genStartElementMethod();
        clazz.addMethod(method);
        method = this.genEndElementMethod();
        clazz.addMethod(method);
        method = SAXGeneratorSupport.createImplementationMethod(M_CHARACTERS, new MethodParameter[]{new MethodParameter("chars", Type.createArray((Type)Type.CHAR), false), new MethodParameter("start", Type.INT, false), new MethodParameter("len", Type.INT, false)}, SAX_EXCEPTION);
        StringBuffer code = new StringBuffer();
        code.append("\nbuffer.append(chars, start, len);");
        if (this.model.isPropagateSAX()) {
            code.append("handler.characters(chars, start, len);");
        }
        code.append("\n");
        method.setBody(code.toString());
        clazz.addMethod(method);
        method = SAXGeneratorSupport.createImplementationMethod(M_IGNORABLE_WHITESPACE, new MethodParameter[]{new MethodParameter("chars", Type.createArray((Type)Type.CHAR), false), new MethodParameter("start", Type.INT, false), new MethodParameter("len", Type.INT, false)}, SAX_EXCEPTION);
        if (this.model.isPropagateSAX()) {
            method.setBody("\nhandler.ignorableWhitespace(chars, start, len);\n");
        }
        clazz.addMethod(method);
        method = SAXGeneratorSupport.createImplementationMethod(M_PROCESSING_INSTRUCTION, new MethodParameter[]{new MethodParameter("target", Type_STRING, false), new MethodParameter("data", Type_STRING, false)}, SAX_EXCEPTION);
        if (this.model.isPropagateSAX()) {
            method.setBody("\nhandler.processingInstruction(target, data);\n");
        }
        clazz.addMethod(method);
        method = this.genStartPrefixMappingMethod();
        if (method != null) {
            clazz.addMethod(method);
        }
        if ((method = this.genEndPrefixMappingMethod()) != null) {
            clazz.addMethod(method);
        }
        if ((method = this.genSkippedEntityMethod()) != null) {
            clazz.addMethod(method);
        }
        method = this.genEmmitBufferMethod();
        clazz.addMethod(method);
        method = this.genJAXPParseInputSourceMethod();
        clazz.addMethod(method);
        method = this.genJAXPParseURLMethod();
        clazz.addMethod(method);
        method = this.genJAXP_ParseInputSourceMethod();
        clazz.addMethod(method);
        method = this.genJAXP_ParseURLMethod();
        clazz.addMethod(method);
        method = this.genJAXP_ParseSupportMethod();
        clazz.addMethod(method);
        method = this.genSampleErrorHandler();
        clazz.addMethod(method);
        return clazz;
    }

    private MethodElement genEmmitBufferMethod() throws SourceException {
        MethodElement methodElement = new MethodElement();
        methodElement.setName(Identifier.create((String)EMMIT_BUFFER));
        methodElement.setModifiers(2);
        methodElement.setParameters(new MethodParameter[]{new MethodParameter("fireOnlyIfMixed", Type.BOOLEAN, true)});
        methodElement.setExceptions(new Identifier[]{Identifier.create((String)SAX_EXCEPTION)});
        StringBuffer buf = new StringBuffer();
        buf.append("\nif (fireOnlyIfMixed && buffer.length() == 0) return; //skip it\n");
        buf.append("\nObject[] ctx = (Object[]) context.peek();\n");
        buf.append("String here = (String) ctx[0];\n");
        buf.append(this.getSAXAttributes() + " attrs = (" + this.getSAXAttributes() + ") ctx[1];\n");
        String switchPrefix = "if";
        Iterator it = this.model.getElementBindings().values().iterator();
        while (it.hasNext()) {
            ElementBindings.Entry next = (ElementBindings.Entry)it.next();
            String name = next.getElement();
            String method = HANDLE_PREFIX + this.elementMapping.getMethod(name);
            String parslet = this.elementMapping.getParslet(name);
            String data = "buffer.length() == 0 ? null : buffer.toString()";
            parslet = parslet == null ? data : "parslet." + parslet + "(" + data + ")";
            String handling = next.getType();
            if (!"DATA".equals(handling) && !"MIXED".equals(handling)) continue;
            buf.append(switchPrefix + " (\"" + name + "\".equals(here)) {\n");
            if ("DATA".equals(handling)) {
                buf.append("if (fireOnlyIfMixed) throw new IllegalStateException(\"Unexpected characters() event! (Missing DTD?)\");\n");
            }
            buf.append("handler." + method + "(" + parslet + ", attrs);\n");
            switchPrefix = "} else if";
        }
        if (!switchPrefix.equals("if")) {
            buf.append("} else {\n //do not care\n}\n");
        }
        buf.append("buffer.delete(0, buffer.length());\n");
        methodElement.setBody(buf.toString());
        return methodElement;
    }

    private MethodElement genJAXP_ParseSupportMethod() throws SourceException {
        MethodElement method = new MethodElement();
        method.setName(Identifier.create((String)M_PARSE));
        method.setModifiers(10);
        method.setParameters(new MethodParameter[]{new MethodParameter("input", Type.parse((String)SAX_INPUT_SOURCE), true), new MethodParameter("recognizer", Type.parse((String)this.model.getStub()), true)});
        String parser = this.sax == 1 ? "Parser" : "XMLReader";
        method.setBody("\njavax.xml.parsers.SAXParserFactory factory = javax.xml.parsers.SAXParserFactory.newInstance();\nfactory.setValidating(true);  //the code was generated according DTD\nfactory.setNamespaceAware(false);  //the code was generated according DTD\n" + parser + " parser = factory.newSAXParser().get" + parser + "();\n" + "parser.set" + (this.sax == 1 ? "Document" : "Content") + "Handler(recognizer);\n" + "parser.setErrorHandler(recognizer.getDefaultErrorHandler());\n" + "if (recognizer.resolver != null) parser.setEntityResolver(recognizer.resolver);\n" + "parser.parse(input);" + "\n");
        method.setExceptions(JAXP_PARSE_EXCEPTIONS);
        return method;
    }

    private MethodElement genSampleErrorHandler() throws SourceException {
        MethodElement method = new MethodElement();
        method.setName(Identifier.create((String)"getDefaultErrorHandler"));
        method.setModifiers(4);
        method.setReturn(Type.parse((String)"ErrorHandler"));
        method.setBody("\nreturn new ErrorHandler() { \npublic void error(SAXParseException ex) throws SAXException  {\nif (context.isEmpty()) System.err.println(\"Missing DOCTYPE.\");\nthrow ex;\n}\n\npublic void fatalError(SAXParseException ex) throws SAXException {\nthrow ex;\n}\n\npublic void warning(SAXParseException ex) throws SAXException {\n// ignore\n}\n};\n\n");
        String docText = "\nCreates default error handler used by this parser.\n@return org.xml.sax.ErrorHandler implementation\n";
        method.getJavaDoc().setRawText(docText);
        return method;
    }

    private MethodElement genJAXP_ParseInputSourceMethod() throws SourceException {
        MethodElement method = new MethodElement();
        method.setName(Identifier.create((String)M_PARSE));
        method.setModifiers(9);
        if (this.model.hasParslets()) {
            method.setParameters(new MethodParameter[]{new MethodParameter("input", Type.parse((String)SAX_INPUT_SOURCE), true), new MethodParameter("handler", Type.parse((String)this.model.getHandler()), true), new MethodParameter("parslet", Type.parse((String)this.model.getParslet()), true)});
        } else {
            method.setParameters(new MethodParameter[]{new MethodParameter("input", Type.parse((String)SAX_INPUT_SOURCE), true), new MethodParameter("handler", Type.parse((String)this.model.getHandler()), true)});
        }
        String parsletParam = this.model.hasParslets() ? ", parslet" : SAX_PACKAGE;
        method.setBody("\nparse(input, new " + this.model.getStub() + "(handler, null" + parsletParam + "));\n");
        method.setExceptions(JAXP_PARSE_EXCEPTIONS);
        JavaDoc.Method jdoc = method.getJavaDoc();
        jdoc.setRawText("\nThe recognizer entry method taking an Inputsource.\n@param input InputSource to be parsed.\n@throws java.io.IOException on I/O error.\n@throws SAXException propagated exception thrown by a DocumentHandler.\n@throws javax.xml.parsers.ParserConfigurationException a parser satisfining requested configuration can not be created.\n@throws javax.xml.parsers.FactoryConfigurationRrror if the implementation can not be instantiated.\n");
        return method;
    }

    private MethodElement genJAXP_ParseURLMethod() throws SourceException {
        MethodElement method = new MethodElement();
        method.setName(Identifier.create((String)M_PARSE));
        method.setModifiers(9);
        if (this.model.hasParslets()) {
            method.setParameters(new MethodParameter[]{new MethodParameter("url", Type.parse((String)"java.net.URL"), true), new MethodParameter("handler", Type.parse((String)this.model.getHandler()), true), new MethodParameter("parslet", Type.parse((String)this.model.getParslet()), true)});
        } else {
            method.setParameters(new MethodParameter[]{new MethodParameter("url", Type.parse((String)"java.net.URL"), true), new MethodParameter("handler", Type.parse((String)this.model.getHandler()), true)});
        }
        String parsletParam = this.model.hasParslets() ? ", parslet" : SAX_PACKAGE;
        method.setBody("\nparse(new InputSource(url.toExternalForm()), handler" + parsletParam + ");\n");
        method.setExceptions(JAXP_PARSE_EXCEPTIONS);
        JavaDoc.Method jdoc = method.getJavaDoc();
        jdoc.setRawText("\nThe recognizer entry method taking a URL.\n@param url URL source to be parsed.\n@throws java.io.IOException on I/O error.\n@throws SAXException propagated exception thrown by a DocumentHandler.\n@throws javax.xml.parsers.ParserConfigurationException a parser satisfining requested configuration can not be created.\n@throws javax.xml.parsers.FactoryConfigurationRrror if the implementation can not be instantiated.\n");
        return method;
    }

    private MethodElement genJAXPParseInputSourceMethod() throws SourceException {
        MethodElement method = new MethodElement();
        method.setName(Identifier.create((String)M_PARSE));
        method.setModifiers(1);
        method.setParameters(new MethodParameter[]{new MethodParameter("input", Type.parse((String)SAX_INPUT_SOURCE), true)});
        method.setBody("\nparse(input, this);\n");
        method.setExceptions(JAXP_PARSE_EXCEPTIONS);
        JavaDoc.Method jdoc = method.getJavaDoc();
        jdoc.setRawText("\nThe recognizer entry method taking an InputSource.\n@param input InputSource to be parsed.\n@throws java.io.IOException on I/O error.\n@throws SAXException propagated exception thrown by a DocumentHandler.\n@throws javax.xml.parsers.ParserConfigurationException a parser satisfining requested configuration can not be created.\n@throws javax.xml.parsers.FactoryConfigurationRrror if the implementation can not be instantiated.\n");
        return method;
    }

    private MethodElement genJAXPParseURLMethod() throws SourceException {
        MethodElement method = new MethodElement();
        method.setName(Identifier.create((String)M_PARSE));
        method.setModifiers(1);
        method.setParameters(new MethodParameter[]{new MethodParameter("url", Type.parse((String)"java.net.URL"), true)});
        method.setBody("\nparse(new InputSource(url.toExternalForm()), this);\n");
        method.setExceptions(JAXP_PARSE_EXCEPTIONS);
        JavaDoc.Method jdoc = method.getJavaDoc();
        jdoc.setRawText("\nThe recognizer entry method taking a URL.\n@param url URL source to be parsed.\n@throws java.io.IOException on I/O error.\n@throws SAXException propagated exception thrown by a DocumentHandler.\n@throws javax.xml.parsers.ParserConfigurationException a parser satisfining requested configuration can not be created.\n@throws javax.xml.parsers.FactoryConfigurationRrror if the implementation can not be instantiated.\n");
        return method;
    }

    private static FieldElement createField(String name, String clzz) throws SourceException {
        FieldElement field = new FieldElement();
        field.setName(Identifier.create((String)name));
        field.setModifiers(2);
        field.setType(Type.createClass((Identifier)Identifier.create((String)clzz)));
        return field;
    }

    private static MethodElement createInterfaceMethod(String name, MethodParameter[] params, String exception) throws SourceException {
        MethodElement method = new MethodElement();
        method.setModifiers(1);
        method.setReturn(Type.VOID);
        method.setName(Identifier.create((String)name));
        if (params != null) {
            method.setParameters(params);
        }
        if (exception != null) {
            method.setExceptions(new Identifier[]{Identifier.create((String)exception)});
        }
        method.setBody("\n");
        return method;
    }

    private static MethodElement createImplementationMethod(String name, MethodParameter[] params, String exception) throws SourceException {
        MethodElement method = SAXGeneratorSupport.createInterfaceMethod(name, params, exception);
        method.setModifiers(17);
        String docText = "\nThis SAX interface method is implemented by the parser.\n";
        method.getJavaDoc().setRawText(docText);
        return method;
    }

    private TreeDTDRoot getDTD() throws IOException, TreeException {
        if (this.dtd == null) {
            TreeEditorCookie cake = (TreeEditorCookie)((DTDDataObject)this.DO).getCookie(class$org$netbeans$modules$xml$tax$cookies$TreeEditorCookie == null ? (class$org$netbeans$modules$xml$tax$cookies$TreeEditorCookie = SAXGeneratorSupport.class$("org.netbeans.modules.xml.tax.cookies.TreeEditorCookie")) : class$org$netbeans$modules$xml$tax$cookies$TreeEditorCookie);
            if (cake == null) {
                throw new TreeException("DTDDataObject:INTERNAL ERROR");
            }
            TreeDocumentRoot result = cake.openDocumentRoot();
            this.dtd = (TreeDTDRoot)result;
        }
        return this.dtd;
    }

    private Identifier getSAXHandlerInterface() {
        if (this.sax == 1) {
            return Identifier.create((String)SAX_DOCUMENT_HANDLER);
        }
        if (this.sax == 2) {
            return Identifier.create((String)SAX2_CONTENT_HANDLER);
        }
        return null;
    }

    private String getSAXAttributes() {
        if (this.sax == 1) {
            return SAX_ATTRIBUTE_LIST;
        }
        if (this.sax == 2) {
            return SAX2_ATTRIBUTES;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ParsletImplGenerator
    implements CodeGenerator {
        private final String name;

        ParsletImplGenerator(String name) {
            this.name = name;
        }

        public void generate(SourceElement target) throws SourceException {
            target.addClass(SAXGeneratorSupport.this.generateParsletImpl(this.name));
        }
    }

    private class ParsletGenerator
    implements CodeGenerator {
        private final String name;

        ParsletGenerator(String name) {
            this.name = name;
        }

        public void generate(SourceElement target) throws SourceException {
            target.addClass(SAXGeneratorSupport.this.generateParslet(this.name));
        }
    }

    private class InterfaceImplGenerator
    implements CodeGenerator {
        private final String name;

        InterfaceImplGenerator(String name) {
            this.name = name;
        }

        public void generate(SourceElement target) throws SourceException {
            target.addClass(SAXGeneratorSupport.this.generateInterfaceImpl(this.name));
        }
    }

    private class InterfaceGenerator
    implements CodeGenerator {
        private final String name;

        InterfaceGenerator(String name) {
            this.name = name;
        }

        public void generate(SourceElement target) throws SourceException {
            target.addClass(SAXGeneratorSupport.this.generateInterface(this.name));
        }
    }

    private class StubGenerator
    implements CodeGenerator {
        private final String name;
        private final String face;
        private final String let;

        StubGenerator(String name, String face, String let) {
            this.name = name;
            this.face = face;
            this.let = let;
        }

        public void generate(SourceElement target) throws SourceException {
            target.addClass(SAXGeneratorSupport.this.generateStub(this.name, this.face, this.let));
        }
    }

    private static interface CodeGenerator {
        public void generate(SourceElement var1) throws SourceException;
    }
}

