/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.generator;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.xml.core.lib.GuiUtil;
import org.netbeans.modules.xml.tools.generator.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.util.UserCancelException;

public class SelectFileDialog
extends JPanel {
    private static final long serialVersionUID = 4699298946223454165L;
    private Util.NameCheck check;
    private JButton OK_OPTION = new JButton(Util.THIS.getString("BK0002"));
    private JLabel fileLabel;
    private JTextField fileField;
    private JPanel fillPanel;
    private DialogDescriptor selectDD;
    private FileObject folder;
    private String name;
    private String ext;

    public SelectFileDialog(FileObject folder, String name, String ext) {
        this(folder, name, ext, Util.JAVA_CHECK);
    }

    public SelectFileDialog(FileObject folder, String name, String ext, Util.NameCheck check) {
        this.folder = folder;
        this.name = name;
        this.ext = ext;
        this.check = check;
        this.selectDD = new DialogDescriptor((Object)this, Util.THIS.getString("PROP_fileNameTitle") + " *." + ext, true, new Object[]{this.OK_OPTION, NotifyDescriptor.CANCEL_OPTION}, (Object)this.OK_OPTION, 0, null, null);
        this.initComponents();
        this.fileLabel.setDisplayedMnemonic(Util.THIS.getChar("PROP_fileName_mne"));
        this.ownInitComponents();
        this.initAccessibility();
    }

    private void ownInitComponents() {
        this.fileField.setText(this.name);
        this.updateDialogUI();
    }

    private void initComponents() {
        this.fileLabel = new JLabel();
        this.fileField = new JTextField();
        this.fillPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.fileLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/xml/tools/generator/Bundle").getString("PROP_fileName"));
        this.fileLabel.setLabelFor(this.fileField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.fileLabel, gridBagConstraints);
        this.fileField.setColumns(20);
        this.fileField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectFileDialog.this.fileFieldActionPerformed(evt);
            }
        });
        this.fileField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                SelectFileDialog.this.fileFieldFocusGained(evt);
            }
        });
        this.fileField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                SelectFileDialog.this.fileFieldKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.fileField, gridBagConstraints);
        this.fillPanel.setPreferredSize(new Dimension(0, 0));
        this.fillPanel.setMinimumSize(new Dimension(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fillPanel, gridBagConstraints);
    }

    private void fileFieldFocusGained(FocusEvent evt) {
        this.fileField.selectAll();
    }

    private void fileFieldKeyReleased(KeyEvent evt) {
        this.updateDialogUI();
    }

    private void fileFieldActionPerformed(ActionEvent evt) {
        this.updateDialogUI();
    }

    private void updateDialogUI() {
        this.enableOkOption(this.checkAll());
    }

    private boolean checkAll() {
        String typedText = this.fileField.getText();
        if (typedText.indexOf(File.separatorChar) != -1) {
            return false;
        }
        return this.check.checkName(typedText);
    }

    private void enableOkOption(boolean enable) {
        this.OK_OPTION.setEnabled(enable);
    }

    public FileObject getFileObject() throws IOException {
        FileObject newFO = null;
        while (newFO == null) {
            DialogDisplayer.getDefault().createDialog(this.selectDD).show();
            if (this.selectDD.getValue() != this.OK_OPTION) {
                throw new UserCancelException();
            }
            final String newName = this.fileField.getText();
            newFO = this.folder.getFileObject(newName, this.ext);
            if (newFO == null || newFO.isVirtual()) {
                FileSystem fs = this.folder.getFileSystem();
                final FileObject tempFile = newFO;
                fs.runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        block3: {
                            if (tempFile != null && tempFile.isVirtual()) {
                                tempFile.delete();
                            }
                            try {
                                SelectFileDialog.this.folder.createData(newName, SelectFileDialog.this.ext);
                            }
                            catch (IOException exc) {
                                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)Util.THIS.getString("MSG_cannot_create_data", newName + "." + SelectFileDialog.this.ext), 2);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                                if (!Util.THIS.isLoggable()) break block3;
                                Util.THIS.debug(exc);
                            }
                        }
                    }
                });
                newFO = this.folder.getFileObject(newName, this.ext);
                continue;
            }
            if (newFO == null) continue;
            DataObject data = DataObject.find((FileObject)newFO);
            if (data.isModified() || !data.isValid()) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)Util.THIS.getString("BK0001"), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                throw new UserCancelException();
            }
            if (GuiUtil.confirmAction((String)MessageFormat.format(Util.THIS.getString("PROP_replaceMsg"), newName, this.ext))) continue;
            throw new UserCancelException();
        }
        return newFO;
    }

    public void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_SelectFileDialog"));
        this.fileField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_fileField"));
    }
}

