/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.server;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.netbeans.modules.web.monitor.data.ClientData;
import org.netbeans.modules.web.monitor.data.ContextAttributes;
import org.netbeans.modules.web.monitor.data.ContextData;
import org.netbeans.modules.web.monitor.data.CookieIn;
import org.netbeans.modules.web.monitor.data.CookieOut;
import org.netbeans.modules.web.monitor.data.CookiesData;
import org.netbeans.modules.web.monitor.data.DataRecord;
import org.netbeans.modules.web.monitor.data.DispatchData;
import org.netbeans.modules.web.monitor.data.Dispatches;
import org.netbeans.modules.web.monitor.data.EngineData;
import org.netbeans.modules.web.monitor.data.Headers;
import org.netbeans.modules.web.monitor.data.MonitorData;
import org.netbeans.modules.web.monitor.data.Param;
import org.netbeans.modules.web.monitor.data.RequestAttributesIn;
import org.netbeans.modules.web.monitor.data.RequestAttributesOut;
import org.netbeans.modules.web.monitor.data.RequestData;
import org.netbeans.modules.web.monitor.data.ServletData;
import org.netbeans.modules.web.monitor.data.SessionData;
import org.netbeans.modules.web.monitor.data.SessionIn;
import org.netbeans.modules.web.monitor.data.SessionOut;
import org.netbeans.modules.web.monitor.server.Logger;
import org.netbeans.modules.web.monitor.server.MonitorRequestWrapper;
import org.netbeans.modules.web.monitor.server.MonitorResponseWrapper;
import org.netbeans.modules.web.monitor.server.NotifyUtil;

public class MonitorFilter
implements Filter,
Logger {
    public static final String REPLAY = "netbeans.replay";
    public static final String PORT = "netbeans.replay.port";
    public static final String REPLAYSTATUS = "netbeans.replay.status";
    public static final String REPLAYSESSION = "netbeans.replay.session";
    private String attribute = null;
    public static final String PREFIX = "netbeans.monitor";
    private static final String attNameRequest = "netbeans.monitor.request";
    private static final String attNameResponse = "netbeans.monitor.response";
    private static final String attNameFilter = "netbeans.monitor.filter";
    private static final String attNameMonData = "netbeans.monitor.monData";
    public static final String ATTR = "netbeans.monitor.servlet";
    public static final String IDE = "netbeans.monitor.ide";
    public static final String IDES = "netbeans.monitor.register";
    private static boolean collectData = true;
    private FilterConfig filterConfig = null;
    private static final String className = "org.netbeans.modules.web.monitor.server.Monitor";
    private static ResourceBundle statusmsgs = null;
    private static NotifyUtil notifyUtil = null;
    private static final boolean debug = false;

    public MonitorFilter() {
        statusmsgs = ResourceBundle.getBundle("org.netbeans.modules.web.monitor.server.MonitorBundle");
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        String ipaddress = req.getRemoteAddr();
        if (!collectData) {
            try {
                chain.doFilter(req, res);
            }
            catch (Throwable t) {
                this.rethrow(t);
            }
            return;
        }
        Object requestIn = (HttpServletRequest)req;
        String query = requestIn.getQueryString();
        if (query != null && query.startsWith(REPLAY)) {
            if ((requestIn = this.getRequest((HttpServletRequest)requestIn, ipaddress)) == null) {
                try {
                    chain.doFilter(req, res);
                }
                catch (Throwable t) {
                    this.rethrow(t);
                }
                return;
            }
        } else {
            requestIn = new MonitorRequestWrapper((HttpServletRequest)requestIn);
            requestIn.setAttribute(attNameRequest, requestIn);
        }
        requestIn.setAttribute(attNameFilter, (Object)this);
        requestIn.setAttribute(attNameMonData, new Stack());
        MonitorData monData = new MonitorData();
        this.getDataBefore(monData, (HttpServletRequest)requestIn);
        Stack dataStack = null;
        try {
            dataStack = (Stack)requestIn.getAttribute(attNameMonData);
        }
        catch (Throwable t) {
            // empty catch block
        }
        dataStack.push(monData);
        HttpServletResponse r = (HttpServletResponse)res;
        MonitorResponseWrapper monResponse = new MonitorResponseWrapper(r, (HttpServletRequest)requestIn);
        requestIn.setAttribute(attNameResponse, (Object)monResponse);
        Throwable processingError = null;
        try {
            chain.doFilter((ServletRequest)requestIn, (ServletResponse)monResponse);
        }
        catch (ServletException se) {
            this.log("ServletException");
            processingError = se;
        }
        catch (IOException ioe) {
            this.log("IOException");
            processingError = ioe;
        }
        catch (Throwable t) {
            this.log("Error: " + t.getMessage());
            processingError = t;
        }
        this.getDataAfter(monData, (HttpServletRequest)requestIn, monResponse);
        MonitorData md = (MonitorData)dataStack.pop();
        if (!md.getAttributeValue("id").equals(monData.getAttributeValue("id"))) {
            // empty if block
        }
        StringBuffer buf = new StringBuffer(monData.getAttributeValue("id"));
        buf.append("|");
        buf.append(monData.getAttributeValue("method"));
        buf.append("|");
        buf.append(monData.getAttributeValue("resource"));
        notifyUtil.sendRecord(monData, buf.toString());
        if (processingError != null) {
            this.log("A web application object caused an exception");
            this.log(MonitorFilter.getStackTrace(processingError));
            this.rethrow(processingError);
        }
    }

    public void handleDispatchedBefore(ServletRequest req, Servlet servlet) {
        HttpServletRequest request = null;
        try {
            request = (HttpServletRequest)req;
        }
        catch (ClassCastException cce) {
            // empty catch block
        }
        request.setAttribute(ATTR, (Object)servlet);
        DispatchData disData = new DispatchData();
        this.getDataBefore(disData, request);
        Stack dataStack = null;
        try {
            dataStack = (Stack)request.getAttribute(attNameMonData);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (dataStack.empty()) {
            // empty if block
        }
        if (!dataStack.empty()) {
            DispatchData dd;
            Object obj = dataStack.peek();
            Dispatches disp = null;
            if (obj instanceof MonitorData) {
                MonitorData md = (MonitorData)obj;
                disp = md.getDispatches();
                if (disp == null) {
                    disp = new Dispatches();
                    md.setDispatches(disp);
                }
            } else if (obj instanceof DispatchData && (disp = (dd = (DispatchData)obj).getDispatches()) == null) {
                disp = new Dispatches();
                dd.setDispatches(disp);
            }
            disp.addDispatchData(disData);
        }
        dataStack.push(disData);
    }

    public void handleDispatchedAfter(ServletRequest req, ServletResponse res) {
        MonitorRequestWrapper request = null;
        if (req instanceof MonitorRequestWrapper) {
            try {
                request = (MonitorRequestWrapper)req;
            }
            catch (ClassCastException cce) {
                return;
            }
        }
        try {
            request = (MonitorRequestWrapper)((Object)req.getAttribute(attNameRequest));
        }
        catch (NullPointerException npe) {
            return;
        }
        MonitorResponseWrapper response = null;
        if (res instanceof MonitorResponseWrapper) {
            try {
                response = (MonitorResponseWrapper)res;
            }
            catch (ClassCastException cce) {
                return;
            }
        }
        try {
            response = (MonitorResponseWrapper)((Object)req.getAttribute(attNameResponse));
        }
        catch (NullPointerException npe) {
            return;
        }
        Stack dataStack = null;
        try {
            dataStack = (Stack)request.getAttribute(attNameMonData);
        }
        catch (Throwable t) {
            return;
        }
        if (dataStack.empty()) {
            return;
        }
        Object obj = dataStack.pop();
        try {
            this.getDataAfter((DataRecord)obj, (HttpServletRequest)request, response);
        }
        catch (ClassCastException cce) {
            return;
        }
    }

    private void getDataBefore(DataRecord dataRecord, HttpServletRequest request) {
        if (dataRecord instanceof MonitorData) {
            String timestamp = String.valueOf(System.currentTimeMillis());
            String method = request.getMethod();
            String uri = request.getRequestURI();
            String resource = new String(uri);
            String id = new String(timestamp);
            dataRecord.setAttributeValue("id", id);
            dataRecord.setAttributeValue("timestamp", timestamp);
            dataRecord.setAttributeValue("resource", resource);
            dataRecord.setAttributeValue("method", method);
        } else if (dataRecord instanceof DispatchData) {
            String resource = (String)request.getAttribute("javax.servlet.include.request_uri");
            if (resource == null || resource.equals("")) {
                resource = request.getRequestURI();
            }
            dataRecord.setAttributeValue("resource", resource);
        }
        ClientData cd = new ClientData();
        this.recordClientData(cd, request);
        dataRecord.setClientData(cd);
        SessionData sd = new SessionData();
        this.getSessionIn(sd, request);
        dataRecord.setSessionData(sd);
        RequestData rd = new RequestData();
        this.recordRequestData(rd, request);
        dataRecord.setRequestData(rd);
        CookiesData cookiesData = new CookiesData();
        this.recordCookiesIn(cookiesData, request);
        dataRecord.setCookiesData(cookiesData);
        ContextData cond = new ContextData();
        this.recordContextData(cond, request);
        dataRecord.setContextData(cond);
        EngineData ed = new EngineData();
        this.recordEngineData(ed, request);
        dataRecord.setEngineData(ed);
        ServletData servd = new ServletData();
        if (request.getAttribute(ATTR) == null) {
            servd.setAttributeValue("collected", "false");
        } else {
            this.recordServletData(servd, request);
        }
        dataRecord.setServletData(servd);
    }

    private void getDataAfter(DataRecord dataRecord, HttpServletRequest request, MonitorResponseWrapper monResponse) {
        int status = monResponse.getStatus();
        if (status == 0) {
            status = 200;
        }
        String statusStr = "sc" + String.valueOf(status);
        RequestData rd = dataRecord.getRequestData();
        rd.setAttributeValue("status", statusmsgs.getString(statusStr));
        RequestAttributesOut reqattrout = new RequestAttributesOut();
        reqattrout.setParam(this.recordRequestAttributes(request));
        rd.setRequestAttributesOut(reqattrout);
        this.addRequestParameters(rd, request);
        this.recordCookiesOut(dataRecord.getCookiesData(), monResponse);
        this.addSessionOut(dataRecord.getSessionData(), request);
    }

    private void recordClientData(ClientData cd, HttpServletRequest request) {
        String protocol = request.getProtocol();
        while (protocol.endsWith("\n")) {
            protocol = protocol.substring(0, protocol.length() - 2);
        }
        cd.setAttributeValue("protocol", protocol);
        cd.setAttributeValue("remoteAddress", request.getRemoteAddr());
        StringBuffer valueBuf = new StringBuffer(128);
        int counter = 0;
        Enumeration hvals = request.getHeaders("user-agent");
        if (hvals != null) {
            while (hvals.hasMoreElements()) {
                if (counter > 0) {
                    valueBuf.append(", ");
                }
                valueBuf.append((String)hvals.nextElement());
                ++counter;
            }
        }
        cd.setAttributeValue("software", valueBuf.toString());
        valueBuf = new StringBuffer(128);
        counter = 0;
        hvals = request.getHeaders("accept-language");
        if (hvals != null) {
            while (hvals.hasMoreElements()) {
                if (counter > 0) {
                    valueBuf.append(", ");
                }
                valueBuf.append((String)hvals.nextElement());
                ++counter;
            }
        }
        cd.setAttributeValue("locale", valueBuf.toString());
        valueBuf = new StringBuffer(128);
        counter = 0;
        hvals = request.getHeaders("accept");
        if (hvals != null) {
            while (hvals.hasMoreElements()) {
                if (counter > 0) {
                    valueBuf.append(", ");
                }
                valueBuf.append((String)hvals.nextElement());
                ++counter;
            }
        }
        cd.setAttributeValue("formatsAccepted", valueBuf.toString());
        valueBuf = new StringBuffer(128);
        counter = 0;
        hvals = request.getHeaders("accept-encoding");
        if (hvals != null) {
            while (hvals.hasMoreElements()) {
                if (counter > 0) {
                    valueBuf.append(", ");
                }
                valueBuf.append((String)hvals.nextElement());
                ++counter;
            }
        }
        cd.setAttributeValue("encodingsAccepted", valueBuf.toString());
        valueBuf = new StringBuffer(128);
        counter = 0;
        hvals = request.getHeaders("accept-charset");
        if (hvals != null) {
            while (hvals.hasMoreElements()) {
                if (counter > 0) {
                    valueBuf.append(", ");
                }
                valueBuf.append((String)hvals.nextElement());
                ++counter;
            }
        }
        cd.setAttributeValue("charsetsAccepted", valueBuf.toString());
    }

    private void recordCookiesIn(CookiesData cd, HttpServletRequest request) {
        Cookie[] cks = null;
        try {
            cks = request.getCookies();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (cks == null || cks.length == 0) {
            cd.setCookieIn(new CookieIn[0]);
            return;
        }
        CookieIn[] theCookies = new CookieIn[cks.length];
        int i = 0;
        while (i < theCookies.length) {
            theCookies[i] = new CookieIn(cks[i]);
            ++i;
        }
        cd.setCookieIn(theCookies);
    }

    private void recordCookiesOut(CookiesData cd, MonitorResponseWrapper response) {
        Enumeration e = response.getCookies();
        int numCookies = 0;
        while (e.hasMoreElements()) {
            e.nextElement();
            ++numCookies;
        }
        if (numCookies == 0) {
            cd.setCookieOut(new CookieOut[0]);
            return;
        }
        e = response.getCookies();
        CookieOut[] theCookies = null;
        try {
            theCookies = new CookieOut[numCookies];
            int i = 0;
            while (i < theCookies.length) {
                theCookies[i] = new CookieOut((Cookie)e.nextElement());
                ++i;
            }
        }
        catch (NullPointerException ne) {
            theCookies = new CookieOut[]{};
        }
        cd.setCookieOut(theCookies);
    }

    private void getSessionIn(SessionData sess, HttpServletRequest request) {
        HttpSession sessIn = null;
        try {
            sessIn = request.getSession(false);
        }
        catch (Exception ne) {
            // empty catch block
        }
        if (sessIn == null) {
            sess.setAttributeValue("before", "false");
            return;
        }
        sess.setAttributeValue("before", "true");
        sess.setAttributeValue("id", sessIn.getId());
        DateFormat df = DateFormat.getDateTimeInstance(0, 3);
        Date date = new Date(sessIn.getCreationTime());
        sess.setAttributeValue("created", df.format(date));
        SessionIn si = new SessionIn();
        int maxint = 0;
        try {
            maxint = sessIn.getMaxInactiveInterval();
            if (maxint != 0) {
                si.setAttributeValue("inactiveInterval", String.valueOf(maxint));
            }
        }
        catch (NumberFormatException ne) {
            // empty catch block
        }
        try {
            date = new Date(sessIn.getLastAccessedTime());
            si.setAttributeValue("lastAccessed", df.format(date));
        }
        catch (Exception ex) {
            // empty catch block
        }
        si.setParam(this.getSessionAttributes(sessIn));
        sess.setSessionIn(si);
    }

    private void addSessionOut(SessionData sess, HttpServletRequest request) {
        HttpSession sessOut = null;
        try {
            sessOut = request.getSession(false);
        }
        catch (Exception ne) {
            // empty catch block
        }
        if (sessOut == null) {
            sess.setAttributeValue("after", "false");
            return;
        }
        DateFormat df = DateFormat.getDateTimeInstance(0, 3);
        sess.setAttributeValue("after", "true");
        Date date = null;
        if (sess.getAttributeValue("before").equals("false")) {
            sess.setAttributeValue("id", sessOut.getId());
            date = new Date(sessOut.getCreationTime());
            sess.setAttributeValue("created", df.format(date));
        }
        SessionOut so = new SessionOut();
        int maxint = 0;
        try {
            maxint = sessOut.getMaxInactiveInterval();
            if (maxint != 0) {
                so.setAttributeValue("inactiveInterval", String.valueOf(maxint));
            }
        }
        catch (NumberFormatException ne) {
            // empty catch block
        }
        try {
            date = new Date(sessOut.getLastAccessedTime());
            so.setAttributeValue("lastAccessed", df.format(date));
        }
        catch (Exception ex) {
            // empty catch block
        }
        Param[] params = this.getSessionAttributes(sessOut);
        so.setParam(params);
        sess.setSessionOut(so);
    }

    private Param[] getSessionAttributes(HttpSession session) {
        Enumeration names = null;
        try {
            names = session.getAttributeNames();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (names == null || !names.hasMoreElements()) {
            return new Param[0];
        }
        Vector<Param> v = new Vector<Param>();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object value = session.getAttribute(name);
            String valueRep = null;
            valueRep = value == null ? ResourceBundle.getBundle("org.netbeans.modules.web.monitor.server.Bundle").getString("MON_Warning_attributes") : value.toString();
            Param p = new Param();
            p.setAttributeValue("name", name);
            p.setAttributeValue("value", valueRep);
            v.add(p);
        }
        int size = v.size();
        Param[] params = new Param[size];
        int i = 0;
        while (i < size) {
            params[i] = (Param)((Object)v.elementAt(i));
            ++i;
        }
        return params;
    }

    private void recordRequestData(RequestData rd, HttpServletRequest request) {
        String method = request.getMethod();
        rd.setAttributeValue("uri", request.getRequestURI());
        rd.setAttributeValue("method", method);
        String protocol = request.getProtocol();
        while (protocol.endsWith("\n")) {
            protocol = protocol.substring(0, protocol.length() - 2);
        }
        rd.setAttributeValue("protocol", protocol);
        rd.setAttributeValue("ipaddress", request.getRemoteAddr());
        String queryString = request.getQueryString();
        if (queryString == null || queryString.trim().equals("")) {
            queryString = "";
        }
        rd.setAttributeValue("queryString", queryString);
        rd.setAttributeValue("scheme", request.getScheme());
        Headers headers = new Headers();
        headers.setParam(this.recordHeaders(request));
        rd.setHeaders(headers);
        RequestAttributesIn reqattrin = new RequestAttributesIn();
        reqattrin.setParam(this.recordRequestAttributes(request));
        rd.setRequestAttributesIn(reqattrin);
    }

    private void recordContextData(ContextData cd, HttpServletRequest request) {
        ServletContext context = this.filterConfig.getServletContext();
        cd.setAttributeValue("absPath", context.getRealPath("/"));
        cd.setAttributeValue("contextName", context.getServletContextName());
        ContextAttributes ctxtattr = new ContextAttributes();
        ctxtattr.setParam(this.recordContextAttributes(context));
        cd.setContextAttributes(ctxtattr);
        Enumeration e = context.getInitParameterNames();
        Vector<Param> v = new Vector<Param>();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = context.getInitParameter(name);
            Param p = new Param();
            p.setAttributeValue("name", name);
            p.setAttributeValue("value", value);
            v.add(p);
        }
        int size = v.size();
        Param[] params = new Param[size];
        int i = 0;
        while (i < size) {
            params[i] = (Param)((Object)v.elementAt(i));
            ++i;
        }
        cd.setParam(params);
    }

    private void recordEngineData(EngineData ed, HttpServletRequest request) {
        ServletContext context = this.filterConfig.getServletContext();
        ed.setAttributeValue("serverName", request.getServerName());
        ed.setAttributeValue("serverPort", String.valueOf(request.getServerPort()));
        ed.setAttributeValue("jre", String.valueOf(context.getMajorVersion()));
        ed.setAttributeValue("platform", context.getServerInfo());
    }

    private void recordServletData(ServletData sd, HttpServletRequest request) {
        Servlet servlet;
        String str = null;
        try {
            str = request.getServletPath();
        }
        catch (Exception excep) {
            // empty catch block
        }
        if (str != null && !str.equals("")) {
            sd.setAttributeValue("relPath", str);
        }
        str = null;
        try {
            str = request.getPathTranslated();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (str != null && !str.trim().equals("null")) {
            sd.setAttributeValue("transPath", str);
        }
        if ((servlet = (Servlet)request.getAttribute(ATTR)) == null) {
            sd.setAttributeValue("collected", "no");
            return;
        }
        sd.setAttributeValue("collected", "true");
        try {
            String pkgName = servlet.getClass().getPackage().getName();
            if (pkgName != null) {
                sd.setAttributeValue("packageName", pkgName);
            }
        }
        catch (Exception exc) {
            // empty catch block
        }
        sd.setAttributeValue("className", servlet.getClass().getName());
        String info = servlet.getServletInfo();
        if (info == null || info.trim().equals("")) {
            info = "";
        }
        sd.setAttributeValue("servletInfo", info);
        ServletConfig config = null;
        try {
            config = servlet.getServletConfig();
        }
        catch (Throwable t) {
            this.log("WARNING: the getServletConfig() method has been overridden in such a way that it");
            this.log("throws an exception. This can cause the application to fail.");
            this.log(t.getMessage());
        }
        if (config == null) {
            return;
        }
        String servletName = config.getServletName();
        if (servletName == null || servletName.equals("")) {
            sd.setAttributeValue("name", "");
        } else {
            sd.setAttributeValue("name", servletName);
        }
        Enumeration e = config.getInitParameterNames();
        Vector<Param> v = new Vector<Param>();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = "";
            try {
                value = config.getInitParameter(name);
            }
            catch (Exception ex) {
                // empty catch block
            }
            Param p = new Param();
            p.setAttributeValue("name", name);
            p.setAttributeValue("value", value);
            v.add(p);
        }
        int size = v.size();
        Param[] params = new Param[size];
        int i = 0;
        while (i < size) {
            params[i] = (Param)((Object)v.elementAt(i));
            ++i;
        }
        sd.setParam(params);
    }

    private Param[] recordHeaders(HttpServletRequest request) {
        Vector<Param> v = new Vector<Param>();
        Vector<String> names = new Vector<String>();
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (names.contains(name)) continue;
            Enumeration value = request.getHeaders(name);
            int counter = 0;
            while (value.hasMoreElements()) {
                v.add(new Param(name, (String)value.nextElement()));
                ++counter;
            }
            if (counter <= true) continue;
            names.add(name);
        }
        int size = v.size();
        Param[] params = new Param[size];
        int i = 0;
        while (i < size) {
            params[i] = (Param)((Object)v.elementAt(i));
            ++i;
        }
        return params;
    }

    private void addRequestParameters(RequestData rd, HttpServletRequest request) {
        String[] vals;
        String name;
        Enumeration e;
        String method = rd.getAttributeValue("method");
        boolean urlencoded = true;
        if (method.equals("POST")) {
            Headers headers = rd.getHeaders();
            String urlencodedS = "application/x-www-form-urlencoded";
            String typeS = "Content-type";
            if (headers.containsHeader(typeS) && !headers.getHeader(typeS).equalsIgnoreCase(urlencodedS)) {
                urlencoded = false;
            }
        }
        rd.setAttributeValue("urlencoded", String.valueOf(urlencoded));
        if (method.equals("GET")) {
            try {
                e = request.getParameterNames();
                while (e.hasMoreElements()) {
                    name = (String)e.nextElement();
                    vals = request.getParameterValues(name);
                    int i = 0;
                    while (i < vals.length) {
                        rd.addParam(new Param(name, vals[i]));
                        ++i;
                    }
                }
            }
            catch (Exception ex) {}
        } else if (method.equals("POST") && urlencoded) {
            e = null;
            try {
                e = request.getParameterNames();
                while (e.hasMoreElements()) {
                    name = (String)e.nextElement();
                    vals = request.getParameterValues(name);
                    int i = 0;
                    while (i < vals.length) {
                        rd.addParam(new Param(name, vals[i]));
                        ++i;
                    }
                }
            }
            catch (Exception ex) {
                rd.setAttributeValue("urlencoded", "bad");
            }
        }
    }

    private Param[] recordRequestAttributes(HttpServletRequest request) {
        Vector<Param> v = new Vector<Param>();
        Enumeration e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object value = request.getAttribute(name);
            Param p = new Param();
            p.setAttributeValue("name", name);
            p.setAttributeValue("value", value.toString());
            v.add(p);
        }
        int size = v.size();
        Param[] params = new Param[size];
        int i = 0;
        while (i < size) {
            params[i] = (Param)((Object)v.elementAt(i));
            ++i;
        }
        return params;
    }

    private Param[] recordContextAttributes(ServletContext context) {
        Vector<Param> v = new Vector<Param>();
        Enumeration e = context.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object value = context.getAttribute(name);
            Param p = new Param();
            p.setAttributeValue("name", name);
            p.setAttributeValue("value", value.toString());
            v.add(p);
        }
        int size = v.size();
        Param[] params = new Param[size];
        int i = 0;
        while (i < size) {
            params[i] = (Param)((Object)v.elementAt(i));
            ++i;
        }
        return params;
    }

    private HttpServletRequestWrapper getRequest(HttpServletRequest requestIn, String ipaddress) {
        String status;
        boolean debug = false;
        if (debug) {
            this.log("getRequest() STARTS HERE");
        }
        if ((status = requestIn.getParameter(REPLAYSTATUS)) == null) {
            this.log(" replay request corrupted");
            return null;
        }
        String id = requestIn.getParameter(REPLAY);
        Object obj = null;
        try {
            obj = requestIn.getAttribute(attNameRequest);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (obj instanceof MonitorRequestWrapper) {
            if (debug) {
                this.log(" request from attribute");
            }
            return (HttpServletRequestWrapper)obj;
        }
        if (obj instanceof String) {
            if (debug) {
                this.log(" null request from attribute");
            }
            return null;
        }
        if (debug) {
            this.log("Try to retrieve the request from the originating IDE " + ipaddress);
        }
        String portS = requestIn.getParameter(PORT);
        int port = 0;
        try {
            port = Integer.parseInt(portS);
        }
        catch (NumberFormatException nfe) {
            if (debug) {
                this.log("Request did not provide a port number");
            }
            return null;
        }
        RequestData rd = notifyUtil.getRecord(id, status, ipaddress, port);
        boolean replaceSessionID = false;
        try {
            String sessionID = requestIn.getParameter(REPLAYSESSION);
            if (sessionID != null) {
                if (debug) {
                    this.log("User asked for new session " + sessionID);
                }
                replaceSessionID = true;
            } else if (debug) {
                this.log("User wants browser's session");
            }
        }
        catch (NullPointerException npe) {
            this.log("NPE when getting netbeans.replay.session");
        }
        if (rd != null) {
            if (debug) {
                this.log("Got requestdata as we should");
            }
            MonitorRequestWrapper requestWrapper = new MonitorRequestWrapper(requestIn);
            if (debug) {
                this.log("Created wrapper");
            }
            requestWrapper.populate(rd, replaceSessionID);
            if (debug) {
                this.log("Populated wrapper");
            }
            requestWrapper.setAttribute(attNameRequest, (Object)requestWrapper);
            return requestWrapper;
        }
        if (debug) {
            this.log("Failed to get the request");
        }
        return null;
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        this.attribute = filterConfig != null ? filterConfig.getInitParameter("attribute") : null;
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        MonitorRequestWrapper.setServletContext(filterConfig.getServletContext());
        notifyUtil = new NotifyUtil();
        boolean noIDE = true;
        String ide = filterConfig.getInitParameter(IDE).trim();
        try {
            notifyUtil.setIDE(ide);
            collectData = true;
        }
        catch (MalformedURLException mux) {
            this.log("IDE init parameter has an invalid value:");
            this.log(ide);
            this.log("starting anyway");
        }
        String ides = filterConfig.getInitParameter(IDES);
        if (ides != null && !ides.trim().equals("")) {
            StringTokenizer st = new StringTokenizer(ides, ",");
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                try {
                    notifyUtil.setIDE(name.trim());
                    collectData = true;
                }
                catch (MalformedURLException mux) {
                    this.log("additional IDE includes an invalid server declaration:");
                    this.log(name);
                    this.log("starting anyway");
                }
            }
        }
    }

    public String toString() {
        if (this.filterConfig == null) {
            return "MonitorFilter()";
        }
        StringBuffer sb = new StringBuffer("MonitorFilter(");
        sb.append(this.filterConfig);
        sb.append(")");
        return sb.toString();
    }

    public static boolean getCollectData() {
        return collectData;
    }

    public static void setCollectData(boolean v) {
        collectData = v;
    }

    private void rethrow(Throwable t) throws IOException, ServletException {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof ServletException) {
            throw (ServletException)t;
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        String message = ResourceBundle.getBundle("org.netbeans.modules.web.monitor.server.Bundle").getString("MON_Rethrow");
        throw new ServletException(message, t);
    }

    private void sendProcessingError(Throwable t, ServletResponse res) {
        String stackTrace = MonitorFilter.getStackTrace(t);
        if (stackTrace != null && !stackTrace.equals("")) {
            try {
                res.setContentType("text/html");
                PrintStream ps = new PrintStream((OutputStream)res.getOutputStream());
                PrintWriter pw = new PrintWriter(ps);
                pw.print("<html>\n<head>\n</head>\n<body>\n");
                pw.print("<h1>The resource did not process correctly</h1>\n<pre>\n");
                pw.print(stackTrace);
                pw.print("</pre></body>\n</html>");
                pw.close();
                ps.close();
                res.getOutputStream().close();
            }
            catch (Exception ex) {}
        } else {
            try {
                PrintStream ps = new PrintStream((OutputStream)res.getOutputStream());
                t.printStackTrace(ps);
                ps.close();
                res.getOutputStream().close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public static String getStackTrace(Throwable t) {
        String stackTrace = null;
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            sw.close();
            stackTrace = sw.getBuffer().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stackTrace;
    }

    public void log(String msg) {
        System.out.println("MonitorFilter::" + msg);
    }

    public void log(Throwable t) {
        this.log(MonitorFilter.getStackTrace(t));
    }
}

