/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.server;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpUtils;
import org.netbeans.modules.web.monitor.data.Param;
import org.netbeans.modules.web.monitor.data.RequestData;

public class MonitorRequestWrapper
extends HttpServletRequestWrapper {
    private boolean methodSetLocally = false;
    private String localMethod = null;
    private static ServletContext context = null;
    public static final String JSESSIONID = "JSESSIONID";
    public static final String REPLACED = "netbeans.replay.session-replaced";
    private static final boolean debug = false;
    private boolean parametersSetLocally = false;
    private Hashtable localParameters = null;
    private String localQueryString = null;
    private boolean queryStringSetLocally = false;
    private String localProtocol = null;
    private boolean protocolSetLocally = false;
    private String localScheme = null;
    private boolean schemeSetLocally = false;
    private boolean headersSetLocally = false;
    private Param[] localHeaders = null;
    private boolean cookiesSetLocally = false;
    private Vector localCookies = null;
    private String localRemoteAddr = null;
    private boolean remoteAddrSetLocally = false;

    MonitorRequestWrapper(HttpServletRequest req) {
        super(req);
    }

    private HttpServletRequest getHRequest() {
        return (HttpServletRequest)this.getRequest();
    }

    public void setMethod(String value) {
        this.localMethod = value;
        this.methodSetLocally = true;
    }

    public String getMethod() {
        if (this.methodSetLocally) {
            return this.localMethod;
        }
        return this.getHRequest().getMethod();
    }

    public void setParameters(Hashtable ht) {
        this.localParameters = ht;
        this.parametersSetLocally = true;
    }

    public String getParameter(String key) {
        if (!this.parametersSetLocally) {
            return this.getRequest().getParameter(key);
        }
        String[] values = (String[])this.localParameters.get(key);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Map getParameterMap() {
        if (!this.parametersSetLocally) {
            return this.getRequest().getParameterMap();
        }
        return this.localParameters;
    }

    public Enumeration getParameterNames() {
        if (!this.parametersSetLocally) {
            return this.getRequest().getParameterNames();
        }
        return this.localParameters.keys();
    }

    public String[] getParameterValues(String name) {
        if (!this.parametersSetLocally) {
            return this.getRequest().getParameterValues(name);
        }
        return (String[])this.localParameters.get(name);
    }

    public void setQueryString(String value) {
        this.localQueryString = value;
        this.queryStringSetLocally = true;
    }

    public String getQueryString() {
        if (!this.queryStringSetLocally) {
            return this.getHRequest().getQueryString();
        }
        return this.localQueryString;
    }

    public void setProtocol(String value) {
        this.localProtocol = value;
        this.protocolSetLocally = true;
    }

    public String getProtocol() {
        if (!this.protocolSetLocally) {
            return this.getRequest().getProtocol();
        }
        return this.localProtocol;
    }

    public void setScheme(String value) {
        this.localScheme = value;
        this.schemeSetLocally = true;
    }

    public String getScheme() {
        if (this.schemeSetLocally) {
            return this.localScheme;
        }
        return this.getRequest().getScheme();
    }

    public String getHeader(String key) {
        if (this.headersSetLocally) {
            int len = this.localHeaders.length;
            int i = 0;
            while (i < len) {
                if (this.localHeaders[i].getName().equalsIgnoreCase(key)) {
                    return this.localHeaders[i].getValue();
                }
                ++i;
            }
            return "";
        }
        return this.getHRequest().getHeader(key);
    }

    private void setHeader(String headerName, String headerValue) {
        boolean addedHeader = false;
        if (this.headersSetLocally) {
            int i = 0;
            while (i < this.localHeaders.length) {
                if (this.localHeaders[i].getName().equalsIgnoreCase(headerName)) {
                    this.localHeaders[i].setValue(headerValue);
                    addedHeader = true;
                    break;
                }
                ++i;
            }
            if (addedHeader) {
                return;
            }
            Param[] p = new Param[this.localHeaders.length + 1];
            int numHeaders = 0;
            while (numHeaders < this.localHeaders.length) {
                p[numHeaders] = this.localHeaders[numHeaders];
                ++numHeaders;
            }
            p[numHeaders] = new Param(headerName, headerValue);
            this.localHeaders = p;
            return;
        }
        Vector<Param> v = new Vector<Param>();
        Vector<String> names = new Vector<String>();
        Enumeration e = this.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (names.contains(name)) continue;
            if (name.equalsIgnoreCase(headerName)) {
                v.add(new Param(headerName, headerValue));
                names.add(name);
                addedHeader = true;
                continue;
            }
            Enumeration value = this.getHeaders(name);
            int counter = 0;
            while (value.hasMoreElements()) {
                v.add(new Param(name, (String)value.nextElement()));
                ++counter;
            }
            if (counter <= true) continue;
            names.add(name);
        }
        int size = v.size();
        this.localHeaders = new Param[size];
        int i = 0;
        while (i < size) {
            this.localHeaders[i] = (Param)((Object)v.elementAt(i));
            ++i;
        }
        this.headersSetLocally = true;
    }

    private void removeHeader(String headerName) {
        Vector<Param> v = new Vector<Param>();
        if (this.headersSetLocally) {
            int i = 0;
            while (i < this.localHeaders.length) {
                if (!this.localHeaders[i].getName().equalsIgnoreCase(headerName)) {
                    v.add(this.localHeaders[i]);
                }
                ++i;
            }
        } else {
            Vector<String> names = new Vector<String>();
            names.add(headerName);
            Enumeration e = this.getHeaderNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (names.contains(name)) continue;
                Enumeration value = this.getHeaders(name);
                int counter = 0;
                while (value.hasMoreElements()) {
                    v.add(new Param(name, (String)value.nextElement()));
                    ++counter;
                }
                if (counter <= true) continue;
                names.add(name);
            }
        }
        int size = v.size();
        this.localHeaders = new Param[size];
        int i = 0;
        while (i < size) {
            this.localHeaders[i] = (Param)((Object)v.elementAt(i));
            ++i;
        }
        this.headersSetLocally = true;
    }

    public Enumeration getHeaderNames() {
        if (this.headersSetLocally) {
            Vector<String> v = new Vector<String>();
            int len = this.localHeaders.length;
            int i = 0;
            while (i < len) {
                v.add(this.localHeaders[i].getName());
                ++i;
            }
            return v.elements();
        }
        return this.getHRequest().getHeaderNames();
    }

    public Enumeration getHeaders(String name) {
        if (this.headersSetLocally) {
            Vector<String> v = new Vector<String>();
            int len = this.localHeaders.length;
            int i = 0;
            while (i < len) {
                if (this.localHeaders[i].getName().equalsIgnoreCase(name)) {
                    v.add(this.localHeaders[i].getValue());
                }
                ++i;
            }
            return v.elements();
        }
        return this.getHRequest().getHeaders(name);
    }

    public int getIntHeader(String name) {
        int headerValue = -1;
        String value = this.getHeader(name);
        if (value != null) {
            headerValue = Integer.parseInt(value);
        }
        return headerValue;
    }

    public long getDateHeader(String name) {
        long dateValue = -1L;
        String value = this.getHeader(name);
        if (value != null) {
            int el = value.indexOf(59);
            if (el != -1) {
                value = value.substring(0, el);
            }
            try {
                dateValue = Date.parse(value);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (dateValue == -1L) {
                throw new IllegalArgumentException();
            }
        }
        return dateValue;
    }

    public Cookie[] getCookies() {
        if (!this.cookiesSetLocally) {
            return this.getHRequest().getCookies();
        }
        if (this.localCookies == null) {
            return new Cookie[0];
        }
        int numCookies = this.localCookies.size();
        Cookie[] cookieArray = new Cookie[numCookies];
        Enumeration e = this.localCookies.elements();
        int index = 0;
        while (e.hasMoreElements()) {
            cookieArray[index] = (Cookie)e.nextElement();
            ++index;
        }
        return cookieArray;
    }

    public void setCookies(Vector cookies) {
        this.cookiesSetLocally = true;
        this.localCookies = cookies;
    }

    public void deleteCookie(String name) {
        this.cookiesSetLocally = true;
        if (this.localCookies == null) {
            this.localCookies = new Vector();
        }
        if (this.localCookies.size() == 0) {
            return;
        }
        Enumeration e = this.localCookies.elements();
        while (e.hasMoreElements()) {
            try {
                Cookie cookie = (Cookie)e.nextElement();
                if (!cookie.getName().equals(name)) continue;
                this.localCookies.remove(cookie);
                return;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void deleteCookie(Cookie ck) {
        this.cookiesSetLocally = true;
        if (this.localCookies == null) {
            this.localCookies = new Vector();
        }
        if (this.localCookies.size() == 0) {
            return;
        }
        Enumeration e = this.localCookies.elements();
        while (e.hasMoreElements()) {
            try {
                Cookie cookie = (Cookie)e.nextElement();
                if (!cookie.getName().equals(ck.getName()) || !cookie.getValue().equals(ck.getValue())) continue;
                this.localCookies.remove(cookie);
                return;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public Vector getCookieVector() {
        return this.localCookies;
    }

    public Enumeration getAttributeNames() {
        Enumeration e = this.getRequest().getAttributeNames();
        Vector<String> v = new Vector<String>();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.startsWith("netbeans.monitor")) continue;
            v.add(name);
        }
        return v.elements();
    }

    public void setRemoteAddr(String value) {
        this.localRemoteAddr = value;
        this.remoteAddrSetLocally = true;
    }

    public String getRemoteAddr() {
        if (!this.remoteAddrSetLocally) {
            return this.getRequest().getRemoteAddr();
        }
        return this.localRemoteAddr;
    }

    public String toString() {
        String value;
        String name;
        StringBuffer buf = new StringBuffer();
        buf.append("uri: ");
        buf.append(this.getRequestURI());
        buf.append("\n");
        buf.append("method: ");
        buf.append(this.getMethod());
        buf.append("\n");
        buf.append("QueryString: ");
        buf.append(this.getQueryString());
        buf.append("\n");
        buf.append("Parameters:\n");
        Enumeration e = this.getParameterNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = this.getParameter(name);
            buf.append("\tName: ");
            buf.append(name);
            buf.append("\tValue: ");
            buf.append(value);
            buf.append("\n");
        }
        buf.append("Headers:\n");
        e = this.getHeaderNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = this.getHeader(name);
            buf.append("\tName: ");
            buf.append(name);
            buf.append("\tValue: ");
            buf.append(value);
            buf.append("\n");
        }
        return buf.toString();
    }

    static void setServletContext(ServletContext ctx) {
        context = ctx;
    }

    public void populate(RequestData rd, boolean replaceSessionID) {
        String cookieStr;
        Hashtable<String, String[]> ht;
        String queryString;
        String method = rd.getAttributeValue("method");
        this.setMethod(method);
        this.setProtocol(rd.getAttributeValue("protocol"));
        this.setScheme(rd.getAttributeValue("scheme"));
        if (method.equals("GET")) {
            queryString = rd.getAttributeValue("queryString");
            this.setQueryString(queryString);
            ht = null;
            try {
                ht = HttpUtils.parseQueryString((String)queryString);
            }
            catch (Exception ex) {
                ht = new Hashtable<String, String[]>();
            }
            this.setParameters(ht);
        } else if (method.equals("POST")) {
            queryString = rd.getAttributeValue("queryString");
            this.setQueryString(queryString);
            ht = null;
            try {
                ht = HttpUtils.parseQueryString((String)queryString);
            }
            catch (Exception ex) {
                ht = new Hashtable<String, String[]>();
            }
            Param[] params = rd.getParam();
            int numParams = params.length;
            int i = 0;
            while (i < numParams) {
                String name = params[i].getAttributeValue("name");
                String[] values = null;
                if (ht.containsKey(name)) {
                    values = (String[])ht.get(name);
                    String[] newvals = new String[values.length + 1];
                    int j = 0;
                    while (j < values.length) {
                        newvals[j] = values[j];
                        ++j;
                    }
                    newvals[j] = params[i].getAttributeValue("value");
                    ht.put(name, newvals);
                } else {
                    values = new String[]{params[i].getAttributeValue("value")};
                    ht.put(name, values);
                }
                ++i;
            }
            this.setParameters(ht);
        } else if (method.equals("PUT")) {
            queryString = rd.getAttributeValue("queryString");
            this.setQueryString(queryString);
            this.setParameters(new Hashtable());
        } else {
            queryString = rd.getAttributeValue("queryString");
            this.setQueryString(queryString);
            this.setParameters(new Hashtable());
        }
        StringBuffer cookieBuf = new StringBuffer();
        int numHeaders = rd.getHeaders().sizeParam();
        this.localHeaders = new Param[numHeaders];
        int i = 0;
        while (i < numHeaders) {
            this.localHeaders[i] = rd.getHeaders().getParam(i);
            ++i;
        }
        this.headersSetLocally = true;
        this.localCookies = new Vector();
        this.cookiesSetLocally = true;
        String idFromRequest = null;
        Param[] myCookies = rd.getCookiesAsParams();
        if (myCookies != null && myCookies.length > 0) {
            String ckname = null;
            String ckvalue = null;
            int i2 = 0;
            while (i2 < myCookies.length) {
                ckname = myCookies[i2].getAttributeValue("name");
                ckvalue = myCookies[i2].getAttributeValue("value");
                if (ckname.equalsIgnoreCase(JSESSIONID)) {
                    idFromRequest = ckvalue;
                } else {
                    this.localCookies.add(new Cookie(ckname, ckvalue));
                    if (cookieBuf.length() > 0) {
                        cookieBuf.append("; ");
                    }
                    cookieBuf.append(ckname);
                    cookieBuf.append("=");
                    cookieBuf.append(ckvalue);
                }
                ++i2;
            }
        }
        boolean sessionReplaced = false;
        try {
            String value = (String)this.getHRequest().getAttribute(REPLACED);
            if (value.equals("true")) {
                sessionReplaced = true;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (sessionReplaced) {
            if (idFromRequest != null) {
                this.localCookies.add(new Cookie(JSESSIONID, idFromRequest));
                if (cookieBuf.length() > 0) {
                    cookieBuf.append("; ");
                }
                cookieBuf.append(JSESSIONID);
                cookieBuf.append("=");
                cookieBuf.append(idFromRequest);
            }
        } else {
            Cookie[] ck = this.getHRequest().getCookies();
            if (ck != null && ck.length > 0) {
                int i3 = 0;
                while (i3 < ck.length) {
                    if (ck[i3].getName().equals(JSESSIONID)) {
                        this.localCookies.add(ck[i3]);
                        if (cookieBuf.length() > 0) {
                            cookieBuf.append("; ");
                        }
                        cookieBuf.append(JSESSIONID);
                        cookieBuf.append("=");
                        cookieBuf.append(ck[i3].getValue());
                    }
                    ++i3;
                }
            }
        }
        if ((cookieStr = cookieBuf.toString()).equals("")) {
            this.removeHeader("cookie");
        } else {
            this.setHeader("cookie", cookieBuf.toString());
        }
    }

    private void log(String s) {
        System.out.println("MonitorRequestWrapper::" + s);
    }
}

