/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglibed;

import java.awt.Dialog;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.web.taglibed.SAXParseError;
import org.netbeans.modules.web.taglibed.TLDEditorSupport;
import org.netbeans.modules.web.taglibed.XMLJ2eeDataObject;
import org.netbeans.modules.web.taglibed.control.GenerateCodeAction;
import org.netbeans.modules.web.taglibed.control.PropertyView;
import org.netbeans.modules.web.taglibed.model.TLDException;
import org.netbeans.modules.web.taglibed.model.TagLibraryInfoData;
import org.netbeans.modules.web.taglibed.view.TLDNode;
import org.netbeans.modules.web.taglibed.view.TaglibWizardIterator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.InputSource;

public final class TLDDataObject
extends XMLJ2eeDataObject
implements Cloneable {
    public static final String PROP_DOCBASE = "documentBase";
    public static final String PROP_APPNAME = "appName";
    ResourceBundle resbundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDDataObject == null ? (class$org$netbeans$modules$web$taglibed$TLDDataObject = TLDDataObject.class$("org.netbeans.modules.web.taglibed.TLDDataObject")) : class$org$netbeans$modules$web$taglibed$TLDDataObject));
    FileObject fileObject = null;
    TagLibraryInfoData taglib = null;
    String tldPath = null;
    TLDNode tldNode = null;
    private boolean updatingTreeFromDocument = false;
    private RegenTask generationTask = null;
    protected static final RequestProcessor RP = new RequestProcessor("TLD Parsing");
    private boolean userElectedNotToAutoSaveVersionUpdate = false;
    private Object lineUp = new Object();
    boolean ignoreChanges = false;
    private static final boolean debug = false;
    private static final boolean debugdetail = false;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$TLDDataObject;
    static /* synthetic */ Class class$org$openide$loaders$TemplateWizard$Iterator;

    public TLDDataObject() throws DataObjectExistsException, IOException {
        super(null, null);
    }

    public TLDDataObject(FileObject obj, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(obj, loader);
        this.fileObject = obj;
        if (!this.isValid(obj)) {
            MessageFormat msgFormat = new MessageFormat(this.resbundle.getString("TLDDataObject_FileDoesntExist"));
            Object[] arg0 = new Object[]{this.getPrimaryFile().getName()};
        }
        this.fileObject.addFileChangeListener(new FileChangeListener(){

            public void fileAttributeChanged(FileAttributeEvent fae) {
            }

            public void fileChanged(FileEvent fae) {
                boolean shouldRefreshNode;
                boolean isValid = TLDDataObject.this.isValid(TLDDataObject.this.fileObject);
                TagLibraryInfoData newTaglib = TLDDataObject.this.readTaglib();
                boolean newTaglibIsNull = newTaglib == null;
                boolean oldTaglibIsNull = TLDDataObject.this.taglib == null;
                boolean bl = shouldRefreshNode = newTaglibIsNull != oldTaglibIsNull;
                if (shouldRefreshNode) {
                    TLDDataObject.this.taglib = newTaglib;
                    TLDDataObject.this.addListenersToTaglib(TLDDataObject.this.taglib);
                    if (TLDDataObject.this.tldNode != null) {
                        TLDDataObject.this.tldNode.setTaglib(TLDDataObject.this.taglib);
                        TLDDataObject.this.tldNode.refreshChildren();
                        if (TLDDataObject.this.taglib != null) {
                            TLDDataObject.this.setNodeDirty(true);
                            TLDEditorSupport editorSupport = TLDDataObject.this.getEditorSupport();
                            if (editorSupport != null) {
                                editorSupport.reloadDoc();
                            }
                        }
                    }
                }
            }

            public void fileDataCreated(FileEvent fae) {
            }

            public void fileDeleted(FileEvent fae) {
            }

            public void fileFolderCreated(FileEvent fae) {
            }

            public void fileRenamed(FileRenameEvent fae) {
            }
        });
    }

    public Node.Cookie getCookie(Class c) {
        if (c.isAssignableFrom(class$org$openide$loaders$TemplateWizard$Iterator == null ? (class$org$openide$loaders$TemplateWizard$Iterator = TLDDataObject.class$("org.openide.loaders.TemplateWizard$Iterator")) : class$org$openide$loaders$TemplateWizard$Iterator)) {
            return TaglibWizardIterator.singleton();
        }
        return super.getCookie(c);
    }

    public TLDNode getTLDNode() {
        return this.tldNode;
    }

    public void setTLDNode(TLDNode value) {
        this.tldNode = value;
    }

    boolean isValid(FileObject obj) {
        File targetFile = FileUtil.toFile((FileObject)obj);
        return targetFile != null && targetFile.exists();
    }

    protected synchronized Node createNodeDelegate() {
        return new TLDNode(this);
    }

    void addListenersToTaglib(TagLibraryInfoData taglib) {
        if (taglib != null) {
            taglib.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (TLDDataObject.this.ignoreChanges) {
                        return;
                    }
                    if (evt.getPropertyName().equals("treeDirty")) {
                        TLDDataObject.this.setNodeDirty(true);
                    }
                }
            });
        }
    }

    protected TagLibraryInfoData readTaglib() {
        return this.createTaglibFromPath();
    }

    public synchronized void setNodeDirty(boolean treeDirty) {
        if (this.updatingTreeFromDocument) {
            return;
        }
        super.setNodeDirty(treeDirty);
        if (treeDirty) {
            this.restartGen();
        }
    }

    private void restartGen() {
        if (this.generationTask == null) {
            this.generationTask = new RegenTask();
            this.restartGen_impl();
        }
    }

    private void restartGen_impl() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (TLDDataObject.this.generationTask != null && !TLDDataObject.this.generationTask.hasStarted()) {
                    RegenTask runningTask = TLDDataObject.this.generationTask;
                    TLDDataObject.this.generationTask = null;
                    runningTask.run();
                }
            }
        });
    }

    protected String updateDocument() {
        if (this.taglib != null) {
            StringBuffer buf = new StringBuffer();
            this.taglib.writeExtendedTagLibraryDescriptor(buf);
            return buf.toString();
        }
        return " ";
    }

    public boolean prepareForSave() {
        boolean wasJSP1dot1 = this.taglib.isVersionUpdatePending();
        boolean goAhead = true;
        if (wasJSP1dot1 && (goAhead = this.show1dot1VersionUpdateDialog())) {
            this.taglib.setVersionUpdatePending(false);
        }
        return goAhead;
    }

    boolean show1dot1VersionUpdateDialog() {
        boolean shouldSave;
        String title = this.resbundle.getString("TLD_VersionUpdate.Title");
        MessageFormat msgF = new MessageFormat(this.resbundle.getString("TLD_VersionUpdate.Message"));
        Object[] args = new Object[]{this.getName()};
        String message = msgF.format(args);
        boolean modal = true;
        String saveOption = this.resbundle.getString("TLD_VersionUpdate.SaveNowOption");
        String saveLaterOption = this.resbundle.getString("TLD_VersionUpdate.SaveLaterOption");
        Object[] options = new Object[]{saveOption, saveLaterOption};
        String initialValue = saveOption;
        int optionsAlign = 0;
        HelpCtx helpCtx = null;
        ActionListener actionListener = null;
        DialogDescriptor dialog = new DialogDescriptor((Object)message, title, modal, options, (Object)initialValue, optionsAlign, helpCtx, actionListener);
        Dialog d = DialogDisplayer.getDefault().createDialog(dialog);
        d.show();
        if (dialog.getValue() == saveOption) {
            this.taglib.ensureVersionIsUpToDate();
            shouldSave = true;
        } else {
            shouldSave = false;
        }
        return shouldSave;
    }

    protected SAXParseError updateNode(InputSource is) throws IOException {
        this.updateTree(is);
        return null;
    }

    protected void updateTree(InputSource is) throws IOException {
        try {
            block8: {
                try {
                    TagLibraryInfoData newTagLib = this.createTaglibFromStream(is);
                    if (newTagLib == null) break block8;
                    if (this.taglib == null) {
                        this.taglib = newTagLib;
                        this.addListenersToTaglib(this.taglib);
                        break block8;
                    }
                    this.ignoreChanges = true;
                    this.taglib.mergeTaglib(newTagLib);
                    this.ignoreChanges = false;
                }
                catch (IOException e) {
                    Object var4_5 = null;
                    this.ignoreChanges = false;
                    if (this.tldNode != null) {
                        this.tldNode.refreshChildren();
                    }
                }
            }
            Object var4_4 = null;
            this.ignoreChanges = false;
            if (this.tldNode != null) {
                this.tldNode.refreshChildren();
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.ignoreChanges = false;
            if (this.tldNode != null) {
                this.tldNode.refreshChildren();
            }
            throw throwable;
        }
    }

    protected TagLibraryInfoData old_createTaglibFromStream(InputSource is) throws IOException {
        try {
            String url;
            FileObject fo = this.getPrimaryFile();
            String fileName = fo.getName() + ".tld";
            String path = url = fo.getURL().toString();
            String nbfs = "nbfs:/SystemFileSystem/";
            if (url.startsWith(nbfs)) {
                String nhome = System.getProperty("netbeans.home");
                File f = new File(nhome);
                String p = f.getAbsolutePath();
                path = p + File.separator + "system" + File.separator + url.substring(nbfs.length(), url.length());
            }
            return new TagLibraryInfoData(is, fileName, path);
        }
        catch (FileStateInvalidException fex) {
            throw new IOException(fex.getLocalizedMessage());
        }
        catch (TLDException ex) {
            throw new IOException(ex.getLocalizedMessage());
        }
    }

    protected TagLibraryInfoData createTaglibFromStream(InputSource is) throws IOException {
        try {
            FileObject fo = this.getPrimaryFile();
            File f = FileUtil.toFile((FileObject)fo);
            String path = f != null ? f.getAbsolutePath() : fo.getURL().toExternalForm();
            return new TagLibraryInfoData(is, fo.getNameExt(), path);
        }
        catch (TLDException ex) {
            throw new IOException(ex.getLocalizedMessage());
        }
    }

    protected TagLibraryInfoData createTaglibFromPath() {
        TagLibraryInfoData newTaglib = null;
        try {
            this.tldPath = this.getFilePath();
            if (this.tldPath == null) {
                FileObject fo = this.getPrimaryFile();
                File f = FileUtil.toFile((FileObject)fo);
                String path = f != null ? f.getAbsolutePath() : fo.getURL().toExternalForm();
                newTaglib = new TagLibraryInfoData(new InputSource(fo.getInputStream()), fo.getNameExt(), path);
            } else {
                newTaglib = new TagLibraryInfoData(this.tldPath);
            }
        }
        catch (FileStateInvalidException fex) {
        }
        catch (TLDException ex) {
        }
        catch (IOException ioex) {
            System.err.println(ioex.getLocalizedMessage());
        }
        return newTaglib;
    }

    protected TagLibraryInfoData old_createTaglibFromPath() {
        TagLibraryInfoData newTaglib = null;
        try {
            this.tldPath = this.getFilePath();
            if (this.tldPath == null) {
                String url;
                FileObject fo = this.getPrimaryFile();
                String fileName = fo.getName() + ".tld";
                String path = url = fo.getURL().toString();
                String nbfs = "nbfs:/SystemFileSystem/";
                if (url.startsWith(nbfs)) {
                    String nhome = System.getProperty("netbeans.home");
                    File f = new File(nhome);
                    String p = f.getAbsolutePath();
                    path = p + File.separator + "system" + File.separator + url.substring(nbfs.length(), url.length());
                }
                newTaglib = new TagLibraryInfoData(new InputSource(fo.getInputStream()), fileName, path);
            } else {
                newTaglib = new TagLibraryInfoData(this.tldPath);
            }
        }
        catch (FileStateInvalidException fex) {
        }
        catch (TLDException ex) {
        }
        catch (IOException ioex) {
            System.err.println(ioex.getLocalizedMessage());
        }
        return newTaglib;
    }

    public String getFilePath() throws FileStateInvalidException {
        FileObject fo = this.getPrimaryFile();
        FileSystem fs = fo.getFileSystem();
        if (fs instanceof LocalFileSystem) {
            File root = ((LocalFileSystem)fs).getRootDirectory();
            String ap = root.getAbsolutePath();
            if (!ap.endsWith(File.separator)) {
                ap = ap + File.separator;
            }
            String relPath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile").getResourceName(fo, File.separatorChar, true);
            return ap + relPath;
        }
        return null;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$web$taglibed$TLDDataObject == null ? (class$org$netbeans$modules$web$taglibed$TLDDataObject = TLDDataObject.class$("org.netbeans.modules.web.taglibed.TLDDataObject")) : class$org$netbeans$modules$web$taglibed$TLDDataObject);
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public TagLibraryInfoData getTaglib() {
        if (this.taglib == null) {
            this.taglib = this.readTaglib();
            if (this.taglib != null) {
                this.addListenersToTaglib(this.taglib);
            }
        }
        return this.taglib;
    }

    public void generateCode() {
        GenerateCodeAction.generateCode(this);
    }

    public void refreshForTesting() {
        TagLibraryInfoData newtaglib;
        this.taglib = newtaglib = this.createTaglibFromPath();
    }

    public void packageTaglibInJar() {
        PropertyView.getInstance().getSupport().packageTaglibInJar(this, this.taglib);
    }

    protected String getIconBaseForValidDocument() {
        return "org/netbeans/modules/web/taglibed/view/images/tags";
    }

    protected String getIconBaseForInvalidDocument() {
        return "org/netbeans/modules/web/taglibed/view/images/tags";
    }

    private void updateDocument(Document doc, String newDoc) throws BadLocationException {
        int origLen = doc.getLength();
        int newLen = newDoc.length();
        String origDoc = doc.getText(0, origLen);
        if (origDoc.equals(newDoc)) {
            return;
        }
        int granularity = 10;
        int prefix = -1;
        int postfix = -1;
        String toInsert = newDoc;
        if (origLen > 10 && newLen > 10) {
            int pos1;
            block14: {
                pos1 = 0;
                int len = Math.min(origLen, newLen);
                while (origDoc.regionMatches(pos1, newDoc, pos1, 10) && (pos1 += 10) + 10 < len) {
                }
                if (pos1 > 0) {
                    prefix = pos1;
                }
                pos1 = origLen - 10;
                int pos2 = newLen - 10;
                while (origDoc.regionMatches(pos1, newDoc, pos2, 10)) {
                    pos2 -= 10;
                    if ((pos1 -= 10) < 0) {
                        pos1 += 10;
                    } else {
                        if (pos2 >= 0) continue;
                        pos2 += 10;
                    }
                    break block14;
                }
                pos1 += 10;
                pos2 += 10;
            }
            if (pos1 < origLen - 10) {
                postfix = pos1;
            }
        }
        if (prefix != -1 && postfix != -1) {
            int delta;
            if (postfix < prefix) {
                postfix = prefix;
            }
            if ((delta = prefix + (origLen - postfix) - newLen) > 0) {
                postfix += delta;
            }
        }
        int removeBeginIndex = prefix == -1 ? 0 : prefix;
        int removeEndIndex = postfix == -1 ? origLen - 1 : postfix;
        doc.remove(removeBeginIndex, removeEndIndex - removeBeginIndex);
        if (toInsert.length() > 0) {
            int p1 = prefix == -1 ? 0 : prefix;
            int p2 = toInsert.length();
            if (postfix != -1) {
                p2 -= origLen - postfix;
            }
            if (p2 > p1) {
                toInsert = toInsert.substring(p1, p2);
                doc.insertString(removeBeginIndex, toInsert, null);
            }
        }
    }

    private String filterEndLines(String str) {
        char[] text = str.toCharArray();
        int pos = 0;
        int i = 0;
        while (i < text.length) {
            char c = text[i];
            if (c != '\r') {
                if (pos != i) {
                    text[pos] = c;
                }
                ++pos;
            }
            ++i;
        }
        return new String(text, 0, pos - 1);
    }

    public TLDDataObject getClone() throws CloneNotSupportedException {
        return (TLDDataObject)this.clone();
    }

    private String ego() {
        return "" + this.hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class WizardData {
        private FileSystem documentBase;
        private String documentBasePath;
        private String taglibName;
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.propertyChangeSupport.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.propertyChangeSupport.removePropertyChangeListener(l);
        }

        public FileSystem getDocumentBase() {
            return this.documentBase;
        }

        public void setDocumentBase(FileSystem documentBase) {
            FileSystem oldDocumentBase = this.documentBase;
            this.documentBase = documentBase;
            this.propertyChangeSupport.firePropertyChange(TLDDataObject.PROP_DOCBASE, oldDocumentBase, documentBase);
        }

        public String getDocumentBasePath() {
            return this.documentBasePath;
        }

        public void setDocumentBasePath(String path) {
            this.documentBasePath = path;
        }

        public String getTaglibName() {
            return this.taglibName;
        }

        public void setTaglibName(String value) {
            this.taglibName = value;
        }
    }

    class RegenTask
    implements Runnable {
        private boolean started = false;
        static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$TLDEditorSupport;
        static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

        RegenTask() {
        }

        public boolean hasStarted() {
            return this.started;
        }

        public void run() {
            Object object = TLDDataObject.this.lineUp;
            synchronized (object) {
                block19: {
                    this.started = true;
                    String newDoc = TLDDataObject.this.updateDocument();
                    TLDEditorSupport editor = (TLDEditorSupport)TLDDataObject.this.getCookie(class$org$netbeans$modules$web$taglibed$TLDEditorSupport == null ? (class$org$netbeans$modules$web$taglibed$TLDEditorSupport = RegenTask.class$("org.netbeans.modules.web.taglibed.TLDEditorSupport")) : class$org$netbeans$modules$web$taglibed$TLDEditorSupport);
                    if (editor != null) {
                        boolean saved = false;
                        try {
                            block18: {
                                try {
                                    editor.ignoreChanges = true;
                                    StyledDocument doc = editor.openDocument();
                                    TLDDataObject.this.updateDocument(doc, TLDDataObject.this.filterEndLines(newDoc));
                                    JEditorPane[] editors = editor.getOpenedPanes();
                                    if (editors != null && editors.length != 0) break block18;
                                    SaveCookie savec = (SaveCookie)TLDDataObject.this.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = RegenTask.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
                                    if (savec == null) {
                                        savec = editor.ensureSaveCookie();
                                    }
                                    if (savec == null) break block18;
                                    if (TLDDataObject.this.taglib.isVersionUpdatePending()) {
                                        if (!TLDDataObject.this.userElectedNotToAutoSaveVersionUpdate) {
                                            boolean saveQuestion = TLDDataObject.this.show1dot1VersionUpdateDialog();
                                            if (saveQuestion) {
                                                TLDDataObject.this.taglib.setVersionUpdatePending(false);
                                                savec.save();
                                            } else {
                                                TLDDataObject.this.userElectedNotToAutoSaveVersionUpdate = true;
                                            }
                                        }
                                        break block18;
                                    }
                                    savec.save();
                                    saved = true;
                                }
                                catch (BadLocationException e) {
                                    e.printStackTrace();
                                    Object var10_12 = null;
                                    editor.ignoreChanges = false;
                                    TLDDataObject.this.setNodeDirty(false);
                                    if (!saved) {
                                        TLDDataObject.this.setDocumentDirty(true);
                                    }
                                    break block19;
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                    Object var10_13 = null;
                                    editor.ignoreChanges = false;
                                    TLDDataObject.this.setNodeDirty(false);
                                    if (!saved) {
                                        TLDDataObject.this.setDocumentDirty(true);
                                    }
                                }
                            }
                            Object var10_11 = null;
                            editor.ignoreChanges = false;
                            TLDDataObject.this.setNodeDirty(false);
                            if (!saved) {
                                TLDDataObject.this.setDocumentDirty(true);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var10_14 = null;
                            editor.ignoreChanges = false;
                            TLDDataObject.this.setNodeDirty(false);
                            if (!saved) {
                                TLDDataObject.this.setDocumentDirty(true);
                            }
                            throw throwable;
                        }
                    }
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

