/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglibed;

import java.awt.Dialog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.web.taglibed.TLDDataObject;
import org.netbeans.modules.web.taglibed.XMLJ2eeDataObject;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.CloneableOpenSupport;

public class TLDEditorSupport
extends DataEditorSupport
implements EditorCookie.Observable,
OpenCookie,
LineCookie,
CloseCookie,
PrintCookie {
    private static final int AUTO_PARSING_DELAY = 2000;
    private DialogDescriptor dialog;
    private RequestProcessor.Task parsingDocumentTask;
    XMLJ2eeDataObject dataObject;
    public boolean ignoreChanges = false;
    private static RequestProcessor parsingTimerRP = null;
    boolean alreadySaving = false;
    private static final boolean debug = false;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

    public TLDEditorSupport(XMLJ2eeDataObject obj) {
        super((DataObject)obj, (CloneableEditorSupport.Env)new XmlEnv(obj));
        this.dataObject = obj;
        this.setMIMEType("text/xml");
    }

    protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
        EditorKit k = this.createEditorKit();
        OutputStreamWriter osw = new OutputStreamWriter(stream, "UTF8");
        BufferedWriter writer = new BufferedWriter(osw);
        k.write(writer, (Document)doc, 0, doc.getLength());
        ((Writer)writer).close();
    }

    protected void loadFromStreamToKit(StyledDocument doc, InputStream stream, EditorKit kit) throws IOException, BadLocationException {
        EditorKit k = this.createEditorKit();
        InputStreamReader isr = new InputStreamReader(stream, "UTF8");
        BufferedReader reader = new BufferedReader(isr);
        k.read(reader, (Document)doc, 0);
        ((Reader)reader).close();
    }

    public void restartTimer() {
        this.dataObject.setDocumentDirty(true);
        if (parsingTimerRP == null) {
            parsingTimerRP = new RequestProcessor("TLDEditorParsinTimer");
        }
        Runnable run = new Runnable(){

            public void run() {
                if (!TLDEditorSupport.this.ignoreChanges) {
                    TLDEditorSupport.this.dataObject.parsingDocument();
                }
            }
        };
        this.parsingDocumentTask = this.parsingDocumentTask == null || this.parsingDocumentTask.isFinished() || this.parsingDocumentTask.cancel() ? parsingTimerRP.post(run, 100) : parsingTimerRP.post(run, 2000);
    }

    protected boolean notifyModified() {
        boolean notif = super.notifyModified();
        if (!notif) {
            return false;
        }
        TLDDataObject obj = (TLDDataObject)this.getDataObject();
        this.ensureSaveCookie();
        if (!obj.isNodeDirty()) {
            this.restartTimer();
        }
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        TLDDataObject obj = (TLDDataObject)this.getDataObject();
        obj.removeSaveCookie();
    }

    public SaveCookie ensureSaveCookie() {
        TLDDataObject obj = (TLDDataObject)this.getDataObject();
        SaveCookie sc = (SaveCookie)obj.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = TLDEditorSupport.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
        if (sc == null) {
            sc = new Save();
            obj.addSaveCookie(sc);
        }
        return sc;
    }

    public UndoRedo.Manager getUndo() {
        return this.getUndoRedo();
    }

    public void reloadDoc() {
        this.reloadDocument();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class XmlEnv
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = -800036748848958489L;
        static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$TLDEditorSupport;

        public XmlEnv(XMLJ2eeDataObject obj) {
            super((DataObject)obj);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((TLDDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (TLDEditorSupport)this.getDataObject().getCookie(class$org$netbeans$modules$web$taglibed$TLDEditorSupport == null ? (class$org$netbeans$modules$web$taglibed$TLDEditorSupport = XmlEnv.class$("org.netbeans.modules.web.taglibed.TLDEditorSupport")) : class$org$netbeans$modules$web$taglibed$TLDEditorSupport);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class Save
    implements SaveCookie {
        static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$TLDEditorSupport;

        public void save() throws IOException {
            try {
                if (!TLDEditorSupport.this.alreadySaving) {
                    TLDEditorSupport.this.alreadySaving = true;
                    this.saveImpl();
                    TLDEditorSupport.this.alreadySaving = false;
                }
                Object var2_1 = null;
                TLDEditorSupport.this.alreadySaving = false;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                TLDEditorSupport.this.alreadySaving = false;
                throw throwable;
            }
        }

        public void saveImpl() throws IOException {
            TLDDataObject obj = (TLDDataObject)TLDEditorSupport.this.getDataObject();
            boolean goAheadSaveMyDay = obj.prepareForSave();
            if (!goAheadSaveMyDay) {
                return;
            }
            if (obj.isDocumentValid()) {
                obj.setSavingDocument(true);
                TLDEditorSupport.this.saveDocument();
            } else {
                obj.displayErrorMessage();
                StatusDisplayer.getDefault().setStatusText("");
                TLDEditorSupport.this.dialog = new DialogDescriptor((Object)NbBundle.getMessage((Class)(Save.class$org$netbeans$modules$web$taglibed$TLDEditorSupport == null ? (Save.class$org$netbeans$modules$web$taglibed$TLDEditorSupport = Save.class$("org.netbeans.modules.web.taglibed.TLDEditorSupport")) : Save.class$org$netbeans$modules$web$taglibed$TLDEditorSupport), (String)"MSG_invalidXmlWarning"), NbBundle.getMessage((Class)(Save.class$org$netbeans$modules$web$taglibed$TLDEditorSupport == null ? (Save.class$org$netbeans$modules$web$taglibed$TLDEditorSupport = Save.class$("org.netbeans.modules.web.taglibed.TLDEditorSupport")) : Save.class$org$netbeans$modules$web$taglibed$TLDEditorSupport), (String)"TTL_invalidXmlWarning"));
                Dialog d = DialogDisplayer.getDefault().createDialog(TLDEditorSupport.this.dialog);
                d.show();
                if (TLDEditorSupport.this.dialog.getValue() == NotifyDescriptor.OK_OPTION) {
                    obj.setSavingDocument(true);
                    TLDEditorSupport.this.saveDocument();
                } else {
                    RequestProcessor.getDefault().post(new Runnable(this){
                        private final /* synthetic */ Save this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            StatusDisplayer.getDefault().setStatusText("");
                        }
                    }, 100);
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

