/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglibed.codegen;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.netbeans.modules.web.taglibed.codegen.TagGenerator;
import org.netbeans.modules.web.taglibed.model.TagAttributeInfoData;
import org.netbeans.modules.web.taglibed.model.TagInfoData;
import org.netbeans.modules.web.taglibed.model.TagLibraryInfoData;
import org.netbeans.modules.web.taglibed.model.TagVariableInfoData;
import org.openide.filesystems.FileObject;
import org.openide.src.ClassElement;
import org.openide.src.DefaultElementPrinter;
import org.openide.src.ElementPrinter;
import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.MethodElement;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;

public class TEIGenerator {
    TagInfoData tag;
    TagLibraryInfoData taglib;
    FileObject teiFo;
    FileObject taglibFolder;
    SourceElement teiSource;
    ClassElement teiClass;
    Vector userMethods;
    Vector tagInterfaceMethods;
    Vector propertyMethods;
    Vector propertyFields;
    Vector otherImports;
    int indent = 0;
    String indentString = "    ";
    Hashtable uniqueValues;

    public TEIGenerator() {
    }

    public TEIGenerator(TagInfoData tag, TagLibraryInfoData taglib, FileObject teiFo, FileObject taglibFolder) {
        this.tag = tag;
        this.taglib = taglib;
        this.teiFo = teiFo;
        this.taglibFolder = taglibFolder;
    }

    public TagInfoData getTag() {
        return this.tag;
    }

    public void setTag(TagInfoData tag) {
        this.tag = tag;
    }

    public TagLibraryInfoData getTaglib() {
        return this.taglib;
    }

    public void setTaglib(TagLibraryInfoData taglib) {
        this.taglib = taglib;
    }

    public FileObject getTeiFo() {
        return this.teiFo;
    }

    public void setTeiFo(FileObject value) {
        this.teiFo = value;
    }

    public FileObject getTaglibFolder() {
        return this.taglibFolder;
    }

    public void setTaglibFolder(FileObject value) {
        this.taglibFolder = value;
    }

    public SourceElement getSource() {
        return this.teiSource;
    }

    public void setSource(SourceElement value) {
        this.teiSource = value;
    }

    public void writeSourceElement(SourceElement elt, String fileName) {
        try {
            FileOutputStream out = new FileOutputStream(fileName);
            PrintWriter writer = new PrintWriter(out);
            DefaultElementPrinter eprinter = new DefaultElementPrinter(writer);
            elt.print((ElementPrinter)eprinter);
            out.flush();
            writer.close();
        }
        catch (Exception ex) {
            System.out.println("TEIGenerator::writeSourceElement caught exception: " + ex);
            ex.printStackTrace();
        }
    }

    public void generateTEISource(TagInfoData tag, SourceElement elt) throws SourceException {
        this.indent = 0;
        this.userMethods = new Vector();
        this.tagInterfaceMethods = new Vector();
        this.propertyMethods = new Vector();
        this.propertyFields = new Vector();
        this.otherImports = new Vector();
        this.uniqueValues = new Hashtable();
        this.setTag(tag);
        this.setSource(elt);
        this.ensureGenerateImports(this.teiSource, tag);
        this.teiClass = this.ensureGenerateClass(this.teiSource, tag);
        this.ensureGenerateTEIInterfaceMethods(this.teiClass, tag);
    }

    public ClassElement ensureGenerateClass(SourceElement teiSource, TagInfoData tag) throws SourceException {
        String teiClassName;
        String pkgName = tag.getPackageName();
        String fullName = teiClassName = tag.ensureTeiClassName();
        if (pkgName != null && !pkgName.equals("")) {
            fullName = pkgName + "." + teiClassName;
        }
        Identifier className = Identifier.create((String)fullName, (String)teiClassName);
        this.teiClass = teiSource.getClass(className);
        if (this.teiClass == null) {
            this.teiClass = new ClassElement();
            this.teiClass.setName(className);
            teiSource.addClass(this.teiClass);
        }
        this.setClassInheritance(this.teiClass, tag);
        return this.teiClass;
    }

    public void setClassInheritance(ClassElement teiClass, TagInfoData tag) throws SourceException {
        Identifier newSuperClass = Identifier.create((String)"TagExtraInfo");
        Identifier currentSuperClass = teiClass.getSuperclass();
        if (currentSuperClass == null || !currentSuperClass.equals((Object)newSuperClass)) {
            teiClass.setSuperclass(newSuperClass);
        }
    }

    public void ensureGenerateTEIInterfaceMethods(ClassElement declaringClass, TagInfoData tag) throws SourceException {
        this.ensureGenerateGetVariableInfoMethod(declaringClass, tag);
        this.ensureGenerateIsValidMethod(declaringClass, tag);
    }

    public MethodElement ensureGenerateGetVariableInfoMethod(ClassElement declaringClass, TagInfoData tag) throws SourceException {
        StringBuffer methodBody = new StringBuffer(512);
        ++this.indent;
        this.indentPrintln(methodBody, "");
        this.indentPrintln(methodBody, "Vector vars = new Vector();");
        Vector varNames = this.generateScriptingVariablesDeclarationCode(declaringClass, methodBody, tag);
        this.indentPrintln(methodBody, "//");
        this.indentPrintln(methodBody, "// Now assemble the variables into the array");
        this.indentPrintln(methodBody, "//");
        this.indentPrintln(methodBody, "VariableInfo varInfoArray[] = new VariableInfo[vars.size()];");
        this.indentPrintln(methodBody, "int i=0;");
        this.indentPrintln(methodBody, "for (Enumeration en = vars.elements(); en.hasMoreElements(); ) {");
        ++this.indent;
        this.indentPrintln(methodBody, "varInfoArray[i] = (VariableInfo)en.nextElement();");
        this.indentPrintln(methodBody, "i++;");
        --this.indent;
        this.indentPrintln(methodBody, "};");
        this.indentPrintln(methodBody, "return varInfoArray;");
        --this.indent;
        StringBuffer javadocBuf = new StringBuffer(512);
        this.println(javadocBuf, " ");
        this.println(javadocBuf, "This method is called by the JSP engine to set up");
        this.println(javadocBuf, "the scripting variables for this tag.");
        this.println(javadocBuf, "This method is automatically generated. Do not modify this method.");
        this.println(javadocBuf, "Instead, modify the methods that this method calls.");
        this.println(javadocBuf, " ");
        Type[] argumentTypes = new Type[1];
        String[] argumentNames = new String[1];
        argumentTypes[0] = TagGenerator.getTypeFromString("TagData", "javax.servlet.jsp.tagext.TagData");
        argumentNames[0] = "data";
        MethodElement gvi = TagGenerator.generateMethod(declaringClass, Identifier.create((String)"getVariableInfo"), TagGenerator.getTypeFromString("VariableInfo[]", "javax.servlet.jsp.tagext.VariableInfo[]"), argumentTypes, argumentNames, true, methodBody.toString(), false, javadocBuf.toString());
        return gvi;
    }

    public MethodElement ensureGenerateIsValidMethod(ClassElement declaringClass, TagInfoData tag) throws SourceException {
        StringBuffer methodBody = new StringBuffer(512);
        ++this.indent;
        this.indentPrintln(methodBody, "");
        this.indentPrintln(methodBody, "return true;");
        --this.indent;
        StringBuffer javadocBuf = new StringBuffer(512);
        this.println(javadocBuf, " ");
        this.println(javadocBuf, "This method is called by the JSP engine to verify");
        this.println(javadocBuf, "that the attributes are valid. ");
        this.println(javadocBuf, "Modify this method to write code to accomplish this verification.");
        this.println(javadocBuf, " ");
        Type[] argumentTypes = new Type[1];
        String[] argumentNames = new String[1];
        argumentTypes[0] = TagGenerator.getTypeFromString("TagData", "javax.servlet.jsp.tagext.TagData");
        argumentNames[0] = "data";
        MethodElement iv = TagGenerator.generateMethod(declaringClass, Identifier.create((String)"isValid"), Type.BOOLEAN, argumentTypes, argumentNames, true, methodBody.toString(), false, javadocBuf.toString());
        return iv;
    }

    public Vector generateScriptingVariablesDeclarationCode(ClassElement declaringClass, StringBuffer methodBody, TagInfoData tag) throws SourceException {
        Vector tagVars = tag.getVariablesVector();
        Vector<String> varNames = new Vector<String>();
        Enumeration en = tagVars.elements();
        while (en.hasMoreElements()) {
            TagVariableInfoData tagVar = (TagVariableInfoData)en.nextElement();
            int nameType = tagVar.getNameType();
            if (nameType != 2) continue;
            String varInfoName = nameType == 1 ? tagVar.getNameAttribute() + "_attrVar" : tagVar.getName() + "_Var";
            String varName = this.generateScriptingVariableValueDeclarationCode(declaringClass, methodBody, tagVar, varInfoName);
            varNames.addElement(varName);
        }
        return varNames;
    }

    public String generateScriptingVariableValueDeclarationCode(ClassElement declaringClass, StringBuffer buf, TagVariableInfoData tagVar, String varInfoName) throws SourceException {
        this.indentPrintln(buf, "");
        if (tagVar.getNameType() == 0) {
            this.indentPrintln(buf, "//");
            this.indentPrintln(buf, "// Declare a fixed-name scripting variable");
            this.indentPrintln(buf, "//");
            this.indentPrintln(buf, "VariableInfo " + varInfoName + " = ");
            this.indentPrintln(buf, "    new VariableInfo(\"" + tagVar.getName() + "\",");
            this.indentPrintln(buf, "                     \"" + tagVar.getType() + "\",");
            this.indentPrintln(buf, "                     " + tagVar.getDeclare() + ",");
            this.indentPrintln(buf, "                     VariableInfo." + TagVariableInfoData.scopeString(tagVar.getScope()) + ");");
            this.indentPrintln(buf, "vars.addElement(" + varInfoName + ");");
        } else if (tagVar.getNameType() == 1) {
            this.indentPrintln(buf, "//");
            this.indentPrintln(buf, "// Declare a scripting variable whose name derives from an attribute value");
            this.indentPrintln(buf, "//");
            String attName = tagVar.getNameAttribute();
            String attVar = this.uniqueValue(attName + "_Value");
            TagAttributeInfoData tagAtt = this.tag.getAttributeByName(attName);
            boolean attributeIsRequired = false;
            if (tagAtt != null && tagAtt.isRequired()) {
                attributeIsRequired = true;
            }
            this.indentPrintln(buf, "String " + attVar + " = data.getAttributeString(\"" + attName + "\");");
            this.indentPrintln(buf, "if (" + attVar + " == null) {");
            ++this.indent;
            if (attributeIsRequired) {
                this.indentPrintln(buf, "// The attribute " + attName + " is required, so if it isn't present,");
                this.indentPrintln(buf, "// we throw an error.");
                this.indentPrintln(buf, "throw new Error(\"TagLibrary inconsistency: attribute (" + attName + ") not found\");");
            } else {
                this.indentPrintln(buf, "// The attribute " + attName + " is not required, so we can ignore its absence,");
                this.indentPrintln(buf, "// and refrain from generating its variable.");
            }
            --this.indent;
            this.indentPrintln(buf, "} else {");
            ++this.indent;
            this.indentPrintln(buf, "VariableInfo " + varInfoName + " = ");
            this.indentPrintln(buf, "    new VariableInfo(" + attVar + ",");
            this.indentPrintln(buf, "                     \"" + tagVar.getType() + "\",");
            this.indentPrintln(buf, "                     " + tagVar.getDeclare() + ",");
            this.indentPrintln(buf, "                     VariableInfo." + TagVariableInfoData.scopeString(tagVar.getScope()) + ");");
            this.indentPrintln(buf, "vars.addElement(" + varInfoName + ");");
            --this.indent;
            this.indentPrintln(buf, "}");
        } else if (tagVar.getNameType() == 2) {
            this.indentPrintln(buf, "");
            this.indentPrintln(buf, "//");
            this.indentPrintln(buf, "// Declare a scripting variable whose name is determined by some other means");
            this.indentPrintln(buf, "//");
            this.indentPrintln(buf, "VariableInfo " + varInfoName + " = ");
            String otherVarCreationMethod = "createOtherVariable_" + varInfoName;
            this.indentPrintln(buf, "    " + otherVarCreationMethod + "(data);");
            this.generateOtherVarCreationMethod(declaringClass, tagVar.getName(), varInfoName, tagVar, otherVarCreationMethod);
            this.indentPrintln(buf, "if (" + varInfoName + " != null) {");
            ++this.indent;
            this.indentPrintln(buf, "vars.addElement(" + varInfoName + ");");
            ++this.indent;
            this.indentPrintln(buf, "}");
        }
        return varInfoName;
    }

    public MethodElement generateOtherVarCreationMethod(ClassElement declaringClass, String varName, String varInfoName, TagVariableInfoData tagVar, String otherVarCreationMethod) throws SourceException {
        StringBuffer methodBody = new StringBuffer(1024);
        StringBuffer javadocBuf = new StringBuffer(512);
        this.indentPrintln(methodBody, "");
        this.indentPrintln(methodBody, "//");
        this.indentPrintln(methodBody, "// TODO: fill in this method to declare the scripting variable " + varName);
        this.indentPrintln(methodBody, "//        You need to create a name for your variable.");
        this.indentPrintln(methodBody, "//        The name should match the name you set for it ");
        this.indentPrintln(methodBody, "//        in the tag handler method setNameOfVariable_" + varName + "().");
        this.indentPrintln(methodBody, "//         For example:");
        this.indentPrintln(methodBody, "//           String variableName = yourCalculation(data.getAttribute(\"id\"));");
        this.indentPrintln(methodBody, "//");
        this.indentPrintln(methodBody, "String variableName = \"" + varName + "\";");
        this.indentPrintln(methodBody, "VariableInfo " + varInfoName + " = ");
        this.indentPrintln(methodBody, "    new VariableInfo(variableName,");
        this.indentPrintln(methodBody, "                     \"" + tagVar.getType() + "\",");
        this.indentPrintln(methodBody, "                     " + tagVar.getDeclare() + ",");
        this.indentPrintln(methodBody, "                     VariableInfo." + TagVariableInfoData.scopeString(tagVar.getScope()) + ");");
        this.indentPrintln(methodBody, "");
        this.indentPrintln(methodBody, "return " + varInfoName + ";");
        Type[] argumentTypes = new Type[1];
        String[] argumentNames = new String[1];
        argumentTypes[0] = TagGenerator.getTypeFromString("TagData", "javax.servlet.jsp.tagext.TagData");
        argumentNames[0] = "data";
        MethodElement ovcm = TagGenerator.generateMethod(declaringClass, Identifier.create((String)otherVarCreationMethod), TagGenerator.getTypeFromString("VariableInfo", "javax.servlet.jsp.tagext.VariableInfo"), argumentTypes, argumentNames, false, methodBody.toString(), false, javadocBuf.toString());
        return ovcm;
    }

    public void ensureGenerateImports(SourceElement elt, TagInfoData tag) throws SourceException {
        Import[] allImports = elt.getImports();
        TagGenerator.addImport(elt, "javax.servlet.jsp.tagext.TagData", false, allImports);
        TagGenerator.addImport(elt, "javax.servlet.jsp.tagext.TagExtraInfo", false, allImports);
        TagGenerator.addImport(elt, "javax.servlet.jsp.tagext.VariableInfo", false, allImports);
        TagGenerator.addImport(elt, "java.util.Enumeration", false, allImports);
        TagGenerator.addImport(elt, "java.util.Vector", false, allImports);
    }

    static String capitalizeFirstLetter(String str) {
        if (str == null || str.length() <= 0) {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String capitalize(String str) {
        if (str == null || str.length() < 1) {
            return str;
        }
        int len = str.length();
        char[] chars = new char[len];
        str.getChars(0, len, chars, 0);
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String decapitalize(String str) {
        if (str == null || str.length() < 1) {
            return str;
        }
        int len = str.length();
        char[] chars = new char[len];
        str.getChars(0, len, chars, 0);
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public void indentPrint(StringBuffer buf, String thing) {
        int i = 0;
        while (i < this.indent) {
            buf.append(this.indentString);
            ++i;
        }
        buf.append(thing);
    }

    public void indentPrintln(StringBuffer buf, String thing) {
        this.indentPrint(buf, thing);
        buf.append('\n');
    }

    public void print(StringBuffer buf, String thing) {
        buf.append(thing);
    }

    public void println(StringBuffer buf, String thing) {
        this.print(buf, thing);
        buf.append('\n');
    }

    public String uniqueValue(String seed) {
        String result = seed;
        Integer nextSuffix = (Integer)this.uniqueValues.get(seed);
        if (nextSuffix == null) {
            nextSuffix = new Integer(1);
        } else {
            result = result + nextSuffix;
            nextSuffix = new Integer(nextSuffix + 1);
        }
        this.uniqueValues.put(seed, nextSuffix);
        return result;
    }
}

