/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglibed.codegen;

import java.beans.Introspector;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.netbeans.modules.web.taglibed.TLDDataObject;
import org.netbeans.modules.web.taglibed.control.IDEHelper;
import org.netbeans.modules.web.taglibed.model.TagAttributeInfoData;
import org.netbeans.modules.web.taglibed.model.TagInfoData;
import org.netbeans.modules.web.taglibed.model.TagLibraryInfoData;
import org.netbeans.modules.web.taglibed.model.TagVariableInfoData;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.src.ClassElement;
import org.openide.src.DefaultElementPrinter;
import org.openide.src.Element;
import org.openide.src.ElementPrinter;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.JavaDoc;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.text.IndentEngine;
import org.openide.util.NbBundle;

public class TagGenerator {
    TagInfoData tag;
    TagLibraryInfoData taglib;
    FileObject tagHandlerFo;
    FileObject taglibFolder;
    SourceElement tagSource;
    ClassElement tagHandlerClass;
    Vector userMethods;
    Vector tagInterfaceMethods;
    static Vector propertyMethods;
    static Vector propertyFields;
    ResourceBundle resBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDDataObject == null ? (class$org$netbeans$modules$web$taglibed$TLDDataObject = TagGenerator.class$("org.netbeans.modules.web.taglibed.TLDDataObject")) : class$org$netbeans$modules$web$taglibed$TLDDataObject));
    Vector otherImports;
    static Identifier tagInterfaceIdentifier;
    static Identifier iterationTagInterfaceIdentifier;
    static Identifier bodyTagInterfaceIdentifier;
    static Identifier tagSupportIdentifier;
    static Identifier bodyTagSupportIdentifier;
    static Identifier tryCatchFinallyIdentifier;
    private Element latestUserMethod = null;
    private Element latestAttributeProperty = null;
    static int indent;
    static String indentString;
    private static final boolean debug = false;
    private static final boolean debugdetail = false;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$TLDDataObject;
    static /* synthetic */ Class class$org$openide$src$Element;

    public TagGenerator() {
    }

    public TagGenerator(TagInfoData tag) {
        this.tag = tag;
    }

    public TagGenerator(TagInfoData tag, TagLibraryInfoData taglib, FileObject tagHandlerFo, FileObject taglibFolder) {
        this.tag = tag;
        this.taglib = taglib;
        this.tagHandlerFo = tagHandlerFo;
        this.taglibFolder = taglibFolder;
    }

    public void setup(TagInfoData tag, TagLibraryInfoData taglib, FileObject tagHandlerFo, FileObject taglibFolder) {
        this.tag = tag;
        this.taglib = taglib;
        this.tagHandlerFo = tagHandlerFo;
        this.taglibFolder = taglibFolder;
    }

    public void reset() {
        this.tag = null;
        this.taglib = null;
        this.tagHandlerFo = null;
        this.taglibFolder = null;
    }

    public TagInfoData getTag() {
        return this.tag;
    }

    public void setTag(TagInfoData tag) {
        this.tag = tag;
    }

    public TagLibraryInfoData getTaglib() {
        return this.taglib;
    }

    public void setTaglib(TagLibraryInfoData taglib) {
        this.taglib = taglib;
    }

    public FileObject getTagHandlerFo() {
        return this.tagHandlerFo;
    }

    public void setTagHandlerFo(FileObject value) {
        this.tagHandlerFo = value;
    }

    public FileObject getTaglibFolder() {
        return this.taglibFolder;
    }

    public void setTaglibFolder(FileObject value) {
        this.taglibFolder = value;
    }

    public SourceElement getSource() {
        return this.tagSource;
    }

    public void setSource(SourceElement value) {
        this.tagSource = value;
    }

    public void writeSourceElement(SourceElement elt, String fileName) {
        try {
            FileOutputStream out = new FileOutputStream(fileName);
            PrintWriter writer = new PrintWriter(out);
            StringWriter sw = new StringWriter();
        }
        catch (Exception ex) {
            System.out.println("TagGenerator::writeSourceElement caught exception: " + ex);
            ex.printStackTrace();
        }
    }

    public void old_writeSourceElement(SourceElement elt, String fileName) {
        try {
            FileOutputStream out = new FileOutputStream(fileName);
            PrintWriter writer = new PrintWriter(out);
            Writer beautyWrFile = null;
            beautyWrFile = IndentEngine.find((String)"text/x-java").createWriter((Document)new PlainDocument(), 0, (Writer)writer);
            PrintWriter pw = new PrintWriter(beautyWrFile);
            DefaultElementPrinter eprinter = new DefaultElementPrinter(pw);
            elt.print((ElementPrinter)eprinter);
            out.flush();
            pw.close();
        }
        catch (Exception ex) {
            System.out.println("TagGenerator::writeSourceElement caught exception: " + ex);
            ex.printStackTrace();
        }
    }

    public void generateTagHandlerSource(TLDDataObject tldDo, TagInfoData tag, SourceElement elt, DataObject jdo) throws SourceException {
        indent = 0;
        this.userMethods = new Vector();
        this.tagInterfaceMethods = new Vector();
        propertyMethods = new Vector();
        propertyFields = new Vector();
        this.otherImports = new Vector();
        this.setTag(tag);
        this.setSource(elt);
        this.ensureGenerateImports(this.tagSource, tag);
        this.tagHandlerClass = this.ensureGenerateClass(this.tagSource, tag);
        this.ensureGenerateAttributes(this.tagHandlerClass, tag);
        this.ensureGenerateTagInterfaceMethods(tldDo, this.tagHandlerClass, tag, jdo);
        this.ensureGenerateUserMethods(this.tagHandlerClass, tag);
        this.addOtherImports(elt);
    }

    public ClassElement ensureGenerateClass(SourceElement tagSource, TagInfoData tag) throws SourceException {
        String tagClassName;
        String pkgName = tag.getPackageName();
        String fullName = tagClassName = tag.ensureTagClassName();
        if (pkgName != null && !pkgName.equals("")) {
            fullName = pkgName + "." + tagClassName;
        }
        Identifier className = Identifier.create((String)fullName, (String)tagClassName);
        this.tagHandlerClass = tagSource.getClass(className);
        if (this.tagHandlerClass == null) {
            this.tagHandlerClass = new ClassElement();
            this.tagHandlerClass.setName(className);
            tagSource.addClass(this.tagHandlerClass);
        }
        this.setClassInheritance(this.tagHandlerClass, tag);
        return this.tagHandlerClass;
    }

    public void setClassInheritance(ClassElement tagHandlerClass, TagInfoData tag) throws SourceException {
        boolean extendsSupportClass = tag.getExtendsSupportClass();
        if (extendsSupportClass) {
            Identifier currentSuperClass = tagHandlerClass.getSuperclass();
            String superClassName = this.findSuperClass(tag);
            boolean otherSupportClass = !superClassName.equals("TagSupport") && !superClassName.equals("BodyTagSupport");
            Identifier newSuperClass = Identifier.create((String)superClassName);
            if (currentSuperClass == null || !currentSuperClass.equals((Object)newSuperClass)) {
                tagHandlerClass.setSuperclass(newSuperClass);
            }
        } else {
            String interfaceName = this.findInterface(tag);
            if (interfaceName == null) {
                System.err.println("TagGen:findInterface returned null. Prepare to get whomped by mr. NPE.");
                System.err.println("      tag.implementsInterface=[" + tag.getImplementsInterface() + "]");
            }
            Identifier newInterface = Identifier.create((String)interfaceName);
            Identifier[] currentInterfaces = tagHandlerClass.getInterfaces();
            boolean alreadyImplemented = false;
            int i = 0;
            while (i < currentInterfaces.length) {
                Identifier ci = currentInterfaces[i];
                if (ci.equals((Object)newInterface)) {
                    alreadyImplemented = true;
                    break;
                }
                ++i;
            }
            if (!alreadyImplemented) {
                tagHandlerClass.addInterface(newInterface);
            }
        }
    }

    public void ensureInterfaceMethodsArePresent(ClassElement tagHandlerClass, TagInfoData tag) throws SourceException {
    }

    public void ensureGenerateAttributes(ClassElement tagHandlerClass, TagInfoData tag) throws SourceException {
        Vector attributes = tag.getAttributesVector();
        Enumeration en = attributes.elements();
        while (en.hasMoreElements()) {
            TagAttributeInfoData tagatt = (TagAttributeInfoData)en.nextElement();
            this.ensureGenerateAttribute(tagHandlerClass, tagatt, tag);
        }
    }

    public void ensureGenerateAttribute(ClassElement tagHandlerClass, TagAttributeInfoData tagatt, TagInfoData tag) throws SourceException {
        String def;
        String attType = tagatt.getTypeName();
        String fullAttType = attType.equals("String") ? "java.lang.String" : attType;
        String initValue = null;
        if (!tagatt.isRequired() && (def = tagatt.getDefaultValue()) != null && !def.equals("")) {
            initValue = def;
        }
        this.generateAttributeProperty(tagHandlerClass, tagatt, attType, fullAttType, initValue);
    }

    public void ensureGenerateTagInterfaceMethods(TLDDataObject tldDo, ClassElement declaringClass, TagInfoData tag, DataObject jdo) throws SourceException {
        MethodElement doStartTagMethodElement = this.ensureGenerateDoStartTagMethod(declaringClass, tag);
        MethodElement doAfterBodyMethodElement = null;
        if (this.isBodyTag(declaringClass)) {
            doAfterBodyMethodElement = this.ensureGenerateDoAfterBodyMethod_BodyTag(declaringClass, tag);
        } else if (this.isIterationTag(declaringClass)) {
            doAfterBodyMethodElement = this.ensureGenerateDoAfterBodyMethod_IterationTag(declaringClass, tag);
        }
        MethodElement doEndTagMethodElement = this.ensureGenerateDoEndTagMethod(declaringClass, tag);
        Identifier[] ints = declaringClass.getInterfaces();
        int i = 0;
        while (i < ints.length) {
            this.ensureGenerateDeclaredInterfaceMethods(declaringClass, ints[i], tag);
            ++i;
        }
        if (tag.getImplementsTryCatchFinally()) {
            boolean notyet = true;
            int i2 = 0;
            while (i2 < ints.length) {
                if (this.equalsOrInheritsFrom(ints[i2], tryCatchFinallyIdentifier)) {
                    notyet = false;
                    break;
                }
                ++i2;
            }
            if (notyet) {
                declaringClass.addInterface(tryCatchFinallyIdentifier);
            }
            this.ensureGenerateTryCatchFinallyMethods(declaringClass, tag);
        }
    }

    boolean isBodyTag(ClassElement declaringClass) {
        Identifier currentSuperClass = declaringClass.getSuperclass();
        if (currentSuperClass != null && this.equalsOrInheritsFrom(currentSuperClass, bodyTagSupportIdentifier)) {
            return true;
        }
        Identifier[] currentInterfaces = declaringClass.getInterfaces();
        boolean alreadyImplemented = false;
        int i = 0;
        while (i < currentInterfaces.length) {
            Identifier ci = currentInterfaces[i];
            if (this.equalsOrInheritsFrom(ci, bodyTagInterfaceIdentifier)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean isIterationTag(ClassElement declaringClass) {
        Identifier[] currentInterfaces = declaringClass.getInterfaces();
        boolean alreadyImplemented = false;
        int i = 0;
        while (i < currentInterfaces.length) {
            Identifier ci = currentInterfaces[i];
            if (this.equalsOrInheritsFrom(ci, iterationTagInterfaceIdentifier)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void ensureGenerateDeclaredInterfaceMethods(ClassElement declaringClass, Identifier interfaceDecl, TagInfoData tag) throws SourceException {
        if (this.equalsOrInheritsFrom(interfaceDecl, tagInterfaceIdentifier)) {
            this.ensureGenerateDeclaredInterfaceMethods_Tag(declaringClass, interfaceDecl, tag);
        } else if (this.equalsOrInheritsFrom(interfaceDecl, iterationTagInterfaceIdentifier)) {
            this.ensureGenerateDeclaredInterfaceMethods_IterationTag(declaringClass, interfaceDecl, tag);
        } else if (this.equalsOrInheritsFrom(interfaceDecl, bodyTagInterfaceIdentifier)) {
            this.ensureGenerateDeclaredInterfaceMethods_BodyTag(declaringClass, interfaceDecl, tag);
        }
    }

    public void ensureGenerateDeclaredInterfaceMethods_Tag(ClassElement declaringClass, Identifier interfaceDecl, TagInfoData tag) throws SourceException {
        this.ensureGenerateParentMethods(declaringClass, tag);
        this.ensureGenerateReleaseMethod(declaringClass, tag);
        this.ensureGeneratePageContextMethods(declaringClass, tag);
    }

    public void ensureGenerateDeclaredInterfaceMethods_IterationTag(ClassElement declaringClass, Identifier interfaceDecl, TagInfoData tag) throws SourceException {
        this.ensureGenerateDeclaredInterfaceMethods_Tag(declaringClass, interfaceDecl, tag);
    }

    public void ensureGenerateDeclaredInterfaceMethods_BodyTag(ClassElement declaringClass, Identifier interfaceDecl, TagInfoData tag) throws SourceException {
        this.ensureGenerateDeclaredInterfaceMethods_IterationTag(declaringClass, interfaceDecl, tag);
        this.ensureGenerateDoInitBodyMethod(declaringClass, tag);
        this.ensureGenerateBodyContentMethods(declaringClass, tag);
    }

    public void ensureGenerateDoInitBodyMethod(ClassElement declaringClass, TagInfoData tag) throws SourceException {
        Type[] argumentTypes = new Type[]{};
        Identifier methodName = Identifier.create((String)"doInitBody");
        StringBuffer methodBody = new StringBuffer();
        methodBody.append("    // TODO: Write code to perform actions needed upon initialization of the tag body");
        StringBuffer javadocBuf = new StringBuffer();
        javadocBuf.append("Prepare for evaluation of the tag body.");
        Type returnType = Type.VOID;
        MethodElement dib = TagGenerator.generateMethod(declaringClass, methodName, returnType, null, null, false, methodBody.toString(), false, javadocBuf.toString());
    }

    public void ensureGenerateBodyContentMethods(ClassElement declaringClass, TagInfoData tag) throws SourceException {
        Type bodyContentType = TagGenerator.getTypeFromString("BodyContent", "javax.servlet.jsp.tagext.BodyContent");
        Type[] argumentTypes = new Type[]{bodyContentType};
        Identifier methodName = Identifier.create((String)"setBodyContent");
        MethodElement sbc = declaringClass.getMethod(methodName, argumentTypes);
        StringBuffer methodBody = new StringBuffer();
        methodBody.append("    bodyContent = value;");
        StringBuffer javadocBuf = new StringBuffer();
        javadocBuf.append("Set the body content object for this tag.");
        String[] argumentNames = new String[]{"value"};
        Type returnType = Type.VOID;
        sbc = TagGenerator.generateMethod(declaringClass, methodName, returnType, argumentTypes, argumentNames, false, methodBody.toString(), false, javadocBuf.toString());
        FieldElement bcVar = TagGenerator.ensureGenerateField(declaringClass, Identifier.create((String)"bodyContent"), bodyContentType, false, "This variable contains the body content object.");
        bcVar.setModifiers(4);
        methodName = Identifier.create((String)"getBodyContent");
        methodBody = new StringBuffer();
        methodBody.append("    return bodyContent;");
        javadocBuf = new StringBuffer();
        javadocBuf.append("Get the body content object for this tag.");
        returnType = bodyContentType;
        MethodElement gbc = TagGenerator.generateMethod(declaringClass, methodName, returnType, null, null, true, methodBody.toString(), false, javadocBuf.toString());
    }

    public void ensureGenerateParentMethods(ClassElement declaringClass, TagInfoData tag) throws SourceException {
        Type[] argumentTypes = new Type[]{};
        Identifier methodName = Identifier.create((String)"getParent");
        MethodElement gp = declaringClass.getMethod(methodName, argumentTypes);
        Type tagType = TagGenerator.getTypeFromString("Tag", "javax.servlet.jsp.tagext.Tag");
        if (gp == null) {
            StringBuffer methodBody = new StringBuffer();
            methodBody.append("    return parent;");
            StringBuffer javadocBuf = new StringBuffer();
            javadocBuf.append("@return the parent of this tag.");
            Type returnType = tagType;
            gp = TagGenerator.generateMethod(declaringClass, methodName, returnType, null, null, true, methodBody.toString(), false, javadocBuf.toString());
            FieldElement parentVar = TagGenerator.ensureGenerateField(declaringClass, Identifier.create((String)"parent"), tagType, false, "This variable contains the parent (enclosing) tag.");
            parentVar.setModifiers(4);
            methodBody = new StringBuffer();
            methodBody.append("    parent = value;");
            javadocBuf = new StringBuffer();
            javadocBuf.append("Set the parent of this tag.");
            methodName = Identifier.create((String)"setParent");
            returnType = Type.VOID;
            argumentTypes = new Type[]{tagType};
            String[] argumentNames = new String[]{"value"};
            gp = TagGenerator.generateMethod(declaringClass, methodName, returnType, argumentTypes, argumentNames, false, methodBody.toString(), false, javadocBuf.toString());
        }
    }

    public void ensureGeneratePageContextMethods(ClassElement declaringClass, TagInfoData tag) throws SourceException {
        Type pageContextType = TagGenerator.getTypeFromString("PageContext", "javax.servlet.jsp.PageContext");
        Type[] argumentTypes = new Type[]{pageContextType};
        Identifier methodName = Identifier.create((String)"setPageContext");
        MethodElement spc = declaringClass.getMethod(methodName, argumentTypes);
        if (spc == null) {
            StringBuffer methodBody = new StringBuffer();
            methodBody.append("    pageContext = value;");
            StringBuffer javadocBuf = new StringBuffer();
            javadocBuf.append("Set the page context of this tag.");
            String[] argumentNames = new String[]{"value"};
            Type returnType = Type.VOID;
            spc = TagGenerator.generateMethod(declaringClass, methodName, returnType, argumentTypes, argumentNames, true, methodBody.toString(), false, javadocBuf.toString());
            FieldElement pageContextVar = TagGenerator.ensureGenerateField(declaringClass, Identifier.create((String)"pageContext"), pageContextType, false, "This variable contains the page context.");
            pageContextVar.setModifiers(4);
            methodBody = new StringBuffer();
            methodBody.append("    return pageContext;");
            javadocBuf = new StringBuffer();
            javadocBuf.append("@return the page context object.");
            methodName = Identifier.create((String)"getPageContext");
            returnType = pageContextType;
            MethodElement gpc = TagGenerator.generateMethod(declaringClass, methodName, returnType, null, null, false, methodBody.toString(), false, javadocBuf.toString());
        }
    }

    public void ensureGenerateReleaseMethod(ClassElement declaringClass, TagInfoData tag) throws SourceException {
        StringBuffer methodBody = new StringBuffer();
        methodBody.append("    // Here you release data kept by the tag,\n");
        methodBody.append("    // so the Tag instance can be reused for another request.\n");
        methodBody.append("    // For example, set the attribute values to null or \"\".\n");
        StringBuffer javadocBuf = new StringBuffer();
        javadocBuf.append("Release data kept by the tag, so the tag instance can be reused for another reqeust.");
        Identifier methodName = Identifier.create((String)"release");
        Type returnType = Type.VOID;
        MethodElement gpc = TagGenerator.generateMethod(declaringClass, methodName, returnType, null, null, false, methodBody.toString(), false, javadocBuf.toString());
    }

    public void ensureGenerateTryCatchFinallyMethods(ClassElement declaringClass, TagInfoData tag) throws SourceException {
        Identifier methodName = Identifier.create((String)"doCatch");
        Type throwableType = TagGenerator.getTypeFromString("Throwable", "java.lang.Throwable");
        Type[] argumentTypes = new Type[]{throwableType};
        String[] argumentNames = new String[]{"t"};
        StringBuffer methodBody = new StringBuffer();
        methodBody.append("    // ");
        StringBuffer javadocBuf = new StringBuffer();
        javadocBuf.append("This method is invoked (from the servlet generated from the JSP)\n");
        javadocBuf.append("if a Throwable occurs while evaluating the BODY inside a tag or in\n");
        javadocBuf.append("any of the following methods: \n");
        javadocBuf.append("Tag.doStartTag(), Tag.doEndTag(),\n ");
        javadocBuf.append("Iteration-Tag.doAfterBody() and BodyTag.doInitBody().<P>\n");
        javadocBuf.append("This method is not invoked if the Throwable occurs during one of the setter\n");
        javadocBuf.append("methods.<P>\n");
        javadocBuf.append("This method may throw an exception (the same or a new one) that will be\n");
        javadocBuf.append("propagated further the nest chain. If an exception is thrown, doFinally() will\n");
        javadocBuf.append("be invoked.\n");
        javadocBuf.append("This method is intended to be used to respond to an exceptional condition.\n");
        Type returnType = Type.VOID;
        MethodElement dc = TagGenerator.generateMethod(declaringClass, methodName, returnType, argumentTypes, argumentNames, false, methodBody.toString(), false, javadocBuf.toString());
        TagGenerator.addException(dc, "Throwable", "java.lang.Throwable");
        methodName = Identifier.create((String)"doFinally");
        methodBody = new StringBuffer();
        methodBody.append("  ");
        javadocBuf = new StringBuffer();
        javadocBuf.append("This method is invoked (from the servlet generated from the JSP)\n");
        javadocBuf.append("in all cases after doEndTag() for any class implementing Tag,\n");
        javadocBuf.append("IterationTag or BodyTag. This method is invoked even if an exception has\n");
        javadocBuf.append("occurred in the BODY of the tag, or in any of the following methods:\n");
        javadocBuf.append("Tag.doStartTag(), Tag.doEndTag(), IterationTag.doAfterBody() and Body-Tag.\n");
        javadocBuf.append("doInitBody().<P>\n");
        javadocBuf.append("This method is not invoked if the Throwable occurs during one of the setter\n");
        javadocBuf.append("methods.<P>\n");
        javadocBuf.append("This method should not throw an Exception.<P>\n");
        javadocBuf.append("This method is intended to maintain per-invocation data integrity and\n");
        javadocBuf.append("resource management actions.\n");
        returnType = Type.VOID;
        MethodElement df = TagGenerator.generateMethod(declaringClass, methodName, returnType, null, null, false, methodBody.toString(), false, javadocBuf.toString());
    }

    public boolean equalsOrInheritsFrom(Identifier subject, Identifier possibleSuper) {
        if (subject.equals((Object)possibleSuper)) {
            return true;
        }
        return subject.getName().equals(possibleSuper.getName());
    }

    public String findSuperClass(TagInfoData tag) {
        String superClass = null;
        if (tag.getExtendsSupportClass() && (superClass = tag.getSupportClass()).equals("")) {
            superClass = null;
        }
        return superClass;
    }

    public String findInterface(TagInfoData tag) {
        String interfaceName = null;
        if (!tag.getExtendsSupportClass() && "".equals(interfaceName = tag.getImplementsInterface())) {
            interfaceName = null;
        }
        return interfaceName;
    }

    public MethodElement ensureGenerateDoStartTagMethod(ClassElement declaringClass, TagInfoData tag) throws SourceException {
        StringBuffer methodBody = new StringBuffer(512);
        ++indent;
        this.generateFindParentCode(declaringClass, methodBody, tag);
        this.generateScriptingVariablesValueSettingCode(declaringClass, methodBody, tag, "doStartTag");
        TagGenerator.println(methodBody, "");
        TagGenerator.indentPrintln(methodBody, "otherDoStartTagOperations();");
        TagGenerator.println(methodBody, "");
        TagGenerator.indentPrintln(methodBody, "if (theBodyShouldBeEvaluated()) {");
        ++indent;
        String evalBodyReturnValue = this.isBodyTag(declaringClass) ? "EVAL_BODY_BUFFERED" : "EVAL_BODY_INCLUDE";
        TagGenerator.indentPrintln(methodBody, "return " + evalBodyReturnValue + ";");
        --indent;
        TagGenerator.indentPrintln(methodBody, "} else {");
        ++indent;
        TagGenerator.indentPrintln(methodBody, "return SKIP_BODY;");
        --indent;
        TagGenerator.indentPrintln(methodBody, "}");
        --indent;
        StringBuffer javadocBuf = new StringBuffer(512);
        TagGenerator.println(javadocBuf, " . ");
        TagGenerator.println(javadocBuf, " ");
        TagGenerator.println(javadocBuf, "This method is called when the JSP engine encounters the start tag,");
        TagGenerator.println(javadocBuf, "after the attributes are processed.");
        TagGenerator.println(javadocBuf, "Scripting variables (if any) have their values set here.");
        TagGenerator.println(javadocBuf, "@return EVAL_BODY_INCLUDE if the JSP engine should evaluate the tag body, otherwise return SKIP_BODY.");
        TagGenerator.println(javadocBuf, "This method is automatically generated. Do not modify this method.");
        TagGenerator.println(javadocBuf, "Instead, modify the methods that this method calls.");
        TagGenerator.println(javadocBuf, "");
        MethodElement dst = TagGenerator.generateMethod(declaringClass, Identifier.create((String)"doStartTag"), Type.INT, null, null, true, methodBody.toString(), true, javadocBuf.toString());
        this.tagInterfaceMethods.addElement("doStartTag");
        TagGenerator.addException(dst, "JspException", "javax.servlet.jsp.JspException");
        return dst;
    }

    public MethodElement ensureGenerateDoAfterBodyMethod_BodyTag(ClassElement declaringClass, TagInfoData tag) throws SourceException {
        if (this.isBodyTag(declaringClass)) {
            StringBuffer methodBody = new StringBuffer(2048);
            ++indent;
            this.generateDoAfterBodyMethodBody_BodyTag(methodBody, declaringClass, tag);
            --indent;
            StringBuffer javadocBuf = new StringBuffer(512);
            TagGenerator.println(javadocBuf, " . ");
            TagGenerator.println(javadocBuf, "   ");
            TagGenerator.println(javadocBuf, " ");
            TagGenerator.println(javadocBuf, "This method is called after the JSP engine processes the body content of the tag.");
            TagGenerator.println(javadocBuf, "@return EVAL_BODY_AGAIN if the JSP engine should evaluate the tag body again, otherwise return SKIP_BODY.");
            TagGenerator.println(javadocBuf, "This method is automatically generated. Do not modify this method.");
            TagGenerator.println(javadocBuf, "Instead, modify the methods that this method calls.");
            TagGenerator.println(javadocBuf, "");
            MethodElement dab = TagGenerator.generateMethod(declaringClass, Identifier.create((String)"doAfterBody"), Type.INT, null, null, true, methodBody.toString(), true, javadocBuf.toString());
            this.tagInterfaceMethods.addElement("doAfterBody");
            TagGenerator.addException(dab, "JspException", "javax.servlet.jsp.JspException");
            return dab;
        }
        if (!this.isIterationTag(declaringClass)) {
            Type[] argumentTypes = new Type[]{};
            Identifier methodName = Identifier.create((String)"doAfterBody");
            MethodElement dabMethod = declaringClass.getMethod(methodName, argumentTypes);
            if (dabMethod != null) {
                declaringClass.removeMethod(dabMethod);
            }
        }
        return null;
    }

    public void generateDoAfterBodyMethodBody_BodyTag(StringBuffer buf, ClassElement declaringClass, TagInfoData tag) throws SourceException {
        TagGenerator.indentPrintln(buf, "");
        TagGenerator.indentPrintln(buf, "try {");
        ++indent;
        if (tag.isJSPBodyTag()) {
            TagGenerator.indentPrintln(buf, "//");
            TagGenerator.indentPrintln(buf, "// This code is generated for tags whose bodyContent is \"JSP\"");
            TagGenerator.indentPrintln(buf, "//");
            TagGenerator.indentPrintln(buf, "BodyContent bodyContent = getBodyContent();");
            TagGenerator.indentPrintln(buf, "JspWriter out = bodyContent.getEnclosingWriter();");
            TagGenerator.indentPrintln(buf, "");
            String userBodyWritingMethod = "writeTagBodyContent";
            this.generateUserBodyWritingMethod(declaringClass, userBodyWritingMethod, "JSP", tag);
            TagGenerator.indentPrintln(buf, userBodyWritingMethod + "(out, bodyContent);");
        } else {
            TagGenerator.indentPrintln(buf, "//");
            TagGenerator.indentPrintln(buf, "// This code is generated for tags whose bodyContent is \"tagdependent\"");
            TagGenerator.indentPrintln(buf, "//");
            TagGenerator.indentPrintln(buf, "");
            TagGenerator.indentPrintln(buf, "JspWriter out = getPreviousOut();");
            TagGenerator.indentPrintln(buf, "BodyContent bodyContent = getBodyContent();");
            TagGenerator.indentPrintln(buf, "");
            String userBodyWritingMethod = this.getUserBodyWritingMethodName();
            this.generateUserBodyWritingMethod(declaringClass, userBodyWritingMethod, "tagdependent", tag);
            TagGenerator.indentPrintln(buf, userBodyWritingMethod + "(out, bodyContent);");
        }
        --indent;
        TagGenerator.indentPrintln(buf, "} catch (Exception ex) {");
        ++indent;
        TagGenerator.indentPrintln(buf, " handleBodyContentException(ex); ");
        this.ensureGenerateHandleBodyContentException(declaringClass, tag);
        --indent;
        TagGenerator.indentPrintln(buf, "}");
        TagGenerator.println(buf, "");
        TagGenerator.indentPrintln(buf, "if (theBodyShouldBeEvaluatedAgain()) {");
        ++indent;
        TagGenerator.indentPrintln(buf, "return EVAL_BODY_AGAIN;");
        --indent;
        TagGenerator.indentPrintln(buf, "} else {");
        ++indent;
        TagGenerator.indentPrintln(buf, "return SKIP_BODY;");
        --indent;
        TagGenerator.indentPrintln(buf, "}");
    }

    public MethodElement ensureGenerateHandleBodyContentException(ClassElement declaringClass, TagInfoData tag) throws SourceException {
        StringBuffer methodBody = new StringBuffer(128);
        StringBuffer javadocBuf = new StringBuffer(128);
        TagGenerator.indentPrintln(methodBody, "// Since the doAfterBody method is guarded, place exception handing code here.");
        TagGenerator.indentPrintln(methodBody, "throw new JspException(\"error in " + tag.getTagClassName() + ": \" + ex);");
        TagGenerator.println(javadocBuf, " . ");
        TagGenerator.println(javadocBuf, "   ");
        TagGenerator.println(javadocBuf, "Handles exception from processing the body content.\n");
        Type[] argumentTypes = new Type[]{TagGenerator.getTypeFromString("Exception", "java.lang.Exception")};
        String[] argumentNames = new String[]{"ex"};
        MethodElement handle = TagGenerator.generateMethod(declaringClass, Identifier.create((String)"handleBodyContentException"), Type.VOID, argumentTypes, argumentNames, false, methodBody.toString(), true, javadocBuf.toString());
        TagGenerator.addException(handle, "JspException", "javax.servlet.jsp.JspException");
        return handle;
    }

    public MethodElement ensureGenerateDoAfterBodyMethod_IterationTag(ClassElement declaringClass, TagInfoData tag) throws SourceException {
        if (this.isIterationTag(declaringClass)) {
            StringBuffer methodBody = new StringBuffer(2048);
            ++indent;
            this.generateDoAfterBodyMethodBody_IterationTag(methodBody, declaringClass, tag);
            --indent;
            StringBuffer javadocBuf = new StringBuffer(512);
            TagGenerator.println(javadocBuf, " . ");
            TagGenerator.println(javadocBuf, "   ");
            TagGenerator.println(javadocBuf, " ");
            TagGenerator.println(javadocBuf, "This method is called after the JSP engine processes the body of the tag.");
            TagGenerator.println(javadocBuf, "@return EVAL_BODY_AGAIN if the JSP engine should evaluate the tag body again, otherwise return SKIP_BODY.");
            TagGenerator.println(javadocBuf, "This method is automatically generated. Do not modify this method.");
            TagGenerator.println(javadocBuf, "Instead, modify the methods that this method calls.");
            TagGenerator.println(javadocBuf, "");
            MethodElement dab = TagGenerator.generateMethod(declaringClass, Identifier.create((String)"doAfterBody"), Type.INT, null, null, true, methodBody.toString(), true, javadocBuf.toString());
            this.tagInterfaceMethods.addElement("doAfterBody");
            TagGenerator.addException(dab, "JspException", "javax.servlet.jsp.JspException");
            return dab;
        }
        if (!this.isBodyTag(declaringClass)) {
            Type[] argumentTypes = new Type[]{};
            Identifier methodName = Identifier.create((String)"doAfterBody");
            MethodElement dabMethod = declaringClass.getMethod(methodName, argumentTypes);
            if (dabMethod != null) {
                declaringClass.removeMethod(dabMethod);
            }
        }
        return null;
    }

    public void generateDoAfterBodyMethodBody_IterationTag(StringBuffer buf, ClassElement declaringClass, TagInfoData tag) throws SourceException {
        TagGenerator.println(buf, "");
        TagGenerator.indentPrintln(buf, "if (theBodyShouldBeEvaluatedAgain()) {");
        ++indent;
        TagGenerator.indentPrintln(buf, "return EVAL_BODY_AGAIN;");
        --indent;
        TagGenerator.indentPrintln(buf, "} else {");
        ++indent;
        TagGenerator.indentPrintln(buf, "return SKIP_BODY;");
        --indent;
        TagGenerator.indentPrintln(buf, "}");
    }

    public MethodElement ensureGenerateDoEndTagMethod(ClassElement declaringClass, TagInfoData tag) throws SourceException {
        StringBuffer methodBody = new StringBuffer(512);
        ++indent;
        this.generateScriptingVariablesValueSettingCode(declaringClass, methodBody, tag, "doEndTag");
        TagGenerator.indentPrintln(methodBody, "");
        TagGenerator.indentPrintln(methodBody, "otherDoEndTagOperations();");
        TagGenerator.indentPrintln(methodBody, "");
        TagGenerator.indentPrintln(methodBody, "if (shouldEvaluateRestOfPageAfterEndTag()) {");
        ++indent;
        TagGenerator.indentPrintln(methodBody, "return EVAL_PAGE;");
        --indent;
        TagGenerator.indentPrintln(methodBody, "} else {");
        ++indent;
        TagGenerator.indentPrintln(methodBody, "return SKIP_PAGE;");
        --indent;
        TagGenerator.indentPrintln(methodBody, "}");
        --indent;
        StringBuffer javadocBuf = new StringBuffer(512);
        TagGenerator.println(javadocBuf, " . ");
        TagGenerator.println(javadocBuf, "   ");
        TagGenerator.println(javadocBuf, " ");
        TagGenerator.println(javadocBuf, "This method is called after the JSP engine finished processing the tag.");
        TagGenerator.println(javadocBuf, "@return EVAL_PAGE if the JSP engine should continue evaluating the JSP page, otherwise return SKIP_PAGE.");
        TagGenerator.println(javadocBuf, "This method is automatically generated. Do not modify this method.");
        TagGenerator.println(javadocBuf, "Instead, modify the methods that this method calls.");
        TagGenerator.println(javadocBuf, "");
        MethodElement det = TagGenerator.generateMethod(declaringClass, Identifier.create((String)"doEndTag"), Type.INT, null, null, true, methodBody.toString(), true, javadocBuf.toString());
        this.tagInterfaceMethods.addElement("doEndTag");
        TagGenerator.addException(det, "JspException", "javax.servlet.jsp.JspException");
        return det;
    }

    public void generateUserBodyWritingMethod(ClassElement declaringClass, String userBodyWritingMethod, String bodyContent, TagInfoData tag) throws SourceException {
        StringBuffer buf = new StringBuffer(1024);
        TagGenerator.indentPrintln(buf, "");
        TagGenerator.indentPrintln(buf, "//");
        TagGenerator.indentPrintln(buf, "// TODO: insert code to write html before writing the body content.");
        TagGenerator.indentPrintln(buf, "//       e.g.  out.println(\"<B>\" + getAttribute1() + \"</B>\"); ");
        TagGenerator.indentPrintln(buf, "//             out.println(\"   <BLOCKQUOTE>\"); ");
        TagGenerator.indentPrintln(buf, "");
        TagGenerator.indentPrintln(buf, "//");
        TagGenerator.indentPrintln(buf, "// write the body content (after processing by the JSP engine) on the output Writer");
        TagGenerator.indentPrintln(buf, "//");
        TagGenerator.indentPrintln(buf, "bodyContent.writeOut(out);");
        TagGenerator.indentPrintln(buf, "");
        TagGenerator.indentPrintln(buf, "//");
        TagGenerator.indentPrintln(buf, "// Or else get the body content as a string and process it, e.g.:");
        TagGenerator.indentPrintln(buf, "//     String bodyStr = bodyContent.getString();");
        TagGenerator.indentPrintln(buf, "//     String result = yourProcessingMethod(bodyStr);");
        TagGenerator.indentPrintln(buf, "//     out.println(result);");
        TagGenerator.indentPrintln(buf, "//");
        TagGenerator.indentPrintln(buf, "");
        TagGenerator.indentPrintln(buf, "// TODO: insert code to write html after writing the body content.");
        TagGenerator.indentPrintln(buf, "//       e.g.  out.println(\"   <BLOCKQUOTE>\"); ");
        TagGenerator.indentPrintln(buf, "");
        TagGenerator.indentPrintln(buf, "// clear the body content for the next time through.");
        TagGenerator.indentPrintln(buf, "bodyContent.clearBody();");
        StringBuffer javadocBuf = new StringBuffer(512);
        TagGenerator.println(javadocBuf, " . ");
        TagGenerator.println(javadocBuf, "Fill in this method to process the body content of the tag. ");
        TagGenerator.println(javadocBuf, "You only need to do this if the tag's BodyContent property");
        TagGenerator.println(javadocBuf, "is set to \"JSP\" or \"tagdependent.\"");
        TagGenerator.println(javadocBuf, "If the tag's bodyContent is set to \"empty,\" then this method");
        TagGenerator.println(javadocBuf, "will not be called.");
        TagGenerator.println(javadocBuf, "");
        Type[] argumentTypes = this.getUserBodyWritingMethodTypes();
        String[] argumentNames = this.getUserBodyWritingMethodNames();
        this.markUserMethodLocation(declaringClass);
        MethodElement ubm = TagGenerator.generateMethod(declaringClass, Identifier.create((String)userBodyWritingMethod), Type.VOID, argumentTypes, argumentNames, false, buf.toString(), false, javadocBuf.toString());
        TagGenerator.addException(ubm, "IOException", "java.io.IOException");
        this.setLatestUserMethod((Element)ubm);
        this.userMethods.addElement(userBodyWritingMethod);
    }

    public String getUserBodyWritingMethodName() {
        return "writeTagBodyContent";
    }

    public Type[] getUserBodyWritingMethodTypes() {
        Type[] argumentTypes = new Type[]{TagGenerator.getTypeFromString("JspWriter", "javax.servlet.jsp.JspWriter"), TagGenerator.getTypeFromString("BodyContent", "javax.servlet.jsp.tagext.BodyContent")};
        return argumentTypes;
    }

    public String[] getUserBodyWritingMethodNames() {
        String[] argumentNames = new String[]{"out", "bodyContent"};
        return argumentNames;
    }

    public void generateFindParentCode(ClassElement declaringClass, StringBuffer buf, TagInfoData tag) throws SourceException {
        String parentVariableType = null;
        String fullParentVariableType = null;
        StringBuffer parentBuf = null;
        if (tag.getFindParent()) {
            String parentVariableTagName = tag.getParentType();
            String parentVariableName = tag.getParentVariable();
            if (parentVariableTagName != null) {
                TagInfoData parentVariableTag = tag.getTaglib().findTagByName(parentVariableTagName);
                if (parentVariableTag != null) {
                    parentVariableType = parentVariableTag.getTagClassName();
                    String parentPkg = parentVariableTag.getPackageName();
                    fullParentVariableType = parentPkg == null || parentPkg.equals("") ? parentVariableType : parentPkg + "." + parentVariableType;
                } else {
                    fullParentVariableType = parentVariableType = parentVariableTagName;
                }
                this.checkReferencedTagTypeForPackageDifferences(tag, parentVariableType);
                FieldElement parentVar = TagGenerator.ensureGenerateField(declaringClass, parentVariableName, parentVariableType, fullParentVariableType, false, "This variable contains the parent (enclosing) tag.");
                try {
                    parentVar.setInitValue("null");
                }
                catch (Exception ex3) {
                    // empty catch block
                }
                parentBuf = new StringBuffer(2048);
                TagGenerator.indentPrintln(parentBuf, "//");
                TagGenerator.indentPrintln(parentBuf, "// Then we find the parent (enclosing tag)");
                TagGenerator.indentPrintln(parentBuf, "//");
                TagGenerator.indentPrintln(parentBuf, "if (" + parentVariableName + " == null) {");
                ++indent;
                TagGenerator.indentPrintln(parentBuf, parentVariableName + " = (" + parentVariableType + ")findAncestorWithClass(this, " + parentVariableType + ".class);");
                --indent;
                TagGenerator.indentPrintln(parentBuf, "}");
            } else {
                Object[] args = new Object[]{tag.getTagName()};
                String msg = "TAGGEN_MissingParentType";
                IDEHelper.showWarningMessageI18N(msg, args);
            }
        }
        Enumeration en = tag.getAttributesVector().elements();
        while (en.hasMoreElements()) {
            TagAttributeInfoData att = (TagAttributeInfoData)en.nextElement();
            if (!att.getIsReferenceID()) continue;
            TagGenerator.indentPrintln(buf, "//");
            TagGenerator.indentPrintln(buf, "// The " + att.getName() + " attribute is a reference ID");
            TagGenerator.indentPrintln(buf, "// attribute. This means that we register this tag handler");
            TagGenerator.indentPrintln(buf, "// instance on the session scope under the name specified");
            TagGenerator.indentPrintln(buf, "// as the value of the " + att.getName() + " attribute.");
            TagGenerator.indentPrintln(buf, "//");
            TagGenerator.indentPrintln(buf, "{");
            ++indent;
            TagGenerator.indentPrintln(buf, "String referenceID = get" + TagGenerator.capitalize(att.getName()) + "();");
            TagGenerator.indentPrintln(buf, "if (referenceID == null) {");
            ++indent;
            TagGenerator.indentPrintln(buf, "throw new JspException(\"" + tag.getTagClassName() + ":: <" + tag.getTagName() + " ... > tag is missing the required " + att.getName() + " attribute\");");
            --indent;
            TagGenerator.indentPrintln(buf, "}");
            TagGenerator.indentPrintln(buf, "pageContext.setAttribute(referenceID, this, PageContext.SESSION_SCOPE);");
            --indent;
            TagGenerator.indentPrintln(buf, "}");
            TagGenerator.indentPrintln(buf, "");
        }
        StringBuffer refBuf = null;
        Enumeration en2 = tag.getAttributesVector().elements();
        while (en2.hasMoreElements()) {
            String msg;
            TagAttributeInfoData att = (TagAttributeInfoData)en2.nextElement();
            if (!att.getReferencesTag()) continue;
            if (refBuf == null) {
                refBuf = new StringBuffer(4096);
            }
            String refTagType = null;
            String fullRefTagType = null;
            String refTagName = att.getReferencesTagType();
            TagInfoData refTag = tag.getTaglib().findTagByName(refTagName);
            if (refTag != null) {
                refTagType = refTag.getTagClassName();
                String refTagPkg = refTag.getPackageName();
                refTagType = refTagPkg == null || refTagPkg.equals("") ? refTagType : refTagPkg + "." + refTagType;
            } else {
                fullRefTagType = refTagType = refTagName;
            }
            this.checkReferencedTagTypeForPackageDifferences(tag, refTagType);
            String refVar = att.getReferencesTagVariable();
            if (refTagType != null && !refTagType.equals("") && refVar != null && !refVar.equals("")) {
                TagGenerator.indentPrintln(refBuf, "");
                TagGenerator.indentPrintln(refBuf, "//");
                TagGenerator.indentPrintln(refBuf, "// Find the referenced tag <" + att.getName() + ">, from the session.");
                TagGenerator.indentPrintln(refBuf, "//");
                FieldElement refVarElt = TagGenerator.ensureGenerateField(declaringClass, refVar, refTagType, fullRefTagType, false, "This variable contains an IDRef for the referenced tag " + att.getName());
                refVarElt.setInitValue("null");
                TagGenerator.indentPrintln(refBuf, "{");
                ++indent;
                TagGenerator.indentPrintln(refBuf, "String refTagName = get" + TagGenerator.capitalize(att.getName()) + "();");
                TagGenerator.indentPrintln(refBuf, refVar + " = (" + refTagType + ")pageContext.getAttribute(refTagName, PageContext.SESSION_SCOPE);");
                --indent;
                TagGenerator.indentPrintln(refBuf, "}");
                TagGenerator.indentPrintln(refBuf, "");
                continue;
            }
            Object[] args = new Object[]{tag.getTagName(), att.getName()};
            if (refTagType == null || refTagType.equals("")) {
                msg = "TAGGEN_MissingRefType";
                IDEHelper.showWarningMessageI18N(msg, args);
                continue;
            }
            if (refVar != null && !refVar.equals("")) continue;
            msg = "TAGGEN_MissingRefVar";
            IDEHelper.showWarningMessageI18N(msg, args);
        }
        if (refBuf != null) {
            buf.append((Object)refBuf);
        }
        if (parentBuf != null) {
            buf.append((Object)parentBuf);
        }
    }

    public void checkReferencedTagTypeForPackageDifferences(TagInfoData tag, String referencedTagType) {
        TagInfoData referencedTag = tag.getTaglib().findTagByType(referencedTagType, false);
        if (referencedTag == null) {
            return;
        }
        String thisPkg = tag.getPackageName();
        String thatPkg = referencedTag.getPackageName();
        if (thisPkg == null || thisPkg.equals("") ? thatPkg == null || thatPkg.equals("") : thisPkg.equals(thatPkg)) {
            return;
        }
        this.otherImports.addElement(thatPkg + '.' + referencedTag.getTagClassName());
    }

    public void generateScriptingVariablesValueSettingCode(ClassElement declaringClass, StringBuffer buf, TagInfoData tag, String callingMethodName) throws SourceException {
        Enumeration en = tag.getVariablesVector().elements();
        while (en.hasMoreElements()) {
            TagVariableInfoData tagVar = (TagVariableInfoData)en.nextElement();
            int scope = tagVar.getScope();
            if (callingMethodName.equals("doStartTag") && (scope == 0 || scope == 1)) {
                this.generateScriptingVariableValueSettingCode(declaringClass, buf, tagVar, callingMethodName);
                continue;
            }
            if (!callingMethodName.equals("doEndTag") || scope != 2) continue;
            this.generateScriptingVariableValueSettingCode(declaringClass, buf, tagVar, callingMethodName);
        }
    }

    public void generateScriptingVariableValueSettingCode(ClassElement declaringClass, StringBuffer buf, TagVariableInfoData tagVar, String callingMethodName) throws SourceException {
        String varInfoName = "";
        varInfoName = tagVar.getNameType() == 1 ? tagVar.getNameAttribute() : tagVar.getName();
        TagGenerator.indentPrintln(buf, "");
        TagGenerator.indentPrintln(buf, "//");
        TagGenerator.indentPrintln(buf, "// Set the name and value of the scripting variable \"" + varInfoName + "\"");
        TagGenerator.indentPrintln(buf, "//");
        TagGenerator.indentPrintln(buf, "{");
        ++indent;
        String tagVarName = tagVar.getName();
        String varType = tagVar.getType();
        String fullVarType = tagVar.getType();
        String varNameString = "";
        String nameTypeExplanation = "";
        if (tagVar.getNameType() == 0) {
            varNameString = "\"" + tagVarName + "\"";
            TagGenerator.indentPrintln(buf, "//");
            TagGenerator.indentPrintln(buf, "// The name of this variable is fixed.");
            TagGenerator.indentPrintln(buf, "//");
        } else if (tagVar.getNameType() == 1) {
            String nameAtt = tagVar.getNameAttribute();
            varNameString = "get" + TagGenerator.capitalize(nameAtt) + "()";
            TagGenerator.indentPrintln(buf, "//");
            TagGenerator.indentPrintln(buf, "// The name of this variable comes from the value");
            TagGenerator.indentPrintln(buf, "// of the " + nameAtt + " attribute.");
            TagGenerator.indentPrintln(buf, "//");
        } else if (tagVar.getNameType() == 2) {
            String varNameSettingMethod = "setNameOfVariable_" + tagVarName;
            varNameString = varNameSettingMethod + "()";
            this.markUserMethodLocation(declaringClass);
            MethodElement vnsm = this.generateVarNameSettingMethod(declaringClass, varNameSettingMethod, tagVar, varType, fullVarType, callingMethodName);
            this.setLatestUserMethod((Element)vnsm);
            TagGenerator.indentPrintln(buf, "//");
            TagGenerator.indentPrintln(buf, "// The name of this variable is determined by by user code.");
            TagGenerator.indentPrintln(buf, "// Modify the method " + varNameSettingMethod + " to set the name.");
            TagGenerator.indentPrintln(buf, "//");
        }
        TagGenerator.indentPrintln(buf, "String nameVar = " + varNameString + ";");
        TagGenerator.indentPrintln(buf, "");
        String valueSettingMethod = "setValueOfVariable_" + tagVarName;
        TagGenerator.indentPrintln(buf, "//");
        TagGenerator.indentPrintln(buf, "// Set the value of the variable \"" + tagVarName + "\"  by modifying the ");
        TagGenerator.indentPrintln(buf, "// method: " + valueSettingMethod + "(). ");
        TagGenerator.indentPrintln(buf, "//");
        TagGenerator.indentPrintln(buf, "if (nameVar != null) {");
        ++indent;
        TagGenerator.indentPrintln(buf, varType + " valueObject = " + valueSettingMethod + "();");
        TagGenerator.indentPrintln(buf, "if (valueObject != null) {");
        ++indent;
        TagGenerator.indentPrintln(buf, "pageContext.setAttribute(nameVar, valueObject);");
        --indent;
        TagGenerator.indentPrintln(buf, "}");
        --indent;
        TagGenerator.indentPrintln(buf, "}");
        --indent;
        TagGenerator.indentPrintln(buf, "}");
        this.markUserMethodLocation(declaringClass);
        MethodElement vvsm = this.generateVarValueSettingMethod(declaringClass, valueSettingMethod, tagVar, varType, fullVarType, callingMethodName);
        this.setLatestUserMethod((Element)vvsm);
    }

    MethodElement generateVarValueSettingMethod(ClassElement declaringClass, String valueSettingMethod, TagVariableInfoData tagVar, String varType, String fullVarType, String callingMethodName) throws SourceException {
        StringBuffer valBody = new StringBuffer();
        TagGenerator.println(valBody, "");
        TagGenerator.indentPrintln(valBody, "return null;");
        StringBuffer valJavadoc = new StringBuffer();
        TagGenerator.println(valJavadoc, "");
        TagGenerator.println(valJavadoc, "This method sets the value of the scripting variable \"" + tagVar.getName() + "\"");
        TagGenerator.println(valJavadoc, "It is called from " + callingMethodName + "().");
        TagGenerator.println(valJavadoc, "");
        this.userMethods.addElement(valueSettingMethod);
        return TagGenerator.generateMethod(declaringClass, Identifier.create((String)valueSettingMethod), TagGenerator.getTypeFromString(varType, fullVarType), null, null, false, valBody.toString(), false, valJavadoc.toString());
    }

    MethodElement generateVarNameSettingMethod(ClassElement declaringClass, String varNameSettingMethod, TagVariableInfoData tagVar, String varType, String fullVarType, String callingMethodName) throws SourceException {
        StringBuffer valBody = new StringBuffer();
        TagGenerator.indentPrintln(valBody, "");
        TagGenerator.indentPrintln(valBody, "//");
        TagGenerator.indentPrintln(valBody, "// TODO: change this method to return the name of the");
        TagGenerator.indentPrintln(valBody, "//       scripting variable. You can return a fixed name,");
        TagGenerator.indentPrintln(valBody, "//       or return a name that depends on an attribute");
        TagGenerator.indentPrintln(valBody, "//       value, e.g.: ");
        TagGenerator.indentPrintln(valBody, "//          return getAttribute1() + \"_var\";");
        TagGenerator.indentPrintln(valBody, "//");
        TagGenerator.indentPrintln(valBody, "");
        TagGenerator.indentPrintln(valBody, "return \"" + tagVar.getName() + "\";");
        StringBuffer valJavadoc = new StringBuffer();
        TagGenerator.println(valJavadoc, "");
        TagGenerator.println(valJavadoc, "This method sets the name of the scripting variable \"" + tagVar.getName() + "\"");
        TagGenerator.println(valJavadoc, "It is called from " + callingMethodName + "().");
        TagGenerator.println(valJavadoc, "");
        this.userMethods.addElement(varNameSettingMethod);
        return TagGenerator.generateMethod(declaringClass, Identifier.create((String)varNameSettingMethod), TagGenerator.getTypeFromString(varType, fullVarType), null, null, false, valBody.toString(), false, valJavadoc.toString());
    }

    public void ensureGenerateUserMethods(ClassElement declaringClass, TagInfoData tag) throws SourceException {
        StringBuffer methodBody = new StringBuffer();
        StringBuffer javadocBuf = new StringBuffer(256);
        TagGenerator.generateBodies(methodBody, javadocBuf, "shouldEvaluateRestOfPageAfterEndTag");
        TagGenerator.generateMethod(declaringClass, Identifier.create((String)"shouldEvaluateRestOfPageAfterEndTag"), Type.BOOLEAN, null, null, false, methodBody.toString(), false, javadocBuf.toString());
        this.userMethods.addElement("shouldEvaluateRestOfPageAfterEndTag");
        methodBody = new StringBuffer();
        javadocBuf = new StringBuffer(256);
        TagGenerator.generateBodies(methodBody, javadocBuf, "theBodyShouldBeEvaluated");
        TagGenerator.generateMethod(declaringClass, Identifier.create((String)"theBodyShouldBeEvaluated"), Type.BOOLEAN, null, null, false, methodBody.toString(), false, javadocBuf.toString());
        this.userMethods.addElement("theBodyShouldBeEvaluated");
        if (this.isBodyTag(declaringClass) || this.isIterationTag(declaringClass)) {
            methodBody = new StringBuffer();
            javadocBuf = new StringBuffer(256);
            TagGenerator.generateBodies(methodBody, javadocBuf, "theBodyShouldBeEvaluatedAgain");
            TagGenerator.generateMethod(declaringClass, Identifier.create((String)"theBodyShouldBeEvaluatedAgain"), Type.BOOLEAN, null, null, false, methodBody.toString(), false, javadocBuf.toString());
            this.userMethods.addElement("theBodyShouldBeEvaluatedAgain");
        }
        methodBody = new StringBuffer();
        javadocBuf = new StringBuffer(256);
        TagGenerator.generateBodies(methodBody, javadocBuf, "otherDoStartTagOperations");
        TagGenerator.generateMethod(declaringClass, Identifier.create((String)"otherDoStartTagOperations"), Type.VOID, null, null, false, methodBody.toString(), false, javadocBuf.toString());
        this.userMethods.addElement("otherDoStartTagOperations");
        methodBody = new StringBuffer();
        javadocBuf = new StringBuffer(256);
        TagGenerator.generateBodies(methodBody, javadocBuf, "otherDoEndTagOperations");
        TagGenerator.generateMethod(declaringClass, Identifier.create((String)"otherDoEndTagOperations"), Type.VOID, null, null, false, methodBody.toString(), false, javadocBuf.toString());
        this.userMethods.addElement("otherDoEndTagOperations");
    }

    public static void generateBodies(StringBuffer methodBody, StringBuffer javadocBuf, String methodName) {
        if (methodName.equals("shouldEvaluateRestOfPageAfterEndTag")) {
            ++indent;
            methodBody.append("\n");
            TagGenerator.indentPrint(methodBody, "//\n");
            TagGenerator.indentPrint(methodBody, "// TODO: code that determines whether the rest of the page\n");
            TagGenerator.indentPrint(methodBody, "//       should be evaluated after the tag is processed\n");
            TagGenerator.indentPrint(methodBody, "//       should be placed here.\n");
            TagGenerator.indentPrint(methodBody, "//       Called from the doEndTag() method.\n");
            TagGenerator.indentPrint(methodBody, "//\n");
            TagGenerator.indentPrint(methodBody, "return true;\n");
            --indent;
            TagGenerator.println(javadocBuf, " ");
            TagGenerator.println(javadocBuf, "Fill in this method to determine if the rest of the JSP page");
            TagGenerator.println(javadocBuf, "should be generated after this tag is finished.");
            TagGenerator.println(javadocBuf, "Called from doEndTag().");
            TagGenerator.println(javadocBuf, "");
        } else if (methodName.equals("theBodyShouldBeEvaluated")) {
            methodBody.append("\n");
            ++indent;
            TagGenerator.indentPrint(methodBody, "//\n");
            TagGenerator.indentPrint(methodBody, "// TODO: code that determines whether the body should be\n");
            TagGenerator.indentPrint(methodBody, "//       evaluated should be placed here.\n");
            TagGenerator.indentPrint(methodBody, "//       Called from the doStartTag() method.\n");
            TagGenerator.indentPrint(methodBody, "//\n");
            TagGenerator.indentPrint(methodBody, "return true;\n");
            --indent;
            TagGenerator.println(javadocBuf, " ");
            TagGenerator.println(javadocBuf, "Fill in this method to determine if the tag body should be evaluated");
            TagGenerator.println(javadocBuf, "Called from doStartTag().");
            TagGenerator.println(javadocBuf, "");
        } else if (methodName.equals("theBodyShouldBeEvaluatedAgain")) {
            methodBody.append("\n");
            ++indent;
            TagGenerator.indentPrint(methodBody, "//\n");
            TagGenerator.indentPrint(methodBody, "// TODO: code that determines whether the tag body should be\n");
            TagGenerator.indentPrint(methodBody, "//       evaluated again after processing the tag \n");
            TagGenerator.indentPrint(methodBody, "//       should be placed here.\n");
            TagGenerator.indentPrint(methodBody, "//       You can use this method to create iterating tags.\n");
            TagGenerator.indentPrint(methodBody, "//       Called from the doAfterBody() method.\n");
            TagGenerator.indentPrint(methodBody, "//\n");
            TagGenerator.indentPrint(methodBody, "return false;\n");
            TagGenerator.println(javadocBuf, " ");
            TagGenerator.println(javadocBuf, "Fill in this method to determine if the tag body should be evaluated");
            TagGenerator.println(javadocBuf, "again after evaluating the body.");
            TagGenerator.println(javadocBuf, "Use this method to create an iterating tag.");
            TagGenerator.println(javadocBuf, "Called from doAfterBody().");
            TagGenerator.println(javadocBuf, " ");
            --indent;
        } else if (methodName.equals("otherDoStartTagOperations")) {
            TagGenerator.indentPrintln(methodBody, "");
            ++indent;
            TagGenerator.indentPrintln(methodBody, "//");
            TagGenerator.indentPrintln(methodBody, "// TODO: code that performs other operations in doStartTag");
            TagGenerator.indentPrintln(methodBody, "//       should be placed here.");
            TagGenerator.indentPrintln(methodBody, "//       It will be called after initializing variables, ");
            TagGenerator.indentPrintln(methodBody, "//       finding the parent, setting IDREFs, etc, and ");
            TagGenerator.indentPrintln(methodBody, "//       before calling theBodyShouldBeEvaluated(). ");
            TagGenerator.indentPrintln(methodBody, "//");
            TagGenerator.indentPrintln(methodBody, "//       For example, to print something out to the JSP, use the following:");
            TagGenerator.indentPrintln(methodBody, "//");
            TagGenerator.indentPrintln(methodBody, "//   try {");
            TagGenerator.indentPrintln(methodBody, "//       JspWriter out = pageContext.getOut();");
            TagGenerator.indentPrintln(methodBody, "//       out.println(\"something\");");
            TagGenerator.indentPrintln(methodBody, "//   } catch (java.io.IOException ex) {");
            TagGenerator.indentPrintln(methodBody, "//       // do something");
            TagGenerator.indentPrintln(methodBody, "//   }");
            TagGenerator.indentPrintln(methodBody, "//");
            TagGenerator.indentPrintln(methodBody, "//");
            TagGenerator.indentPrintln(methodBody, "");
            TagGenerator.println(javadocBuf, " ");
            TagGenerator.println(javadocBuf, "Fill in this method to perform other operations from doStartTag().");
            TagGenerator.println(javadocBuf, "");
            --indent;
        } else if (methodName.equals("otherDoEndTagOperations")) {
            TagGenerator.indentPrintln(methodBody, "");
            ++indent;
            TagGenerator.indentPrintln(methodBody, "//");
            TagGenerator.indentPrintln(methodBody, "// TODO: code that performs other operations in doEndTag");
            TagGenerator.indentPrintln(methodBody, "//       should be placed here.");
            TagGenerator.indentPrintln(methodBody, "//       It will be called after initializing variables, ");
            TagGenerator.indentPrintln(methodBody, "//       finding the parent, setting IDREFs, etc, and ");
            TagGenerator.indentPrintln(methodBody, "//       before calling shouldEvaluateRestOfPageAfterEndTag(). ");
            TagGenerator.indentPrintln(methodBody, "//");
            TagGenerator.indentPrintln(methodBody, "");
            TagGenerator.println(javadocBuf, " ");
            TagGenerator.println(javadocBuf, "Fill in this method to perform other operations from doEndTag().");
            TagGenerator.println(javadocBuf, "");
            --indent;
        } else if (methodName.equals("writeTagBodyContent")) {
            ++indent;
            methodBody.append("\n");
            TagGenerator.indentPrint(methodBody, "//\n");
            TagGenerator.indentPrint(methodBody, "// TODO: code that handles the body content of the tag\n");
            TagGenerator.indentPrint(methodBody, "//       should be placed here.\n");
            TagGenerator.indentPrint(methodBody, "//       Called from the doAfterBody() method,\n");
            TagGenerator.indentPrint(methodBody, "//       but only if the tag's bodyContent is declared\n");
            TagGenerator.indentPrint(methodBody, "//       to be \"JSP\" or \"tagdependent.\"\n");
            TagGenerator.indentPrint(methodBody, "//       If the tag's bodyContent is declared \"empty,\"\n");
            TagGenerator.indentPrint(methodBody, "//       then this method can be safely ignored.\n");
            TagGenerator.indentPrint(methodBody, "//\n");
            --indent;
            TagGenerator.println(javadocBuf, " ");
            TagGenerator.println(javadocBuf, "Fill in this method to process the body content of the tag. ");
            TagGenerator.println(javadocBuf, "You only need to do this if the tag's BodyContent property");
            TagGenerator.println(javadocBuf, "is set to \"JSP\" or \"tagdependent.\"");
            TagGenerator.println(javadocBuf, "If the tag's bodyContent is set to \"empty,\" then this method");
            TagGenerator.println(javadocBuf, "will not be called.");
            TagGenerator.println(javadocBuf, "");
        }
    }

    public void ensureGenerateImports(SourceElement elt, TagInfoData tag) throws SourceException {
        Import[] allImports = elt.getImports();
        TagGenerator.addImport(elt, "javax.servlet.jsp.tagext.Tag", false, allImports);
        TagGenerator.addImport(elt, "javax.servlet.jsp.tagext.IterationTag", false, allImports);
        TagGenerator.addImport(elt, "javax.servlet.jsp.tagext.BodyTag", false, allImports);
        TagGenerator.addImport(elt, "javax.servlet.jsp.tagext.TagSupport", false, allImports);
        TagGenerator.addImport(elt, "javax.servlet.jsp.tagext.BodyTagSupport", false, allImports);
        TagGenerator.addImport(elt, "javax.servlet.jsp.tagext.BodyContent", false, allImports);
        TagGenerator.addImport(elt, "javax.servlet.jsp.JspException", false, allImports);
        TagGenerator.addImport(elt, "javax.servlet.jsp.JspWriter", false, allImports);
        TagGenerator.addImport(elt, "javax.servlet.jsp.PageContext", false, allImports);
        TagGenerator.addImport(elt, "javax.servlet.ServletRequest", false, allImports);
        TagGenerator.addImport(elt, "java.io.PrintWriter", false, allImports);
        TagGenerator.addImport(elt, "java.io.IOException", false, allImports);
    }

    public void addOtherImports(SourceElement elt) throws SourceException {
        Import[] allImports = elt.getImports();
        Enumeration en = this.otherImports.elements();
        while (en.hasMoreElements()) {
            String imp = (String)en.nextElement();
            TagGenerator.addImport(elt, imp, false, allImports);
        }
    }

    public static void addImport(SourceElement elt, String importLine, boolean isPackageImport, Import[] allImports) throws SourceException {
        importLine = importLine.trim();
        Identifier impName = Identifier.create((String)importLine, (String)importLine);
        Import imp = new Import(impName, isPackageImport);
        boolean alreadyAdded = false;
        if (allImports != null) {
            int i = 0;
            while (i < allImports.length) {
                if (imp.equals((Object)allImports[i])) {
                    alreadyAdded = true;
                }
                ++i;
            }
        }
        if (!alreadyAdded) {
            elt.addImport(imp);
        }
    }

    public String removeTrailingCR(String line) {
        return line;
    }

    public String generateDummyTagHandlerJavaFile() {
        StringBuffer buf = new StringBuffer(4096);
        this.generateDummyTagHandlerJavaFile(buf);
        return buf.toString();
    }

    public void generateDummyTagHandlerJavaFile(StringBuffer buf) {
        this.tag.ensureTagClassName();
        indent = 0;
        String packageName = this.tag.getPackageName();
        if (packageName != null && !packageName.equals("")) {
            TagGenerator.indentPrintln(buf, "package " + packageName + ";");
            TagGenerator.indentPrintln(buf, "");
        }
        this.generateDummyClassDeclaration(buf);
        TagGenerator.indentPrintln(buf, "");
        ++indent;
        this.generateDummyConstructor(buf);
        TagGenerator.indentPrintln(buf, "");
        this.generateDummyUserMethods(buf);
        this.generateDummyTagInterfaceMethods(buf);
        --indent;
        TagGenerator.indentPrintln(buf, "}");
    }

    public void generateDummyUserMethods(StringBuffer buf) {
        TagGenerator.indentPrintln(buf, "");
        TagGenerator.indentPrintln(buf, "////////////////////////////////////////////////////////////////");
        TagGenerator.indentPrintln(buf, "///                                                          ///");
        TagGenerator.indentPrintln(buf, "///   User methods.                                          ///");
        TagGenerator.indentPrintln(buf, "///                                                          ///");
        TagGenerator.indentPrintln(buf, "///   Modify these methods to customize your tag handler.    ///");
        TagGenerator.indentPrintln(buf, "///                                                          ///");
        TagGenerator.indentPrintln(buf, "////////////////////////////////////////////////////////////////");
        TagGenerator.indentPrintln(buf, "");
        TagGenerator.indentPrintln(buf, "");
        TagGenerator.indentPrintln(buf, "//");
        TagGenerator.indentPrintln(buf, "// methods called from doStartTag()");
        TagGenerator.indentPrintln(buf, "//");
        this.generateDummyUserMethod(buf, "otherDoStartTagOperations", "void");
        this.generateDummyUserMethod(buf, "theBodyShouldBeEvaluated", "boolean");
        TagGenerator.indentPrintln(buf, "");
        TagGenerator.indentPrintln(buf, "//");
        TagGenerator.indentPrintln(buf, "// methods called from doEndTag()");
        TagGenerator.indentPrintln(buf, "//");
        this.generateDummyUserMethod(buf, "otherDoEndTagOperations", "void");
        this.generateDummyUserMethod(buf, "shouldEvaluateRestOfPageAfterEndTag", "boolean");
    }

    public void generateDummyUserMethod(StringBuffer buf, String methodName, String returnType) {
        this.generateDummyUserMethod(buf, methodName, returnType, null, null);
    }

    public void generateDummyUserMethod(StringBuffer buf, String methodName, String returnType, String args, String throwsExceptions) {
        StringBuffer methodBody = new StringBuffer(1024);
        StringBuffer javadocBuf = new StringBuffer(512);
        TagGenerator.generateBodies(methodBody, javadocBuf, methodName);
        TagGenerator.indentPrint(buf, "/**\n" + this.javadocize(javadocBuf).toString());
        TagGenerator.indentPrintln(buf, " */");
        TagGenerator.indentPrint(buf, "public " + returnType + " " + methodName + "(");
        if (args != null) {
            TagGenerator.print(buf, args);
        }
        TagGenerator.print(buf, ") ");
        if (throwsExceptions != null) {
            TagGenerator.print(buf, throwsExceptions);
        }
        TagGenerator.println(buf, " {");
        TagGenerator.println(buf, methodBody.toString());
        TagGenerator.indentPrintln(buf, "}");
        TagGenerator.indentPrintln(buf, "");
    }

    public StringBuffer javadocize(StringBuffer buf) {
        return this.javadocize(buf, " * ");
    }

    public StringBuffer javadocize(StringBuffer buf, String prefix) {
        int bs = buf.length();
        char[] chars = new char[bs];
        buf.getChars(0, bs, chars, 0);
        StringBuffer result = new StringBuffer(2 * bs);
        TagGenerator.indentPrint(result, prefix);
        int i = 0;
        while (i < bs) {
            char ch = chars[i];
            result.append(ch);
            if (ch == '\n' && i + 1 < bs) {
                TagGenerator.indentPrint(result, prefix);
            }
            ++i;
        }
        return result;
    }

    public void generateDummyTagInterfaceMethods(StringBuffer buf) {
        TagGenerator.indentPrintln(buf, "");
        TagGenerator.indentPrintln(buf, "////////////////////////////////////////////////////////////////");
        TagGenerator.indentPrintln(buf, "///                                                          ///");
        TagGenerator.indentPrintln(buf, "///   Tag Handler interface methods.                         ///");
        TagGenerator.indentPrintln(buf, "///                                                          ///");
        TagGenerator.indentPrintln(buf, "///   Do not modify these methods; instead, modify the       ///");
        TagGenerator.indentPrintln(buf, "///   methods that they call.                                ///");
        TagGenerator.indentPrintln(buf, "///                                                          ///");
        TagGenerator.indentPrintln(buf, "////////////////////////////////////////////////////////////////");
        TagGenerator.indentPrintln(buf, "");
        TagGenerator.indentPrintln(buf, "");
        TagGenerator.indentPrintln(buf, "/**");
        TagGenerator.indentPrintln(buf, " * Dummy javadoc comment to get things started.");
        TagGenerator.indentPrintln(buf, " */");
        TagGenerator.indentPrintln(buf, "public int doStartTag() throws JspException {");
        ++indent;
        TagGenerator.indentPrintln(buf, "// Dummy body to get things going.");
        TagGenerator.indentPrintln(buf, "return SKIP_BODY;");
        --indent;
        TagGenerator.indentPrintln(buf, "}");
        TagGenerator.indentPrintln(buf, "");
        TagGenerator.indentPrintln(buf, "/**");
        TagGenerator.indentPrintln(buf, " * Dummy javadoc comment to get things started.");
        TagGenerator.indentPrintln(buf, " */");
        TagGenerator.indentPrintln(buf, "public int doEndTag() throws JspException {");
        ++indent;
        TagGenerator.indentPrintln(buf, "// Dummy body to get things going.");
        TagGenerator.indentPrintln(buf, "return SKIP_PAGE;");
        --indent;
        TagGenerator.indentPrintln(buf, "}");
    }

    public void generateDummyClassDeclaration(StringBuffer buf) {
        String superClass = this.findSuperClass(this.tag);
        String interfaceDecl = this.findInterface(this.tag);
        TagGenerator.indentPrintln(buf, "/**");
        TagGenerator.indentPrintln(buf, " *  Generated tag class.");
        TagGenerator.indentPrintln(buf, " */");
        TagGenerator.indentPrint(buf, "public class " + this.tag.getTagClassName());
        if (superClass != null && !superClass.equals("")) {
            TagGenerator.print(buf, " extends " + superClass);
        }
        if (interfaceDecl != null && !interfaceDecl.equals("")) {
            TagGenerator.print(buf, " implements " + interfaceDecl);
        }
        TagGenerator.println(buf, " {");
        TagGenerator.indentPrintln(buf, "");
    }

    public void generateDummyConstructor(StringBuffer buf) {
        TagGenerator.indentPrintln(buf, "public " + this.tag.getTagClassName() + "() {");
        ++indent;
        TagGenerator.indentPrintln(buf, "super();");
        --indent;
        TagGenerator.indentPrintln(buf, "}");
    }

    public String generateDummyTEIClass(String teiClassName) {
        StringBuffer buf = new StringBuffer(4096);
        this.generateDummyTEIClass(buf, teiClassName);
        return buf.toString();
    }

    public void generateDummyTEIClass(StringBuffer buf, String teiClassName) {
        int oldIndent = indent;
        indent = 0;
        this.generateDummyTEIHeader(buf, teiClassName);
        TagGenerator.indentPrintln(buf, "");
        this.generateDummyTEIDeclaration(buf, teiClassName);
        ++indent;
        TagGenerator.indentPrintln(buf, "");
        this.generateDummyTEIConstructor(buf, teiClassName);
        --indent;
        TagGenerator.indentPrintln(buf, "}");
    }

    public void generateDummyTEIHeader(StringBuffer buf, String teiClassName) {
        String packageName = this.tag.getPackageName();
        if (packageName != null && !packageName.equals("")) {
            TagGenerator.indentPrintln(buf, "package " + packageName + ";");
        }
    }

    public void generateDummyTEIImports(StringBuffer buf) {
        TagGenerator.indentPrintln(buf, "import javax.servlet.jsp.tagext.*;");
    }

    public void generateDummyTEIDeclaration(StringBuffer buf, String teiClassName) {
        TagGenerator.indentPrintln(buf, "/**");
        TagGenerator.indentPrintln(buf, " * A TagExtraInfo class for the tag " + this.tag.getTagName());
        TagGenerator.indentPrintln(buf, " */");
        TagGenerator.indentPrintln(buf, "public class " + teiClassName + " extends TagExtraInfo { ");
    }

    public void generateDummyTEIConstructor(StringBuffer buf, String teiClassName) {
        TagGenerator.indentPrintln(buf, "public " + teiClassName + "() {");
        ++indent;
        TagGenerator.indentPrintln(buf, "super();");
        --indent;
        TagGenerator.indentPrintln(buf, "}");
    }

    public void generateAttributeProperty(ClassElement declaringClass, TagAttributeInfoData tagatt, String typeString, String fullTypeString, String initValue) throws SourceException {
        String attributeName = tagatt.getName();
        String attributeVariable = tagatt.ensureJavaVariableName();
        Type type = TagGenerator.getTypeFromString(typeString, fullTypeString);
        String attributeJavadocComment = "property declaration for tag attribute: " + tagatt.getName() + ".\n";
        this.markAttributePropertyLocation(declaringClass);
        FieldElement field = TagGenerator.generatePropertyField(declaringClass, attributeVariable, type, initValue, true, attributeJavadocComment);
        MethodElement getter = TagGenerator.generateGetterMethod(declaringClass, attributeName, attributeVariable, type, false, null);
        this.setLatestAttributeProperty((Element)getter);
        MethodElement setter = TagGenerator.generateSetterMethod(declaringClass, attributeName, attributeVariable, type, false, false, null);
        this.setLatestAttributeProperty((Element)setter);
    }

    public static Type getTypeFromString(String typeString, String fullyQualifiedTypeString) {
        Type t = Type.createClass((Identifier)Identifier.create((String)fullyQualifiedTypeString, (String)typeString));
        return t;
    }

    public void setLatestUserMethod(Element elt) {
        this.latestUserMethod = elt;
    }

    public void markUserMethodLocation(ClassElement declaringClass) {
        if (this.latestUserMethod == null) {
            Type[] argumentTypes = this.getUserBodyWritingMethodTypes();
            Identifier name = Identifier.create((String)this.getUserBodyWritingMethodName());
            MethodElement ubm = declaringClass.getMethod(name, argumentTypes);
            if (ubm != null) {
                this.setLatestUserMethod((Element)ubm);
            } else {
                Type[] noArgs = new Type[]{};
                Identifier tbname = Identifier.create((String)"theBodyShouldBeEvaluatedAgain");
                MethodElement tbsbea = declaringClass.getMethod(tbname, noArgs);
                if (tbsbea != null) {
                    this.setLatestUserMethod((Element)tbsbea);
                }
            }
        }
        if (this.latestUserMethod != null) {
            this.latestUserMethod.markCurrent(true);
        }
    }

    public void setLatestAttributeProperty(Element elt) {
        this.latestAttributeProperty = elt;
    }

    public void markAttributePropertyLocation(ClassElement declaringClass) {
        if (this.latestAttributeProperty == null) {
            Type[] noArgs = new Type[]{};
            Identifier dabname = Identifier.create((String)"doAfterBody");
            MethodElement dab = declaringClass.getMethod(dabname, noArgs);
            if (dab != null) {
                this.setLatestAttributeProperty((Element)dab);
            } else {
                Identifier detname = Identifier.create((String)"doEndTag");
                MethodElement det = declaringClass.getMethod(detname, noArgs);
                if (det != null) {
                    this.setLatestAttributeProperty((Element)det);
                }
            }
        }
        if (this.latestAttributeProperty != null) {
            this.latestAttributeProperty.markCurrent(true);
        }
    }

    public static MethodElement generateMethod(ClassElement declaringClass, Identifier methodName, Type type, Type[] argumentTypes, String[] argumentNames, boolean replaceBody, String body, boolean replaceJavadoc, String javadocComment) throws SourceException {
        JavaDoc.Method jd;
        if (argumentTypes == null) {
            argumentTypes = new Type[]{};
        }
        if (argumentNames == null) {
            argumentNames = new String[]{};
        }
        MethodElement newMethod = declaringClass.getMethod(methodName, argumentTypes);
        boolean newlyCreatedMethod = false;
        if (newMethod == null) {
            newMethod = new MethodElement();
            newMethod.setName(methodName);
            newMethod.setReturn(type);
            newMethod.setModifiers(1);
            MethodParameter[] params = new MethodParameter[argumentTypes.length];
            int i = 0;
            while (i < params.length) {
                params[i] = new MethodParameter(argumentNames[i], argumentTypes[i], false);
                ++i;
            }
            newMethod.setParameters(params);
            if (declaringClass == null) {
                throw new SourceException();
            }
            jd = newMethod.getJavaDoc();
            declaringClass.addMethod(newMethod);
            jd = newMethod.getJavaDoc();
            newMethod = declaringClass.getMethod(methodName, argumentTypes);
            jd = newMethod.getJavaDoc();
            newlyCreatedMethod = true;
        }
        if (newlyCreatedMethod || replaceBody) {
            if (declaringClass.isInterface()) {
                newMethod.setBody(null);
            } else if (body != null) {
                newMethod.setBody(body);
            }
        }
        if (javadocComment != null && (newlyCreatedMethod || replaceJavadoc) && (jd = newMethod.getJavaDoc()) != null) {
            jd.setRawText(javadocComment);
        }
        return newMethod;
    }

    public static void addException(MethodElement meth, String sourceName, String fullName) throws SourceException {
        if (fullName == null) {
            fullName = sourceName;
        }
        Identifier ex = Identifier.create((String)fullName, (String)sourceName);
        Identifier[] currentExceptions = meth.getExceptions();
        int i = 0;
        while (i < currentExceptions.length) {
            if (ex.equals((Object)currentExceptions[i])) {
                return;
            }
            ++i;
        }
        Identifier[] newExceptions = new Identifier[currentExceptions.length + 1];
        int i2 = 0;
        while (i2 < currentExceptions.length) {
            newExceptions[i2] = currentExceptions[i2];
            ++i2;
        }
        newExceptions[currentExceptions.length] = ex;
        meth.setExceptions(newExceptions);
    }

    public static MethodElement generateGetterMethod(ClassElement declaringClass, String propertyName, Type type, boolean replaceJavadoc, String javadocComment) throws SourceException {
        return TagGenerator.generateGetterMethod(declaringClass, propertyName, propertyName, type, replaceJavadoc, javadocComment);
    }

    public static MethodElement generateGetterMethod(ClassElement declaringClass, String propertyName, String variableName, Type type, boolean replaceJavadoc, String javadocComment) throws SourceException {
        String methodName = (type == Type.BOOLEAN ? "is" : "get") + TagGenerator.capitalizeFirstLetter(propertyName);
        Type[] argumentTypes = new Type[]{};
        String[] argumentNames = new String[]{};
        String propertyField = Introspector.decapitalize(variableName);
        StringBuffer methodBody = new StringBuffer(128);
        TagGenerator.indentPrintln(methodBody, "");
        TagGenerator.indentPrintln(methodBody, "return " + propertyField + ";");
        MethodElement[] methods = declaringClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            try {
                if (methods[i].getName().getName().equals(methodName) && methods[i].getBody().trim().equals(methodBody.toString().trim())) {
                    declaringClass.removeMethod(methods[i]);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
        MethodElement getter = TagGenerator.generateMethod(declaringClass, Identifier.create((String)methodName), type, argumentTypes, argumentNames, false, methodBody.toString(), replaceJavadoc, javadocComment);
        propertyMethods.addElement(methodName);
        return getter;
    }

    public static MethodElement generateSetterMethod(ClassElement declaringClass, String propertyName, Type type, boolean constrained, boolean replaceJavadoc, String javadocComment) throws SourceException {
        return TagGenerator.generateSetterMethod(declaringClass, propertyName, type, constrained, replaceJavadoc, javadocComment);
    }

    public static MethodElement generateSetterMethod(ClassElement declaringClass, String propertyName, String variableName, Type type, boolean constrained, boolean replaceJavadoc, String javadocComment) throws SourceException {
        String methodName = "set" + TagGenerator.capitalizeFirstLetter(propertyName);
        Type returnType = Type.VOID;
        Type[] argumentTypes = new Type[1];
        String[] argumentNames = new String[1];
        argumentTypes[0] = type;
        argumentNames[0] = "value";
        String propertyField = Introspector.decapitalize(variableName);
        StringBuffer methodBody = new StringBuffer(128);
        TagGenerator.indentPrintln(methodBody, "");
        if (propertyField.equals("value")) {
            propertyField = "this." + propertyField;
        }
        TagGenerator.indentPrintln(methodBody, propertyField + " = value;");
        MethodElement[] methods = declaringClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            try {
                if (methods[i].getName().getName().equals(methodName) && methods[i].getBody().trim().equals(methodBody.toString().trim())) {
                    declaringClass.removeMethod(methods[i]);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
        MethodElement setter = TagGenerator.generateMethod(declaringClass, Identifier.create((String)methodName), returnType, argumentTypes, argumentNames, false, methodBody.toString(), replaceJavadoc, javadocComment);
        propertyMethods.addElement(methodName);
        return setter;
    }

    public static FieldElement generatePropertyField(ClassElement declaringClass, String propertyName, Type type, String initValue, boolean replaceJavadoc, String javadocComment) throws SourceException {
        Identifier fieldName = Identifier.create((String)Introspector.decapitalize(propertyName));
        FieldElement result = TagGenerator.ensureGenerateField(declaringClass, fieldName, type, replaceJavadoc, javadocComment);
        if (initValue != null) {
            result.setInitValue(initValue);
        }
        propertyFields.addElement(fieldName);
        return result;
    }

    public static FieldElement ensureGenerateField(ClassElement declaringClass, String fieldName, String typeStr, String fullTypeStr, boolean replaceJavadoc, String javadocComment) throws SourceException {
        return TagGenerator.ensureGenerateField(declaringClass, Identifier.create((String)fieldName), TagGenerator.getTypeFromString(typeStr, fullTypeStr), replaceJavadoc, javadocComment);
    }

    public static FieldElement ensureGenerateField(ClassElement declaringClass, Identifier fieldName, Type type, boolean replaceJavadoc, String javadocComment) throws SourceException {
        FieldElement newField = declaringClass.getField(fieldName);
        boolean newlyCreatedField = false;
        if (newField == null) {
            newField = new FieldElement();
            newField.setName(fieldName);
            newField.setType(type);
            if (declaringClass == null) {
                throw new SourceException();
            }
            declaringClass.addField(newField);
            newField = declaringClass.getField(fieldName);
            newlyCreatedField = true;
        }
        try {
            JavaDoc.Field jd;
            newField.setType(type);
            newField.setModifiers(2);
            if (javadocComment != null && (newlyCreatedField || replaceJavadoc) && (jd = newField.getJavaDoc()) != null) {
                jd.setRawText(javadocComment);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return newField;
    }

    public static String capitalizeFirstLetter(String str) {
        if (str == null || str.length() <= 0) {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String capitalize(String str) {
        if (str == null || str.length() < 1) {
            return str;
        }
        int len = str.length();
        char[] chars = new char[len];
        str.getChars(0, len, chars, 0);
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String decapitalize(String str) {
        if (str == null || str.length() < 1) {
            return str;
        }
        int len = str.length();
        char[] chars = new char[len];
        str.getChars(0, len, chars, 0);
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    static Type[] getParameterTypes(MethodElement methodElement) {
        MethodParameter[] params = methodElement.getParameters();
        Type[] types = new Type[params == null ? 0 : params.length];
        int i = 0;
        while (i < params.length) {
            types[i] = params[i].getType();
            ++i;
        }
        return types;
    }

    public static void dumpClass(ClassElement cl) {
        StringBuffer buf = new StringBuffer(2048);
        TagGenerator.dumpClass(buf, cl);
        System.out.println(buf.toString());
    }

    public static void dumpClass(StringBuffer buf, ClassElement cl) {
        if (cl == null) {
            buf.append("null");
            return;
        }
        int oldIndent = indent;
        indent = 0;
        String superName = cl.getSuperclass() == null ? "null" : cl.getSuperclass().getName();
        Identifier[] interfaces = cl.getInterfaces();
        String implementsStr = "";
        if (interfaces != null && interfaces.length > 0) {
            implementsStr = implementsStr + " implements ";
            int i = 0;
            while (i < interfaces.length) {
                implementsStr = implementsStr + interfaces[i] + " ";
                ++i;
            }
        }
        TagGenerator.indentPrintln(buf, "Class: " + cl.getName() + " extends " + superName + implementsStr + "{");
        ++indent;
        TagGenerator.indentPrintln(buf, "Fields:");
        FieldElement[] fields = cl.getFields();
        if (fields != null) {
            ++indent;
            int i = 0;
            while (i < fields.length) {
                TagGenerator.dumpField(buf, fields[i]);
                ++i;
            }
            --indent;
        } else {
            TagGenerator.indentPrintln(buf, "<null fields>");
        }
        TagGenerator.indentPrintln(buf, "Methods:");
        MethodElement[] methods = cl.getMethods();
        if (methods != null) {
            ++indent;
            int i = 0;
            while (i < methods.length) {
                TagGenerator.dumpMethod(buf, methods[i]);
                ++i;
            }
            --indent;
        } else {
            TagGenerator.indentPrintln(buf, "<null methods>");
        }
        --indent;
        TagGenerator.indentPrintln(buf, "}");
        indent = oldIndent;
    }

    public static void dumpField(StringBuffer buf, FieldElement field) {
        TagGenerator.indentPrintln(buf, field.getType() + " " + field.getName());
    }

    public static String dumpMethod(MethodElement method) {
        StringBuffer buf = new StringBuffer(128);
        TagGenerator.dumpMethod(buf, method);
        return buf.toString();
    }

    public static void dumpMethod(StringBuffer buf, MethodElement method) {
        TagGenerator.indentPrint(buf, method.getReturn() + " " + method.getName() + "( ");
        MethodParameter[] parms = method.getParameters();
        int j = 0;
        while (j < parms.length) {
            Type ptype = parms[j].getType();
            TagGenerator.print(buf, ptype.getSourceString() + ":::" + ptype.getFullString() + " " + parms[j].getName());
            if (j + 1 < parms.length) {
                TagGenerator.print(buf, ", ");
            }
            ++j;
        }
        TagGenerator.println(buf, " )");
    }

    public static void indentPrint(StringBuffer buf, String thing) {
        int i = 0;
        while (i < indent) {
            buf.append(indentString);
            ++i;
        }
        buf.append(thing);
    }

    public static void indentPrintln(StringBuffer buf, String thing) {
        TagGenerator.indentPrint(buf, thing);
        buf.append('\n');
    }

    public static void print(StringBuffer buf, String thing) {
        buf.append(thing);
    }

    public static void println(StringBuffer buf, String thing) {
        TagGenerator.print(buf, thing);
        buf.append('\n');
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        tagInterfaceIdentifier = Identifier.create((String)"Tag", (String)"javax.servlet.jsp.tagext.Tag");
        iterationTagInterfaceIdentifier = Identifier.create((String)"IterationTag", (String)"javax.servlet.jsp.tagext.IterationTag");
        bodyTagInterfaceIdentifier = Identifier.create((String)"BodyTag", (String)"javax.servlet.jsp.tagext.BodyTag");
        tagSupportIdentifier = Identifier.create((String)"TagSupport", (String)"javax.servlet.jsp.tagext.TagSupport");
        bodyTagSupportIdentifier = Identifier.create((String)"BodyTagSupport", (String)"javax.servlet.jsp.tagext.BodyTagSupport");
        tryCatchFinallyIdentifier = Identifier.create((String)"TryCatchFinally", (String)"javax.servlet.jsp.tagext.TryCatchFinally");
        indent = 0;
        indentString = "    ";
    }
}

