/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglibed.control;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.text.Caret;
import org.netbeans.api.java.classpath.ClassPath;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.RepositoryNodeFactory;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.enum.SequenceEnumeration;
import org.openide.util.enum.SingletonEnumeration;

final class DataFolderSelectionPanel
extends JPanel
implements DocumentListener,
DataFilter,
PropertyChangeListener,
VetoableChangeListener {
    private static MessageFormat defaultPackageName;
    private ChangeListener listener;
    private Reference system = new WeakReference<Object>(null);
    private Node rootNode;
    static Dimension PREF_DIM;
    private ResourceBundle resBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDDataObject == null ? (class$org$netbeans$modules$web$taglibed$TLDDataObject = DataFolderSelectionPanel.class$("org.netbeans.modules.web.taglibed.TLDDataObject")) : class$org$netbeans$modules$web$taglibed$TLDDataObject));
    private JPanel namePanel;
    private JLabel jLabel1;
    private JTextField packageName;
    private ExplorerPanel packagesPanel;
    private JPanel folderNamePanel;
    private JLabel jLabel2;
    private JTextField folderName;
    private BeanTreeView beanTreeView;
    private JLabel descriptionLabel;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$TLDDataObject;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$control$DataFolderSelectionPanel;

    public DataFolderSelectionPanel() {
        this.initComponents();
        this.setName(this.resBundle.getString("TLD_DataFolderSelectionName"));
        this.setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
        this.packagesPanel.setBorder(new CompoundBorder(new TitledBorder(this.resBundle.getString("TLD_SelectPackageBorder")), new EmptyBorder(new Insets(8, 8, 8, 8))));
        this.rootNode = this.createPackagesNode();
        this.packagesPanel.getExplorerManager().setRootContext(this.rootNode);
        this.packagesPanel.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
        this.packagesPanel.getExplorerManager().addVetoableChangeListener((VetoableChangeListener)this);
        this.folderName.getDocument().addDocumentListener(this);
        this.folderName.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this.packageName.getDocument().addDocumentListener(this);
        this.packageName.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this.descriptionLabel.setText(this.resBundle.getString("TLD_TargetLocationDescription"));
    }

    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    public void requestFocus() {
        this.packageName.requestFocus();
        this.packageName.selectAll();
    }

    public void initSettings(Entries entry) {
        this.packageName.setText(entry.getPakName());
        this.requestFocus();
        this.setTargetFolder(entry.getDf());
    }

    public Entries getSettings() {
        String cn = this.packageName.getText();
        String pn = this.folderName.getText();
        DataFolder df = null;
        Node[] arr = this.packagesPanel.getExplorerManager().getSelectedNodes();
        if (arr.length == 1) {
            df = (DataFolder)arr[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = DataFolderSelectionPanel.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
        }
        Entries entry = new Entries();
        entry.setPakName(cn);
        entry.setFolderName(pn);
        entry.setDf(df);
        return entry;
    }

    private Node createPackagesNode() {
        return RepositoryNodeFactory.getDefault().repository((DataFilter)this);
    }

    private void initComponents() {
        this.namePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.packageName = new JTextField();
        this.packagesPanel = new ExplorerPanel();
        this.folderNamePanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.folderName = new JTextField();
        this.beanTreeView = new BeanTreeView();
        this.descriptionLabel = new JLabel();
        this.setLayout(new BorderLayout(0, 8));
        this.namePanel.setLayout(new GridBagLayout());
        this.jLabel1.setText(this.resBundle.getString("TLD_TemplateClassName"));
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(0, 0, 0, 8);
        gridBagConstraints1.anchor = 17;
        this.namePanel.add((Component)this.jLabel1, gridBagConstraints1);
        this.packageName.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                DataFolderSelectionPanel.this.packageNameFocusGained(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        this.namePanel.add((Component)this.packageName, gridBagConstraints1);
        this.add((Component)this.namePanel, "North");
        this.packagesPanel.setLayout(new BorderLayout(0, 8));
        this.folderNamePanel.setLayout(new GridBagLayout());
        this.jLabel2.setText(this.resBundle.getString("TLD_TemplatePackageName"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        this.folderNamePanel.add((Component)this.jLabel2, gridBagConstraints2);
        this.folderName.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                DataFolderSelectionPanel.this.folderNameFocusGained(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 8, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        this.folderNamePanel.add((Component)this.folderName, gridBagConstraints2);
        this.packagesPanel.add((Component)this.folderNamePanel, "South");
        this.beanTreeView.setPopupAllowed(false);
        this.packagesPanel.add((Component)this.beanTreeView, "Center");
        this.packagesPanel.add((Component)this.descriptionLabel, "North");
        this.add((Component)this.packagesPanel, "Center");
    }

    private void folderNameFocusGained(FocusEvent evt) {
        this.folderName.selectAll();
    }

    private void packageModelChanged(ListDataEvent evt) {
    }

    private void packageNameFocusGained(FocusEvent evt) {
        this.packageName.selectAll();
    }

    private void DataFolderSelectionTreeValueChanged(TreeSelectionEvent evt) {
    }

    public boolean acceptDataObject(DataObject obj) {
        return obj instanceof DataFolder;
    }

    public void vetoableChange(PropertyChangeEvent ev) throws PropertyVetoException {
        Node[] arr;
        if ("selectedNodes".equals(ev.getPropertyName()) && (arr = this.packagesPanel.getExplorerManager().getSelectedNodes()).length > 1) {
            throw new PropertyVetoException(this.resBundle.getString("TLD_DataFolderSelectionPanel.Only_single_selection_allowed"), ev);
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if ("selectedNodes".equals(ev.getPropertyName())) {
            DataFolder df;
            Node[] arr = this.packagesPanel.getExplorerManager().getSelectedNodes();
            if (arr.length == 1 && (df = (DataFolder)arr[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = DataFolderSelectionPanel.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder)) != null) {
                this.setTargetFolder(df);
                return;
            }
            this.setTargetFolder((DataFolder)null);
        }
    }

    private void fireStateChanged() {
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    public void changedUpdate(DocumentEvent p1) {
        if (p1.getDocument() == this.folderName.getDocument()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String text = DataFolderSelectionPanel.this.folderName.getText();
                    if (text != null) {
                        DataFolderSelectionPanel.this.setTargetFolder(text);
                    }
                }
            });
            return;
        }
        if (p1.getDocument() == this.packageName.getDocument()) {
            this.fireStateChanged();
        }
    }

    public void removeUpdate(DocumentEvent p1) {
        if (p1.getDocument() == this.folderName.getDocument()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FileSystem fs;
                    if (DataFolderSelectionPanel.this.folderName.getText().length() == 0 && (fs = (FileSystem)DataFolderSelectionPanel.this.system.get()) != null) {
                        DataFolder df = DataFolder.findFolder((FileObject)fs.getRoot());
                        DataFolderSelectionPanel.this.setTargetFolder(df);
                        DataFolderSelectionPanel.this.folderName.selectAll();
                    }
                }
            });
        }
        if (p1.getDocument() == this.packageName.getDocument()) {
            this.fireStateChanged();
        }
    }

    public void insertUpdate(DocumentEvent p1) {
        this.changedUpdate(p1);
    }

    public Component getComponent() {
        return this;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(class$org$netbeans$modules$web$taglibed$control$DataFolderSelectionPanel == null ? (class$org$netbeans$modules$web$taglibed$control$DataFolderSelectionPanel = DataFolderSelectionPanel.class$("org.netbeans.modules.web.taglibed.control.DataFolderSelectionPanel")) : class$org$netbeans$modules$web$taglibed$control$DataFolderSelectionPanel);
    }

    public boolean isValid() {
        Node[] arr;
        if (!Utilities.isJavaIdentifier((String)this.packageName.getText())) {
            return false;
        }
        String text = this.folderName.getText();
        if (text.length() == 0 && (arr = this.packagesPanel.getExplorerManager().getSelectedNodes()).length == 1 && arr[0] == this.rootNode) {
            return false;
        }
        if (text.equals(DataFolderSelectionPanel.defaultPackageName((FileSystem)this.system.get()))) {
            return true;
        }
        StringTokenizer tok = new StringTokenizer(text, ".");
        while (tok.hasMoreElements()) {
            String pkg = tok.nextToken();
            if (Utilities.isJavaIdentifier((String)pkg)) continue;
            return false;
        }
        return true;
    }

    public void addChangeListener(ChangeListener l) {
        if (this.listener != null) {
            throw new IllegalStateException();
        }
        this.listener = l;
    }

    public void removeChangeListener(ChangeListener l) {
        this.listener = null;
    }

    private static String computeSuggestion(Node node, String pref, Node[] first) {
        Node[] arr = node.getChildren().getNodes();
        String match = null;
        int i = 0;
        while (i < arr.length) {
            String name = arr[i].getName();
            if (name.startsWith(pref)) {
                if (match == null) {
                    match = name;
                    first[0] = arr[i];
                } else {
                    int indx = pref.length();
                    int end = Math.min(name.length(), match.length());
                    while (indx < end && match.charAt(indx) == name.charAt(indx)) {
                        ++indx;
                    }
                    match = match.substring(0, indx);
                }
            }
            ++i;
        }
        if (match == null || match.length() == pref.length()) {
            return null;
        }
        return match.substring(pref.length());
    }

    private boolean setTargetFolder(DataFolder f) {
        boolean exact;
        Node n;
        String name;
        if (f != null) {
            FileObject fo = f.getPrimaryFile();
            name = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile").getResourceName(fo, '.', false);
            StringTokenizer st = new StringTokenizer(name, ".");
            try {
                FileSystem fs = fo.getFileSystem();
                if (fo.isRoot()) {
                    name = DataFolderSelectionPanel.defaultPackageName(fs);
                }
                this.system = new WeakReference<FileSystem>(fs);
                SequenceEnumeration en = new SequenceEnumeration((Enumeration)new SingletonEnumeration((Object)fs.getSystemName()), (Enumeration)st);
                n = NodeOp.findPath((Node)this.rootNode, (Enumeration)en);
                exact = true;
            }
            catch (FileStateInvalidException ex) {
                n = this.rootNode;
                name = "";
                exact = false;
            }
            catch (NodeNotFoundException ex) {
                n = ex.getClosestNode();
                DataFolder df = (DataFolder)n.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = DataFolderSelectionPanel.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
                if (df != null) {
                    FileObject dfo = df.getPrimaryFile();
                    name = ClassPath.getClassPath((FileObject)dfo, (String)"classpath/compile").getResourceName(dfo, '.', false);
                } else {
                    name = "";
                }
                exact = false;
            }
        } else {
            n = this.rootNode;
            name = null;
            exact = true;
        }
        ExplorerManager em = this.packagesPanel.getExplorerManager();
        em.removePropertyChangeListener((PropertyChangeListener)this);
        this.folderName.getDocument().removeDocumentListener(this);
        try {
            em.setSelectedNodes(new Node[]{n});
        }
        catch (PropertyVetoException ex) {
            throw new InternalError();
        }
        this.folderName.setText(name);
        this.folderName.getDocument().addDocumentListener(this);
        em.addPropertyChangeListener((PropertyChangeListener)this);
        this.fireStateChanged();
        return exact;
    }

    private boolean setTargetFolder(String f) {
        Node n = null;
        NodeNotFoundException closest = null;
        Node[] arr = this.rootNode.getChildren().getNodes();
        int i = 0;
        while (i < arr.length) {
            Node root = arr[i];
            StringTokenizer st = new StringTokenizer(f, ".");
            try {
                n = NodeOp.findPath((Node)root, (Enumeration)st);
                break;
            }
            catch (NodeNotFoundException ex) {
                if (closest == null && !st.hasMoreElements()) {
                    closest = ex;
                }
                ++i;
            }
        }
        if (n != null) {
            closest = null;
        } else {
            if (closest == null) {
                return false;
            }
            n = closest.getClosestNode();
        }
        ExplorerManager em = this.packagesPanel.getExplorerManager();
        em.removePropertyChangeListener((PropertyChangeListener)this);
        if (closest != null) {
            Node[] first = new Node[1];
            String sugg = DataFolderSelectionPanel.computeSuggestion(closest.getClosestNode(), closest.getMissingChildName(), first);
            if (sugg != null) {
                this.folderName.getDocument().removeDocumentListener(this);
                this.folderName.setText(f + sugg);
                Caret c = this.folderName.getCaret();
                c.setDot(f.length() + sugg.length());
                c.moveDot(f.length());
                this.folderName.getDocument().addDocumentListener(this);
            }
            if (first[0] != null) {
                n = first[0];
            }
        }
        try {
            em.setSelectedNodes(new Node[]{n});
        }
        catch (PropertyVetoException ex) {
            throw new InternalError();
        }
        DataFolder df = (DataFolder)n.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = DataFolderSelectionPanel.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
        if (df != null) {
            try {
                FileSystem fs = df.getPrimaryFile().getFileSystem();
                this.system = new WeakReference<FileSystem>(fs);
            }
            catch (FileStateInvalidException ex) {
                // empty catch block
            }
        }
        em.addPropertyChangeListener((PropertyChangeListener)this);
        this.fireStateChanged();
        return closest == null;
    }

    private static String defaultPackageName(FileSystem fs) {
        ResourceBundle resBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDDataObject == null ? (class$org$netbeans$modules$web$taglibed$TLDDataObject = DataFolderSelectionPanel.class$("org.netbeans.modules.web.taglibed.TLDDataObject")) : class$org$netbeans$modules$web$taglibed$TLDDataObject));
        String n = fs == null ? "" : fs.getDisplayName();
        MessageFormat msg = new MessageFormat(resBundle.getString("TLD_DataFolderSelectionPanel.default_package"));
        Object[] obj = new Object[]{n};
        return msg.format(obj);
    }

    private void debug(String s) {
        System.out.println("## " + s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PREF_DIM = new Dimension(600, 300);
    }

    static class Entries {
        private String pakName;
        private String folderName;
        FileSystem fs = null;
        DataFolder df = null;
        FileObject fo = null;

        Entries() {
        }

        public void setPakName(String n) {
            this.pakName = n;
        }

        public void setFolderName(String n) {
            this.folderName = n;
        }

        public void setFs(FileSystem f) {
            this.fs = f;
            this.setFolder();
            this.setFileObject();
        }

        public String getPakName() {
            return this.pakName;
        }

        public String getFolderName() {
            return this.folderName;
        }

        public FileSystem getFs() {
            return this.fs;
        }

        public void setFolder() {
            if (this.fs != null) {
                this.df = DataFolder.findFolder((FileObject)this.fs.getRoot());
            }
        }

        public void setFileObject() {
            if (this.df != null) {
                this.fo = this.df.getPrimaryFile();
            }
        }

        public void setDf(DataFolder f) {
            this.df = f;
            this.setFileObject();
            try {
                this.fs = this.fo.getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                this.fs = null;
            }
        }

        public DataFolder getDf() {
            return this.df;
        }

        public void debug() {
            System.out.println("## Entries: debug output begin----------");
            System.out.println("## pakName=" + this.pakName + " -- fs.getDisplayName=" + this.fs.getDisplayName() + " -- fs.getSystemName=" + this.fs.getSystemName() + " -- fs.toString=" + this.fs.toString());
            System.out.println("## df.getName=" + this.df.getName());
            System.out.println("## fo.getPackageName=" + ClassPath.getClassPath((FileObject)this.fo, (String)"classpath/compile").getResourceName(this.fo, File.separatorChar, false));
            System.out.println("## folderName=" + this.folderName);
            System.out.println("##  Entries: debug output end-----------");
        }
    }
}

