/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglibed.control;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JMenuItem;
import org.netbeans.modules.web.taglibed.TLDDataObject;
import org.netbeans.modules.web.taglibed.codegen.TEIGenerator;
import org.netbeans.modules.web.taglibed.codegen.TagGenerator;
import org.netbeans.modules.web.taglibed.control.IDEHelper;
import org.netbeans.modules.web.taglibed.control.TldActionSupport;
import org.netbeans.modules.web.taglibed.model.TLDException;
import org.netbeans.modules.web.taglibed.model.TagInfoData;
import org.netbeans.modules.web.taglibed.model.TagLibraryInfoData;
import org.netbeans.modules.web.taglibed.view.TLDNode;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.src.Identifier;
import org.openide.src.SourceElement;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.TopComponent;

public class GenerateCodeAction
extends CallableSystemAction {
    private static TLDNode tldNode;
    private static int numFilesGenerated;
    private static Vector generatedFiles;
    private static Node[] selectedNodes;
    private static Node target;
    ResourceBundle resBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDDataObject == null ? (class$org$netbeans$modules$web$taglibed$TLDDataObject = GenerateCodeAction.class$("org.netbeans.modules.web.taglibed.TLDDataObject")) : class$org$netbeans$modules$web$taglibed$TLDDataObject));
    private static boolean openGeneratedTagsInEditor;
    public static boolean displayGeneratedFilesAsDialog;
    private static final boolean debug = false;
    private static final boolean debugdetail = false;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$TLDDataObject;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$control$GenerateCodeAction;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$control$TldActionSupport;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

    public GenerateCodeAction() {
        this.setupMnemonics();
    }

    public void setupMnemonics() {
        JMenuItem popupPresenter;
        char mnemonic = this.getMnemonic(this.resBundle, "TLD_GenerateCodeAction.Mnemonic_Generate_Tag_Handlers");
        JMenuItem menuPresenter = this.getMenuPresenter();
        if (menuPresenter != null) {
            menuPresenter.setMnemonic(mnemonic);
        }
        if ((popupPresenter = this.getPopupPresenter()) != null) {
            popupPresenter.setMnemonic(mnemonic);
        }
    }

    public void addNotify() {
        this.setupMnemonics();
        super.addNotify();
    }

    public char getMnemonic(ResourceBundle resBundle, String key) {
        String mnemonicString = resBundle.getString(key).trim();
        return mnemonicString.charAt(0);
    }

    public String getName() {
        return this.resBundle.getString("TLD_GenerateCodeAction.Generate_Tag_Handlers");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$web$taglibed$control$GenerateCodeAction == null ? (class$org$netbeans$modules$web$taglibed$control$GenerateCodeAction = GenerateCodeAction.class$("org.netbeans.modules.web.taglibed.control.GenerateCodeAction")) : class$org$netbeans$modules$web$taglibed$control$GenerateCodeAction);
    }

    protected String iconResource() {
        return null;
    }

    public void performAction() {
        boolean forceGenerateAll = false;
        GenerateCodeAction.generateTagHandlers(forceGenerateAll);
    }

    public static void generateTagHandlers(boolean forceGenerateAll) {
        selectedNodes = TopComponent.getRegistry().getActivatedNodes();
        GenerateCodeAction.generateTagHandlers(selectedNodes, forceGenerateAll);
    }

    public static void generateTagHandlers(Node[] selectedNodes, boolean forceGenerateAll) {
        tldNode = null;
        numFilesGenerated = 0;
        GenerateCodeAction.resetGeneratedFiles();
        TLDDataObject tldDo = null;
        if (selectedNodes != null && selectedNodes.length > 0) {
            int i = 0;
            while (i < selectedNodes.length) {
                target = selectedNodes[i];
                TldActionSupport cookie = (TldActionSupport)target.getCookie(class$org$netbeans$modules$web$taglibed$control$TldActionSupport == null ? GenerateCodeAction.class$("org.netbeans.modules.web.taglibed.control.TldActionSupport") : class$org$netbeans$modules$web$taglibed$control$TldActionSupport);
                if (cookie != null) {
                    tldNode = cookie.getTldNode();
                }
                if (cookie != null) {
                    FileObject root;
                    if (cookie.getType() == 0) {
                        tldDo = cookie.getTLDDataObject();
                        FileObject fo = tldDo.getPrimaryFile();
                        root = fo.getParent();
                        TagLibraryInfoData taglib = cookie.getTaglib();
                        Vector alltags = taglib.getTagsVector();
                        root = IDEHelper.ensureTagHandlerGenerationRootIsMounted(root, taglib);
                        GenerateCodeAction.generateTagHandlers(tldDo, alltags, root, forceGenerateAll);
                    } else if (cookie.getType() == 2) {
                        Node parent;
                        TagInfoData tag = cookie.getTag();
                        target = parent = target.getParentNode();
                        cookie = (TldActionSupport)target.getCookie(class$org$netbeans$modules$web$taglibed$control$TldActionSupport == null ? GenerateCodeAction.class$("org.netbeans.modules.web.taglibed.control.TldActionSupport") : class$org$netbeans$modules$web$taglibed$control$TldActionSupport);
                        tldDo = cookie.getTLDDataObject();
                        FileObject fo = tldDo.getPrimaryFile();
                        root = fo.getParent();
                        Vector<TagInfoData> singleTag = new Vector<TagInfoData>();
                        singleTag.addElement(tag);
                        root = IDEHelper.ensureTagHandlerGenerationRootIsMounted(root, tag.getTaglib());
                        GenerateCodeAction.generateTagHandlers(tldDo, singleTag, root, forceGenerateAll);
                    }
                }
                ++i;
            }
            GenerateCodeAction.displayGeneratedFiles("");
        }
    }

    public static void generateCode(TLDDataObject tldDo) {
        boolean forceGenerateAll = true;
        FileObject fo = tldDo.getPrimaryFile();
        FileObject root = fo.getParent();
        TagLibraryInfoData taglib = tldDo.getTaglib();
        Vector alltags = taglib.getTagsVector();
        root = IDEHelper.ensureTagHandlerGenerationRootIsMounted(root, taglib);
        GenerateCodeAction.resetGeneratedFiles();
        GenerateCodeAction.generateTagHandlers(tldDo, alltags, root, forceGenerateAll);
    }

    public static void resetGeneratedFiles() {
        generatedFiles = new Vector();
    }

    private static File validateNewFolder(String folderPath) throws IOException {
        File file = new File(folderPath);
        if (file.exists() && file.isDirectory()) {
            return file;
        }
        return null;
    }

    public static void generateTagHandlers(TLDDataObject tldDo, Vector alltags, FileObject root, boolean forceGenerateAll) {
        Vector genTags = forceGenerateAll ? alltags : GenerateCodeAction.tagsThatNeedGeneration(alltags, root);
        TagGenerator taggen = new TagGenerator(null);
        Enumeration en = genTags.elements();
        while (en.hasMoreElements()) {
            TagInfoData tag = (TagInfoData)en.nextElement();
            GenerateCodeAction.generateHandlers(tldDo, tag, root, taggen);
        }
    }

    public static void generateHandlers(TLDDataObject tldDo, TagInfoData tag, FileObject root, TagGenerator taggen) {
        String title;
        String msg;
        boolean overwrite = true;
        tag.ensureTagClassName();
        tag.ensureNoDotClass();
        String packageName = tag.getPackageName();
        String dirName = packageName != null ? packageName.trim().replace('.', '/') : "";
        taggen.setTag(tag);
        FileObject pkgDirFo = null;
        File tagHandlerFile = null;
        File teiFile = null;
        try {
            EditorCookie ec;
            if (root.isReadOnly()) {
                String msg2 = IDEHelper.getString("TLD_GenerateCodeAction.Exception.tagHandlerRootReadOnly", IDEHelper.getAbsolutePath(root));
                throw new TLDException(msg2);
            }
            DataFolder df = IDEHelper.createFolder(root, dirName);
            pkgDirFo = df.getPrimaryFile();
            String tagClassName = tag.getTagClassName();
            FileObject tagHandlerFo = pkgDirFo.getFileObject(tagClassName, "java");
            GenerateCodeAction.statusMsgI18N("TLD_GenerateCodeAction.status.startTagHandler", tagClassName);
            if (tagHandlerFo == null) {
                if (pkgDirFo.isReadOnly()) {
                    String msg3 = IDEHelper.getString("TLD_GenerateCodeAction.Exception.tagHandlerPackageReadOnly", IDEHelper.getAbsolutePath(pkgDirFo));
                    throw new TLDException(msg3);
                }
                String out = taggen.generateDummyTagHandlerJavaFile();
                IDEHelper.saveHandlerFileAs(pkgDirFo, tagClassName, "java", out, overwrite);
                out = null;
                tagHandlerFo = pkgDirFo.getFileObject(tagClassName, "java");
                GenerateCodeAction.statusMsgI18N("TLD_GenerateCodeAction.status.generatedDummy", IDEHelper.getAbsolutePath(tagHandlerFo));
            }
            if (tagHandlerFo.isReadOnly()) {
                String msg4 = IDEHelper.getString("TLD_GenerateCodeAction.Exception.tagHandlerFileReadOnly", IDEHelper.getAbsolutePath(tagHandlerFo));
                throw new TLDException(msg4);
            }
            String handlerAbsPath = IDEHelper.getAbsolutePath(tagHandlerFo);
            GenerateCodeAction.statusMsgI18N("TLD_GenerateCodeAction.status.writingSource", handlerAbsPath);
            DataObject tagHandlerDO = DataObject.find((FileObject)tagHandlerFo);
            SourceCookie sourceCookie = (SourceCookie)tagHandlerDO.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = GenerateCodeAction.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie);
            EditorCookie edCookie = (EditorCookie)tagHandlerDO.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = GenerateCodeAction.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
            SourceElement tagElt = sourceCookie.getSource();
            taggen.generateTagHandlerSource(tldDo, tag, tagElt, tagHandlerDO);
            tag.clearTagHandlerDirtyBit(tagClassName);
            ++numFilesGenerated;
            tagHandlerFile = FileUtil.toFile((FileObject)tagHandlerFo);
            if (tagHandlerFile != null) {
                try {
                    SaveCookie saveCookie = (SaveCookie)tagHandlerDO.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = GenerateCodeAction.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
                    if (saveCookie != null) {
                        saveCookie.save();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                generatedFiles.addElement(tagHandlerFile.getAbsolutePath());
            }
            GenerateCodeAction.statusMsgI18N("TLD_GenerateCodeAction.status.handlerFinished", handlerAbsPath);
            if (GenerateCodeAction.openGeneratedTagsInEditor() && (ec = (EditorCookie)tagHandlerDO.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = GenerateCodeAction.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie)) != null) {
                GenerateCodeAction.statusMsgI18N("TLD_GenerateCodeAction.status.openingInEditor", handlerAbsPath);
                ec.open();
            }
        }
        catch (Exception ex) {
            msg = IDEHelper.getString("TLD_GenerateCodeAction.TagHandlerException", tag.getTagName(), (Object)ex.getMessage(), (Object)(tagHandlerFile == null ? "" : tagHandlerFile.getAbsolutePath()));
            title = IDEHelper.getString("TLD_GenerateCodeAction.Exception.title");
            IDEHelper.showMessage(msg, 2, title);
        }
        try {
            if (tag.hasVariablesOfNameTypeOther() && pkgDirFo != null) {
                String msg5;
                String teiClassName = tag.ensureTeiClassName();
                FileObject teiFo = pkgDirFo.getFileObject(teiClassName, "java");
                GenerateCodeAction.statusMsgI18N("TLD_GenerateCodeAction.status.startTEI", teiClassName);
                if (teiFo == null) {
                    if (pkgDirFo.isReadOnly()) {
                        msg5 = IDEHelper.getString("TLD_GenerateCodeAction.Exception.teiPackageReadOnly", IDEHelper.getAbsolutePath(pkgDirFo));
                        throw new TLDException(msg5);
                    }
                    String out = taggen.generateDummyTEIClass(teiClassName);
                    IDEHelper.saveHandlerFileAs(pkgDirFo, teiClassName, "java", out, overwrite);
                    teiFo = pkgDirFo.getFileObject(teiClassName, "java");
                    GenerateCodeAction.statusMsgI18N("TLD_GenerateCodeAction.status.generatedDummyTEI", IDEHelper.getAbsolutePath(teiFo));
                }
                if (teiFo.isReadOnly()) {
                    msg5 = IDEHelper.getString("TLD_GenerateCodeAction.Exception.teiFileReadOnly", IDEHelper.getAbsolutePath(teiFo));
                    throw new TLDException(msg5);
                }
                String absTEI = IDEHelper.getAbsolutePath(teiFo);
                GenerateCodeAction.statusMsgI18N("TLD_GenerateCodeAction.status.writingSourceTEI", absTEI);
                DataObject teiDO = DataObject.find((FileObject)teiFo);
                SourceCookie sourceCookie1 = (SourceCookie)teiDO.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = GenerateCodeAction.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie);
                SourceElement teiElt = sourceCookie1.getSource();
                String pkg = tag.getPackageName();
                String teiFullClassName = pkg == null || pkg.equals("") ? teiClassName : pkg + "." + teiClassName;
                Identifier teiClassNameId = Identifier.create((String)teiFullClassName, (String)teiClassName);
                TEIGenerator teigen = new TEIGenerator();
                teigen.generateTEISource(tag, teiElt);
                tag.clearTEIDirtyBit(teiClassName);
                GenerateCodeAction.statusMsgI18N("TLD_GenerateCodeAction.status.handlerFinishedTEI", absTEI);
                EditorCookie teiEc = (EditorCookie)teiDO.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = GenerateCodeAction.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                if (teiEc != null) {
                    GenerateCodeAction.statusMsgI18N("TLD_GenerateCodeAction.status.openingInEditorTEI", absTEI);
                    teiEc.open();
                }
                ++numFilesGenerated;
                teiFile = FileUtil.toFile((FileObject)teiFo);
                generatedFiles.addElement(teiFile.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            msg = IDEHelper.getString("TLD_GenerateCodeAction.TEIException", tag.getTagName(), (Object)ex.getMessage(), (Object)(teiFile == null ? "" : teiFile.getAbsolutePath()));
            title = IDEHelper.getString("TLD_GenerateCodeAction.Exception.title");
            IDEHelper.showMessage(msg, 2, title);
        }
        taggen.reset();
    }

    public static boolean openGeneratedTagsInEditor() {
        return openGeneratedTagsInEditor;
    }

    public static void setOpenGeneratedTagsInEditor(boolean value) {
        openGeneratedTagsInEditor = value;
    }

    public static void displayGeneratedFiles(String pkgName) {
        ResourceBundle resBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDDataObject == null ? (class$org$netbeans$modules$web$taglibed$TLDDataObject = GenerateCodeAction.class$("org.netbeans.modules.web.taglibed.TLDDataObject")) : class$org$netbeans$modules$web$taglibed$TLDDataObject));
        if (numFilesGenerated > 0) {
            if (pkgName.equals("")) {
                pkgName = resBundle.getString("TLD_GenerateCodeAction.current");
            }
            String preamble = numFilesGenerated == 1 ? IDEHelper.getString("TLD_NumberOfFileGenerated_Singular", resBundle, (Object)target.getName()) : IDEHelper.getString("TLD_NumberOfFileGenerated", resBundle, (Object)target.getName(), (Object)new Integer(numFilesGenerated));
            String title = IDEHelper.getString("TLD_GenerateCodeAction.Info_Title", resBundle);
            GenerateCodeAction.statusMsgI18N("TLD_GenerateCodeAction.status.generatedNFiles", "" + numFilesGenerated);
            if (displayGeneratedFilesAsDialog) {
                IDEHelper.showMultilineMessage(generatedFiles, preamble, title, "    ", null, 1);
            }
        } else {
            Object[] o = new Object[]{target.getName()};
            GenerateCodeAction.statusMsgI18N("TLD_GenerateCodeAction.status.generated0Files");
            if (displayGeneratedFilesAsDialog) {
                IDEHelper.showInfoMessageI18N("TLD_GenerateCodeAction.No_File_Generated", o);
            }
        }
    }

    public static void setDisplayGeneratedFilesAsDialog(boolean value) {
        displayGeneratedFilesAsDialog = value;
    }

    public static Vector tagsThatNeedGeneration(Vector alltags, FileObject root) {
        Vector<TagInfoData> result = new Vector<TagInfoData>();
        Enumeration en = alltags.elements();
        while (en.hasMoreElements()) {
            TagInfoData tag = (TagInfoData)en.nextElement();
            if (!GenerateCodeAction.tagNeedsGeneration(tag, root)) continue;
            result.addElement(tag);
        }
        return result;
    }

    public static boolean tagNeedsGeneration(TagInfoData tag, FileObject root) {
        String teiClassName;
        if (tag.getTagHandlerDirtyBit() || tag.getTEIDirtyBit()) {
            return true;
        }
        String tagClassName = tag.getTagClassName();
        String packageName = tag.getPackageName();
        String dirName = packageName != null ? packageName.trim().replace('.', '/') : "";
        FileObject fo = IDEHelper.findFileObject(root, dirName, tagClassName, "java");
        if (fo == null) {
            return true;
        }
        return tag.hasVariables() && (fo = IDEHelper.findFileObject(root, dirName, teiClassName = tag.ensureTeiClassName(), "java")) == null;
    }

    public static void statusMsgI18N(String key) {
        String msg = IDEHelper.getString(key);
        GenerateCodeAction.statusMsg(msg);
    }

    public static void statusMsgI18N(String key, Object arg) {
        String msg = IDEHelper.getString(key, arg);
        GenerateCodeAction.statusMsg(msg);
    }

    public static void statusMsg(String msg) {
        StatusDisplayer.getDefault().setStatusText(msg);
    }

    private static void debugStringVec(Vector v) {
    }

    private static void debugFileObject(FileObject fo) {
    }

    private static void debugDataFolder(DataFolder df) {
    }

    public static final boolean isValidFileName(String id) {
        if (id == null) {
            return false;
        }
        if (id.equals("")) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(id.charAt(0)) && !Character.isLetterOrDigit(id.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < id.length()) {
            if (!Character.isJavaIdentifierPart(id.charAt(i)) && (Character.isWhitespace(id.charAt(i)) || Character.isISOControl(id.charAt(i)))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        openGeneratedTagsInEditor = true;
        displayGeneratedFilesAsDialog = true;
    }
}

