/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglibed.control;

import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.SyncFailedException;
import java.io.Writer;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.netbeans.modules.web.taglibed.TLDDataObject;
import org.netbeans.modules.web.taglibed.control.TldActionSupport;
import org.netbeans.modules.web.taglibed.model.TagAttributeInfoData;
import org.netbeans.modules.web.taglibed.model.TagInfoData;
import org.netbeans.modules.web.taglibed.model.TagLibraryInfoData;
import org.netbeans.modules.web.taglibed.model.TagVariableInfoData;
import org.netbeans.modules.web.taglibed.view.TLDNode;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.RepositoryNodeFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.IndentEngine;
import org.openide.util.NbBundle;
import sun.security.action.GetPropertyAction;

public class IDEHelper {
    private static boolean validationInProgress = false;
    private static final boolean debugtests = false;
    private static final boolean debug = false;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$TLDDataObject;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$control$TldActionSupport;

    public static FileObject saveHandlerFileAs(FileObject folderFile, String name, String extension, StringBuffer fileDataBuffer, boolean overwrite) throws IOException {
        return IDEHelper.saveHandlerFileAs(folderFile, name, extension, fileDataBuffer.toString(), overwrite);
    }

    public static FileObject saveHandlerFileAs(FileObject folderFile, String name, String extension, String fileData, boolean overwrite) throws IOException {
        return IDEHelper.saveFileAs(folderFile, name, extension, fileData, overwrite, "text/x-java");
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public static StringBuffer readLocalFileAs(FileObject folderFile, String name, String extension) {
        StringWriter w;
        StringBuffer buf;
        block17: {
            String current;
            buf = new StringBuffer();
            FileObject fo = null;
            fo = folderFile.getFileObject(name, extension);
            if (fo == null) {
                return buf;
            }
            BufferedReader r = null;
            w = new StringWriter();
            r = new BufferedReader(new InputStreamReader(fo.getInputStream()));
            String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
            String line = null;
            while ((current = r.readLine()) != null) {
                void var9_11;
                if (line != null) {
                    w.write(lineSeparator);
                }
                line = var9_11;
                w.write(line);
            }
            Object var11_12 = null;
            try {
                w.flush();
                w.close();
                if (r != null) {
                    r.close();
                }
                break block17;
            }
            catch (IOException ex2) {}
            break block17;
            {
                catch (FileNotFoundException ex) {
                    Object var11_13 = null;
                    try {
                        w.flush();
                        w.close();
                        if (r != null) {
                            r.close();
                        }
                        break block17;
                    }
                    catch (IOException ex2) {}
                    break block17;
                }
                catch (IOException ex) {
                    Object var11_14 = null;
                    try {
                        w.flush();
                        w.close();
                        if (r != null) {
                            r.close();
                        }
                        break block17;
                    }
                    catch (IOException ex2) {}
                }
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                try {
                    w.flush();
                    w.close();
                    if (r != null) {
                        r.close();
                    }
                }
                catch (IOException ex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        buf = w.getBuffer();
        return buf;
    }

    public static boolean acceptDataObjectForTLD(DataObject dataObj) {
        if (dataObj instanceof DataFolder) {
            return true;
        }
        FileObject tldFileObj = dataObj.getPrimaryFile();
        if (tldFileObj == null) {
            return false;
        }
        return tldFileObj.getExt().equalsIgnoreCase("tld");
    }

    public static boolean acceptDataObjectForBean(DataObject dataObj) {
        if (dataObj instanceof DataFolder) {
            return true;
        }
        if (dataObj.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = IDEHelper.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie) == null) {
            return false;
        }
        FileObject javaFileObj = dataObj.getPrimaryFile();
        if (javaFileObj == null) {
            return false;
        }
        if (!javaFileObj.getExt().equalsIgnoreCase("java")) {
            return false;
        }
        return javaFileObj.existsExt("class");
    }

    public static void showErrorMessageI18N(String i18nErrorMsg) {
        IDEHelper.showErrorMessageI18N(i18nErrorMsg, "TLD_ErrorMsgTitle");
    }

    public static void showErrorMessageI18N(String i18nErrorMsg, String i18nTitle) {
        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)IDEHelper.getString(i18nErrorMsg), 0);
        msg.setTitle(IDEHelper.getString(i18nTitle));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
    }

    public static void showErrorMessageI18N(String i18nErrorMsg, Object[] obj) {
        IDEHelper.showErrorMessageI18N(i18nErrorMsg, obj, "TLD_ErrorMsgTitle");
    }

    public static void showErrorMessageI18N(String i18nErrorMsg, Object[] obj, String i18nTitle) {
        MessageFormat msgFormat = new MessageFormat(IDEHelper.getString(i18nErrorMsg));
        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)msgFormat.format(obj), 0);
        msg.setTitle(IDEHelper.getString(i18nTitle));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
    }

    public static NotifyDescriptor.Message showWarningMessageI18N(String i18nErrorMsg) {
        return IDEHelper.showWarningMessageI18N(i18nErrorMsg, "TLD_WarningMsgTitle");
    }

    public static NotifyDescriptor.Message showWarningMessageI18N(String i18nErrorMsg, String i18nTitle) {
        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)IDEHelper.getString(i18nErrorMsg), 2);
        msg.setTitle(IDEHelper.getString(i18nTitle));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
        return msg;
    }

    public static NotifyDescriptor.Message showWarningMessageI18N(String i18nErrorMsg, Object[] obj) {
        return IDEHelper.showWarningMessageI18N(i18nErrorMsg, obj, "TLD_WarningMsgTitle");
    }

    public static NotifyDescriptor.Message showWarningMessageI18N(String i18nErrorMsg, Object[] obj, String i18nTitle) {
        MessageFormat msgFormat = new MessageFormat(IDEHelper.getString(i18nErrorMsg));
        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)msgFormat.format(obj), 2);
        msg.setTitle(IDEHelper.getString(i18nTitle));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
        return msg;
    }

    public static void showInfoMessageI18N(String i18nMsg) {
        IDEHelper.showInfoMessageI18N(i18nMsg, "TLD_InformationMsgTitle");
    }

    public static void showInfoMessageI18N(String i18nMsg, String i18nTitle) {
        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)IDEHelper.getString(i18nMsg), 1);
        msg.setTitle(IDEHelper.getString(i18nTitle));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
    }

    public static void showInfoMessageI18N(String i18nMsg, Object[] obj) {
        IDEHelper.showInfoMessageI18N(i18nMsg, obj, "TLD_InformationMsgTitle");
    }

    public static void showInfoMessageI18N(String i18nMsg, Object[] obj, String i18nTitle) {
        MessageFormat msgFormat = new MessageFormat(IDEHelper.getString(i18nMsg));
        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)msgFormat.format(obj), 1);
        msg.setTitle(IDEHelper.getString(i18nTitle));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
    }

    public static void showMessage(String msg, int msgType) {
        String title = msgType == 1 ? IDEHelper.getString("TLD_InformationMsgTitle") : (msgType == 2 ? IDEHelper.getString("TLD_WarningMsgTitle") : (msgType == 2 ? IDEHelper.getString("TLD_ErrorMsgTitle") : ""));
        IDEHelper.showMessage(msg, msgType, title);
    }

    public static void showMessage(String msgText, int msgType, String title) {
        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)msgText, msgType);
        msg.setTitle(title);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
    }

    public static Object cancellableConfirmationI18N(String i18nQuestionMsg) {
        NotifyDescriptor.Confirmation confirm = new NotifyDescriptor.Confirmation((Object)IDEHelper.getString(i18nQuestionMsg), IDEHelper.getString("TLD_ConfirmMsgTitle"), 1);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)confirm);
    }

    public static boolean askConfirmationI18N(String i18nQuestionMsg) {
        NotifyDescriptor.Confirmation confirm = new NotifyDescriptor.Confirmation((Object)IDEHelper.getString(i18nQuestionMsg), IDEHelper.getString("TLD_ConfirmMsgTitle"), 0);
        Object confirmOption = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirm);
        return confirmOption.equals(NotifyDescriptor.YES_OPTION);
    }

    public static boolean askConfirmationI18N(String i18nQuestionMsg, Object[] obj) {
        MessageFormat msg = new MessageFormat(IDEHelper.getString(i18nQuestionMsg));
        NotifyDescriptor.Confirmation confirm = new NotifyDescriptor.Confirmation((Object)msg.format(obj), IDEHelper.getString("TLD_ConfirmMsgTitle"), 0);
        Object confirmOption = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirm);
        return confirmOption.equals(NotifyDescriptor.YES_OPTION);
    }

    public static boolean fileExists(DataFolder folder, String name, String ext) {
        return folder != null && folder.getPrimaryFile().getFileObject(name, ext) != null;
    }

    public static FileObject findFileObject(FileObject folder, String packageName, String name, String ext) {
        FileObject f;
        StringTokenizer st = new StringTokenizer(packageName, "/");
        while (st.hasMoreElements()) {
            packageName = st.nextToken();
            if (packageName.length() <= 0 || packageName.equals(".")) continue;
            f = folder.getFileObject(packageName);
            if (f == null) {
                return null;
            }
            folder = f;
        }
        if (name != null) {
            folder = f = folder.getFileObject(name, ext);
        }
        return folder;
    }

    public static DataFolder createFolder(FileObject folder, String name) throws IOException {
        DataFolder rv = null;
        FileObject fo = null;
        try {
            fo = IDEHelper.findOrCreateFolder(folder, name);
            rv = DataFolder.findFolder((FileObject)fo);
        }
        catch (IllegalArgumentException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            rv = null;
        }
        return rv;
    }

    public static FileObject findOrCreateFolder(FileObject folder, String path) throws IOException {
        String separators = File.separatorChar != '/' ? "/" + File.separatorChar : "/";
        StringTokenizer st = new StringTokenizer(path, separators);
        while (st.hasMoreElements()) {
            FileObject f;
            block9: {
                String name = st.nextToken();
                if (name.length() <= 0 || name.equals(".")) continue;
                f = folder.getFileObject(name);
                if (f == null) {
                    if (name.equals("..")) {
                        if (folder.isRoot()) {
                            File folderF = FileUtil.toFile((FileObject)folder);
                            try {
                                String folderCp = folderF.getCanonicalPath();
                                String relPath = folderCp.endsWith(File.separator) ? folderCp + path : folderCp + File.separator + path;
                                File relF = new File(relPath);
                                String newAbsolutePath = relF.getCanonicalPath();
                                return IDEHelper.findOrMountFileObject(newAbsolutePath);
                            }
                            catch (IOException ex) {
                                return null;
                            }
                        }
                        f = folder.getParent();
                    } else {
                        try {
                            f = folder.createFolder(name);
                        }
                        catch (SyncFailedException ex) {
                            folder.refresh();
                            f = folder.getFileObject(name);
                            if (f != null) break block9;
                            throw ex;
                        }
                    }
                }
            }
            folder = f;
        }
        return folder;
    }

    public static FileObject ensureTagHandlerGenerationRootIsMounted(FileObject parentRoot, TagLibraryInfoData taglib) {
        String taglibGenRoot = taglib.getTagHandlerGenerationRoot();
        File result = null;
        if (taglibGenRoot == null) {
            result = FileUtil.toFile((FileObject)parentRoot);
        } else if ((taglibGenRoot = taglibGenRoot.trim()).equals(".") || taglibGenRoot.length() == 0) {
            result = FileUtil.toFile((FileObject)parentRoot);
        } else if (IDEHelper.isRelative(taglibGenRoot)) {
            try {
                DataFolder df = IDEHelper.createFolder(parentRoot, taglibGenRoot);
                result = FileUtil.toFile((FileObject)df.getPrimaryFile());
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        } else {
            File absFile = new File(taglibGenRoot);
            if (absFile != null) {
                boolean success = absFile.mkdirs();
                result = absFile;
            }
        }
        if (result != null) {
            FileSystem mountedFs = IDEHelper.mountFs(result);
            FileObject mounted = mountedFs.getRoot();
            return mounted;
        }
        return null;
    }

    public static FileObject findOrMountFileObject(String absPath) {
        File result = null;
        File absFile = new File(absPath);
        if (absFile != null) {
            boolean success = absFile.mkdirs();
            result = absFile;
        }
        if (result == null) {
            return null;
        }
        FileObject[] fos = FileUtil.fromFile((File)absFile);
        if (fos.length > 0) {
            return fos[0];
        }
        FileSystem mountedFs = IDEHelper.mountFs(result);
        FileObject mounted = mountedFs.getRoot();
        return mounted;
    }

    public static boolean isRelative(String directory) {
        if (directory.startsWith("/") || directory.startsWith("\\")) {
            return false;
        }
        return directory.length() <= 1 || directory.charAt(1) != ':';
    }

    public static FileSystem fileToFs(File f) {
        LocalFileSystem localFS = null;
        if (f != null && f.isDirectory()) {
            localFS = new LocalFileSystem();
            try {
                try {
                    f = f.getCanonicalFile();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                localFS.setRootDirectory(f);
            }
            catch (IOException ex) {
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        return localFS;
    }

    public static FileSystem mountFs(File f) {
        FileSystem localFS = IDEHelper.fileToFs(f);
        FileSystem newFS = null;
        if (localFS != null) {
            Repository r = Repository.getDefault();
            FileSystem existingFS = IDEHelper.findAlreadyMountedFileSystem(r, localFS);
            if (existingFS == null) {
                r.addFileSystem(localFS);
                newFS = localFS;
            } else {
                newFS = existingFS;
            }
        }
        return newFS;
    }

    public static FileSystem findAlreadyMountedFileSystem(Repository r, FileSystem targetFs) {
        FileObject targetRoot = targetFs.getRoot();
        String targetDisplayName = targetFs.getDisplayName();
        String targetSystemName = targetFs.getSystemName();
        File targetFile = FileUtil.toFile((FileObject)targetRoot);
        if (targetFile == null) {
            return null;
        }
        String targetFileAbs = targetFile.getAbsolutePath();
        Enumeration fsen = r.fileSystems();
        while (fsen.hasMoreElements()) {
            File fsFile;
            FileSystem fs = (FileSystem)fsen.nextElement();
            boolean hidden = fs.isHidden();
            if (hidden || (fsFile = FileUtil.toFile((FileObject)fs.getRoot())) == null) continue;
            String fsFileAbs = fsFile.getAbsolutePath();
            if (targetFileAbs.equals(fsFileAbs)) {
                return fs;
            }
            String sn = fs.getSystemName();
            if (targetSystemName.equals(sn)) {
                return fs;
            }
            String dn = fs.getDisplayName();
            if (targetDisplayName.equals(dn)) {
                return fs;
            }
            if (!targetSystemName.equals(dn)) continue;
            return fs;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileObject saveFileAs(FileObject folderFile, String name, String extension, String fileData, boolean overwrite, String mimeType) throws IOException {
        FileObject fileObject;
        FileObject fo = null;
        try {
            fo = folderFile.createData(name, extension);
        }
        catch (IOException ex) {
            if (!overwrite) {
                throw ex;
            }
            fo = folderFile.getFileObject(name, extension);
        }
        FileLock lock = null;
        OutputStreamWriter wrFile = null;
        Writer beautyWrFile = null;
        try {
            lock = fo.lock();
            wrFile = new OutputStreamWriter(fo.getOutputStream(lock));
            if (mimeType != null) {
                try {
                    beautyWrFile = IndentEngine.find((String)mimeType).createWriter((Document)new PlainDocument(), 0, (Writer)wrFile);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (beautyWrFile != null) {
                beautyWrFile.write(fileData);
            } else {
                wrFile.write(fileData);
            }
            fileObject = fo;
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {
                if (beautyWrFile != null) {
                    beautyWrFile.flush();
                    beautyWrFile.close();
                } else if (wrFile != null) {
                    ((Writer)wrFile).flush();
                    ((Writer)wrFile).close();
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            if (lock == null) throw throwable;
            lock.releaseLock();
            throw throwable;
        }
        try {
            if (beautyWrFile != null) {
                beautyWrFile.flush();
                beautyWrFile.close();
            } else if (wrFile != null) {
                ((Writer)wrFile).flush();
                ((Writer)wrFile).close();
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        if (lock == null) return fileObject;
        lock.releaseLock();
        return fileObject;
    }

    public static synchronized boolean validateTaglibName(String value) {
        String invalidChars = IDEHelper.validateJavaIdentifier(value);
        if (invalidChars == null) {
            return true;
        }
        IDEHelper.showValidationMessageI18N("TLDValidation_TagLibraryName", invalidChars, "TagWizard_WarningMsgTitle");
        return false;
    }

    public static String stripJavaIdentifierInvalidChars(String value) {
        int len = value.length();
        char[] chars = new char[len];
        value.getChars(0, len, chars, 0);
        if (len == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer(len);
        int i = 0;
        while (i < len && !Character.isJavaIdentifierStart(chars[i])) {
            ++i;
        }
        while (i < len) {
            if (Character.isJavaIdentifierPart(chars[i])) {
                buf.append(chars[i]);
            }
            ++i;
        }
        if (buf.length() > 0) {
            return buf.toString();
        }
        return null;
    }

    public static boolean isJavaIdentifierChar(char ch) {
        return Character.isJavaIdentifierPart(ch);
    }

    public static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isJavaQualifiedClassNameChar(char ch) {
        return IDEHelper.isJavaIdentifierChar(ch) || ch == '.';
    }

    public static boolean isJavaPackageClassNameChar(char ch) {
        return IDEHelper.isJavaIdentifierChar(ch) || ch == '.';
    }

    public static boolean startsWithDigit(String value) {
        return IDEHelper.startsWithInvalidChar(value);
    }

    public static boolean startsWithInvalidChar(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        return !Character.isJavaIdentifierStart(value.charAt(0));
    }

    public static String validateJavaIdentifier(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(32);
        int len = value.length();
        char[] chars = new char[len];
        value.getChars(0, len, chars, 0);
        boolean valid = true;
        if (len > 0 && !Character.isJavaIdentifierStart(chars[0])) {
            valid = false;
            buf.append(chars[0]);
        }
        int i = 1;
        while (i < len) {
            if (!Character.isJavaIdentifierPart(chars[i])) {
                valid = false;
                buf.append(chars[i]);
            }
            ++i;
        }
        if (valid) {
            return null;
        }
        return buf.toString();
    }

    public static String validateJavaClass(String value) {
        StringBuffer buf = new StringBuffer(32);
        int len = value.length();
        boolean valid = true;
        char[] chars = new char[len];
        value.getChars(0, len, chars, 0);
        if (len > 0 && !Character.isJavaIdentifierStart(chars[0])) {
            valid = false;
            buf.append(chars[0]);
        }
        int i = 1;
        while (i < len) {
            if (!Character.isJavaIdentifierPart(chars[i])) {
                valid = false;
                buf.append(chars[i]);
            }
            ++i;
        }
        if (valid) {
            return null;
        }
        return buf.toString();
    }

    public static String validateJavaPackageName(String value) {
        StringBuffer buf = new StringBuffer(32);
        int len = value.length();
        char[] chars = new char[len];
        value.getChars(0, len, chars, 0);
        if (len == 0) {
            return null;
        }
        boolean valid = true;
        if (len > 0 && !Character.isJavaIdentifierStart(chars[0])) {
            valid = false;
            buf.append(chars[0]);
        }
        int i = 1;
        while (i < len) {
            if (!IDEHelper.isJavaPackageClassNameChar(chars[i])) {
                valid = false;
                buf.append(chars[i]);
            }
            ++i;
        }
        if (valid) {
            return null;
        }
        return buf.toString();
    }

    public static NotifyDescriptor.Message showValidationMessageI18N(String i18nErrorMsg, String customizerTitleRes) {
        if (!validationInProgress) {
            validationInProgress = true;
            String msgString = IDEHelper.getValidationMessageI18N(i18nErrorMsg);
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)msgString, 2);
            msg.setTitle(IDEHelper.getString(customizerTitleRes));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            validationInProgress = false;
            return msg;
        }
        return null;
    }

    public static NotifyDescriptor.Message showValidationMessageI18N(String i18nErrorMsg, String invalidChars, String customizerTitleRes) {
        if (!validationInProgress) {
            validationInProgress = true;
            String msgString = IDEHelper.getValidationMessageI18N(i18nErrorMsg, invalidChars);
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)msgString, 2);
            msg.setTitle(IDEHelper.getString(customizerTitleRes));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            validationInProgress = false;
            return msg;
        }
        return null;
    }

    public static String getValidationMessageI18N(String i18nErrorMsg) {
        String msgString = IDEHelper.getString(i18nErrorMsg);
        return msgString;
    }

    public static String getValidationMessageI18N(String i18nErrorMsg, String invalidChars) {
        int l = invalidChars.length();
        StringBuffer buf = new StringBuffer(l * 5);
        MessageFormat charQuoter = new MessageFormat(IDEHelper.getString("TLD_Validation_character_quoting"));
        int i = 0;
        while (i < l) {
            String ich = invalidChars.substring(i, i + 1);
            Object[] oneChar = new Object[]{ich};
            String quoted = charQuoter.format(oneChar);
            buf.append(quoted);
            if (i < l - 1) {
                buf.append(", ");
            }
            ++i;
        }
        String invalidCharsWithQuotes = buf.toString();
        Object[] args = new Object[]{invalidCharsWithQuotes};
        MessageFormat msgFormat = new MessageFormat(IDEHelper.getString(i18nErrorMsg));
        return msgFormat.format(args);
    }

    public static ResourceBundle getResBundle() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDDataObject == null ? (class$org$netbeans$modules$web$taglibed$TLDDataObject = IDEHelper.class$("org.netbeans.modules.web.taglibed.TLDDataObject")) : class$org$netbeans$modules$web$taglibed$TLDDataObject));
    }

    public static String getString(String i18nErrorMsg) {
        return IDEHelper.getString(i18nErrorMsg, IDEHelper.getResBundle());
    }

    public static String getString(String i18nErrorMsg, ResourceBundle resBundle) {
        return resBundle.getString(i18nErrorMsg);
    }

    public static String getString(String i18nErrorMsg, Object arg0) {
        return IDEHelper.getString(i18nErrorMsg, IDEHelper.getResBundle(), arg0);
    }

    public static String getString(String i18nErrorMsg, ResourceBundle resBundle, Object arg0) {
        Object[] args = new Object[]{arg0};
        MessageFormat msgFormat = new MessageFormat(resBundle.getString(i18nErrorMsg));
        return msgFormat.format(args);
    }

    public static String getString(String i18nErrorMsg, Object arg0, Object arg1) {
        return IDEHelper.getString(i18nErrorMsg, IDEHelper.getResBundle(), arg0, arg1);
    }

    public static String getString(String i18nErrorMsg, ResourceBundle resBundle, Object arg0, Object arg1) {
        Object[] args = new Object[]{arg0, arg1};
        MessageFormat msgFormat = new MessageFormat(resBundle.getString(i18nErrorMsg));
        return msgFormat.format(args);
    }

    public static String getString(String i18nErrorMsg, Object arg0, Object arg1, Object arg2) {
        return IDEHelper.getString(i18nErrorMsg, IDEHelper.getResBundle(), arg0, arg1, arg2);
    }

    public static String getString(String i18nErrorMsg, ResourceBundle resBundle, Object arg0, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        MessageFormat msgFormat = new MessageFormat(resBundle.getString(i18nErrorMsg));
        return msgFormat.format(args);
    }

    public static String getString(String i18nErrorMsg, Object arg0, Object arg1, Object arg2, Object arg3) {
        return IDEHelper.getString(i18nErrorMsg, IDEHelper.getResBundle(), arg0, arg1, arg2, arg3);
    }

    public static String getString(String i18nErrorMsg, ResourceBundle resBundle, Object arg0, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        MessageFormat msgFormat = new MessageFormat(resBundle.getString(i18nErrorMsg));
        return msgFormat.format(args);
    }

    public static void showMultilineMessage(Vector lines, String preamble, String title, String postamble) {
        String defaultIndent = "    ";
        int defaultMsgType = 0;
        IDEHelper.showMultilineMessage(lines, preamble, title, defaultIndent, postamble, defaultMsgType);
    }

    public static void showMultilineMessage(Vector lines, String preamble, String title, String indent, String postamble, int msgType) {
        if (lines == null || lines.size() == 0) {
            return;
        }
        String multilines = IDEHelper.assembleMultilineMessage(lines, preamble, title, indent, postamble);
        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)multilines, msgType);
        msg.setTitle(title);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
    }

    public static boolean askWhetherToApplyUnappliedChanges(Vector changes, String preamble, String title) {
        if (changes == null || changes.size() == 0) {
            return false;
        }
        String indent = "    ";
        String postamble = null;
        String msgsString = IDEHelper.assembleMultilineMessage(changes, preamble, title, indent, postamble);
        String applyButtonTitle = IDEHelper.getString("TLD_Customizers.Apply_or_discard_ApplyButton");
        JButton applyButton = new JButton(applyButtonTitle);
        applyButton.setMnemonic(IDEHelper.getString("TLD_Customizers.Apply_or_discard_ApplyButton_Mnemonic").charAt(0));
        applyButton.setToolTipText(IDEHelper.getString("ACS_Customizers.Apply_or_discard_ApplyButtonA11yDesc"));
        JButton discardButton = new JButton(IDEHelper.getString("TLD_Customizers.Apply_or_discard_DiscardButton"));
        discardButton.setMnemonic(IDEHelper.getString("TLD_Customizers.Apply_or_discard_DiscardButton_Mnemonic").charAt(0));
        discardButton.setToolTipText(IDEHelper.getString("ACS_Customizers.Apply_or_discard_DiscardButtonA11yDesc"));
        Object[] options = new Object[]{applyButton, discardButton};
        NotifyDescriptor.Confirmation question = new NotifyDescriptor.Confirmation((Object)msgsString, title, -1, 3);
        question.setOptions(options);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)question);
        Object chosen = question.getValue();
        if (chosen instanceof String) {
            return chosen.equals(applyButtonTitle);
        }
        if (chosen instanceof JButton) {
            return chosen.equals(applyButton);
        }
        return false;
    }

    public static String assembleMultilineMessage(Vector lines, String preamble, String title, String indent, String postamble) {
        StringBuffer msgsBuf = new StringBuffer(512);
        if (preamble != null && preamble.length() != 0) {
            msgsBuf.append(preamble);
            msgsBuf.append('\n');
        }
        Enumeration en = lines.elements();
        while (en.hasMoreElements()) {
            String line = (String)en.nextElement();
            msgsBuf.append(indent);
            msgsBuf.append(line);
            if (!en.hasMoreElements()) continue;
            msgsBuf.append('\n');
        }
        if (postamble != null && postamble.length() != 0) {
            msgsBuf.append('\n');
            msgsBuf.append(postamble);
        }
        return msgsBuf.toString();
    }

    public static String fileObjectFullPath(FileObject fo) {
        if (fo == null) {
            return "null";
        }
        try {
            FileSystem fs = fo.getFileSystem();
            return fs.getSystemName() + ":" + fo.toString();
        }
        catch (Exception ex) {
            return "<exception getting file object full path>";
        }
    }

    public static String getAbsolutePath(FileObject fo) {
        File f;
        if (fo != null && (f = FileUtil.toFile((FileObject)fo)) != null) {
            return f.getAbsolutePath();
        }
        return "null";
    }

    public static TLDNode findTLDNode(String fsDir, String pkg, String tldFileName) {
        File f = new File(fsDir);
        FileSystem fs = IDEHelper.mountFs(f);
        TLDNode tldNode = IDEHelper.findTLDNode(fs, tldFileName);
        return tldNode;
    }

    public static TLDNode findTLDNode(FileSystem tldFileSystem, String tldFileName) {
        Node fileSystemsNode;
        Node root = fileSystemsNode = RepositoryNodeFactory.getDefault().repository(DataFilter.ALL);
        Children rootChildren = root.getChildren();
        String fsName = tldFileSystem.getSystemName();
        Node fsNode = rootChildren.findChild(fsName);
        Children fsChildren = fsNode.getChildren();
        Enumeration en = fsChildren.nodes();
        while (en.hasMoreElements()) {
            Node n = (Node)en.nextElement();
            String nodeName = n.getName();
            TldActionSupport cookie = (TldActionSupport)n.getCookie(class$org$netbeans$modules$web$taglibed$control$TldActionSupport == null ? IDEHelper.class$("org.netbeans.modules.web.taglibed.control.TldActionSupport") : class$org$netbeans$modules$web$taglibed$control$TldActionSupport);
            if (cookie == null || nodeName == null || !nodeName.equals(tldFileName)) continue;
            return cookie.getTldNode();
        }
        return null;
    }

    public static boolean equivalentTldDataObjects(TLDDataObject a, TLDDataObject b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        try {
            FileObject aFo = a.getPrimaryFile();
            FileObject bFo = b.getPrimaryFile();
            File af = FileUtil.toFile((FileObject)aFo);
            File bf = FileUtil.toFile((FileObject)bFo);
            String ap = af.getAbsolutePath();
            String bp = bf.getAbsolutePath();
            return ap.equals(bp);
        }
        catch (NullPointerException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return false;
        }
    }

    public static void modifyTaglib(TagLibraryInfoData taglib, String whichTest) {
        if (whichTest == null) {
            return;
        }
        if (whichTest.equals("test1")) {
            IDEHelper.modifyTaglib_test1(taglib);
        } else if (whichTest.equals("test2")) {
            IDEHelper.modifyTaglib_test2(taglib);
        } else {
            return;
        }
    }

    public static void modifyTaglib_test1(TagLibraryInfoData taglib) {
        Vector tags = taglib.getTagsVector();
        TagInfoData tag = (TagInfoData)tags.elementAt(0);
        TagAttributeInfoData newAtt = new TagAttributeInfoData(tag);
        tag.addAttribute(newAtt);
        newAtt.setName("newAtt");
        newAtt.setRequired(true);
        newAtt.setTypeName("java.lang.String");
        newAtt.setRequestTime(false);
        newAtt.setIsReferenceID(true);
        TagVariableInfoData newVar = new TagVariableInfoData(tag);
        tag.addVariable(newVar);
        newVar.setName("newVar");
        newVar.setNameType("fromAttribute");
        newVar.setNameAttribute("newAtt");
        newVar.setType("String");
        newVar.setScope("NESTED");
    }

    public static void modifyTaglib_test2(TagLibraryInfoData taglib) {
        Vector tags = taglib.getTagsVector();
        if (tags.size() == 0) {
            System.out.println(" Tag library (shortname=" + taglib.getShortName() + ") has no tags. .. testing error.");
            return;
        }
        TagInfoData tag = (TagInfoData)tags.elementAt(0);
        TagAttributeInfoData newAtt = new TagAttributeInfoData(tag);
        tag.addAttribute(newAtt);
        newAtt.setName("newAtt2");
        newAtt.setRequired(true);
        newAtt.setTypeName("java.lang.String");
        newAtt.setRequestTime(false);
        newAtt.setIsReferenceID(false);
        TagVariableInfoData newVar = new TagVariableInfoData(tag);
        tag.addVariable(newVar);
        newVar.setName("newVar2");
        newVar.setNameType("static");
        newVar.setType("String");
        newVar.setScope("AT_BEGIN");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

