/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglibed.control;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.jarpackager.api.ArchiveBuilder;
import org.netbeans.modules.jarpackager.api.ArchiveController;
import org.netbeans.modules.jarpackager.api.ArchiveEntry;
import org.netbeans.modules.jarpackager.api.ArchiveMember;
import org.netbeans.modules.jarpackager.api.ArchiveMemberSet;
import org.netbeans.modules.jarpackager.api.FOArchiveEntry;
import org.netbeans.modules.web.taglibed.TLDDataObject;
import org.netbeans.modules.web.taglibed.model.TagLibraryInfoData;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class TaglibArchiveBuilder
implements ArchiveBuilder {
    public static final TaglibArchiveBuilder INSTANCE = new TaglibArchiveBuilder();
    public static TagLibraryInfoData taglib = null;
    public static FileObject taglibRootFo = null;
    public static FileObject taglibFo = null;
    public static ArchiveMember taglibArchiveMember = null;
    public static final boolean debug = false;

    public static void setTaglib(TagLibraryInfoData taglib) {
        TaglibArchiveBuilder.taglib = taglib;
    }

    public static void setTaglibRootFo(FileObject root) {
        taglibRootFo = root;
    }

    public static void setTaglibFo(FileObject fo) {
        taglibFo = fo;
    }

    public static FileObject getTaglibFo() {
        FileObject value = taglibFo;
        return value;
    }

    public static void setTaglibArchiveMember(ArchiveMember tm) {
        taglibArchiveMember = tm;
    }

    public static ArchiveMember getTaglibArchiveMember() {
        ArchiveMember value = taglibArchiveMember;
        return value;
    }

    public ArchiveController initController(File target, Map options) {
        return new TaglibArchiveController(taglib, target, options);
    }

    static class TaglibArchiveController
    implements ArchiveController {
        TagLibraryInfoData taglib = null;
        boolean possiblyApplicableToJar = false;
        int processMemberSetCount = 0;
        boolean doneExtraProcessing = false;

        public TaglibArchiveController(TagLibraryInfoData taglib, File target, Map options) {
            this.taglib = taglib;
            this.doneExtraProcessing = false;
            this.processMemberSetCount = 0;
        }

        public void processMemberSet(ArchiveMemberSet set) {
            if (this.processMemberSetCount == 0) {
                this.possiblyApplicableToJar = false;
                if (this.applicableToJar(set)) {
                    this.possiblyApplicableToJar = true;
                } else {
                    return;
                }
            }
            ++this.processMemberSetCount;
            ArchiveMember[] all = set.allMembers();
            int i = 0;
            while (i < all.length) {
                FileObject fo = all[i].getDataObject().getPrimaryFile();
                String name = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile").getResourceName(fo, '/', true);
                String targetDirectory = all[i].getTargetDirectory();
                if (name.indexOf("CVS") >= 0 || name.indexOf("SCCS") >= 0) {
                    set.removeMember(all[i].getDataObject());
                } else if (name.startsWith("META-INF/taglibs") || "META-INF/taglibs".equals(targetDirectory)) {
                    TaglibArchiveBuilder.setTaglibArchiveMember(all[i]);
                    set.removeMember(all[i].getDataObject());
                    return;
                }
                ++i;
            }
        }

        public boolean applicableToJar(ArchiveMemberSet set) {
            ArchiveMember[] all = set.allMembers();
            int i = 0;
            while (i < all.length) {
                DataObject dob;
                String targetDir = all[i].getTargetDirectory();
                if (targetDir != null && targetDir.equals("META-INF/taglibs") && (dob = all[i].getDataObject()) instanceof TLDDataObject) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public ArchiveEntry[] addEntry() {
            DataObject taglibDo;
            if (!this.possiblyApplicableToJar) {
                return null;
            }
            ArchiveMember taglibMember = TaglibArchiveBuilder.getTaglibArchiveMember();
            FileObject taglibFo = null;
            if (taglibMember != null && (taglibDo = taglibMember.getDataObject()) != null) {
                taglibFo = taglibDo.getPrimaryFile();
            }
            if (taglibFo == null) {
                taglibFo = TaglibArchiveBuilder.getTaglibFo();
            }
            FOArchiveEntry taglibEntry = new FOArchiveEntry(taglibFo, "META-INF/taglib.tld");
            ArchiveEntry[] result = new ArchiveEntry[]{taglibEntry};
            this.processMemberSetCount = 0;
            return result;
        }

        public int willPostprocess(ArchiveEntry entry) {
            return 0;
        }

        public InputStream postProcess(ArchiveEntry entry, InputStream input) {
            return input;
        }
    }
}

