/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglibed.control;

import java.beans.FeatureDescriptor;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.jarpackager.ArchiveDescriptor;
import org.netbeans.modules.jarpackager.ContentMember;
import org.netbeans.modules.jarpackager.ContentMemberList;
import org.netbeans.modules.jarpackager.FileObjectFilter;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.JarCreator;
import org.netbeans.modules.jarpackager.JarDataObject;
import org.netbeans.modules.jarpackager.api.ArchiveFilter;
import org.netbeans.modules.web.taglibed.TLDDataObject;
import org.netbeans.modules.web.taglibed.control.IDEHelper;
import org.netbeans.modules.web.taglibed.control.TagLibraryCookie;
import org.netbeans.modules.web.taglibed.control.TldActionSupport;
import org.netbeans.modules.web.taglibed.model.TagAttributeInfoData;
import org.netbeans.modules.web.taglibed.model.TagInfoData;
import org.netbeans.modules.web.taglibed.model.TagLibraryInfoData;
import org.netbeans.modules.web.taglibed.model.TagVariableInfoData;
import org.netbeans.modules.web.taglibed.view.TLDHelperChildren;
import org.netbeans.modules.web.taglibed.view.TLDHelperNode;
import org.netbeans.modules.web.taglibed.view.TLDNode;
import org.netbeans.modules.web.taglibed.view.TagAttributeCustomizer;
import org.netbeans.modules.web.taglibed.view.TagAttributeNode;
import org.netbeans.modules.web.taglibed.view.TagCustomizer;
import org.netbeans.modules.web.taglibed.view.TagNode;
import org.netbeans.modules.web.taglibed.view.TagVariableCustomizer;
import org.netbeans.modules.web.taglibed.view.TagVariableNode;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class TaglibSupport {
    public static final int NODE_TYPES_LOWER_BOUND = 0;
    public static final int TLD_NODE = 0;
    public static final int TAG_NODE = 2;
    public static final int ATTRIBUTES_NODE = 3;
    public static final int ATTRIBUTE_NODE = 4;
    public static final int TEI_NODE = 5;
    public static final int VARIABLE_NODE = 6;
    public static final int CLASSES_NODE = 7;
    public static final int NODE_TYPES_UPPER_BOUND = 8;
    public static final String CLASS_EXT = "class";
    public static final String DOT_CLASS_EXT = ".class";
    public static final String JAR_EXT = "jar";
    public static final String DOT_JAR_EXT = ".jar";
    public static final String JAR_CONTENT_EXT = "jarContent";
    public static final String DOT_JAR_CONTENT_EXT = ".jarContent";
    public static final String TAGLIB_JAR_HOLDING_TARGET = "META-INF/taglibs";
    public static final String TAGLIB_JAR_TARGET = "META-INF/taglib.tld";
    public static final String TAGLIB_JAR_TARGET_DIR = "META-INF";
    public static final String TAGLIB_JAR_TARGET_NAME = "taglib.tld";
    public static final int TLD_PANE = 0;
    public static final int TAG_PANE = 1;
    public static final int ATTRIBUTE_PANE = 2;
    public static final int VARIABLE_PANE = 3;
    private ResourceBundle resBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDDataObject == null ? (class$org$netbeans$modules$web$taglibed$TLDDataObject = TaglibSupport.class$("org.netbeans.modules.web.taglibed.TLDDataObject")) : class$org$netbeans$modules$web$taglibed$TLDDataObject));
    boolean warnIfTooManyTags = true;
    boolean warnOverAndOver = false;
    private static int taglibSeedNum = 0;
    private int tagSeedNum = 0;
    private int attributeSeedNum = 0;
    private int variableSeedNum = 0;
    private static final boolean debug = false;
    private static final boolean debugjar = false;
    static int gensym_index = 0;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$TLDDataObject;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$control$TldActionSupport;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

    public void redisplayTagNode(Node node) {
        TldActionSupport cookie = (TldActionSupport)node.getCookie(class$org$netbeans$modules$web$taglibed$control$TldActionSupport == null ? (class$org$netbeans$modules$web$taglibed$control$TldActionSupport = TaglibSupport.class$("org.netbeans.modules.web.taglibed.control.TldActionSupport")) : class$org$netbeans$modules$web$taglibed$control$TldActionSupport);
        TLDNode n = cookie.getTldNode();
        TLDHelperChildren children = (TLDHelperChildren)n.getChildren();
        children.refreshHelperChildren();
    }

    public void addTagDialog(TldActionSupport cookie, Node node) {
        Vector tags;
        TagLibraryInfoData taglib = cookie.getTaglib();
        TagInfoData tag = this.newTag(taglib);
        tag.disableDirtyBit();
        String title = IDEHelper.getString("TLD_TagCustomizer.addTagTitle");
        TagCustomizer addDialog = TagCustomizer.createAddDialog(title, tag);
        addDialog.open();
        if (!addDialog.addDialogClosedWithOK()) {
            return;
        }
        tag.enableDirtyBit();
        this.addTag(cookie, taglib, tag, node);
        if (this.warnIfTooManyTags && (tags = taglib.getTagsVector()) != null) {
            int numTags = tags.size();
            if (this.warnOverAndOver) {
                if (numTags > 100) {
                    this.showTooManyTagsWarning();
                }
            } else if (numTags == 101) {
                this.showTooManyTagsWarning();
            }
        }
    }

    public void addTagAction(TldActionSupport cookie, Node node) {
        TagLibraryInfoData taglib = cookie.getTaglib();
        TagInfoData tag = this.newTag(taglib);
        this.addTag(cookie, taglib, tag, node);
    }

    private void showTooManyTagsWarning() {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)this.resBundle.getString("TLD_TooManyTagsWarning"), 2));
    }

    public void addTag(TldActionSupport cookie, TagLibraryInfoData taglib, TagInfoData tag, Node filterNode) {
        taglib.addTag(tag);
        TLDDataObject tldDo = cookie.getTLDDataObject();
        TagNode tagNode = new TagNode(tldDo, taglib, tag);
        TLDNode node = cookie.getTldNode();
        TLDHelperChildren children = (TLDHelperChildren)node.getChildren();
        children.refreshHelperChildren();
        TopComponent tc = TopComponent.getRegistry().getActivated();
        if (tc instanceof ExplorerManager.Provider) {
            ExplorerManager em = ((ExplorerManager.Provider)tc).getExplorerManager();
            try {
                em.setSelectedNodes(new Node[]{filterNode.getChildren().findChild(((FeatureDescriptor)((Object)tagNode)).getName())});
            }
            catch (PropertyVetoException exc) {
                // empty catch block
            }
        }
    }

    public TagInfoData newTag(TagLibraryInfoData taglib) {
        TagInfoData tag = new TagInfoData(taglib);
        tag.disableDirtyBit();
        tag.setTagName(this.ensureUniqueTagName(taglib, this.resBundle.getString("TLD_TaglibSupport.NewTag")));
        String tagPkg = taglib.ensureShortName().toLowerCase();
        tag.setPackageName(tagPkg);
        tag.ensureTagDefaults();
        tag.enableDirtyBit();
        return tag;
    }

    public void addTagAttributeDialog(TldActionSupport cookie, Node node) {
        TagLibraryInfoData taglib = cookie.getTaglib();
        TagInfoData tag = cookie.getTag();
        TagAttributeInfoData tagatt = this.newTagAttribute(tag);
        String title = IDEHelper.getString("TLD_TagAttributeCustomizer.addTagAttributeTitle");
        TagAttributeCustomizer addDialog = TagAttributeCustomizer.createAddDialog(title, tagatt);
        addDialog.open();
        if (!addDialog.addDialogClosedWithOK()) {
            return;
        }
        this.addTagAttribute(cookie, taglib, tag, tagatt, node);
    }

    public void addTagAttributeAction(TldActionSupport cookie, Node node) {
        TagLibraryInfoData taglib = cookie.getTaglib();
        TagInfoData tag = cookie.getTag();
        TagAttributeInfoData tagatt = this.newTagAttribute(tag);
        this.addTagAttribute(cookie, taglib, tag, tagatt, node);
    }

    private void addTagAttribute(TldActionSupport cookie, TagLibraryInfoData taglib, TagInfoData tag, TagAttributeInfoData tagatt, Node node) {
        TopComponent tc;
        TLDHelperChildren children;
        tag.addAttribute(tagatt);
        TLDDataObject tldDo = cookie.getTLDDataObject();
        TagAttributeNode tagattNode = new TagAttributeNode(tldDo, taglib, tag, tagatt);
        TLDHelperNode n = cookie.getTldHelperNode_Attributes();
        if (n != null && (children = (TLDHelperChildren)n.getChildren()) != null) {
            children.refreshHelperChildren();
        }
        if ((tc = TopComponent.getRegistry().getActivated()) instanceof ExplorerManager.Provider) {
            ExplorerManager em = ((ExplorerManager.Provider)tc).getExplorerManager();
            try {
                Node newAttNode = node.getChildren().findChild(((FeatureDescriptor)((Object)tagattNode)).getName());
                if (newAttNode == null && n != null) {
                    Node tnode = node.getChildren().findChild(((FeatureDescriptor)((Object)n)).getName());
                    newAttNode = tnode.getChildren().findChild(((FeatureDescriptor)((Object)tagattNode)).getName());
                }
                if (newAttNode != null) {
                    em.setSelectedNodes(new Node[]{newAttNode});
                }
            }
            catch (PropertyVetoException exc) {
                // empty catch block
            }
        }
    }

    public TagAttributeInfoData newTagAttribute(TagInfoData tag) {
        TagAttributeInfoData tagatt = new TagAttributeInfoData(tag);
        tagatt.setName(this.ensureUniqueTagAttributeName(tag, this.resBundle.getString("TLD_TaglibSupport.newAttribute")));
        return tagatt;
    }

    public void addTagVariableDialog(TldActionSupport cookie, Node node) {
        TagLibraryInfoData taglib = cookie.getTaglib();
        TagInfoData tag = cookie.getTag();
        TagVariableInfoData tagvar = this.newTagVariable(tag);
        String title = IDEHelper.getString("TLD_TagVariableCustomizer.addTagVariableTitle");
        TagVariableCustomizer addDialog = TagVariableCustomizer.createAddDialog(title, tagvar);
        addDialog.open();
        if (!addDialog.addDialogClosedWithOK()) {
            return;
        }
        this.addTagVariable(cookie, taglib, tag, tagvar, node);
    }

    public void addTagVariableAction(TldActionSupport cookie, Node node) {
        TagLibraryInfoData taglib = cookie.getTaglib();
        TagInfoData tag = cookie.getTag();
        TagVariableInfoData tagvar = this.newTagVariable(tag);
        this.addTagVariable(cookie, taglib, tag, tagvar, node);
    }

    private void addTagVariable(TldActionSupport cookie, TagLibraryInfoData taglib, TagInfoData tag, TagVariableInfoData tagvar, Node node) {
        TopComponent tc;
        TLDHelperChildren children;
        tag.addVariable(tagvar);
        TLDDataObject tldDo = cookie.getTLDDataObject();
        TagVariableNode tagvarNode = new TagVariableNode(tldDo, taglib, tag, tagvar);
        TLDHelperNode n = cookie.getTldHelperNode_Variables();
        if (n != null && (children = (TLDHelperChildren)n.getChildren()) != null) {
            children.refreshHelperChildren();
        }
        if ((tc = TopComponent.getRegistry().getActivated()) instanceof ExplorerManager.Provider) {
            ExplorerManager em = ((ExplorerManager.Provider)tc).getExplorerManager();
            try {
                Node newVarNode = node.getChildren().findChild(((FeatureDescriptor)((Object)tagvarNode)).getName());
                if (newVarNode == null && n != null) {
                    Node vnode = node.getChildren().findChild(((FeatureDescriptor)((Object)n)).getName());
                    newVarNode = vnode.getChildren().findChild(((FeatureDescriptor)((Object)tagvarNode)).getName());
                }
                if (newVarNode != null) {
                    em.setSelectedNodes(new Node[]{newVarNode});
                }
            }
            catch (PropertyVetoException exc) {
                // empty catch block
            }
        }
    }

    public TagVariableInfoData newTagVariable(TagInfoData tag) {
        TagVariableInfoData tagvar = new TagVariableInfoData(tag);
        tagvar.setName(this.ensureUniqueTagVariableName(tag, this.resBundle.getString("TLD_TaglibSupport.newVariable")));
        return tagvar;
    }

    public static String ensureUniqueTagLibraryName(FileObject targetFolder, String seed) {
        int seedSize = seed.length();
        StringBuffer newNameBuf = new StringBuffer(seedSize + 5);
        newNameBuf.append(seed);
        String newNameString = seed;
        while (!TaglibSupport.isUniqueTagLibraryName(targetFolder, newNameString)) {
            newNameBuf.insert(seedSize, ++taglibSeedNum);
            newNameString = newNameBuf.toString();
        }
        return newNameString;
    }

    public static boolean isUniqueTagLibraryName(FileObject targetFolder, String proposedName) {
        return targetFolder.getFileObject(proposedName, "tld") == null;
    }

    public String ensureUniqueTagName(TagLibraryInfoData taglib, String seed) {
        int seedSize = seed.length();
        StringBuffer newNameBuf = new StringBuffer(seedSize + 5);
        newNameBuf.append(seed);
        String newNameString = seed;
        while (!this.isUniqueTagName(taglib, newNameString)) {
            ++this.tagSeedNum;
            newNameBuf.insert(seedSize, this.tagSeedNum);
            newNameString = newNameBuf.toString();
        }
        return newNameString;
    }

    public boolean isUniqueTagName(TagLibraryInfoData taglib, String proposedName) {
        Vector tags = taglib.getTagsVector();
        if (tags == null) {
            return true;
        }
        Enumeration en = tags.elements();
        while (en.hasMoreElements()) {
            TagInfoData tag = (TagInfoData)en.nextElement();
            if (!proposedName.equals(tag.getTagName())) continue;
            return false;
        }
        return true;
    }

    public String ensureUniqueTagAttributeName(TagInfoData tag, String seed) {
        int seedSize = seed.length();
        StringBuffer newNameBuf = new StringBuffer(seedSize + 5);
        newNameBuf.append(seed);
        String newNameString = seed;
        while (!this.isUniqueTagAttributeName(tag, newNameString)) {
            ++this.attributeSeedNum;
            newNameBuf.insert(seedSize, this.attributeSeedNum);
            newNameString = newNameBuf.toString();
        }
        return newNameString;
    }

    public boolean isUniqueTagAttributeName(TagInfoData tag, String proposedName) {
        Vector atts = tag.getAttributesVector();
        if (atts == null) {
            return true;
        }
        Enumeration en = atts.elements();
        while (en.hasMoreElements()) {
            TagAttributeInfoData att = (TagAttributeInfoData)en.nextElement();
            if (!proposedName.equals(att.getName())) continue;
            return false;
        }
        return true;
    }

    public String ensureUniqueTagVariableName(TagInfoData tag, String seed) {
        int seedSize = seed.length();
        StringBuffer newNameBuf = new StringBuffer(seedSize + 5);
        newNameBuf.append(seed);
        String newNameString = seed;
        while (!this.isUniqueTagVariableName(tag, newNameString)) {
            ++this.variableSeedNum;
            newNameBuf.insert(seedSize, this.variableSeedNum);
            newNameString = newNameBuf.toString();
        }
        return newNameString;
    }

    public boolean isUniqueTagVariableName(TagInfoData tag, String proposedName) {
        Vector atts = tag.getVariablesVector();
        if (atts == null) {
            return true;
        }
        Enumeration en = atts.elements();
        while (en.hasMoreElements()) {
            TagVariableInfoData att = (TagVariableInfoData)en.nextElement();
            if (!proposedName.equals(att.getName())) continue;
            return false;
        }
        return true;
    }

    public void deleteItem(TldActionSupport cookie, Node n) {
        int type = cookie.getType();
        if (type >= 0 && type <= 8) {
            switch (type) {
                case 0: {
                    break;
                }
                case 2: {
                    this.deleteTag(cookie, n);
                    break;
                }
                case 4: {
                    this.deleteAttribute(cookie, n);
                    break;
                }
                case 6: {
                    this.deleteVariable(cookie, n);
                    break;
                }
            }
        }
    }

    public void deleteTag(TldActionSupport cookie, Node n) {
        TagLibraryInfoData taglib = cookie.getTaglib();
        TagInfoData tag = cookie.getTag();
        taglib.deleteTag(tag);
        try {
            n.destroy();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    public void destroyNode(Node n) {
        try {
            n.destroy();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    public void deleteAttribute(TldActionSupport cookie, Node n) {
        TagLibraryInfoData taglib = cookie.getTaglib();
        TagInfoData tag = cookie.getTag();
        TagAttributeInfoData tagatt = cookie.getTagAttribute();
        tag.deleteAttribute(tagatt);
        try {
            n.destroy();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    public void deleteVariable(TldActionSupport cookie, Node n) {
        TagLibraryInfoData taglib = cookie.getTaglib();
        TagInfoData tag = cookie.getTag();
        TagVariableInfoData tagvar = cookie.getTagVariable();
        tag.deleteVariable(tagvar);
        try {
            n.destroy();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    public void saveTaglibIfNecessary(TldActionSupport cookie, Node n) {
        try {
            TLDDataObject tdo = cookie.getTLDDataObject();
            SaveCookie savec = (SaveCookie)tdo.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = TaglibSupport.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
            if (savec != null) {
                savec.save();
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    public void saveTaglib(TldActionSupport cookie, Node n, boolean checkIfNecessary) {
        TLDDataObject tdo = cookie.getTLDDataObject();
        this.saveTaglib(tdo, checkIfNecessary);
    }

    public void saveTaglib(TLDDataObject obj, boolean checkIfNecessary) {
        FileObject fo = obj.getPrimaryFile();
        FileObject root = fo.getParent();
        TagLibraryInfoData taglib = obj.getTaglib();
        if (checkIfNecessary && !taglib.isDirty()) {
            return;
        }
        String dir = taglib.getTldDirectory();
        String tldFileName = taglib.getTldFileName();
        boolean overwrite = true;
        if (tldFileName.endsWith(".tld")) {
            try {
                String tldName = tldFileName.substring(0, tldFileName.length() - ".tld".length());
                StringBuffer buf = new StringBuffer(4096);
                taglib.writeExtendedTagLibraryDescriptor(buf);
                IDEHelper.saveFileAs(root, tldName, "tld", buf.toString(), overwrite, null);
                taglib.clearTldDirtyBit();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    public void packageTaglibInJar(TldActionSupport cookie) {
        TagLibraryInfoData taglib = cookie.getTaglib();
        TLDDataObject tlddo = cookie.getTLDDataObject();
        this.packageTaglibInJar(tlddo, taglib);
    }

    public void packageTaglibInJar(TLDDataObject tlddo, TagLibraryInfoData taglib) {
        try {
            FileObject tagHandlerRoot;
            FileObject taglibFo = tlddo.getFileObject();
            FileObject delegateTagHandlerRootFo = tagHandlerRoot = IDEHelper.ensureTagHandlerGenerationRootIsMounted(taglibFo.getParent(), taglib);
            String jarFileAbs = this.resolveJarFileAbsolutePath(taglib, taglibFo);
            int lastSlash = jarFileAbs.lastIndexOf(47);
            String jarParentPath = jarFileAbs.substring(0, lastSlash);
            String jarName = jarFileAbs.substring(lastSlash + 1);
            FileObject jarParentFo = IDEHelper.findOrMountFileObject(jarParentPath);
            JarDataObject jardo = this.getJarContentDataObject(taglib, jarParentFo, jarName, jarFileAbs);
            JarContent jarc = jardo.getJarContent();
            FileObject jcFo = jardo.getPrimaryFile();
            this.updateJarContentMembers(jarc, taglib, tlddo, taglibFo, delegateTagHandlerRootFo);
            jardo.setModified(true);
            this.updateJar(jcFo, jarParentFo, jarName, jarc, taglib);
            jardo.save();
            Object[] o = new Object[]{jarFileAbs};
            IDEHelper.showInfoMessageI18N("TLD_PackageTldJarAction.Jar_File_Written", o);
        }
        catch (Exception ex) {
            this.notifyCreationError(ex, "MSG_CannotCreateJar");
        }
    }

    public JarDataObject getJarContentDataObject(TagLibraryInfoData taglib, FileObject jarParentFo, String jarName, String jarFileAbsolutePath) {
        JarDataObject jardo = null;
        try {
            jardo = this.findOrCreateJarDataObject(jarParentFo, jarName);
            if (jardo == null) {
                return null;
            }
            JarContent jc = jardo.getJarContent();
            String jarFileAbsPathExt = jarFileAbsolutePath + '.' + JAR_EXT;
            File jarFileFile = new File(jarFileAbsPathExt);
            jc.setTargetFile(jarFileFile);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return jardo;
    }

    public JarDataObject findOrCreateJarDataObject(FileObject jarParentFo, String jarName) throws IOException {
        JarDataObject jardo = null;
        FileObject jcFo = jarParentFo.getFileObject(jarName, JAR_CONTENT_EXT);
        if (jcFo == null) {
            jcFo = jarParentFo.createData(jarName, JAR_CONTENT_EXT);
        }
        if (jcFo != null) {
            jardo = (JarDataObject)DataObject.find((FileObject)jcFo);
        }
        return jardo;
    }

    public String fullPathName(FileObject fo, String ext) {
        String fileNoExt = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile").getResourceName(fo, '/', false);
        String fileName = ext != null ? fileNoExt + "." + ext : fileNoExt;
        String path = null;
        try {
            FileSystem fs = fo.getFileSystem();
            String fsName = fs.getSystemName();
            String fsNameNoColons = fsName.replace(':', '/');
            path = fsNameNoColons + "/" + fileName;
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return path;
    }

    public static FileObject[] getTagHandlerFilesForJar(TagLibraryInfoData taglib, FileObject parentFo) {
        Vector tagsVector = taglib.getTagsVector();
        HashSet<String> packagesSet = new HashSet<String>();
        Vector<String> looseHandlerFiles = new Vector<String>();
        Vector<FileObject> results = new Vector<FileObject>();
        Enumeration en = tagsVector.elements();
        while (en.hasMoreElements()) {
            TagInfoData tag = (TagInfoData)en.nextElement();
            String tagPackage = tag.getPackageName();
            if (tagPackage == null || tagPackage.trim().equals("")) {
                String teiClass;
                String tagClass = tag.getTagClassName();
                if (tagClass != null && !tagClass.trim().equals("")) {
                    looseHandlerFiles.addElement(tagClass);
                }
                if ((teiClass = tag.getTeiClassName()) == null || teiClass.trim().equals("")) continue;
                looseHandlerFiles.addElement(teiClass);
                continue;
            }
            packagesSet.add(tagPackage);
        }
        Vector<String> unfoundClassFiles = new Vector<String>();
        Enumeration en2 = looseHandlerFiles.elements();
        while (en2.hasMoreElements()) {
            String handlerClassName = (String)en2.nextElement();
            FileObject fo = parentFo.getFileObject(handlerClassName, CLASS_EXT);
            if (fo != null) {
                results.addElement(fo);
                continue;
            }
            unfoundClassFiles.addElement(handlerClassName);
        }
        Iterator it = packagesSet.iterator();
        while (it.hasNext()) {
            String packageName = (String)it.next();
            FileObject fo = TaglibSupport.getPackageFileObject(parentFo, packageName);
            if (fo == null) continue;
            results.addElement(fo);
        }
        FileObject[] resultsArray = new FileObject[results.size()];
        int i = 0;
        Enumeration en3 = results.elements();
        while (en3.hasMoreElements()) {
            resultsArray[i] = (FileObject)en3.nextElement();
            ++i;
        }
        return resultsArray;
    }

    void printFileObjectChildren(FileObject parentFo) {
        Enumeration children = parentFo.getChildren(false);
        System.out.println("     FileObject: " + parentFo + "   ------- children: ---- ");
        while (children.hasMoreElements()) {
            FileObject child = (FileObject)children.nextElement();
            System.out.println("        " + child);
        }
        System.out.println("     ========================");
    }

    public static FileObject getPackageFileObject(FileObject parentFo, String packageName) {
        if (packageName == null) {
            return parentFo;
        }
        int firstDot = packageName.indexOf(46);
        if (firstDot < 0) {
            FileObject fo = parentFo.getFileObject(packageName);
            return fo;
        }
        String topLevelPackageString = packageName.substring(0, firstDot);
        String restOfPackageString = packageName.substring(firstDot + 1);
        FileObject topPkg = parentFo.getFileObject(topLevelPackageString);
        return TaglibSupport.getPackageFileObject(topPkg, restOfPackageString);
    }

    public void updateJar(FileObject jarContentFo, FileObject parentFo, String jarFileName, JarContent jc, TagLibraryInfoData taglib) throws IOException {
        JarCreator creator;
        block6: {
            File jarFile = null;
            jarFile = jc.getTargetFile();
            if (jarFile != null && jarFile.exists()) {
                jarFile.delete();
            }
            creator = null;
            FileOutputStream fos = null;
            try {
                jarFile.delete();
                fos = new FileOutputStream(jarFile);
                creator = new JarCreator((ArchiveDescriptor)jc);
                creator.createJar((OutputStream)fos, jarFile);
                Object var10_9 = null;
                if (fos == null) break block6;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (fos != null) {
                    fos.close();
                }
                if (creator != null) {
                    // empty if block
                }
                throw throwable;
            }
            fos.close();
        }
        if (creator != null) {
            // empty if block
        }
    }

    private void updateJarContentMembers(JarContent jarc, TagLibraryInfoData taglib, TLDDataObject tlddo, FileObject taglibFo, FileObject rootFo) {
        ContentMemberList jarContentMembers = jarc.getContentList();
        try {
            TLDDataObject daisy = tlddo.getClone();
            int existingDaisyIndex = this.findTargettedDataObjectName(jarContentMembers, (DataObject)daisy, TAGLIB_JAR_TARGET_DIR);
            if (existingDaisyIndex != -1) {
                jarContentMembers.removeMember(existingDaisyIndex);
            }
            jarContentMembers.addMember((DataObject)daisy, TAGLIB_JAR_TARGET_DIR);
        }
        catch (CloneNotSupportedException ex) {
            // empty catch block
        }
        if (!taglibFo.getName().equals("taglib")) {
            boolean currentTagLibraryOverwritesMetaInfSlashTaglibDotTld = false;
            int metainfTaglibIndex = this.findTargettedMember(jarContentMembers, TAGLIB_JAR_TARGET_DIR, TAGLIB_JAR_TARGET_NAME);
            if (metainfTaglibIndex != -1) {
                if (currentTagLibraryOverwritesMetaInfSlashTaglibDotTld) {
                    jarContentMembers.removeMember(metainfTaglibIndex);
                    jarContentMembers.addMember((DataObject)tlddo, TAGLIB_JAR_TARGET_DIR, TAGLIB_JAR_TARGET_NAME);
                }
            } else {
                int taglibDotTldEntry = this.findUntargettedTaglibDotTldEntry(jarContentMembers);
                if (taglibDotTldEntry == -1) {
                    jarContentMembers.addMember((DataObject)tlddo, TAGLIB_JAR_TARGET_DIR, TAGLIB_JAR_TARGET_NAME);
                }
            }
        } else {
            int metainfTaglibIndex = this.findTargettedMember(jarContentMembers, TAGLIB_JAR_TARGET_DIR, TAGLIB_JAR_TARGET_NAME);
            if (metainfTaglibIndex != -1) {
                jarContentMembers.removeMember(metainfTaglibIndex);
            }
        }
        FileObject[] filesToPut = TaglibSupport.getTagHandlerFilesForJar(taglib, rootFo);
        try {
            int i = 0;
            while (i < filesToPut.length) {
                FileObject fo = filesToPut[i];
                DataObject fdo = DataObject.find((FileObject)fo);
                if (fdo != null) {
                    DataObject matchingMember = this.findDataObjectInContentMembers(fdo, jarContentMembers);
                    if (matchingMember != null) {
                        jarContentMembers.removeMember(matchingMember);
                    }
                    FileObjectFilter filter = JarContent.ALL;
                    ContentMember member = new ContentMember(fdo, (ArchiveFilter)filter, null, true);
                    jarContentMembers.add(member);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        jarc.setContentList(jarContentMembers);
    }

    private int findTargettedMember(ContentMemberList jarContentMembers, String targetDir, String targetName) {
        int i = 0;
        while (i < jarContentMembers.size()) {
            ContentMember cm = (ContentMember)jarContentMembers.get(i);
            if ((targetDir == null || targetDir.equals(cm.getTargetDirectory())) && (targetName == null || targetName.equals(cm.getTargetName()))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int findUntargettedTaglibDotTldEntry(ContentMemberList jarContentMembers) {
        int i = 0;
        while (i < jarContentMembers.size()) {
            String targetName;
            ContentMember cm = (ContentMember)jarContentMembers.get(i);
            DataObject dob = cm.getDataObject();
            String name = dob.getPrimaryFile().getNameExt();
            if (TAGLIB_JAR_TARGET_NAME.equals(name) && ((targetName = cm.getTargetName()) == null || targetName.equals(""))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int findTargettedDataObjectName(ContentMemberList jarContentMembers, DataObject dob, String targetDir) {
        String targetDOBName = dob.getName();
        int i = 0;
        while (i < jarContentMembers.size()) {
            ContentMember cm = (ContentMember)jarContentMembers.get(i);
            DataObject cmdo = cm.getDataObject();
            if (targetDOBName.equals(cmdo.getName()) && (targetDir == null || targetDir.equals(cm.getTargetDirectory())) && (cm.getTargetName() == null || cm.getTargetName().equals(""))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String resolveJarFileAbsolutePath(TagLibraryInfoData taglib, FileObject taglibFo) {
        String absJarFilePath;
        String jarFile = taglib.getJarFile();
        String taglibName = taglibFo.getName();
        if (jarFile == null || jarFile.equals("")) {
            FileObject taglibParentFo = taglibFo.getParent();
            File tpf = FileUtil.toFile((FileObject)taglibParentFo);
            String parentPath = tpf.getAbsolutePath();
            absJarFilePath = parentPath + "/" + taglibName;
        } else if (IDEHelper.isRelative(jarFile)) {
            FileObject taglibParentFo = taglibFo.getParent();
            File tpf = FileUtil.toFile((FileObject)taglibParentFo);
            String parentPath = tpf.getAbsolutePath();
            absJarFilePath = parentPath + "/" + jarFile;
        } else {
            absJarFilePath = jarFile;
        }
        absJarFilePath = absJarFilePath.replace('\\', '/');
        if (absJarFilePath.endsWith(DOT_JAR_EXT)) {
            absJarFilePath = absJarFilePath.substring(0, absJarFilePath.length() - 4);
        }
        return absJarFilePath;
    }

    private DataObject findDataObjectInContentMembers(DataObject dob, ContentMemberList jarContentMembers) {
        FileObject fo = dob.getPrimaryFile();
        String path = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile").getResourceName(fo, '/', true);
        int i = 0;
        while (i < jarContentMembers.size()) {
            ContentMember member = (ContentMember)jarContentMembers.get(i);
            DataObject mdo = member.getDataObject();
            if (mdo.equals(dob)) {
                return mdo;
            }
            FileObject mfo = mdo.getPrimaryFile();
            String mpath = ClassPath.getClassPath((FileObject)mfo, (String)"classpath/compile").getResourceName(mfo, '/', true);
            if (mpath.equals(path)) {
                return mdo;
            }
            ++i;
        }
        return null;
    }

    private void debugPrintJarContents(ContentMemberList jarContentMembers) {
        System.out.println("     <jarContentMembers> DataObjects ");
        Enumeration en = jarContentMembers.enumerateDataObjects();
        while (en.hasMoreElements()) {
            DataObject dob = (DataObject)en.nextElement();
            System.out.println("         " + dob);
        }
        System.out.println("     </jarContentMembers> ");
        System.out.println("     <jarContentMembers> ContentMembers ");
        int i = 0;
        while (i < jarContentMembers.size()) {
            ContentMember cm = (ContentMember)jarContentMembers.get(i);
            System.out.println("        do: " + cm.getDataObject());
            System.out.println("         targetdir: " + cm.getTargetDirectory());
            System.out.println("         targetname: " + cm.getTargetName());
            ++i;
        }
        System.out.println("     </jarContentMembers> ");
    }

    String normalizedTargetPath(String targetPath) {
        if (targetPath.trim().equals("")) {
            return null;
        }
        int endMark = targetPath.lastIndexOf(".");
        if (endMark < 0) {
            targetPath = targetPath + DOT_JAR_EXT;
        }
        return targetPath;
    }

    public void notifyCreationError(Exception ex, String msg) {
        MessageFormat msgFormat = new MessageFormat(this.resBundle.getString("TLD_TaglibSupport.Notify_Creation_Error"));
        Object[] obj = new Object[]{msg, ex};
        String fmsg = msgFormat.format(obj);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)fmsg, 2));
    }

    public void pasteTag(TagLibraryCookie cookie) {
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (nodes != null && nodes.length > 0) {
            TagInfoData tag = cookie.getTag();
            int i = 0;
            while (i < nodes.length) {
                TagLibraryCookie tldCookie = (TagLibraryCookie)nodes[i].getCookie(class$org$netbeans$modules$web$taglibed$control$TldActionSupport == null ? TaglibSupport.class$("org.netbeans.modules.web.taglibed.control.TldActionSupport") : class$org$netbeans$modules$web$taglibed$control$TldActionSupport);
                TagLibraryInfoData taglib = tldCookie.getTaglib();
                TagInfoData newtag = this.cloneTag(tag, taglib);
                String newtagname = this.ensureUniqueTagName(taglib, newtag.getTagName());
                newtag.setTagName(newtagname);
                newtag.useDefaultTagClassName();
                if (newtag.hasVariables()) {
                    newtag.useDefaultTeiClassName();
                }
                taglib.addTag(newtag);
                this.redisplayTagNode(nodes[i]);
                ++i;
            }
        }
    }

    public void pasteAttribute(TagLibraryCookie cookie) {
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (nodes != null && nodes.length > 0) {
            TagAttributeInfoData att = cookie.getTagAttribute();
            int i = 0;
            while (i < nodes.length) {
                TldActionSupport support = (TldActionSupport)nodes[i].getCookie(class$org$netbeans$modules$web$taglibed$control$TldActionSupport == null ? TaglibSupport.class$("org.netbeans.modules.web.taglibed.control.TldActionSupport") : class$org$netbeans$modules$web$taglibed$control$TldActionSupport);
                TagInfoData tag = support.getTag();
                TagAttributeInfoData newatt = this.cloneTagAttribute(tag, att);
                String newattname = this.ensureUniqueTagAttributeName(tag, newatt.getName());
                newatt.setName(newattname);
                tag.addAttribute(newatt);
                TLDHelperNode hn = null;
                int type = support.getType();
                if (type == 2) {
                    TagNode n = support.getTagNode();
                    TLDHelperChildren siblings = (TLDHelperChildren)n.getChildren();
                    hn = (TLDHelperNode)siblings.getNodes()[0];
                } else if (type == 3) {
                    hn = support.getTldHelperNode_Attributes();
                }
                if (hn != null) {
                    TLDHelperChildren children = (TLDHelperChildren)hn.getChildren();
                    children.refreshHelperChildren();
                }
                ++i;
            }
        }
    }

    public void pasteVariable(TagLibraryCookie cookie) {
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (nodes != null && nodes.length > 0) {
            TagVariableInfoData tagvar = cookie.getTagVariable();
            int i = 0;
            while (i < nodes.length) {
                TldActionSupport support = (TldActionSupport)nodes[i].getCookie(class$org$netbeans$modules$web$taglibed$control$TldActionSupport == null ? TaglibSupport.class$("org.netbeans.modules.web.taglibed.control.TldActionSupport") : class$org$netbeans$modules$web$taglibed$control$TldActionSupport);
                TagInfoData tag = support.getTag();
                TagVariableInfoData newvar = this.cloneTagVariable(tag, tagvar);
                String newvarname = this.ensureUniqueTagVariableName(tag, newvar.getName());
                newvar.setName(newvarname);
                tag.addVariable(newvar);
                TLDHelperNode hn = null;
                int type = support.getType();
                if (type == 2) {
                    TagNode n = support.getTagNode();
                    TLDHelperChildren siblings = (TLDHelperChildren)n.getChildren();
                    hn = (TLDHelperNode)siblings.getNodes()[1];
                } else if (type == 5) {
                    hn = support.getTldHelperNode_Variables();
                }
                if (hn != null) {
                    TLDHelperChildren children = (TLDHelperChildren)hn.getChildren();
                    children.refreshHelperChildren();
                }
                ++i;
            }
        }
    }

    public TagInfoData cloneTag(TagInfoData tag, TagLibraryInfoData taglibInfo) {
        String teiClassName;
        String pvar;
        String ii;
        TagInfoData newtag = new TagInfoData(taglibInfo);
        newtag.disableDirtyBit();
        newtag.setTagName(new String(tag.getTagName()));
        newtag.setTagClassName(new String(tag.getTagClassName()));
        newtag.setBodyContent(new String(tag.getBodyContent()));
        newtag.setDescription(tag.getDescription() == null ? null : new String(tag.getDescription()));
        newtag.setExample(tag.getExample() == null ? null : new String(tag.getExample()));
        Vector attributeInfo = tag.getAttributesVector();
        if (attributeInfo != null && attributeInfo.size() > 0) {
            Vector<TagAttributeInfoData> attVector = new Vector<TagAttributeInfoData>();
            Enumeration en = attributeInfo.elements();
            while (en.hasMoreElements()) {
                TagAttributeInfoData att = (TagAttributeInfoData)en.nextElement();
                TagAttributeInfoData newatt = this.cloneTagAttribute(newtag, att);
                attVector.addElement(newatt);
            }
            newtag.setAttributesVector(attVector);
        }
        if (tag.hasVariables()) {
            Vector<TagVariableInfoData> varVector = new Vector<TagVariableInfoData>();
            Enumeration en = tag.getVariablesVector().elements();
            while (en.hasMoreElements()) {
                TagVariableInfoData variableInfo = (TagVariableInfoData)en.nextElement();
                TagVariableInfoData newvar = this.cloneTagVariable(newtag, variableInfo);
                varVector.addElement(newvar);
            }
            newtag.setVariablesVector(varVector);
        }
        newtag.setImports(new String(tag.getImports()));
        String pkgName = tag.getPackageName();
        if (pkgName != null) {
            newtag.setPackageName(new String(tag.getPackageName()));
        }
        if ((ii = tag.getImplementsInterface()) != null) {
            newtag.setImplementsInterface(new String(ii));
        }
        newtag.setExtendsSupportClass(tag.getExtendsSupportClass());
        String sc = tag.getSupportClass();
        if (sc != null) {
            newtag.setSupportClass(new String(sc));
        }
        newtag.setImplementsTryCatchFinally(tag.getImplementsTryCatchFinally());
        newtag.setFindParent(tag.getFindParent());
        String ptype = tag.getParentType();
        if (ptype != null) {
            newtag.setParentType(new String(ptype));
        }
        if ((pvar = tag.getParentVariable()) != null) {
            newtag.setParentVariable(new String(pvar));
        }
        if ((teiClassName = tag.getTeiClassName()) != null) {
            newtag.setTeiClassName(new String(teiClassName));
        }
        newtag.enableDirtyBit();
        return newtag;
    }

    public TagAttributeInfoData cloneTagAttribute(TagInfoData tag, TagAttributeInfoData att) {
        String reftagvar;
        TagAttributeInfoData tagatt = new TagAttributeInfoData(tag);
        tagatt.disableDirtyBit();
        tagatt.setName(new String(att.getName()));
        tagatt.setTypeName(new String(att.getTypeName()));
        tagatt.setRequestTime(att.getRequestTime());
        tagatt.setRequired(att.getRequired());
        tagatt.setDefaultValue(new String(att.getDefaultValue()));
        tagatt.setIsReferenceID(att.getIsReferenceID());
        tagatt.setReferencesTag(att.getReferencesTag());
        String reftagtype = att.getReferencesTagType();
        if (reftagtype != null) {
            tagatt.setReferencesTagType(new String(reftagtype));
        }
        if ((reftagvar = att.getReferencesTagVariable()) != null) {
            tagatt.setReferencesTagVariable(new String(reftagvar));
        }
        tagatt.setReferencesTagReferentFirst(att.getReferencesTagReferentFirst());
        tagatt.setReferenceScope(att.getReferenceScope());
        tagatt.enableDirtyBit();
        return tagatt;
    }

    public TagVariableInfoData cloneTagVariable(TagInfoData tag, TagVariableInfoData variableInfo) {
        TagVariableInfoData tagvar = new TagVariableInfoData(tag);
        tagvar.disableDirtyBit();
        tagvar.setName(new String(variableInfo.getName()));
        tagvar.setNameType(variableInfo.getNameType());
        String nameatt = variableInfo.getNameAttribute();
        if (nameatt != null) {
            tagvar.setNameAttribute(new String(nameatt));
        }
        tagvar.setType(new String(variableInfo.getType()));
        tagvar.setScope(variableInfo.getScope());
        tagvar.setDeclare(variableInfo.getDeclare());
        tagvar.enableDirtyBit();
        return tagvar;
    }

    public void updateTagCustomizer(TagLibraryInfoData taglib, TagInfoData tag) {
        TagCustomizer c = TagCustomizer.getCustomizer();
        TagAttributeCustomizer catt = TagAttributeCustomizer.getCustomizer();
        if (c != null && !taglib.getRegenerationOn()) {
            TagCustomizer.getDefault(tag);
        }
    }

    public void updateTagAttributeCustomizer(TagLibraryInfoData taglib, TagAttributeInfoData tagatt) {
        TagAttributeCustomizer c = TagAttributeCustomizer.getCustomizer();
        if (c != null && !taglib.getRegenerationOn()) {
            TagAttributeCustomizer.getDefault(tagatt);
        }
    }

    public void updateTagVariableCustomizer(TagLibraryInfoData taglib, TagVariableInfoData tagvar) {
        TagVariableCustomizer c = TagVariableCustomizer.getCustomizer();
        if (c != null && !taglib.getRegenerationOn()) {
            TagVariableCustomizer.getDefault(tagvar);
        }
    }

    public static String gensym(String seed) {
        return seed + ++gensym_index;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

