/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglibed.model;

public class CommentItem {
    public static final int COMMENT = 0;
    public static final int CHARACTERS = 1;
    private static String commentStartDelimiter = "<!--";
    private static String commentEndDelimiter = "-->";
    private static int startDelimiterLength = 4;
    private static int endDelimiterLength = 3;
    private int type;
    private String contents;

    public CommentItem(int type, String contents) {
        this.type = type;
        this.contents = contents;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int value) {
        this.type = value;
    }

    public String getContents() {
        return this.contents;
    }

    public void setContents(String value) {
        this.contents = value;
    }

    public String toString() {
        switch (this.type) {
            case 0: {
                int finalLength = this.contents.length() + startDelimiterLength + endDelimiterLength;
                StringBuffer buf = new StringBuffer(finalLength);
                buf.append(commentStartDelimiter);
                buf.append(this.contents);
                buf.append(commentEndDelimiter);
                return buf.toString();
            }
            case 1: {
                return this.contents;
            }
        }
        return null;
    }

    public void toString(StringBuffer buf) {
        switch (this.type) {
            case 0: {
                buf.append(commentStartDelimiter);
                buf.append(this.contents);
                buf.append(commentEndDelimiter);
                break;
            }
            case 1: {
                buf.append(this.contents);
                break;
            }
        }
    }

    public static void setCommentDelimiters(String startDelimiter, String endDelimiter) {
        commentStartDelimiter = startDelimiter == null ? "" : startDelimiter;
        commentEndDelimiter = endDelimiter == null ? "" : endDelimiter;
        startDelimiterLength = startDelimiter.length();
        endDelimiterLength = endDelimiter.length();
    }
}

