/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglibed.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.Vector;
import org.netbeans.modules.web.taglibed.model.CommentCache;
import org.netbeans.modules.web.taglibed.model.TagInfoData;
import org.netbeans.modules.web.taglibed.model.TagLibraryInfoData;

public class TagAttributeInfoData {
    private String name;
    private String type;
    private boolean required;
    private boolean rtexprvalue;
    private String defaultValue = null;
    private String javaVariable = null;
    private boolean isReferenceID = false;
    private boolean referencesTag = false;
    private String referencesTagType = null;
    private String referencesTagVariable = null;
    private boolean referencesTagReferentFirst = false;
    private int referenceScope = -1;
    private PropertyChangeSupport propSupport;
    private TagInfoData tag;
    protected CommentCache commentCache;
    public static final String ATTRIBUTE_NAME = "AttributeName";
    public static final String ATTRIBUTE_TYPE = "AttributeType";
    public static final String ATTRIBUTE_REQUIRED = "AttributeRequired";
    public static final String ATTRIBUTE_REQUEST_TIME = "AttributeRequestTime";
    public static final String IS_REFERENCEID = "IsReferenceID";
    public static final String REFERENCES_TAG = "ReferencesTag";
    public static final String REFERENCES_TAG_TYPE = "ReferencesTagType";
    public static final String REFERENCES_TAG_VARIABLE = "ReferencesTagVariable";
    public static final String REFERENCE_SCOPE = "ReferenceScope";
    public static final String REFERENT_FIRST = "ReferentFirst";
    public static final String DEFAULT_VALUE = "DefaultValue";
    public static final String JAVA_VARIABLE = "JavaVariable";
    private Object lock;
    private boolean dirtybitenabled = true;
    public static final String ID = "id";
    private static final boolean debugdirty = false;

    public TagAttributeInfoData(TagInfoData tag, String name, boolean required, boolean rtexprvalue, String type) {
        this.disableDirtyBit();
        this.tag = tag;
        this.name = name;
        this.required = required;
        this.rtexprvalue = rtexprvalue;
        this.type = type;
        this.lock = new Object();
        this.commentCache = new CommentCache();
        this.initializeCodeGenerationOptions();
        this.setupPropertyChangeSupport();
        this.enableDirtyBit();
    }

    public TagAttributeInfoData(TagInfoData tag) {
        this.disableDirtyBit();
        this.tag = tag;
        this.name = "";
        this.required = TagLibraryInfoData.getBooleanDefault("attribute.required");
        this.rtexprvalue = TagLibraryInfoData.getBooleanDefault("attribute.rtexprvalue");
        this.type = TagLibraryInfoData.getDefault("attribute.type");
        this.lock = new Object();
        this.commentCache = new CommentCache();
        this.initializeCodeGenerationOptions();
        this.setupPropertyChangeSupport();
        this.enableDirtyBit();
    }

    private TagAttributeInfoData() {
        this.required = TagLibraryInfoData.getBooleanDefault("attribute.required");
        this.rtexprvalue = TagLibraryInfoData.getBooleanDefault("attribute.rtexprvalue");
        this.type = TagLibraryInfoData.getDefault("attribute.type");
    }

    private void initializeCodeGenerationOptions() {
        this.referencesTagType = null;
        this.referencesTagVariable = null;
        this.isReferenceID = TagLibraryInfoData.getBooleanDefault("attribute.isReferenceID");
        this.referencesTag = TagLibraryInfoData.getBooleanDefault("attribute.referencesTag");
        this.referencesTagReferentFirst = TagLibraryInfoData.getBooleanDefault("attribute.referencesTagReferentFirst");
        this.referenceScope = TagLibraryInfoData.getIntDefault("attribute.referenceScope");
        this.defaultValue = TagLibraryInfoData.getDefault("attribute.defaultValue");
        this.javaVariable = null;
    }

    private void setupPropertyChangeSupport() {
        this.propSupport = new PropertyChangeSupport(this);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propSupport.removePropertyChangeListener(listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public TagInfoData getTag() {
        return this.tag;
    }

    public void setTag(TagInfoData value) {
        this.tag = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        String oldValue;
        if (!(value = value.trim()).equals(oldValue = this.name)) {
            Object object = this.lock;
            synchronized (object) {
                this.name = value;
                String explanation = "tag " + this.tag.getTagName() + ": attribute " + oldValue + " changed its name to " + value;
                this.tag.setTagHandlerDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
                this.firePropertyChange(ATTRIBUTE_NAME, oldValue, value);
            }
        }
    }

    public String getTypeName() {
        return this.type;
    }

    public void setTypeName(String value) {
        String oldValue;
        if (!(value = value.trim()).equals(oldValue = this.type)) {
            Object object = this.lock;
            synchronized (object) {
                this.type = value;
                this.firePropertyChange(ATTRIBUTE_TYPE, oldValue, value);
                String explanation = "tag " + this.tag.getTagName() + ": attribute " + this.getName() + " changed its type to " + value;
                this.tag.setTagHandlerDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
            }
        }
    }

    public boolean canBeRequestTime() {
        return this.rtexprvalue;
    }

    public boolean getRequestTime() {
        return this.rtexprvalue;
    }

    public void setRequestTime(boolean value) {
        boolean oldValue = this.rtexprvalue;
        if (value != oldValue) {
            Object object = this.lock;
            synchronized (object) {
                this.rtexprvalue = value;
                this.firePropertyChange(ATTRIBUTE_REQUEST_TIME, oldValue ? Boolean.TRUE : Boolean.FALSE, value ? Boolean.TRUE : Boolean.FALSE);
                String explanation = "tag " + this.tag.getTagName() + ": attribute " + this.getName() + " changed its can-be-request-time flag to " + value;
                this.tag.setTagHandlerDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
            }
        }
    }

    public void setRequestTime(String value) {
        this.setRequestTime("true".equalsIgnoreCase(value));
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean getRequired() {
        return this.required;
    }

    public void setRequired(boolean value) {
        boolean oldValue = this.required;
        if (value != oldValue) {
            Object object = this.lock;
            synchronized (object) {
                this.required = value;
                this.firePropertyChange(ATTRIBUTE_REQUIRED, oldValue ? Boolean.TRUE : Boolean.FALSE, value ? Boolean.TRUE : Boolean.FALSE);
                String explanation = "tag " + this.tag.getTagName() + ": attribute " + this.getName() + " changed its required flag to " + value;
                this.tag.setTagHandlerDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
            }
        }
    }

    public void setRequired(String value) {
        this.setRequired("true".equalsIgnoreCase(value));
    }

    public boolean getIsReferenceID() {
        return this.isReferenceID;
    }

    public void setIsReferenceID(boolean value) {
        boolean oldValue = this.isReferenceID;
        if (value != oldValue) {
            Object object = this.lock;
            synchronized (object) {
                this.isReferenceID = value;
                String explanation = "tag " + this.tag.getTagName() + ": attribute " + this.getName() + " changed its referenceID flag to " + value;
                this.tag.setTagHandlerDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
                this.firePropertyChange(IS_REFERENCEID, oldValue ? Boolean.TRUE : Boolean.FALSE, value ? Boolean.TRUE : Boolean.FALSE);
            }
        }
    }

    public void setIsReferenceID(String value) {
        this.setIsReferenceID("true".equalsIgnoreCase(value));
    }

    public boolean getReferencesTag() {
        return this.referencesTag;
    }

    public void setReferencesTag(boolean value) {
        boolean oldValue = this.referencesTag;
        if (value != oldValue) {
            Object object = this.lock;
            synchronized (object) {
                this.referencesTag = value;
                String explanation = "tag " + this.tag.getTagName() + ": attribute " + this.getName() + " changed its referencesTag flag to " + value;
                this.tag.setTagHandlerDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
                this.firePropertyChange(REFERENCES_TAG, oldValue ? Boolean.TRUE : Boolean.FALSE, value ? Boolean.TRUE : Boolean.FALSE);
            }
        }
    }

    public void setReferencesTag(String value) {
        this.setReferencesTag("true".equalsIgnoreCase(value));
    }

    public String getReferencesTagType() {
        return this.referencesTagType;
    }

    public void setReferencesTagType(String value) {
        String oldValue;
        if (!(value = value.trim()).equals(oldValue = this.referencesTagType)) {
            Object object = this.lock;
            synchronized (object) {
                this.referencesTagType = value;
                this.firePropertyChange(REFERENCES_TAG_TYPE, oldValue, value);
                String explanation = "tag " + this.tag.getTagName() + ": attribute " + this.getName() + " changed its references tag type to " + value;
                this.tag.setTagHandlerDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
            }
        }
    }

    public String getReferenceScopeString() {
        return TagInfoData.getScopeString(this.referenceScope);
    }

    public void setReferenceScopeString(String value) {
        String oldValue;
        if (!(value = value.trim()).equals(oldValue = this.getReferenceScopeString())) {
            this.setReferenceScope(TagInfoData.getScopeIntValue(value));
        }
    }

    public int getReferenceScope() {
        return this.referenceScope;
    }

    public void setReferenceScope(int value) {
        int oldValue = this.referenceScope;
        if (value != oldValue) {
            Object object = this.lock;
            synchronized (object) {
                this.referenceScope = value;
                this.firePropertyChange(REFERENCE_SCOPE, TagInfoData.getScopeString(oldValue), TagInfoData.getScopeString(value));
                String explanation = "tag " + this.tag.getTagName() + ": attribute " + this.getName() + " changed its reference scope to " + value;
                this.tag.setTagHandlerDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
            }
        }
    }

    public String getReferencesTagVariable() {
        return this.referencesTagVariable;
    }

    public void setReferencesTagVariable(String value) {
        String oldValue;
        if (!(value = value.trim()).equals(oldValue = this.referencesTagVariable)) {
            Object object = this.lock;
            synchronized (object) {
                this.referencesTagVariable = value;
                String explanation = "tag " + this.tag.getTagName() + ": attribute " + this.getName() + " changed its references tag variable to " + value;
                this.tag.setTagHandlerDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
                this.firePropertyChange(REFERENCES_TAG_VARIABLE, oldValue, value);
            }
        }
    }

    public boolean getReferencesTagReferentFirst() {
        return this.referencesTagReferentFirst;
    }

    public void setReferencesTagReferentFirst(boolean value) {
        boolean oldValue = this.referencesTagReferentFirst;
        if (value != oldValue) {
            Object object = this.lock;
            synchronized (object) {
                this.referencesTagReferentFirst = value;
                String explanation = "tag " + this.tag.getTagName() + ": attribute " + this.getName() + " changed its referencesTagReferentFirst flag to " + value;
                this.tag.setTagHandlerDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
                this.firePropertyChange(REFERENT_FIRST, oldValue ? Boolean.TRUE : Boolean.FALSE, value ? Boolean.TRUE : Boolean.FALSE);
            }
        }
    }

    public void setReferencesTagReferentFirst(String value) {
        this.setReferencesTagReferentFirst("true".equalsIgnoreCase(value));
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String value) {
        String oldValue;
        if (!(value = value.trim()).equals(oldValue = this.defaultValue)) {
            Object object = this.lock;
            synchronized (object) {
                this.defaultValue = value;
                this.firePropertyChange(DEFAULT_VALUE, oldValue, value);
                String explanation = "tag " + this.tag.getTagName() + ": attribute " + this.getName() + " changed its default value to " + value;
                this.tag.setTagHandlerDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
            }
        }
    }

    public String ensureJavaVariableName() {
        String varName = this.getJavaVariableName();
        if (varName == null || varName.equals("")) {
            varName = this.getName();
        }
        return varName;
    }

    public String getJavaVariableName() {
        return this.javaVariable;
    }

    public void setJavaVariableName(String value) {
        String oldValue;
        if (!(value = value.trim()).equals(oldValue = this.javaVariable)) {
            Object object = this.lock;
            synchronized (object) {
                this.javaVariable = value;
                this.firePropertyChange(JAVA_VARIABLE, oldValue, value);
                String explanation = "tag " + this.tag.getTagName() + ": attribute " + this.getName() + " changed its java variable name to " + value;
                this.tag.setTagHandlerDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
            }
        }
    }

    public void setTldDirtyBit(String explanation) {
        if (this.dirtybitenabled) {
            this.tag.getTaglib().setTldDirtyBit(explanation);
        }
    }

    public void enableDirtyBit() {
        this.dirtybitenabled = true;
    }

    public void disableDirtyBit() {
        this.dirtybitenabled = false;
    }

    public static TagAttributeInfoData getIdAttribute(TagAttributeInfoData[] a) {
        int i = 0;
        while (i < a.length) {
            if (a[i].getName().equals(ID)) {
                return a[i];
            }
            ++i;
        }
        return null;
    }

    public static TagAttributeInfoData getIdAttribute(Vector atts) {
        Enumeration en = atts.elements();
        while (en.hasMoreElements()) {
            TagAttributeInfoData att = (TagAttributeInfoData)en.nextElement();
            if (!att.getName().equals(ID)) continue;
            return att;
        }
        return null;
    }

    public CommentCache getCommentCache() {
        return this.commentCache;
    }

    void setCommentCache(CommentCache value) {
        this.commentCache = value;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("name = " + this.name + " ");
        b.append("type = " + this.type + " ");
        b.append("required = " + this.required + " ");
        b.append("rtexprvalue = " + this.rtexprvalue + " ");
        return b.toString();
    }
}

