/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglibed.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.jsp.tagext.TagExtraInfo;
import org.netbeans.modules.web.taglibed.model.CommentCache;
import org.netbeans.modules.web.taglibed.model.TagAttributeInfoData;
import org.netbeans.modules.web.taglibed.model.TagLibraryInfoData;
import org.netbeans.modules.web.taglibed.model.TagVariableInfoData;

public class TagInfoData {
    public static final int UNKNOWN_SCOPE = -1;
    public static final int PAGE_SCOPE = 0;
    public static final int REQUEST_SCOPE = 1;
    public static final int SESSION_SCOPE = 2;
    public static final int APPLICATION_SCOPE = 3;
    private String tagName;
    private String tagClassName;
    private String displayName;
    private String bodyContent;
    private String smallIcon;
    private String largeIcon;
    private String description;
    private String example;
    private TagExtraInfo tagExtraInfo;
    private Vector attributeInfo;
    private Vector variableInfo;
    private String importsString;
    private String packageName = null;
    private String implementsInterface = null;
    private boolean extendsSupportClass = true;
    private String supportClass = null;
    private boolean implementsTryCatchFinally = false;
    private boolean findParent = false;
    private String parentType = null;
    private String parentVariable = null;
    private String teiClassName = null;
    private PropertyChangeSupport propSupport;
    TagLibraryInfoData tagLibrary;
    protected CommentCache commentCache;
    public static final String BODY_CONTENT_JSP = "JSP";
    public static final String BODY_CONTENT_TAG_DEPENDENT = "TAGDEPENDENT";
    public static final String BODY_CONTENT_EMPTY = "EMPTY";
    private Object lock;
    public static final String TAG_NAME = "TagName";
    public static final String TAG_CLASS_NAME = "TagClassName";
    public static final String DISPLAY_NAME = "DisplayName";
    public static final String BODY_CONTENT = "BodyContent";
    public static final String SMALL_ICON = "SmallIcon";
    public static final String LARGE_ICON = "LargeIcon";
    public static final String DESCRIPTION = "Description";
    public static final String EXAMPLE = "Example";
    public static final String PACKAGE_NAME = "PackageName";
    public static final String IMPLEMENTS_INTERFACE = "ImplementsInterface";
    public static final String EXTENDS_SUPPORT_CLASS = "ExtendsSupportClass";
    public static final String SUPPORT_CLASS = "SupportClass";
    public static final String IMPLEMENTS_TRY_CATCH_FINALLY = "ImplementsTryCatchFinally";
    public static final String FIND_PARENT = "FindParent";
    public static final String PARENT_TYPE = "ParentType";
    public static final String PARENT_VARIABLE = "ParentVariable";
    public static final String IMPORTS = "Imports";
    public static final String REPLACE_ATTRIBUTES = "ReplaceAttributes";
    public static final String REPLACE_VARIABLES = "ReplaceVariables";
    public static final String TAG_DIRTY_BIT = "TagDirtyBit";
    public static final String TEI_DIRTY_BIT = "TeiDirtyBit";
    static int indent = 0;
    static String indentString = "    ";
    private boolean dirtyBitEnabled = true;
    private boolean tagHandlerDirtyBit = false;
    private String tagHandlerLastCleanFile = null;
    private Vector tagHandlerDirtyBitEvents = null;
    private boolean teiDirtyBit = false;
    private String teiLastCleanFile = null;
    private Vector teiDirtyBitEvents = null;
    private static final boolean debugdirty = false;
    private static final boolean debug = false;

    private TagInfoData() {
        Exception ex = new Exception("oops");
        ex.printStackTrace();
    }

    public TagInfoData(TagLibraryInfoData taglibInfo) {
        this.disableDirtyBit();
        this.lock = new Object();
        this.setupPropertyChangeSupport();
        this.tagLibrary = taglibInfo;
        this.tagName = "";
        this.setTagClassName("");
        this.setDisplayName("");
        this.bodyContent = BODY_CONTENT_JSP;
        this.description = null;
        this.example = null;
        this.tagExtraInfo = null;
        this.attributeInfo = new Vector();
        this.variableInfo = new Vector();
        this.importsString = "";
        this.packageName = null;
        this.commentCache = new CommentCache();
        this.initializeCodeGenerationOptions();
        this.enableDirtyBit();
    }

    public TagInfoData(String tagName, String tagClassName, String bodyContent, String description, TagLibraryInfoData taglib, TagExtraInfo tagExtraInfo, Vector attributeInfo, Vector variableInfo) {
        this.disableDirtyBit();
        this.lock = new Object();
        this.setupPropertyChangeSupport();
        this.tagLibrary = taglib;
        this.tagName = tagName;
        this.setTagClassName(tagClassName);
        this.setDisplayName("");
        this.bodyContent = bodyContent;
        this.description = description;
        this.example = null;
        this.tagExtraInfo = tagExtraInfo;
        this.attributeInfo = attributeInfo;
        this.variableInfo = variableInfo;
        this.importsString = "";
        this.packageName = null;
        this.lock = new Object();
        this.commentCache = new CommentCache();
        this.initializeCodeGenerationOptions();
        this.enableDirtyBit();
    }

    private void initializeCodeGenerationOptions() {
        this.implementsTryCatchFinally = false;
        this.implementsInterface = null;
        this.extendsSupportClass = true;
        this.supportClass = null;
        this.findParent = TagLibraryInfoData.getBooleanDefault("tag.findParent");
        this.parentType = null;
        this.parentVariable = null;
    }

    public void ensureTagDefaults() {
        String bc = this.getBodyContent();
        if (TagInfoData.isBlank(bc)) {
            bc = BODY_CONTENT_JSP;
            this.setBodyContent(bc);
        }
        if (this.extendsSupportClass && TagInfoData.isBlank(this.supportClass)) {
            if (bc.equalsIgnoreCase(BODY_CONTENT_JSP) || bc.equalsIgnoreCase("tagdependent")) {
                this.setSupportClass("BodyTagSupport");
            } else {
                this.setSupportClass("TagSupport");
            }
        }
        if (!this.extendsSupportClass && TagInfoData.isBlank(this.implementsInterface)) {
            if (bc.equalsIgnoreCase(BODY_CONTENT_JSP) || bc.equalsIgnoreCase("tagdependent")) {
                this.setImplementsInterface("BodyTag");
            } else {
                this.setImplementsInterface("Tag");
            }
        }
    }

    public static boolean isBlank(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().equals("");
    }

    private void setupPropertyChangeSupport() {
        this.propSupport = new PropertyChangeSupport(this);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propSupport.removePropertyChangeListener(listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String value) {
        if ((value = value.trim()) != null && !value.equals(this.tagName)) {
            Object object = this.lock;
            synchronized (object) {
                String oldValue = this.tagName;
                this.tagName = value;
                this.firePropertyChange(TAG_NAME, oldValue, value);
                String explanation = "tag " + oldValue + "changed its name to " + value;
                this.setTagHandlerDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
            }
        }
    }

    public Vector getAttributesVector() {
        return this.attributeInfo;
    }

    public void setAttributesVector(Vector value) {
        this.attributeInfo = value;
        this.firePropertyChange(REPLACE_ATTRIBUTES, null, null);
    }

    public TagAttributeInfoData getAttributeByName(String attName) {
        if (attName == null) {
            return null;
        }
        Vector atts = this.getAttributesVector();
        Enumeration en = atts.elements();
        while (en.hasMoreElements()) {
            TagAttributeInfoData tagatt = (TagAttributeInfoData)en.nextElement();
            if (!attName.equals(tagatt.getName())) continue;
            return tagatt;
        }
        return null;
    }

    public void addAttribute(TagAttributeInfoData att) {
        if (this.attributeInfo == null) {
            this.attributeInfo = new Vector();
        }
        this.attributeInfo.addElement(att);
        String explanation = "tag " + this.getTagName() + " added attribute: " + att.getName();
        this.setTagHandlerDirtyBit(explanation);
        this.setTldDirtyBit(explanation);
    }

    public void deleteAttribute(TagAttributeInfoData att) {
        if (this.attributeInfo == null) {
            return;
        }
        this.attributeInfo.removeElement(att);
        String explanation = "tag " + this.getTagName() + " deleted attribute: " + att.getName();
        this.setTagHandlerDirtyBit(explanation);
        this.setTldDirtyBit(explanation);
    }

    public Vector getVariablesVector() {
        return this.variableInfo;
    }

    public void setVariablesVector(Vector value) {
        this.variableInfo = value;
        this.firePropertyChange(REPLACE_VARIABLES, null, null);
    }

    public boolean hasVariables() {
        return this.variableInfo != null && this.variableInfo.size() > 0;
    }

    public boolean hasVariablesOfNameTypeOther() {
        if (!this.hasVariables()) {
            return false;
        }
        Enumeration en = this.variableInfo.elements();
        while (en.hasMoreElements()) {
            TagVariableInfoData var = (TagVariableInfoData)en.nextElement();
            if (var.getNameType() != 2) continue;
            return true;
        }
        return false;
    }

    public void addVariable(TagVariableInfoData var) {
        if (this.variableInfo == null) {
            this.variableInfo = new Vector();
        }
        this.variableInfo.addElement(var);
        if (var.getNameType() == 2) {
            this.ensureTeiClassName();
        }
        String explanation = "tag " + this.getTagName() + " added variable: " + var.getName();
        this.setTagHandlerDirtyBit(explanation);
        this.setTldDirtyBit(explanation);
    }

    public void deleteVariable(TagVariableInfoData var) {
        if (this.variableInfo == null) {
            this.variableInfo = new Vector();
        }
        this.variableInfo.removeElement(var);
        String explanation = "tag " + this.getTagName() + " deleted variable: " + var.getName();
        this.setTagHandlerDirtyBit(explanation);
        this.setTEIDirtyBit(explanation);
        this.setTldDirtyBit(explanation);
    }

    public TagExtraInfo getTagExtraInfo() {
        return this.tagExtraInfo;
    }

    public void setTagExtraInfo(TagExtraInfo value) {
        this.tagExtraInfo = value;
        String explanation = "tag " + this.getTagName() + "changed its TagExtraInfo name to " + value;
        this.setTldDirtyBit(explanation);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String value) {
        this.displayName = value;
        String explanation = "tag " + this.getTagName() + "changed its display name to " + value;
        this.setTldDirtyBit(explanation);
    }

    public String getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(String value) {
        String explanation = "tag " + this.getTagName() + "changed its small icon to " + value;
        this.setTldDirtyBit(explanation);
        this.smallIcon = value;
    }

    public String getLargeIcon() {
        return this.largeIcon;
    }

    public void setLargeIcon(String value) {
        String explanation = "tag " + this.getTagName() + "changed its large icon to " + value;
        this.setTldDirtyBit(explanation);
        this.largeIcon = value;
    }

    public String getTagClassNameNoPkg() {
        return this.getTagClassName();
    }

    public String getTagClassName() {
        return this.tagClassName;
    }

    public void setTagClassName(String value) {
        if ((value = value.trim()) != null && !value.equals(this.tagClassName)) {
            if (this.hasVariables()) {
                String teiClassName = value + "TEI";
                this.setTeiClassName(teiClassName);
            }
            Object object = this.lock;
            synchronized (object) {
                String oldClassName = this.tagClassName;
                this.tagClassName = this.removePackageName(value, true);
                this.firePropertyChange(TAG_CLASS_NAME, oldClassName, this.tagClassName);
                String explanation = "tag " + this.getTagName() + "changed its tag class name to " + this.tagClassName;
                this.setTagHandlerDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
            }
        }
    }

    public String getTeiClassName() {
        return this.teiClassName;
    }

    public void setTeiClassName(String value) {
        if ((value = value.trim()) != null && !value.equals(this.tagClassName)) {
            Object object = this.lock;
            synchronized (object) {
                String oldTEIClassName = this.teiClassName;
                this.teiClassName = this.removePackageName(value, true);
                this.firePropertyChange(TAG_CLASS_NAME, oldTEIClassName, this.teiClassName);
                String explanation = "tag " + this.getTagName() + "changed its Tei class name to " + this.teiClassName;
                this.setTldDirtyBit(explanation);
            }
        }
    }

    public String ensureTagClassName() {
        if (this.tagClassName == null || this.tagClassName.equals("")) {
            String suggestedTagClassName = TagInfoData.suggestTagClassName(this.getTagName());
            this.setTagClassName(suggestedTagClassName);
        }
        return this.tagClassName;
    }

    public String ensureTeiClassName() {
        if (this.teiClassName == null) {
            this.setTeiClassName(this.getTagClassName() + "TEI");
        }
        return this.teiClassName;
    }

    public String useDefaultTagClassName() {
        String suggestedTagClassName = TagInfoData.suggestTagClassName(this.getTagName());
        this.setTagClassName(suggestedTagClassName);
        return this.tagClassName;
    }

    public String useDefaultTeiClassName() {
        this.setTeiClassName(this.getTagClassName() + "TEI");
        return this.teiClassName;
    }

    public String removePackageName(String value, boolean setPackage) {
        String result;
        int index = value.lastIndexOf(46);
        if (index < 0) {
            result = value;
        } else {
            String packageName = value.substring(0, index);
            String className = value.substring(index + 1);
            if (setPackage) {
                this.setPackageName(packageName);
            }
            result = className;
        }
        return result;
    }

    public String getBodyContent() {
        return this.bodyContent;
    }

    public void setBodyContent(String value) {
        if (!(value = value.trim()).equals(this.bodyContent)) {
            Object object = this.lock;
            synchronized (object) {
                String oldValue = this.bodyContent;
                this.bodyContent = value;
                String explanation = "tag " + this.getTagName() + "changed its body content to " + value;
                this.setTagHandlerDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
                this.firePropertyChange(BODY_CONTENT, oldValue, value);
            }
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        if (value != null && !value.equals(this.description)) {
            Object object = this.lock;
            synchronized (object) {
                String oldValue = this.description;
                this.description = value;
                String explanation = "tag " + this.getTagName() + "changed its description.";
                this.setTldDirtyBit(explanation);
                this.firePropertyChange(DESCRIPTION, oldValue, value);
            }
        }
    }

    public String getExample() {
        return this.example;
    }

    public void setExample(String value) {
        if (value != null && !value.equals(this.example)) {
            Object object = this.lock;
            synchronized (object) {
                String oldValue = this.example;
                this.example = value;
                String explanation = "tag " + this.getTagName() + "changed its example.";
                this.setTldDirtyBit(explanation);
                this.firePropertyChange(EXAMPLE, oldValue, value);
            }
        }
    }

    public TagLibraryInfoData getTaglib() {
        return this.tagLibrary;
    }

    public void setTagLibrary(TagLibraryInfoData value) {
        this.tagLibrary = value;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String value) {
        if (value == null) {
            value = "";
        }
        if (!(value = value.trim()).equals(this.packageName)) {
            Object object = this.lock;
            synchronized (object) {
                String oldValue = this.packageName;
                this.packageName = value;
                String explanation = "tag " + this.getTagName() + "changed its package name to " + value;
                this.setTagHandlerDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
                this.firePropertyChange(PACKAGE_NAME, oldValue, value);
            }
        }
    }

    public String getImplementsInterface() {
        return this.implementsInterface;
    }

    public void setImplementsInterface(String value) {
        if (value == null) {
            value = "";
        }
        if (!(value = value.trim()).equals(this.implementsInterface)) {
            Object object = this.lock;
            synchronized (object) {
                String oldValue = this.implementsInterface;
                this.implementsInterface = value;
                String explanation = "tag " + this.getTagName() + "changed its implements interface to " + value;
                this.setTagHandlerDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
                this.firePropertyChange(IMPLEMENTS_INTERFACE, oldValue, value);
            }
        }
    }

    public boolean getExtendsSupportClass() {
        return this.extendsSupportClass;
    }

    public void setExtendsSupportClass(boolean value) {
        boolean oldValue = this.extendsSupportClass;
        if (value != oldValue) {
            Object object = this.lock;
            synchronized (object) {
                this.extendsSupportClass = value;
                String explanation = "tag " + this.getTagName() + "changed its extendsSupportClass to " + value;
                this.setTagHandlerDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
                this.firePropertyChange(EXTENDS_SUPPORT_CLASS, oldValue ? Boolean.TRUE : Boolean.FALSE, value ? Boolean.TRUE : Boolean.FALSE);
            }
        }
    }

    public void setExtendsSupportClass(String value) {
        this.setExtendsSupportClass("true".equalsIgnoreCase(value));
    }

    public String getSupportClass() {
        return this.supportClass;
    }

    public void setSupportClass(String value) {
        if (value == null) {
            value = "";
        }
        if (!(value = value.trim()).equals(this.supportClass)) {
            Object object = this.lock;
            synchronized (object) {
                String oldValue = this.supportClass;
                this.supportClass = value;
                String explanation = "tag " + this.getTagName() + "changed its implements interface to " + value;
                this.setTagHandlerDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
                this.firePropertyChange(SUPPORT_CLASS, oldValue, value);
            }
        }
    }

    public boolean getImplementsTryCatchFinally() {
        return this.implementsTryCatchFinally;
    }

    public void setImplementsTryCatchFinally(boolean value) {
        boolean oldValue = this.implementsTryCatchFinally;
        if (value != oldValue) {
            Object object = this.lock;
            synchronized (object) {
                this.implementsTryCatchFinally = value;
                String explanation = "tag " + this.getTagName() + "changed its implementsTryCatchFinally to " + value;
                this.setTagHandlerDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
                this.firePropertyChange(IMPLEMENTS_TRY_CATCH_FINALLY, oldValue ? Boolean.TRUE : Boolean.FALSE, value ? Boolean.TRUE : Boolean.FALSE);
            }
        }
    }

    public void setImplementsTryCatchFinally(String value) {
        this.setImplementsTryCatchFinally("true".equalsIgnoreCase(value));
    }

    public boolean getFindParent() {
        return this.findParent;
    }

    public void setFindParent(boolean value) {
        boolean oldValue = this.findParent;
        if (value != oldValue) {
            Object object = this.lock;
            synchronized (object) {
                this.findParent = value;
                String explanation = "tag " + this.getTagName() + "changed its findParent to " + value;
                this.setTagHandlerDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
                this.firePropertyChange(FIND_PARENT, oldValue ? Boolean.TRUE : Boolean.FALSE, value ? Boolean.TRUE : Boolean.FALSE);
            }
        }
    }

    public void setFindParent(String value) {
        this.setFindParent("true".equalsIgnoreCase(value));
    }

    public String getParentType() {
        return this.parentType;
    }

    public void setParentType(String value) {
        if (!(value = value.trim()).equals(this.parentType)) {
            Object object = this.lock;
            synchronized (object) {
                String oldValue = this.parentType;
                this.parentType = value;
                String explanation = "tag " + this.getTagName() + "changed its find parent type to " + value;
                this.setTagHandlerDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
                this.firePropertyChange(PARENT_TYPE, oldValue, value);
            }
        }
    }

    public String getParentVariable() {
        return this.parentVariable;
    }

    public void setParentVariable(String value) {
        if (!(value = value.trim()).equals(this.parentVariable)) {
            Object object = this.lock;
            synchronized (object) {
                String oldValue = this.parentVariable;
                this.parentVariable = value;
                String explanation = "tag " + this.getTagName() + "changed its find parent variable to " + value;
                this.setTagHandlerDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
                this.firePropertyChange(PARENT_VARIABLE, oldValue, value);
            }
        }
    }

    public String getImports() {
        return this.importsString;
    }

    public void setImports(String value) {
        if (!(value = value.trim()).equals(this.importsString)) {
            Object object = this.lock;
            synchronized (object) {
                String oldValue = this.importsString;
                this.importsString = value;
                String explanation = "tag " + this.getTagName() + "changed its imports string.";
                this.setTagHandlerDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
                this.firePropertyChange(IMPORTS, oldValue, value);
            }
        }
    }

    public CommentCache getCommentCache() {
        return this.commentCache;
    }

    void setCommentCache(CommentCache value) {
        this.commentCache = value;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("name = " + this.tagName + " ");
        b.append("class = " + this.tagClassName + " ");
        b.append("displayname = " + this.displayName + " ");
        b.append("body = " + this.bodyContent + " ");
        b.append("description = " + this.description + " ");
        b.append("example = " + this.example + " ");
        Enumeration en = this.attributeInfo.elements();
        if (!en.hasMoreElements()) {
            b.append("attributesVector = { } ");
        } else {
            b.append("attributesVector = { ");
            while (en.hasMoreElements()) {
                b.append("\t" + en.nextElement().toString());
            }
            b.append("\n}\n");
        }
        Enumeration env = this.variableInfo.elements();
        if (!env.hasMoreElements()) {
            b.append("variablesVector = { } ");
        } else {
            b.append("variablesVector = {\n");
            while (env.hasMoreElements()) {
                b.append("\t" + env.nextElement().toString());
            }
            b.append("\n}\n");
        }
        return b.toString();
    }

    public boolean isBodyTag() {
        String bc = TagLibraryInfoData.ensureValue("tag.bodyContent", this.bodyContent);
        return this.bodyContent != null && !this.bodyContent.equals("empty");
    }

    public boolean isJSPBodyTag() {
        return this.bodyContent != null && this.bodyContent.equalsIgnoreCase(BODY_CONTENT_JSP);
    }

    public static void indentPrintln(StringBuffer buf, Object thing) {
        TagInfoData.indentPrint(buf, thing);
        buf.append('\n');
    }

    public static void indentPrint(StringBuffer buf, Object thing) {
        int i = 0;
        while (i < indent) {
            buf.append(indentString);
            ++i;
        }
        buf.append(thing.toString());
    }

    public static void println(StringBuffer buf) {
        buf.append('\n');
    }

    public static void println(StringBuffer buf, Object thing) {
        buf.append(thing.toString());
        buf.append('\n');
    }

    public void ensureNoDotClass() {
    }

    public static String capitalize(String str) {
        if (str == null || str.length() < 1) {
            return str;
        }
        int len = str.length();
        char[] chars = new char[len];
        str.getChars(0, len, chars, 0);
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String decapitalize(String str) {
        if (str == null || str.length() < 1) {
            return str;
        }
        int len = str.length();
        char[] chars = new char[len];
        str.getChars(0, len, chars, 0);
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static String relativizeFilePath(String path, String directory) {
        char ch;
        if (directory == null || directory.equals("")) {
            return path;
        }
        File pathFile = new File(path);
        int commonChars = TagInfoData.numberOfCommonChars(path, directory);
        if (commonChars > 0 && ((ch = path.charAt(commonChars)) == File.separatorChar || ch == '/' || ch == '\\')) {
            ++commonChars;
        }
        String relativePath = path.substring(commonChars);
        return relativePath;
    }

    public static int numberOfCommonChars(String a, String b) {
        int lenA = a.length();
        int lenB = b.length();
        int n = Math.min(lenA, lenB);
        char[] charsA = new char[lenA];
        char[] charsB = new char[lenB];
        a.getChars(0, lenA, charsA, 0);
        b.getChars(0, lenB, charsB, 0);
        int i = 0;
        while (n-- != 0) {
            char c1 = charsA[i];
            char c2 = charsB[i];
            if (c1 != c2) {
                return i;
            }
            ++i;
        }
        return i;
    }

    public static String suggestTagClassName(String nameString) {
        String tail;
        String cap = TagInfoData.capitalize(nameString);
        int n = cap.length();
        if (n > 2 && (tail = cap.substring(n - 3)).equalsIgnoreCase("tag")) {
            return cap;
        }
        return cap + "Tag";
    }

    public static String suggestVariableName(String typeName, String suffix) {
        int lastdot = typeName.lastIndexOf(46);
        if (lastdot > 0) {
            typeName = typeName.substring(lastdot + 1);
        }
        return TagInfoData.decapitalize(typeName) + suffix;
    }

    public void enableDirtyBit() {
        this.dirtyBitEnabled = true;
    }

    public void disableDirtyBit() {
        this.dirtyBitEnabled = false;
    }

    public boolean getDirtyBitEnabled() {
        return this.dirtyBitEnabled;
    }

    public void setTldDirtyBit(String explanation) {
        if (this.dirtyBitEnabled) {
            this.tagLibrary.setTldDirtyBit(explanation);
        }
        this.tagLibrary.setTldDirtyBit(explanation);
    }

    public void clearTagHandlerDirtyBit(String filename) {
        Boolean oldValue = this.tagHandlerDirtyBit ? Boolean.TRUE : Boolean.FALSE;
        this.tagHandlerDirtyBit = false;
        this.tagHandlerLastCleanFile = filename;
        this.tagHandlerDirtyBitEvents = new Vector();
        this.firePropertyChange(TAG_DIRTY_BIT, oldValue, this.tagHandlerDirtyBit ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setTagHandlerDirtyBit(String explanation) {
        Boolean oldValue = this.tagHandlerDirtyBit ? Boolean.TRUE : Boolean.FALSE;
        this.tagHandlerDirtyBit = true;
        if (this.tagHandlerDirtyBitEvents == null) {
            this.tagHandlerDirtyBitEvents = new Vector();
        }
        this.tagHandlerDirtyBitEvents.addElement(explanation);
        this.firePropertyChange(TAG_DIRTY_BIT, oldValue, this.tagHandlerDirtyBit ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getTagHandlerDirtyBit() {
        return this.tagHandlerDirtyBit;
    }

    public Vector getTagHandlerDirtyBitEvents() {
        return this.tagHandlerDirtyBitEvents;
    }

    public String getTagHandlerDirtyBitLastCleanFile() {
        return this.tagHandlerLastCleanFile;
    }

    public void clearTEIDirtyBit(String filename) {
        Boolean oldValue = this.teiDirtyBit ? Boolean.TRUE : Boolean.FALSE;
        this.teiDirtyBit = false;
        this.teiLastCleanFile = filename;
        this.teiDirtyBitEvents = new Vector();
        this.firePropertyChange(TEI_DIRTY_BIT, oldValue, this.teiDirtyBit ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setTEIDirtyBit(String explanation) {
        Boolean oldValue = this.teiDirtyBit ? Boolean.TRUE : Boolean.FALSE;
        this.teiDirtyBit = true;
        if (this.teiDirtyBitEvents == null) {
            this.teiDirtyBitEvents = new Vector();
        }
        this.teiDirtyBitEvents.addElement(explanation);
        this.firePropertyChange(TEI_DIRTY_BIT, oldValue, this.teiDirtyBit ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getTEIDirtyBit() {
        return this.teiDirtyBit;
    }

    public Vector getTEIDirtyBitEvents() {
        return this.teiDirtyBitEvents;
    }

    public String getTEIDirtyBitLastCleanFile() {
        return this.teiLastCleanFile;
    }

    public static String getScopeString(int scope) {
        switch (scope) {
            case 0: {
                return "Page";
            }
            case 1: {
                return "Request";
            }
            case 2: {
                return "Session";
            }
            case 3: {
                return "Application";
            }
        }
        return null;
    }

    public static int getScopeIntValue(String scope) {
        if ("Page".equalsIgnoreCase(scope)) {
            return 0;
        }
        if ("Request".equalsIgnoreCase(scope)) {
            return 1;
        }
        if ("Session".equalsIgnoreCase(scope)) {
            return 2;
        }
        if ("Application".equalsIgnoreCase(scope)) {
            return 3;
        }
        return -1;
    }
}

