/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglibed.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.netbeans.modules.web.taglibed.model.CommentCache;
import org.netbeans.modules.web.taglibed.model.CommentItem;
import org.netbeans.modules.web.taglibed.model.ListenerData;
import org.netbeans.modules.web.taglibed.model.ParamData;
import org.netbeans.modules.web.taglibed.model.TLDException;
import org.netbeans.modules.web.taglibed.model.TagAttributeInfoData;
import org.netbeans.modules.web.taglibed.model.TagInfoData;
import org.netbeans.modules.web.taglibed.model.TagVariableInfoData;
import org.netbeans.modules.web.taglibed.model.TaglibDocumentHandler;
import org.netbeans.modules.web.taglibed.model.ValidatorData;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class TagLibraryInfoData {
    public static final String TAGLIB_EXTENSION = "tld";
    public static final String DOT_TAGLIB_EXTENSION = ".tld";
    private static final String TLD = "META-INF/taglib.tld";
    private static final String WEBAPP_INF = "/WEB-INF/web.xml";
    public static final String TAGLIB_DTD_PUBLIC_ID_1_2 = "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN";
    public static final String TAGLIB_DTD_RESOURCE_1_2 = "http://java.sun.com/dtd/web-jsptaglibrary_1_2.dtd";
    public static final String TAGLIB_DTD_PUBLIC_ID_1_1 = "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN";
    public static final String TAGLIB_DTD_RESOURCE_1_1 = "/org/apache/jasper/resources/web-jsptaglib_1_1.dtd";
    public static final String ALT_TAGLIB_DTD_RESOURCE_1_1 = "http://java.sun.com/j2ee/dtds/web-jsptaglibrary_1_1.dtd";
    public static final String TLDX_COMMENT_PREFIX = "Forte4J_TLDX:";
    public static final String TLDX_COMMENT_PREFIX_COMMENT = " This comment contains code generation information. Do not delete.";
    Vector tagsVector;
    protected String tldxFilePath;
    protected String tldFileName;
    protected String tldFileDirectory;
    protected String prefix;
    protected String tagHandlerPackage = null;
    protected String tlibversion;
    protected String jspversion;
    protected String shortname;
    protected String displayname;
    protected String uri;
    protected String smallIcon;
    protected String largeIcon;
    protected String description;
    protected ValidatorData validator = null;
    protected Vector taglibListeners = null;
    protected String tagHandlerGenerationRoot;
    protected String jarFile;
    String dtdName = null;
    String dtdPublicId = null;
    String dtdSystemId = null;
    boolean versionUpdateIsPending = false;
    protected CommentCache commentCache;
    private PropertyChangeSupport propSupport;
    private Object lock = new Object();
    public static final String SHORT_NAME = "ShortName";
    public static final String DISPLAY_NAME = "DisplayName";
    public static final String RELIABLE_URN = "ReliableURN";
    public static final String URI = "URI";
    public static final String SMALL_ICON = "SmallIcon";
    public static final String LARGE_ICON = "LargeIcon";
    public static final String VALIDATOR = "Validator";
    public static final String LISTENERS = "Listeners";
    public static final String DESCRIPTION = "Description";
    public static final String JSPVERSION = "JspVersion";
    public static final String PREFIX = "Prefix";
    public static final String TAG_HANDLER_GENERATION_ROOT = "TagHandlerGenerationRoot";
    public static final String JAR_FILE = "JarFile";
    public static final String TLIBVERSION = "TLibVersion";
    public static final String ADD_TAG = "AddTag";
    public static final String DELETE_TAG = "DeleteTag";
    public static final String REPLACE_TAGS = "ReplaceTags";
    public static final String DIRTY_BIT = "DirtyBit";
    public static final String TREE_DIRTY = "treeDirty";
    private boolean regenerationOn = true;
    private static boolean previousNewLinePending = false;
    public static String INDENTSTRING = "    ";
    static int indent = 0;
    static String supportedJSPVersion = "1.2";
    private static String xmlHeader = null;
    private static Hashtable defaultsTable = new Hashtable();
    private boolean tldDirtyBit = false;
    private Vector tldDirtyBitEvents;
    private static final boolean debug = false;
    private static final boolean debugxml = false;
    private static final boolean debugdirty = false;
    private static final boolean debugdetail = false;
    private static final boolean debugversionupdate = false;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$TLDDataObject;

    public TagLibraryInfoData(String tldxFilePath) throws IOException, TLDException {
        this.tagsVector = new Vector();
        this.setupPropertyChangeSupport();
        this.tldxFilePath = tldxFilePath;
        File dirFile = new File(tldxFilePath);
        this.tldFileDirectory = dirFile.getParent();
        this.tldFileName = dirFile.getName();
        this.commentCache = new CommentCache();
        FileInputStream is = new FileInputStream(tldxFilePath);
        if (is == null) {
            String msg = NbBundle.getMessage((Class)(class$org$netbeans$modules$web$taglibed$TLDDataObject == null ? (class$org$netbeans$modules$web$taglibed$TLDDataObject = TagLibraryInfoData.class$("org.netbeans.modules.web.taglibed.TLDDataObject")) : class$org$netbeans$modules$web$taglibed$TLDDataObject), (String)"TLD_TagLibraryInfoData.jsp.error.tldfile_not_found", (Object)tldxFilePath);
            throw new IOException(msg);
        }
        this.parseTLD(new InputSource(is), tldxFilePath);
        this.ensureTLDDefaults();
        this.clearTldDirtyBit();
        this.clearTagsDirtyBits();
    }

    public TagLibraryInfoData(InputSource in, String name, String path) throws IOException, TLDException {
        this.tagsVector = new Vector();
        this.setupPropertyChangeSupport();
        this.tldxFilePath = path;
        File dirFile = new File(this.tldxFilePath);
        this.tldFileDirectory = dirFile.getParent();
        this.tldFileName = name;
        this.commentCache = new CommentCache();
        this.parseTLD(in, this.tldxFilePath);
        this.ensureTLDDefaults();
        this.clearTldDirtyBit();
    }

    public void ensureTLDDefaults() {
        Vector tagsv;
        String shortname = this.ensureShortName();
        if (TagLibraryInfoData.isBlank(this.getURI())) {
            this.setURI("/" + shortname);
        }
        if ((tagsv = this.getTagsVector()) != null) {
            Enumeration en = tagsv.elements();
            while (en.hasMoreElements()) {
                TagInfoData tag = (TagInfoData)en.nextElement();
                tag.ensureTagDefaults();
            }
        }
    }

    public static boolean isBlank(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().equals("");
    }

    public boolean isVersionUpdatePending() {
        this.calculatePendingVersionUpdate();
        return this.versionUpdateIsPending;
    }

    public void setVersionUpdatePending(boolean value) {
        this.versionUpdateIsPending = value;
    }

    public void calculatePendingVersionUpdate() {
        if (this.versionUpdateIsPending) {
            return;
        }
        if (!"1.2".equals(this.getJspVersion())) {
            this.versionUpdateIsPending = true;
            return;
        }
        String publicID = this.getDtdPublicId();
        if (!publicID.equals(TAGLIB_DTD_PUBLIC_ID_1_2)) {
            this.versionUpdateIsPending = true;
            return;
        }
        String systemID = this.getDtdSystemId();
        if (!systemID.endsWith("1_2.dtd")) {
            this.versionUpdateIsPending = true;
            return;
        }
        this.versionUpdateIsPending = false;
    }

    public void ensureVersionIsUpToDate() {
        if (!"1.2".equals(this.getJspVersion())) {
            this.setJspVersion("1.2");
        }
        if (!TAGLIB_DTD_PUBLIC_ID_1_2.equals(this.getDtdPublicId())) {
            this.setDtdPublicId(TAGLIB_DTD_PUBLIC_ID_1_2);
        }
        if (!TAGLIB_DTD_RESOURCE_1_2.equals(this.getDtdSystemId())) {
            this.setDtdSystemId(TAGLIB_DTD_RESOURCE_1_2);
        }
    }

    public void mergeTaglib(TagLibraryInfoData newTaglib) {
        Vector newTags;
        this.turnOffRegeneration();
        this.updateTaglibProperties(newTaglib);
        Vector oldTags = this.getTagsVector();
        if (oldTags == null) {
            oldTags = new Vector();
        }
        if ((newTags = newTaglib.getTagsVector()) == null) {
            newTags = new Vector();
        }
        Vector<TagInfoData> resultTags = new Vector<TagInfoData>();
        Enumeration en = newTags.elements();
        while (en.hasMoreElements()) {
            TagInfoData newTag = (TagInfoData)en.nextElement();
            boolean aTagMatched = false;
            int i = 0;
            while (i < oldTags.size()) {
                TagInfoData oldTag = (TagInfoData)oldTags.elementAt(i);
                if (this.tagsMatchForMerging(oldTag, newTag)) {
                    oldTags.removeElementAt(i);
                    aTagMatched = true;
                    this.mergeTags(oldTag, newTag);
                    resultTags.addElement(oldTag);
                    break;
                }
                ++i;
            }
            if (aTagMatched) continue;
            newTag.setTagLibrary(this);
            resultTags.addElement(newTag);
        }
        this.setTagsVector(resultTags);
        boolean newPendingVersionUpdate = newTaglib.isVersionUpdatePending();
        if (newPendingVersionUpdate) {
            this.setVersionUpdatePending(true);
        }
        this.ensureTLDDefaults();
        this.turnOnRegeneration();
    }

    public void turnOnRegeneration() {
        this.regenerationOn = true;
    }

    public void turnOffRegeneration() {
        this.regenerationOn = false;
    }

    public boolean getRegenerationOn() {
        return this.regenerationOn;
    }

    public boolean isRegenerationOn() {
        return this.regenerationOn;
    }

    public boolean tagsMatchForMerging(TagInfoData tagA, TagInfoData tagB) {
        String tagAName = tagA.getTagName();
        if (tagAName == null) {
            return false;
        }
        boolean result = tagAName.equals(tagB.getTagName());
        return result;
    }

    public void updateTaglibProperties(TagLibraryInfoData newTaglib) {
        Vector newListeners;
        ValidatorData newValidator;
        String newJarFile;
        String newTagHandlerGenerationRoot;
        String newJspVersion;
        String newDescription;
        String newLargeIcon;
        String newSmallIcon;
        String newURI;
        String newDisplayName;
        String newShortName;
        String newPrefixString;
        String newDtdSystemId;
        String newDtdPublicId;
        String newDtdName;
        String newTLibVersion = newTaglib.getTLibVersion();
        if (newTLibVersion != null && !newTLibVersion.equals(this.getTLibVersion())) {
            this.setTLibVersion(newTLibVersion);
        }
        if ((newDtdName = newTaglib.getDtdName()) != null && !newDtdName.equals(this.getDtdName())) {
            this.setDtdName(newDtdName);
        }
        if ((newDtdPublicId = newTaglib.getDtdPublicId()) != null && !newDtdPublicId.equals(this.getDtdPublicId())) {
            this.setDtdPublicId(newDtdPublicId);
        }
        if ((newDtdSystemId = newTaglib.getDtdSystemId()) != null && !newDtdSystemId.equals(this.getDtdSystemId())) {
            this.setDtdSystemId(newDtdSystemId);
        }
        if ((newPrefixString = newTaglib.getPrefixString()) != null && !newPrefixString.equals(this.getPrefixString())) {
            this.setPrefixString(newPrefixString);
        }
        if ((newShortName = newTaglib.getShortName()) != null && !newShortName.equals(this.getShortName())) {
            this.setShortName(newShortName);
        }
        if ((newDisplayName = newTaglib.getDisplayName()) != null && !newDisplayName.equals(this.getDisplayName())) {
            this.setDisplayName(newDisplayName);
        }
        if ((newURI = newTaglib.getURI()) != null && !newURI.equals(this.getURI())) {
            this.setURI(newURI);
        }
        if ((newSmallIcon = newTaglib.getSmallIcon()) != null && !newSmallIcon.equals(this.getSmallIcon())) {
            this.setSmallIcon(newSmallIcon);
        }
        if ((newLargeIcon = newTaglib.getLargeIcon()) != null && !newLargeIcon.equals(this.getLargeIcon())) {
            this.setLargeIcon(newLargeIcon);
        }
        if ((newDescription = newTaglib.getDescription()) != null && !newDescription.equals(this.getDescription())) {
            this.setDescription(newDescription);
        }
        if ((newJspVersion = newTaglib.getJspVersion()) != null && !newJspVersion.equals(this.getJspVersion())) {
            this.setJspVersion(newJspVersion);
        }
        if ((newTagHandlerGenerationRoot = newTaglib.getTagHandlerGenerationRoot()) != null && !newTagHandlerGenerationRoot.equals(this.getTagHandlerGenerationRoot())) {
            this.setTagHandlerGenerationRoot(newTagHandlerGenerationRoot);
        }
        if ((newJarFile = newTaglib.getJarFile()) == null || !newJarFile.equals(this.getJarFile())) {
            this.setJarFile(newJarFile);
        }
        if ((newValidator = newTaglib.getValidator()) == null || !newValidator.equals(this.getValidator())) {
            this.setValidator(newValidator);
        }
        if ((newListeners = newTaglib.getTaglibListeners()) == null || !newListeners.equals(this.getTaglibListeners())) {
            this.setTaglibListeners(newListeners);
        }
        this.setCommentCache(newTaglib.getCommentCache());
    }

    public void mergeTags(TagInfoData oldTag, TagInfoData newTag) {
        Vector newVariables;
        Vector newAttributes;
        this.updateTagProperties(oldTag, newTag);
        Vector oldAttributes = oldTag.getAttributesVector();
        if (oldAttributes == null) {
            oldAttributes = new Vector();
        }
        if ((newAttributes = newTag.getAttributesVector()) == null) {
            newAttributes = new Vector();
        }
        Vector<TagAttributeInfoData> resultAttributes = new Vector<TagAttributeInfoData>();
        Enumeration en = newAttributes.elements();
        while (en.hasMoreElements()) {
            TagAttributeInfoData newTagAtt = (TagAttributeInfoData)en.nextElement();
            boolean aTagAttMatched = false;
            int i = 0;
            while (i < oldAttributes.size()) {
                TagAttributeInfoData oldTagAtt = (TagAttributeInfoData)oldAttributes.elementAt(i);
                if (this.tagAttributesMatchForMerging(oldTagAtt, newTagAtt)) {
                    resultAttributes.addElement(oldTagAtt);
                    oldAttributes.removeElementAt(i);
                    aTagAttMatched = true;
                    this.mergeTagAttributes(oldTagAtt, newTagAtt);
                    break;
                }
                ++i;
            }
            if (aTagAttMatched) continue;
            newTagAtt.setTag(oldTag);
            resultAttributes.addElement(newTagAtt);
        }
        oldTag.setAttributesVector(resultAttributes);
        Vector oldVariables = oldTag.getVariablesVector();
        if (oldVariables == null) {
            oldVariables = new Vector();
        }
        if ((newVariables = newTag.getVariablesVector()) == null) {
            newVariables = new Vector();
        }
        Vector<TagVariableInfoData> resultVariables = new Vector<TagVariableInfoData>();
        Enumeration en2 = newVariables.elements();
        while (en2.hasMoreElements()) {
            TagVariableInfoData newTagVar = (TagVariableInfoData)en2.nextElement();
            boolean aTagVarMatched = false;
            Iterator varIt = ((AbstractList)oldVariables).iterator();
            while (varIt.hasNext()) {
                TagVariableInfoData oldTagVar = (TagVariableInfoData)varIt.next();
                if (!this.tagVariablesMatchForMerging(oldTagVar, newTagVar)) continue;
                varIt.remove();
                aTagVarMatched = true;
                resultVariables.addElement(oldTagVar);
                this.mergeTagVariables(oldTagVar, newTagVar);
                break;
            }
            if (aTagVarMatched) continue;
            resultVariables.addElement(newTagVar);
            newTagVar.setTag(oldTag);
        }
        oldTag.setVariablesVector(resultVariables);
    }

    void printVarNames(Vector vars) {
        System.out.print("[");
        Iterator varItdbg = ((AbstractList)vars).iterator();
        while (varItdbg.hasNext()) {
            TagVariableInfoData v = (TagVariableInfoData)varItdbg.next();
            System.out.print(v.getName() + ":" + v.hashCode());
            if (!varItdbg.hasNext()) continue;
            System.out.print(", ");
        }
        System.out.println("]");
    }

    public void updateTagProperties(TagInfoData oldTag, TagInfoData newTag) {
        String newParentVariable;
        String newParentType;
        boolean newFindParent;
        boolean newImplementsTryCatchFinally;
        String newSupportClass;
        boolean newExtendsSupportClass;
        String newImplementsInterface;
        String newPackageName;
        String newDescription;
        String newLargeIcon;
        String newSmallIcon;
        String newBodyContent;
        String newTeiClassName;
        String newTagClassName;
        String newDisplayName = newTag.getDisplayName();
        if (newDisplayName != null && !newDisplayName.equals(oldTag.getDisplayName())) {
            oldTag.setDisplayName(newDisplayName);
        }
        if ((newTagClassName = newTag.getTagClassName()) != null && !newTagClassName.equals(oldTag.getTagClassName())) {
            oldTag.setTagClassName(newTagClassName);
        }
        if ((newTeiClassName = newTag.getTeiClassName()) != null && !newTeiClassName.equals(oldTag.getTeiClassName())) {
            oldTag.setTeiClassName(newTeiClassName);
        }
        if ((newBodyContent = newTag.getBodyContent()) != null && !newBodyContent.equals(oldTag.getBodyContent())) {
            oldTag.setBodyContent(newBodyContent);
        }
        if ((newSmallIcon = newTag.getSmallIcon()) != null && !newSmallIcon.equals(oldTag.getSmallIcon())) {
            oldTag.setSmallIcon(newSmallIcon);
        }
        if ((newLargeIcon = newTag.getLargeIcon()) != null && !newLargeIcon.equals(oldTag.getLargeIcon())) {
            oldTag.setLargeIcon(newLargeIcon);
        }
        if ((newDescription = newTag.getDescription()) != null && !newDescription.equals(oldTag.getDescription())) {
            oldTag.setDescription(newDescription);
        }
        if ((newPackageName = newTag.getPackageName()) != null && !newPackageName.equals(oldTag.getPackageName())) {
            oldTag.setPackageName(newPackageName);
        }
        if ((newImplementsInterface = newTag.getImplementsInterface()) != null && !newImplementsInterface.equals(oldTag.getImplementsInterface())) {
            oldTag.setImplementsInterface(newImplementsInterface);
        }
        if ((newExtendsSupportClass = newTag.getExtendsSupportClass()) != oldTag.getExtendsSupportClass()) {
            oldTag.setExtendsSupportClass(newExtendsSupportClass);
        }
        if ((newSupportClass = newTag.getSupportClass()) != null && !newSupportClass.equals(oldTag.getSupportClass())) {
            oldTag.setSupportClass(newSupportClass);
        }
        if ((newImplementsTryCatchFinally = newTag.getImplementsTryCatchFinally()) != oldTag.getImplementsTryCatchFinally()) {
            oldTag.setImplementsTryCatchFinally(newImplementsTryCatchFinally);
        }
        if ((newFindParent = newTag.getFindParent()) != oldTag.getFindParent()) {
            oldTag.setFindParent(newFindParent);
        }
        if ((newParentType = newTag.getParentType()) != null && !newParentType.equals(oldTag.getParentType())) {
            oldTag.setParentType(newParentType);
        }
        if ((newParentVariable = newTag.getParentVariable()) != null && !newParentVariable.equals(oldTag.getParentVariable())) {
            oldTag.setParentVariable(newParentVariable);
        }
        oldTag.setCommentCache(newTag.getCommentCache());
    }

    public boolean tagAttributesMatchForMerging(TagAttributeInfoData oldTagAtt, TagAttributeInfoData newTagAtt) {
        String oldAttrName = oldTagAtt.getName();
        if (oldAttrName == null) {
            return false;
        }
        boolean result = oldAttrName.equals(newTagAtt.getName());
        return result;
    }

    public void mergeTagAttributes(TagAttributeInfoData oldTagAtt, TagAttributeInfoData newTagAtt) {
        this.updateTagAttributeProperties(oldTagAtt, newTagAtt);
    }

    public void updateTagAttributeProperties(TagAttributeInfoData oldTagAtt, TagAttributeInfoData newTagAtt) {
        String newJavaVariableName;
        String newDefaultValue;
        boolean newReferencesTagReferentFirst;
        String newReferencesTagVariable;
        String newReferenceScopeString;
        String newReferencesTagType;
        boolean newReferencesTag;
        boolean newIsReferenceID;
        boolean newRequired;
        boolean newRequestTime;
        String newTypeName = newTagAtt.getTypeName();
        if (newTypeName != null && !newTypeName.equals(oldTagAtt.getTypeName())) {
            oldTagAtt.setTypeName(newTypeName);
        }
        if ((newRequestTime = newTagAtt.getRequestTime()) != oldTagAtt.getRequestTime()) {
            oldTagAtt.setRequestTime(newRequestTime);
        }
        if ((newRequired = newTagAtt.getRequired()) != oldTagAtt.getRequired()) {
            oldTagAtt.setRequired(newRequired);
        }
        if ((newIsReferenceID = newTagAtt.getIsReferenceID()) != oldTagAtt.getIsReferenceID()) {
            oldTagAtt.setIsReferenceID(newIsReferenceID);
        }
        if ((newReferencesTag = newTagAtt.getReferencesTag()) != oldTagAtt.getReferencesTag()) {
            oldTagAtt.setReferencesTag(newReferencesTag);
        }
        if ((newReferencesTagType = newTagAtt.getReferencesTagType()) != null && !newReferencesTagType.equals(oldTagAtt.getReferencesTagType())) {
            oldTagAtt.setReferencesTagType(newReferencesTagType);
        }
        if ((newReferenceScopeString = newTagAtt.getReferenceScopeString()) != null && !newReferenceScopeString.equals(oldTagAtt.getReferenceScopeString())) {
            oldTagAtt.setReferenceScopeString(newReferenceScopeString);
        }
        if ((newReferencesTagVariable = newTagAtt.getReferencesTagVariable()) != null && !newReferencesTagVariable.equals(oldTagAtt.getReferencesTagVariable())) {
            oldTagAtt.setReferencesTagVariable(newReferencesTagVariable);
        }
        if ((newReferencesTagReferentFirst = newTagAtt.getReferencesTagReferentFirst()) != oldTagAtt.getReferencesTagReferentFirst()) {
            oldTagAtt.setReferencesTagReferentFirst(newReferencesTagReferentFirst);
        }
        if ((newDefaultValue = newTagAtt.getDefaultValue()) != null && !newDefaultValue.equals(oldTagAtt.getDefaultValue())) {
            oldTagAtt.setDefaultValue(newDefaultValue);
        }
        if ((newJavaVariableName = newTagAtt.getJavaVariableName()) != null && !newJavaVariableName.equals(oldTagAtt.getJavaVariableName())) {
            oldTagAtt.setJavaVariableName(newJavaVariableName);
        }
        oldTagAtt.setCommentCache(newTagAtt.getCommentCache());
    }

    public boolean tagVariablesMatchForMerging(TagVariableInfoData oldTagVar, TagVariableInfoData newTagVar) {
        String oldVarName = oldTagVar.getName();
        if (oldVarName == null) {
            return false;
        }
        boolean result = oldVarName.equals(newTagVar.getName());
        return result;
    }

    public void mergeTagVariables(TagVariableInfoData oldTagAtt, TagVariableInfoData newTagAtt) {
        this.updateTagVariableProperties(oldTagAtt, newTagAtt);
    }

    public void updateTagVariableProperties(TagVariableInfoData oldTagVar, TagVariableInfoData newTagVar) {
        boolean newDeclare;
        int newScope;
        String newType;
        String newNameAttribute;
        int newNameType = newTagVar.getNameType();
        if (newNameType != oldTagVar.getNameType()) {
            oldTagVar.setNameType(newNameType);
        }
        if ((newNameAttribute = newTagVar.getNameAttribute()) != null && !newNameAttribute.equals(oldTagVar.getNameAttribute())) {
            oldTagVar.setNameAttribute(newNameAttribute);
        }
        if ((newType = newTagVar.getType()) != null && !newType.equals(oldTagVar.getType())) {
            oldTagVar.setType(newType);
        }
        if ((newScope = newTagVar.getScope()) != oldTagVar.getScope()) {
            oldTagVar.setScope(newScope);
        }
        if ((newDeclare = newTagVar.getDeclare()) != oldTagVar.getDeclare()) {
            oldTagVar.setDeclare(newDeclare);
        }
        oldTagVar.setCommentCache(newTagVar.getCommentCache());
    }

    public CommentCache getCommentCache() {
        return this.commentCache;
    }

    void setCommentCache(CommentCache value) {
        this.commentCache = value;
    }

    public String getReliableURN() {
        return this.getURI();
    }

    public void setReliableURN(String value) {
        this.setURI(value);
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String value) {
        if (value != null && !value.equals(this.uri)) {
            Object object = this.lock;
            synchronized (object) {
                String oldValue = this.uri;
                this.uri = value.trim();
                this.setTldDirtyBit("URI was set to " + value);
                this.firePropertyChange(URI, oldValue, value);
            }
        }
    }

    public String defaultURIString(String tldFileName) {
        return this.ensureShortName();
    }

    public String getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(String value) {
        if (value != null && !value.equals(this.smallIcon)) {
            Object object = this.lock;
            synchronized (object) {
                String oldValue = this.smallIcon;
                this.smallIcon = value.trim();
                this.setTldDirtyBit("SmallIcon was set to " + value);
                this.firePropertyChange(SMALL_ICON, oldValue, value);
            }
        }
    }

    public String getLargeIcon() {
        return this.largeIcon;
    }

    public void setLargeIcon(String value) {
        if (value != null && !value.equals(this.largeIcon)) {
            Object object = this.lock;
            synchronized (object) {
                String oldValue = this.largeIcon;
                this.largeIcon = value.trim();
                this.setTldDirtyBit("LargeIcon was set to " + value);
                this.firePropertyChange(LARGE_ICON, oldValue, value);
            }
        }
    }

    public ValidatorData getValidator() {
        return this.validator;
    }

    public void setValidator(ValidatorData value) {
        if (value != null && !value.equals(this.validator)) {
            Object object = this.lock;
            synchronized (object) {
                String oldValue = this.largeIcon;
                this.validator = value;
                this.setTldDirtyBit("LargeIcon was set to " + value);
                this.firePropertyChange(VALIDATOR, oldValue, value);
            }
        }
    }

    public Vector getTaglibListeners() {
        return this.taglibListeners;
    }

    public void setTaglibListeners(Vector value) {
        if (value != null && !value.equals(this.taglibListeners)) {
            Object object = this.lock;
            synchronized (object) {
                String oldValue = this.largeIcon;
                this.taglibListeners = value;
                this.setTldDirtyBit("LargeIcon was set to " + value);
                this.firePropertyChange(LISTENERS, oldValue, value);
            }
        }
    }

    public void addTaglibListener(ListenerData value) {
        if (value == null) {
            return;
        }
        if (this.taglibListeners == null) {
            this.taglibListeners = new Vector();
        }
        this.taglibListeners.addElement(value);
    }

    public void removeTaglibListener(ListenerData value) {
        if (value == null) {
            return;
        }
        if (this.taglibListeners == null) {
            return;
        }
        this.taglibListeners.removeElement(value);
    }

    public String getTldDirectory() {
        return this.tldFileDirectory;
    }

    public String getTldFileName() {
        return this.tldFileName;
    }

    public String getTldFilePath() {
        return this.tldxFilePath;
    }

    public void setTldFilePath(String value) {
        this.tldxFilePath = value;
    }

    public String getTLibVersion() {
        return this.tlibversion;
    }

    public void setTLibVersion(String value) {
        if (value != null && !value.equals(this.tlibversion)) {
            value = value.trim();
            Object object = this.lock;
            synchronized (object) {
                String oldValue = this.tlibversion;
                this.tlibversion = value;
                this.setTldDirtyBit("TLibVersion was set to " + value);
                this.firePropertyChange(TLIBVERSION, oldValue, value);
            }
        }
    }

    public String getDtdName() {
        return this.dtdName;
    }

    public void setDtdName(String value) {
        this.dtdName = value;
        this.setTldDirtyBit("DtdName was set to " + value);
    }

    public String getDtdPublicId() {
        return this.dtdPublicId;
    }

    public void setDtdPublicId(String value) {
        this.dtdPublicId = value;
        this.setTldDirtyBit("Dtd Public Id was set to " + value);
    }

    public String getDtdSystemId() {
        return this.dtdSystemId;
    }

    public void setDtdSystemId(String value) {
        this.dtdSystemId = value;
        this.setTldDirtyBit("Dtd System Id was set to " + value);
    }

    public String getPrefixString() {
        return this.prefix;
    }

    public void setPrefixString(String value) {
        if (value != null && !value.equals(this.prefix)) {
            Object object = this.lock;
            synchronized (object) {
                String oldValue = this.prefix;
                this.prefix = value.trim();
                this.setTldDirtyBit("Prefix String  was set to " + value);
                this.firePropertyChange(PREFIX, oldValue, value);
            }
        }
    }

    public String getShortName() {
        return this.shortname;
    }

    public void setShortName(String value) {
        if (value != null && !value.equals(this.shortname)) {
            Object object = this.lock;
            synchronized (object) {
                String oldValue = this.shortname;
                this.shortname = value.trim();
                this.setTldDirtyBit("Short name was set to " + value);
                this.firePropertyChange(SHORT_NAME, oldValue, value);
            }
        }
    }

    public String ensureShortName() {
        if (this.shortname == null) {
            String name = this.getTldFileName();
            if (name.endsWith(DOT_TAGLIB_EXTENSION)) {
                name = name.substring(0, name.length() - 4);
            }
            this.shortname = name;
        }
        return this.shortname;
    }

    public String getDisplayName() {
        return this.displayname;
    }

    public void setDisplayName(String value) {
        if (value != null && !value.equals(this.displayname)) {
            Object object = this.lock;
            synchronized (object) {
                String oldValue = this.displayname;
                this.displayname = value.trim();
                this.setTldDirtyBit("Display name was set to " + value);
                this.firePropertyChange(DISPLAY_NAME, oldValue, value);
            }
        }
    }

    public String ensureDisplayName() {
        if (this.displayname == null) {
            String name = this.getTldFileName();
            if (name.endsWith(DOT_TAGLIB_EXTENSION)) {
                name = name.substring(0, name.length() - 4);
            }
            this.displayname = name;
        }
        return this.displayname;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        if (value != null && !value.equals(this.description)) {
            Object object = this.lock;
            synchronized (object) {
                String oldValue = this.description;
                this.description = value;
                this.setTldDirtyBit("Description was set to " + value);
                this.firePropertyChange(DESCRIPTION, oldValue, value);
            }
        }
    }

    public String getJspVersion() {
        return this.jspversion;
    }

    public void setJspVersion(String value) {
        if (value != null && !value.equals(this.jspversion)) {
            Object object = this.lock;
            synchronized (object) {
                String oldValue = this.jspversion;
                this.jspversion = value.trim();
                this.setTldDirtyBit("JSP Version was set to " + value);
                this.firePropertyChange(JSPVERSION, oldValue, value);
            }
        }
    }

    public String getTagHandlerGenerationRoot() {
        return this.tagHandlerGenerationRoot;
    }

    public void setTagHandlerGenerationRoot(String value) {
        if (value != null && !value.equals(this.tagHandlerGenerationRoot)) {
            Object object = this.lock;
            synchronized (object) {
                String oldValue = this.tagHandlerGenerationRoot;
                this.tagHandlerGenerationRoot = value.trim();
                this.setTldDirtyBit("TagHandlerGenerationRoot was set to " + value);
                this.firePropertyChange(TAG_HANDLER_GENERATION_ROOT, oldValue, value);
            }
        }
    }

    public String getJarFile() {
        return this.jarFile;
    }

    public void setJarFile(String value) {
        if (value != null && !value.equals(this.jarFile)) {
            Object object = this.lock;
            synchronized (object) {
                String oldValue = this.jarFile;
                this.jarFile = value.trim();
                this.setTldDirtyBit("JarFile was set to " + value);
                this.firePropertyChange(JAR_FILE, oldValue, value);
            }
        }
    }

    public Vector getTagsVector() {
        return this.tagsVector;
    }

    public void setTagsVector(Vector newTagsVector) {
        this.tagsVector = newTagsVector;
        this.setTldDirtyBit("Replacing the tags vector.");
        this.firePropertyChange(REPLACE_TAGS, null, null);
    }

    public void addTag(TagInfoData tag) {
        if (this.tagsVector == null) {
            this.tagsVector = new Vector();
        }
        this.tagsVector.addElement(tag);
        this.setTldDirtyBit("tag " + tag.getTagName() + " was added.");
        this.firePropertyChange(ADD_TAG, null, null);
    }

    public void deleteTag(TagInfoData tag) {
        if (this.tagsVector == null) {
            return;
        }
        this.tagsVector.removeElement(tag);
        this.setTldDirtyBit("tag " + tag.getTagName() + " was deleted.");
        this.firePropertyChange(DELETE_TAG, null, null);
    }

    public TagInfoData findTagByName(String name) {
        if (name == null) {
            return null;
        }
        Vector tagsVec = this.getTagsVector();
        Enumeration en = tagsVec.elements();
        while (en.hasMoreElements()) {
            TagInfoData tag = (TagInfoData)en.nextElement();
            if (!name.equalsIgnoreCase(tag.getTagName())) continue;
            return tag;
        }
        return null;
    }

    public TagInfoData findTagByType(String type, boolean takePackageIntoAccount) {
        if (type == null) {
            return null;
        }
        Vector tagsVec = this.getTagsVector();
        Enumeration en = tagsVec.elements();
        while (en.hasMoreElements()) {
            TagInfoData tag = (TagInfoData)en.nextElement();
            String tagHandlerClassName = tag.getTagClassName();
            if (takePackageIntoAccount) {
                String qualifiedClassName;
                String pkg = tag.getPackageName();
                String string = qualifiedClassName = pkg == null || pkg.equals("") ? tagHandlerClassName : pkg + '.' + tagHandlerClassName;
                if (!type.equals(qualifiedClassName)) continue;
                return tag;
            }
            if (!type.equals(tagHandlerClassName)) continue;
            return tag;
        }
        return null;
    }

    private void parseTLD(InputSource in, String tldFilePath) throws TLDException {
        XMLReader parser = null;
        try {
            parser = XMLUtil.createXMLReader();
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(16, (Throwable)ex);
        }
        TaglibDocumentHandler taglibDocumentHandler = new TaglibDocumentHandler(this);
        parser.setEntityResolver(taglibDocumentHandler);
        parser.setContentHandler(taglibDocumentHandler);
        parser.setDTDHandler(taglibDocumentHandler);
        try {
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", taglibDocumentHandler);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            parser.parse(in);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    public static void setupInitialIndenting(TagInfoData tag) {
        CommentCache commentCache = tag.getCommentCache();
        commentCache.addCharacters("_before", '\n' + INDENTSTRING);
        String string = '\n' + INDENTSTRING + INDENTSTRING;
    }

    /*
     * WARNING - void declaration
     */
    static void copy(InputStream in, String fileName) throws IOException, FileNotFoundException {
        int nRead;
        byte[] buf = new byte[1024];
        FileOutputStream out = new FileOutputStream(fileName);
        while ((nRead = in.read(buf, 0, buf.length)) != -1) {
            void var4_4;
            out.write(buf, 0, (int)var4_4);
        }
    }

    public static final void print(StringBuffer buf, String name, String value) {
        if (value != null) {
            buf.append(name + " = {\n\t");
            buf.append(value);
            buf.append("\n}\n");
        }
    }

    public static void println(StringBuffer buf) {
        buf.append('\n');
    }

    public static void println(StringBuffer buf, Object obj) {
        buf.append(obj.toString());
        buf.append('\n');
    }

    public static void print(StringBuffer buf, Object obj) {
        buf.append(obj.toString());
    }

    public static void indentPrintValue(StringBuffer buf, String name, String value, CommentCache commentCache) {
        if (value != null && value != "") {
            boolean hasCommentItems = TagLibraryInfoData.printCachedCommentItems(buf, commentCache, name);
            if (!hasCommentItems) {
                if (previousNewLinePending) {
                    buf.append('\n');
                    previousNewLinePending = false;
                }
                TagLibraryInfoData.indentPrint(buf, "");
            }
            buf.append('<');
            buf.append(name);
            buf.append('>');
            buf.append(value);
            buf.append("</");
            buf.append(name);
            buf.append('>');
            previousNewLinePending = true;
        }
    }

    public static String escapeLT(String value) {
        if (value == null) {
            return value;
        }
        int l = value.length();
        StringBuffer buf = new StringBuffer(2 * l);
        char[] chars = new char[l];
        value.getChars(0, l, chars, 0);
        int i = 0;
        while (i < l) {
            char ch = chars[i];
            if (ch == '<') {
                buf.append("&lt;");
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }

    public static void indentPrintTextValue(StringBuffer buf, String name, String value, CommentCache commentCache) {
        boolean hasCommentItems = TagLibraryInfoData.printCachedCommentItems(buf, commentCache, name);
        if (value != null) {
            if (!hasCommentItems) {
                if (previousNewLinePending) {
                    buf.append('\n');
                    previousNewLinePending = false;
                }
                TagLibraryInfoData.indentPrint(buf, "");
            }
            buf.append('<');
            buf.append(name);
            buf.append('>');
            buf.append(value);
            buf.append("</");
            buf.append(name);
            buf.append('>');
            previousNewLinePending = true;
        }
    }

    public static void indentPrintValue(StringBuffer buf, String name, boolean value, CommentCache commentCache) {
        boolean hasCommentItems = TagLibraryInfoData.printCachedCommentItems(buf, commentCache, name);
        if (!hasCommentItems) {
            if (previousNewLinePending) {
                buf.append('\n');
                previousNewLinePending = false;
            }
            TagLibraryInfoData.indentPrint(buf, "");
        }
        buf.append('<');
        buf.append(name);
        buf.append('>');
        buf.append(value ? "true" : "false");
        buf.append("</");
        buf.append(name);
        buf.append('>');
        previousNewLinePending = true;
    }

    public static void indentPrintln(StringBuffer buf, Object thing) {
        TagLibraryInfoData.indentPrint(buf, thing);
        buf.append('\n');
    }

    public static void indentPrint(StringBuffer buf, Object thing) {
        boolean useIndent = true;
        int i = 0;
        while (i < indent) {
            if (useIndent) {
                buf.append(INDENTSTRING);
            }
            ++i;
        }
        buf.append(thing.toString());
    }

    public static boolean printCachedCommentItems(StringBuffer buf, CommentCache commentCache, String key) {
        boolean hasCommentItems = false;
        Vector cachedItems = commentCache.getCommentItems(key);
        if (cachedItems == null) {
            return hasCommentItems;
        }
        Enumeration en = cachedItems.elements();
        while (en.hasMoreElements()) {
            CommentItem citem = (CommentItem)en.nextElement();
            citem.toString(buf);
            hasCommentItems = true;
        }
        return hasCommentItems;
    }

    public static void printNodeTag(StringBuffer buf, String xmltag, String commentPlacement, CommentCache commentCache) {
        boolean hasCommentItems = TagLibraryInfoData.printCachedCommentItems(buf, commentCache, commentPlacement);
        if (!hasCommentItems) {
            if (previousNewLinePending) {
                buf.append('\n');
                previousNewLinePending = false;
            }
            TagLibraryInfoData.indentPrint(buf, "");
        }
        buf.append(xmltag);
        previousNewLinePending = true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(1024);
        TagLibraryInfoData.print(buf, "tlibversion", this.tlibversion);
        TagLibraryInfoData.print(buf, "jspversion", this.jspversion);
        TagLibraryInfoData.print(buf, "shortname", this.shortname);
        TagLibraryInfoData.print(buf, "displayname", this.displayname);
        TagLibraryInfoData.print(buf, "uri", this.uri);
        TagLibraryInfoData.print(buf, "smallIcon", this.smallIcon);
        TagLibraryInfoData.print(buf, "largeIcon", this.largeIcon);
        TagLibraryInfoData.print(buf, "description", this.description);
        TagLibraryInfoData.print(buf, "tagHandlerGenerationRoot", this.tagHandlerGenerationRoot);
        TagLibraryInfoData.print(buf, "jarFile", this.jarFile);
        if (this.tagsVector == null) {
            TagLibraryInfoData.println(buf, "tagsVector = null");
        } else {
            Enumeration en = this.tagsVector.elements();
            while (en.hasMoreElements()) {
                TagLibraryInfoData.println(buf, en.nextElement());
            }
        }
        return buf.toString();
    }

    public void writeExtendedTagLibraryDescriptor(PrintWriter out) {
        this.calculatePendingVersionUpdate();
        StringBuffer buf = new StringBuffer(4096);
        this.prettyPrintTaglib(buf, true);
        out.print(buf);
    }

    public void writeStandardTagLibraryDescriptor(PrintWriter out) {
        StringBuffer buf = new StringBuffer(4096);
        this.prettyPrintTaglib(buf, false);
        out.print(buf);
    }

    public void writeExtendedTagLibraryDescriptor(StringBuffer buf) {
        this.prettyPrintTaglib(buf, true);
    }

    public void writeStandardTagLibraryDescriptor(StringBuffer buf) {
        this.prettyPrintTaglib(buf, false);
    }

    public static String getSupportedJSPVersion() {
        return supportedJSPVersion;
    }

    public static void setSupportedJSPVersion(String value) {
        supportedJSPVersion = value;
    }

    public void prettyPrintTaglib(StringBuffer buf, boolean printExtendedDescriptor) {
        TagLibraryInfoData.prettyPrintTaglib(buf, this, printExtendedDescriptor);
    }

    public static void prettyPrintTaglib(StringBuffer buf, TagLibraryInfoData taglib, boolean printExtendedDescriptor) {
        int lastItemNum;
        Vector tagsV;
        previousNewLinePending = false;
        CommentCache commentCache = taglib.getCommentCache();
        indent = 0;
        TagLibraryInfoData.printCachedCommentItems(buf, commentCache, "_startdocument_");
        TagLibraryInfoData.printTagLibHeader(buf, taglib, printExtendedDescriptor);
        TagLibraryInfoData.printNodeTag(buf, "\n\n<taglib>", "_before_", commentCache);
        ++indent;
        String jspVersion = TagLibraryInfoData.getSupportedJSPVersion();
        if (jspVersion.equals("1.1")) {
            TagLibraryInfoData.indentPrintValue(buf, "tlibversion", taglib.tlibversion, commentCache);
            TagLibraryInfoData.indentPrintValue(buf, "jspversion", taglib.jspversion, commentCache);
            TagLibraryInfoData.indentPrintValue(buf, "shortname", taglib.shortname, commentCache);
            TagLibraryInfoData.indentPrintValue(buf, "uri", taglib.uri, commentCache);
            TagLibraryInfoData.indentPrintTextValue(buf, "info", TagLibraryInfoData.escapeLT(taglib.description), commentCache);
        } else if (jspVersion.equals("1.2")) {
            TagLibraryInfoData.indentPrintValue(buf, "tlib-version", taglib.tlibversion, commentCache);
            TagLibraryInfoData.indentPrintValue(buf, "jsp-version", taglib.jspversion, commentCache);
            TagLibraryInfoData.indentPrintValue(buf, "short-name", taglib.shortname, commentCache);
            TagLibraryInfoData.indentPrintValue(buf, "uri", taglib.uri, commentCache);
            TagLibraryInfoData.indentPrintValue(buf, "display-name", taglib.displayname, commentCache);
            TagLibraryInfoData.indentPrintValue(buf, "small-icon", taglib.smallIcon, commentCache);
            TagLibraryInfoData.indentPrintValue(buf, "large-icon", taglib.largeIcon, commentCache);
            TagLibraryInfoData.indentPrintTextValue(buf, "description", TagLibraryInfoData.escapeLT(taglib.description), commentCache);
            TagLibraryInfoData.prettyPrintValidator(buf, taglib);
            TagLibraryInfoData.prettyPrintListeners(buf, taglib);
        }
        if (printExtendedDescriptor) {
            TagLibraryInfoData.prettyPrintTaglibCodeGenOptions(buf, taglib);
        }
        if ((tagsV = taglib.tagsVector) != null) {
            Enumeration en = tagsV.elements();
            while (en.hasMoreElements()) {
                TagLibraryInfoData.prettyPrintTag(buf, (TagInfoData)en.nextElement(), printExtendedDescriptor);
            }
        }
        --indent;
        TagLibraryInfoData.printNodeTag(buf, "</taglib>\n", "_end_", commentCache);
        boolean hasComments = TagLibraryInfoData.printCachedCommentItems(buf, commentCache, "_after_");
        boolean lastCachedItemIsComment = false;
        Vector cachedItems = commentCache.getCommentItems("_after_");
        if (cachedItems != null && (lastItemNum = cachedItems.size() - 1) >= 0) {
            CommentItem lastItem = (CommentItem)cachedItems.elementAt(lastItemNum);
            boolean bl = lastCachedItemIsComment = lastItem.getType() == 0;
        }
        if (lastCachedItemIsComment) {
            buf.append('\n');
        }
    }

    public static void prettyPrintValidator(StringBuffer buf, TagLibraryInfoData taglib) {
        if (taglib.validator == null) {
            return;
        }
        ValidatorData validator = taglib.validator;
        CommentCache commentCache = validator.getCommentCache();
        TagLibraryInfoData.indentPrintln(buf, "<validator>");
        ++indent;
        TagLibraryInfoData.indentPrintValue(buf, "validator-class", validator.getValidatorClass(), commentCache);
        Vector initParams = validator.getInitParams();
        Enumeration en = initParams.elements();
        while (en.hasMoreElements()) {
            TagLibraryInfoData.prettyPrintInitParam(buf, (ParamData)en.nextElement());
        }
        --indent;
        TagLibraryInfoData.indentPrintln(buf, "</validator>");
    }

    public static void prettyPrintInitParam(StringBuffer buf, ParamData param) {
        CommentCache commentCache = param.getCommentCache();
        TagLibraryInfoData.indentPrintln(buf, "<init-param>");
        ++indent;
        TagLibraryInfoData.indentPrintValue(buf, "param-name", param.getParamName(), commentCache);
        TagLibraryInfoData.indentPrintValue(buf, "param-value", param.getParamValue(), commentCache);
        TagLibraryInfoData.indentPrintValue(buf, "description", param.getDescription(), commentCache);
        --indent;
        TagLibraryInfoData.indentPrintln(buf, "</init-param>");
    }

    public static void prettyPrintListeners(StringBuffer buf, TagLibraryInfoData taglib) {
        Vector taglibListeners = taglib.getTaglibListeners();
        if (taglibListeners == null || taglibListeners.size() < 1) {
            return;
        }
        Enumeration en = taglib.getTaglibListeners().elements();
        while (en.hasMoreElements()) {
            ListenerData listener = (ListenerData)en.nextElement();
            CommentCache commentCache = listener.getCommentCache();
            TagLibraryInfoData.indentPrintln(buf, "<listener>");
            ++indent;
            TagLibraryInfoData.indentPrintValue(buf, "listener-class", listener.getListenerClass(), commentCache);
            --indent;
            TagLibraryInfoData.indentPrintln(buf, "</listener>");
        }
    }

    public static void prettyPrintTaglibCodeGenOptions(StringBuffer buf, TagLibraryInfoData taglib) {
        boolean thereAreCodegenOptionsForTaglib = taglib.tagHandlerGenerationRoot != null && !taglib.tagHandlerGenerationRoot.equals("");
        boolean bl = thereAreCodegenOptionsForTaglib = thereAreCodegenOptionsForTaglib || taglib.jarFile != null && !taglib.jarFile.equals("");
        if (thereAreCodegenOptionsForTaglib) {
            CommentCache commentCache = taglib.getCommentCache();
            TagLibraryInfoData.indentPrintln(buf, "");
            TagLibraryInfoData.indentPrintln(buf, "<!-- Forte4J_TLDX:  This comment contains code generation information. Do not delete.");
            TagLibraryInfoData.indentPrint(buf, "<tldx>");
            previousNewLinePending = true;
            ++indent;
            TagLibraryInfoData.indentPrintValue(buf, "tagHandlerGenerationRoot", taglib.tagHandlerGenerationRoot, commentCache);
            String jspVersion = TagLibraryInfoData.getSupportedJSPVersion();
            if (jspVersion.equals("1.2")) {
                TagLibraryInfoData.indentPrintValue(buf, JAR_FILE, taglib.jarFile, commentCache);
            }
            --indent;
            if (previousNewLinePending) {
                buf.append('\n');
                previousNewLinePending = false;
            }
            TagLibraryInfoData.indentPrintln(buf, "</tldx>");
            TagLibraryInfoData.indentPrint(buf, "-->");
        }
    }

    public static void printTagLibHeader(StringBuffer buf, TagLibraryInfoData taglib, boolean printExtendedDescriptor) {
        if (xmlHeader == null) {
            String tldXMLEncoding = NbBundle.getMessage((Class)(class$org$netbeans$modules$web$taglibed$TLDDataObject == null ? (class$org$netbeans$modules$web$taglibed$TLDDataObject = TagLibraryInfoData.class$("org.netbeans.modules.web.taglibed.TLDDataObject")) : class$org$netbeans$modules$web$taglibed$TLDDataObject), (String)"TLD_Taglib_XML_Default_Encoding");
            xmlHeader = "<?xml version=\"1.0\" encoding=\"" + tldXMLEncoding + "\" ?>";
        }
        TagLibraryInfoData.indentPrintln(buf, xmlHeader);
        TagLibraryInfoData.println(buf);
        String dtdName = taglib.getDtdName();
        if (dtdName == null) {
            dtdName = "taglib";
        }
        String dtdPublicId = taglib.getDtdPublicId();
        String dtdSystemId = taglib.getDtdSystemId();
        String jspVersion = TagLibraryInfoData.getSupportedJSPVersion();
        if (jspVersion.equals("1.1")) {
            if (dtdPublicId == null) {
                dtdPublicId = TAGLIB_DTD_PUBLIC_ID_1_1;
            }
            if (dtdSystemId == null) {
                dtdSystemId = TAGLIB_DTD_RESOURCE_1_1;
            }
        } else if (jspVersion.equals("1.2")) {
            if (dtdPublicId == null || dtdPublicId.equals(TAGLIB_DTD_PUBLIC_ID_1_1)) {
                dtdPublicId = TAGLIB_DTD_PUBLIC_ID_1_2;
            }
            if (dtdSystemId == null || dtdSystemId.equals(TAGLIB_DTD_RESOURCE_1_1) || dtdSystemId.equals(ALT_TAGLIB_DTD_RESOURCE_1_1)) {
                dtdSystemId = TAGLIB_DTD_RESOURCE_1_2;
            }
        }
        dtdName = "taglib";
        TagLibraryInfoData.indentPrintln(buf, "<!DOCTYPE " + dtdName);
        TagLibraryInfoData.indentPrintln(buf, "        PUBLIC \"" + dtdPublicId + "\"");
        TagLibraryInfoData.indentPrintln(buf, "        \"" + dtdSystemId + "\">");
        previousNewLinePending = true;
    }

    public static void prettyPrintTag(StringBuffer buf, TagInfoData tag, boolean printExtendedDescriptor) {
        String jspVersion;
        CommentCache commentCache = tag.getCommentCache();
        TagLibraryInfoData.printNodeTag(buf, "<tag>", "_before_", commentCache);
        ++indent;
        TagLibraryInfoData.indentPrintValue(buf, "name", tag.getTagName(), commentCache);
        String fullyQualifiedClassName = tag.getTagClassName();
        String fullyQualifiedTEIClassName = tag.getTeiClassName();
        String packageName = tag.getPackageName();
        if (packageName != null && !packageName.equals("")) {
            fullyQualifiedClassName = packageName + "." + fullyQualifiedClassName;
            if (fullyQualifiedTEIClassName != null) {
                fullyQualifiedTEIClassName = packageName + "." + fullyQualifiedTEIClassName;
            }
        }
        if ((jspVersion = TagLibraryInfoData.getSupportedJSPVersion()).equals("1.1")) {
            TagLibraryInfoData.indentPrintValue(buf, "tagclass", fullyQualifiedClassName, commentCache);
            TagLibraryInfoData.indentPrintValue(buf, "teiclass", fullyQualifiedTEIClassName, commentCache);
            TagLibraryInfoData.indentPrintValue(buf, "bodycontent", tag.getBodyContent(), commentCache);
            TagLibraryInfoData.indentPrintTextValue(buf, "info", TagLibraryInfoData.escapeLT(tag.getDescription()), commentCache);
        } else if (jspVersion.equals("1.2")) {
            TagLibraryInfoData.indentPrintValue(buf, "tag-class", fullyQualifiedClassName, commentCache);
            TagLibraryInfoData.indentPrintValue(buf, "tei-class", fullyQualifiedTEIClassName, commentCache);
            TagLibraryInfoData.indentPrintValue(buf, "body-content", tag.getBodyContent(), commentCache);
            TagLibraryInfoData.indentPrintValue(buf, "display-name", tag.getDisplayName(), commentCache);
            TagLibraryInfoData.indentPrintValue(buf, "small-icon", tag.getSmallIcon(), commentCache);
            TagLibraryInfoData.indentPrintValue(buf, "large-icon", tag.getLargeIcon(), commentCache);
            TagLibraryInfoData.indentPrintTextValue(buf, "description", TagLibraryInfoData.escapeLT(tag.getDescription()), commentCache);
        }
        if (printExtendedDescriptor) {
            TagLibraryInfoData.prettyPrintTagCodegenOptions(buf, tag);
        }
        Enumeration en = tag.getVariablesVector().elements();
        while (en.hasMoreElements()) {
            TagLibraryInfoData.prettyPrintTagVariable(buf, (TagVariableInfoData)en.nextElement(), printExtendedDescriptor);
        }
        Enumeration en2 = tag.getAttributesVector().elements();
        while (en2.hasMoreElements()) {
            TagLibraryInfoData.prettyPrintAttribute(buf, (TagAttributeInfoData)en2.nextElement(), printExtendedDescriptor);
        }
        if (jspVersion.equals("1.2")) {
            TagLibraryInfoData.indentPrintTextValue(buf, "example", TagLibraryInfoData.escapeLT(tag.getExample()), commentCache);
        }
        --indent;
        TagLibraryInfoData.printNodeTag(buf, "</tag>", "_end_", commentCache);
        boolean hasComments = TagLibraryInfoData.printCachedCommentItems(buf, commentCache, "_after_");
        if (hasComments) {
            previousNewLinePending = false;
        }
    }

    public static void prettyPrintTagCodegenOptions(StringBuffer buf, TagInfoData tag) {
        CommentCache commentCache = tag.getCommentCache();
        boolean hasComments = TagLibraryInfoData.printCachedCommentItems(buf, commentCache, "_beforetldx_");
        if (!hasComments && previousNewLinePending) {
            buf.append('\n');
            previousNewLinePending = false;
            TagLibraryInfoData.indentPrint(buf, "");
        }
        TagLibraryInfoData.println(buf, "<!-- Forte4J_TLDX:  This comment contains code generation information. Do not delete.");
        TagLibraryInfoData.indentPrint(buf, "<tldx>");
        previousNewLinePending = true;
        ++indent;
        TagLibraryInfoData.indentPrintValue(buf, "packagename", tag.getPackageName(), commentCache);
        String jspVersion = TagLibraryInfoData.getSupportedJSPVersion();
        if (jspVersion.equals("1.2")) {
            String ii = tag.getImplementsInterface();
            if (!(ii == null || ii.equals("Tag") || ii.equals("IterationTag") || ii.equals("BodyTag"))) {
                ii = "";
            }
            TagLibraryInfoData.indentPrintValue(buf, "implementsInterface", ii, commentCache);
            TagLibraryInfoData.indentPrintValue(buf, "extendsSupportClass", tag.getExtendsSupportClass() ? "TRUE" : "FALSE", commentCache);
            TagLibraryInfoData.indentPrintValue(buf, "supportClass", tag.getSupportClass(), commentCache);
            TagLibraryInfoData.indentPrintValue(buf, "implementsTryCatchFinally", tag.getImplementsTryCatchFinally() ? "TRUE" : "FALSE", commentCache);
        }
        TagLibraryInfoData.indentPrintValue(buf, "findparent", tag.getFindParent() ? "TRUE" : "FALSE", commentCache);
        TagLibraryInfoData.indentPrintValue(buf, "parenttype", tag.getParentType(), commentCache);
        TagLibraryInfoData.indentPrintValue(buf, "parentvariable", tag.getParentVariable(), commentCache);
        --indent;
        if (previousNewLinePending) {
            buf.append('\n');
            previousNewLinePending = false;
        }
        TagLibraryInfoData.indentPrintln(buf, "</tldx>");
        TagLibraryInfoData.indentPrint(buf, "-->");
        previousNewLinePending = true;
        hasComments = TagLibraryInfoData.printCachedCommentItems(buf, commentCache, "_aftertldx_");
        previousNewLinePending = !hasComments;
    }

    public static void prettyPrintAttribute(StringBuffer buf, TagAttributeInfoData tagAttr, boolean printExtendedDescriptor) {
        CommentCache commentCache = tagAttr.getCommentCache();
        TagLibraryInfoData.printNodeTag(buf, "<attribute>", "_before_", commentCache);
        ++indent;
        TagLibraryInfoData.indentPrintValue(buf, "name", tagAttr.getName(), commentCache);
        TagLibraryInfoData.indentPrintValue(buf, "required", tagAttr.isRequired(), commentCache);
        TagLibraryInfoData.indentPrintValue(buf, "rtexprvalue", tagAttr.canBeRequestTime(), commentCache);
        String jspVersion = TagLibraryInfoData.getSupportedJSPVersion();
        if (jspVersion.equals("1.2")) {
            TagLibraryInfoData.indentPrintValue(buf, "type", tagAttr.getTypeName(), commentCache);
        }
        if (printExtendedDescriptor) {
            TagLibraryInfoData.prettyPrintAttributeCodegenOptions(buf, tagAttr);
        }
        --indent;
        TagLibraryInfoData.printNodeTag(buf, "</attribute>", "_end_", commentCache);
        TagLibraryInfoData.printCachedCommentItems(buf, commentCache, "_after_");
    }

    public static void prettyPrintAttributeCodegenOptions(StringBuffer buf, TagAttributeInfoData tagAttr) {
        CommentCache commentCache = tagAttr.getCommentCache();
        boolean hasComments = TagLibraryInfoData.printCachedCommentItems(buf, commentCache, "_beforetldx_");
        if (!hasComments && previousNewLinePending) {
            buf.append('\n');
            previousNewLinePending = false;
            TagLibraryInfoData.indentPrint(buf, "");
        }
        TagLibraryInfoData.println(buf, "<!-- Forte4J_TLDX:  This comment contains code generation information. Do not delete.");
        TagLibraryInfoData.indentPrint(buf, "<tldx>");
        previousNewLinePending = true;
        ++indent;
        String jspVersion = TagLibraryInfoData.getSupportedJSPVersion();
        if (jspVersion.equals("1.1")) {
            TagLibraryInfoData.indentPrintValue(buf, "type", tagAttr.getTypeName(), commentCache);
        }
        TagLibraryInfoData.indentPrintValue(buf, "javaVariable", tagAttr.getJavaVariableName(), commentCache);
        TagLibraryInfoData.indentPrintValue(buf, "defaultValue", tagAttr.getDefaultValue(), commentCache);
        TagLibraryInfoData.indentPrintValue(buf, "IsReferenceID", tagAttr.getIsReferenceID() ? "TRUE" : "FALSE", commentCache);
        TagLibraryInfoData.indentPrintValue(buf, "ReferencesTag", tagAttr.getReferencesTag() ? "TRUE" : "FALSE", commentCache);
        TagLibraryInfoData.indentPrintValue(buf, "ReferenceScope", tagAttr.getReferenceScopeString(), commentCache);
        TagLibraryInfoData.indentPrintValue(buf, "ReferencesTagType", tagAttr.getReferencesTagType(), commentCache);
        TagLibraryInfoData.indentPrintValue(buf, "ReferencesTagVariable", tagAttr.getReferencesTagVariable(), commentCache);
        TagLibraryInfoData.indentPrintValue(buf, "ReferencesTagReferentFirst", tagAttr.getReferencesTagReferentFirst() ? "TRUE" : "FALSE", commentCache);
        --indent;
        if (previousNewLinePending) {
            buf.append('\n');
            previousNewLinePending = false;
        }
        TagLibraryInfoData.indentPrintln(buf, "</tldx>");
        TagLibraryInfoData.indentPrint(buf, "-->");
        hasComments = TagLibraryInfoData.printCachedCommentItems(buf, commentCache, "_aftertldx_");
        previousNewLinePending = !hasComments;
    }

    public static void prettyPrintTagVariable(StringBuffer buf, TagVariableInfoData tagVar, boolean printExtendedDescriptor) {
        String jspVersion = TagLibraryInfoData.getSupportedJSPVersion();
        if (jspVersion.equals("1.1")) {
            TagLibraryInfoData.prettyPrintTagVariable11(buf, tagVar, printExtendedDescriptor);
        } else if (jspVersion.equals("1.2")) {
            TagLibraryInfoData.prettyPrintTagVariable12(buf, tagVar, printExtendedDescriptor);
        }
    }

    public static void prettyPrintTagVariable11(StringBuffer buf, TagVariableInfoData tagVar, boolean printExtendedDescriptor) {
        CommentCache commentCache = tagVar.getCommentCache();
        if (!printExtendedDescriptor) {
            return;
        }
        boolean hasComments = TagLibraryInfoData.printCachedCommentItems(buf, commentCache, "_before_");
        if (!hasComments) {
            buf.append('\n');
            TagLibraryInfoData.indentPrintln(buf, "");
        }
        buf.append("<!-- Forte4J_TLDX:  This comment contains code generation information. Do not delete.");
        buf.append('\n');
        TagLibraryInfoData.indentPrint(buf, "<tldx>");
        previousNewLinePending = true;
        ++indent;
        hasComments = TagLibraryInfoData.printCachedCommentItems(buf, commentCache, "_insidebefore_");
        if (!hasComments) {
            buf.append('\n');
            TagLibraryInfoData.indentPrint(buf, "");
        }
        TagLibraryInfoData.print(buf, "<variable>");
        previousNewLinePending = true;
        ++indent;
        TagLibraryInfoData.indentPrintValue(buf, "nameType", TagVariableInfoData.nameTypeString(tagVar.getNameType()), commentCache);
        TagLibraryInfoData.indentPrintValue(buf, "name", tagVar.getName(), commentCache);
        TagLibraryInfoData.indentPrintValue(buf, "nameAttribute", tagVar.getNameAttribute(), commentCache);
        TagLibraryInfoData.indentPrintValue(buf, "type", tagVar.getType(), commentCache);
        TagLibraryInfoData.indentPrintValue(buf, "scope", TagVariableInfoData.scopeString(tagVar.getScope()), commentCache);
        TagLibraryInfoData.indentPrintValue(buf, "declare", tagVar.getDeclare(), commentCache);
        --indent;
        if (previousNewLinePending) {
            buf.append('\n');
        }
        TagLibraryInfoData.indentPrintln(buf, "</variable>");
        --indent;
        TagLibraryInfoData.indentPrintln(buf, "</tldx>");
        TagLibraryInfoData.indentPrint(buf, "-->");
        hasComments = TagLibraryInfoData.printCachedCommentItems(buf, commentCache, "_after_");
        previousNewLinePending = !hasComments;
    }

    public static void prettyPrintTagVariable12(StringBuffer buf, TagVariableInfoData tagVar, boolean printExtendedDescriptor) {
        int nameType;
        boolean othervar;
        CommentCache commentCache = tagVar.getCommentCache();
        boolean hasComments = TagLibraryInfoData.printCachedCommentItems(buf, commentCache, "_before_");
        if (!hasComments) {
            buf.append('\n');
            TagLibraryInfoData.indentPrintln(buf, "");
        }
        if (!(hasComments = TagLibraryInfoData.printCachedCommentItems(buf, commentCache, "_insidebefore_"))) {
            buf.append('\n');
            TagLibraryInfoData.indentPrint(buf, "");
        }
        boolean bl = othervar = 2 == (nameType = tagVar.getNameType());
        if (othervar) {
            buf.append("<!-- Forte4J_TLDX:  This comment contains code generation information. Do not delete.");
            buf.append('\n');
            TagLibraryInfoData.indentPrint(buf, "<tldx>");
            previousNewLinePending = true;
            ++indent;
        }
        TagLibraryInfoData.print(buf, "<variable>");
        previousNewLinePending = true;
        ++indent;
        if (!othervar) {
            if (nameType == 0) {
                TagLibraryInfoData.indentPrintValue(buf, "name-given", tagVar.getName(), commentCache);
            } else if (nameType == 1) {
                TagLibraryInfoData.indentPrintValue(buf, "name-from-attribute", tagVar.getNameAttribute(), commentCache);
            }
        } else {
            TagLibraryInfoData.indentPrintValue(buf, "name-type", "other", commentCache);
        }
        TagLibraryInfoData.indentPrintValue(buf, "variable-class", tagVar.getType(), commentCache);
        TagLibraryInfoData.indentPrintValue(buf, "declare", tagVar.getDeclare(), commentCache);
        TagLibraryInfoData.indentPrintValue(buf, "scope", TagVariableInfoData.scopeString(tagVar.getScope()), commentCache);
        buf.append('\n');
        if (!othervar) {
            buf.append("<!-- Forte4J_TLDX:  This comment contains code generation information. Do not delete.");
            buf.append('\n');
            TagLibraryInfoData.indentPrint(buf, "<tldx>");
            previousNewLinePending = true;
            ++indent;
        }
        TagLibraryInfoData.indentPrintValue(buf, "name", tagVar.getName(), commentCache);
        if (!othervar) {
            --indent;
            TagLibraryInfoData.indentPrintln(buf, "</tldx>");
            TagLibraryInfoData.indentPrint(buf, "-->");
        }
        --indent;
        if (previousNewLinePending) {
            buf.append('\n');
        }
        TagLibraryInfoData.indentPrintln(buf, "</variable>");
        if (othervar) {
            --indent;
            TagLibraryInfoData.indentPrintln(buf, "</tldx>");
            TagLibraryInfoData.indentPrint(buf, "-->");
        }
        previousNewLinePending = !(hasComments = TagLibraryInfoData.printCachedCommentItems(buf, commentCache, "_after_"));
    }

    public static String getDefault(String variable) {
        return (String)defaultsTable.get(variable);
    }

    public static boolean getBooleanDefault(String variable) {
        if ("attribute.required".equals(variable)) {
            return false;
        }
        if ("attribute.rtexprvalue".equals(variable)) {
            return true;
        }
        if ("attribute.isReferenceID".equals(variable)) {
            return false;
        }
        if ("attribute.referencesTag".equals(variable)) {
            return false;
        }
        if ("attribute.referencesTagReferentFirst".equals(variable)) {
            return true;
        }
        if ("tag.findParent".equals(variable)) {
            return false;
        }
        return "variable.declare".equals(variable);
    }

    public static int getIntDefault(String variable) {
        if ("variable.nameType".equals(variable)) {
            return 0;
        }
        if ("variable.scope".equals(variable)) {
            return 0;
        }
        if ("attribute.referenceScope".equals(variable)) {
            return 2;
        }
        return -1;
    }

    public static String ensureValue(String variable, String value) {
        if (value == null || value.equals("")) {
            return TagLibraryInfoData.getDefault(variable);
        }
        return value;
    }

    private void setupPropertyChangeSupport() {
        this.propSupport = new PropertyChangeSupport(this);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propSupport.removePropertyChangeListener(listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void clearTldDirtyBit() {
        Boolean oldValue = this.tldDirtyBit ? Boolean.TRUE : Boolean.FALSE;
        this.tldDirtyBit = false;
        this.tldDirtyBitEvents = new Vector();
        this.firePropertyChange(DIRTY_BIT, oldValue, this.tldDirtyBit ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setTldDirtyBit(String explanation) {
        Boolean oldValue = this.tldDirtyBit ? Boolean.TRUE : Boolean.FALSE;
        this.tldDirtyBit = true;
        if (this.tldDirtyBitEvents == null) {
            this.tldDirtyBitEvents = new Vector();
        }
        this.tldDirtyBitEvents.addElement(explanation);
        this.firePropertyChange(DIRTY_BIT, oldValue, this.tldDirtyBit ? Boolean.TRUE : Boolean.FALSE);
        if (this.tldDirtyBit) {
            this.firePropertyChange(TREE_DIRTY, null, null);
        }
    }

    public boolean getTldDirtyBit() {
        return this.tldDirtyBit;
    }

    public boolean isDirty() {
        return this.getTldDirtyBit();
    }

    public Vector getTldDirtyBitEvents() {
        return this.tldDirtyBitEvents;
    }

    public void clearTagsDirtyBits() {
        Enumeration en = this.tagsVector.elements();
        while (en.hasMoreElements()) {
            TagInfoData tag = (TagInfoData)en.nextElement();
            tag.clearTagHandlerDirtyBit(null);
            tag.clearTEIDirtyBit(null);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        defaultsTable.put("tag.bodyContent", "JSP");
        defaultsTable.put("tag.bodycontent", "JSP");
        defaultsTable.put("attribute.type", "String");
        defaultsTable.put("attribute.defaultValue", "");
        defaultsTable.put("attribute.javaVariable", "");
        defaultsTable.put("variable.type", "java.lang.String");
    }
}

