/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglibed.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.netbeans.modules.web.taglibed.model.CommentCache;
import org.netbeans.modules.web.taglibed.model.TagInfoData;
import org.netbeans.modules.web.taglibed.model.TagLibraryInfoData;

public class TagVariableInfoData {
    public static final int NAME_TYPE_FIXED = 0;
    public static final int NAME_TYPE_FROM_ATTRIBUTE = 1;
    public static final int NAME_TYPE_OTHER = 2;
    public static final int NESTED = 0;
    public static final int AT_BEGIN = 1;
    public static final int AT_END = 2;
    public static final String VARIABLE_NAME = "VariableName";
    public static final String NAME_TYPE = "NameType";
    public static final String NAME_ATTRIBUTE = "NameAttribute";
    public static final String VARIABLE_TYPE = "VariableType";
    public static final String SCOPE = "Scope";
    public static final String DECLARE = "Declare";
    private Object lock;
    private int nameType;
    private String nameAttribute;
    private String name;
    private String type;
    private int scope;
    private boolean declare;
    private PropertyChangeSupport propSupport;
    private TagInfoData tag;
    protected CommentCache commentCache;
    private boolean dirtybitenabled = true;
    private static final boolean debugdirty = false;

    public static int nameTypeValueFromString(String val) {
        int defaultVal = TagLibraryInfoData.getIntDefault("variable.nameType");
        if (val == null) {
            return defaultVal;
        }
        if (val.equalsIgnoreCase("fixed")) {
            return 0;
        }
        if (val.equalsIgnoreCase("static")) {
            return 0;
        }
        if (val.equalsIgnoreCase("fromAttribute")) {
            return 1;
        }
        if (val.equalsIgnoreCase("other")) {
            return 2;
        }
        return defaultVal;
    }

    public static String nameTypeString(int nameType) {
        switch (nameType) {
            case 0: {
                return "fixed";
            }
            case 1: {
                return "fromAttribute";
            }
            case 2: {
                return "other";
            }
        }
        return TagVariableInfoData.nameTypeString(TagLibraryInfoData.getIntDefault("variable.nameType"));
    }

    public static int scopeValueFromString(String val) {
        int defaultVal = TagLibraryInfoData.getIntDefault("variable.scope");
        if (val == null) {
            return defaultVal;
        }
        if (val.equalsIgnoreCase("NESTED")) {
            return 0;
        }
        if (val.equalsIgnoreCase("AT_END")) {
            return 2;
        }
        if (val.equalsIgnoreCase("AT_BEGIN")) {
            return 1;
        }
        return defaultVal;
    }

    public static String scopeString(int scope) {
        switch (scope) {
            case 0: {
                return "NESTED";
            }
            case 1: {
                return "AT_BEGIN";
            }
            case 2: {
                return "AT_END";
            }
        }
        return TagVariableInfoData.scopeString(TagLibraryInfoData.getIntDefault("variable.scope"));
    }

    public TagVariableInfoData(TagInfoData tag) {
        this.disableDirtyBit();
        this.lock = new Object();
        this.tag = tag;
        this.nameType = TagLibraryInfoData.getIntDefault("variable.nameType");
        this.name = "";
        this.nameAttribute = null;
        this.type = TagLibraryInfoData.getDefault("variable.type");
        this.scope = TagLibraryInfoData.getIntDefault("variable.scope");
        this.declare = TagLibraryInfoData.getBooleanDefault("variable.declare");
        this.commentCache = new CommentCache();
        this.setupPropertyChangeSupport();
        this.enableDirtyBit();
    }

    private TagVariableInfoData() {
    }

    private void setupPropertyChangeSupport() {
        this.propSupport = new PropertyChangeSupport(this);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propSupport.removePropertyChangeListener(listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public TagInfoData getTag() {
        return this.tag;
    }

    public void setTag(TagInfoData value) {
        this.tag = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        String oldValue;
        if (!(value = value.trim()).equals(oldValue = this.name)) {
            Object object = this.lock;
            synchronized (object) {
                this.name = value;
                String explanation = "tag " + this.tag.getTagName() + ": variable " + oldValue + " changed its name to " + value;
                this.tag.setTagHandlerDirtyBit(explanation);
                this.tag.setTEIDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
                this.firePropertyChange(VARIABLE_NAME, oldValue, value);
            }
        }
    }

    public int getNameType() {
        return this.nameType;
    }

    public void setNameType(int value) {
        int oldValue = this.nameType;
        if (value != oldValue) {
            Object object = this.lock;
            synchronized (object) {
                this.nameType = value;
                String explanation = "tag " + this.tag.getTagName() + ": variable " + this.getName() + " changed its name type to " + TagVariableInfoData.nameTypeString(value);
                this.tag.setTagHandlerDirtyBit(explanation);
                this.tag.setTEIDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
                this.firePropertyChange(NAME_TYPE, new Integer(oldValue), new Integer(value));
            }
        }
    }

    public void setNameType(String value) {
        this.setNameType(TagVariableInfoData.nameTypeValueFromString(value));
    }

    public String getNameAttribute() {
        return this.nameAttribute;
    }

    public void setNameAttribute(String value) {
        String oldValue;
        if (!(value = value.trim()).equals(oldValue = this.nameAttribute)) {
            Object object = this.lock;
            synchronized (object) {
                this.nameAttribute = value;
                String explanation = "tag " + this.tag.getTagName() + ": variable " + this.getName() + " changed its name attribute to " + value;
                this.tag.setTagHandlerDirtyBit(explanation);
                this.tag.setTEIDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
                this.firePropertyChange(NAME_ATTRIBUTE, oldValue, value);
            }
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        String oldValue = this.type;
        if (!value.equals(oldValue)) {
            Object object = this.lock;
            synchronized (object) {
                this.type = value;
                String explanation = "tag " + this.tag.getTagName() + ": variable " + this.getName() + " changed its type to " + value;
                this.tag.setTagHandlerDirtyBit(explanation);
                this.tag.setTEIDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
                this.firePropertyChange(VARIABLE_TYPE, oldValue, value);
            }
        }
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int value) {
        int oldValue = this.scope;
        if (value != oldValue) {
            Object object = this.lock;
            synchronized (object) {
                this.scope = value;
                String explanation = "tag " + this.tag.getTagName() + ": variable " + this.getName() + " changed its scope to " + value;
                this.tag.setTagHandlerDirtyBit(explanation);
                this.tag.setTEIDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
                this.firePropertyChange(SCOPE, new Integer(oldValue), new Integer(value));
            }
        }
    }

    public void setScope(String value) {
        this.setScope(TagVariableInfoData.scopeValueFromString(value));
    }

    public boolean getDeclare() {
        return this.declare;
    }

    public void setDeclare(boolean value) {
        boolean oldValue = this.declare;
        if (value != oldValue) {
            Object object = this.lock;
            synchronized (object) {
                this.declare = value;
                String explanation = "tag " + this.tag.getTagName() + ": attribute " + this.getName() + " changed its declare flag to " + value;
                this.tag.setTagHandlerDirtyBit(explanation);
                this.tag.setTEIDirtyBit(explanation);
                this.setTldDirtyBit(explanation);
                this.firePropertyChange(DECLARE, oldValue ? Boolean.TRUE : Boolean.FALSE, value ? Boolean.TRUE : Boolean.FALSE);
            }
        }
    }

    public void setDeclare(String value) {
        this.setDeclare("true".equalsIgnoreCase(value));
    }

    public void setTldDirtyBit(String explanation) {
        if (this.dirtybitenabled) {
            this.tag.getTaglib().setTldDirtyBit(explanation);
        }
    }

    public void enableDirtyBit() {
        this.dirtybitenabled = true;
    }

    public void disableDirtyBit() {
        this.dirtybitenabled = false;
    }

    public CommentCache getCommentCache() {
        return this.commentCache;
    }

    void setCommentCache(CommentCache value) {
        this.commentCache = value;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("nameType = " + this.nameType + " ");
        b.append("name = " + this.name + " ");
        b.append("nameAttribute = " + this.nameAttribute + " ");
        b.append("type = " + this.type + " ");
        b.append("scope = " + this.scope + " ");
        b.append("declare = " + this.declare + " ");
        return b.toString();
    }
}

