/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglibed.model;

import java.io.CharArrayReader;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.Vector;
import org.netbeans.modules.web.taglibed.model.CommentCache;
import org.netbeans.modules.web.taglibed.model.CommentItem;
import org.netbeans.modules.web.taglibed.model.ListenerData;
import org.netbeans.modules.web.taglibed.model.ParamData;
import org.netbeans.modules.web.taglibed.model.TagAttributeInfoData;
import org.netbeans.modules.web.taglibed.model.TagInfoData;
import org.netbeans.modules.web.taglibed.model.TagLibraryInfoData;
import org.netbeans.modules.web.taglibed.model.TagVariableInfoData;
import org.netbeans.modules.web.taglibed.model.ValidatorData;
import org.netbeans.modules.web.taglibed.model.XMLUtil;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class TaglibDocumentHandler
implements ContentHandler,
LexicalHandler,
DTDHandler,
EntityResolver {
    private boolean inDtd;
    private boolean inParsedEntity;
    private boolean inCDATASection;
    private boolean inOtherNode;
    private boolean isCorrect;
    private Object currentParent;
    private int currentParentType;
    private int currentNodeType;
    private String otherNodeName;
    private String otherNodeChars;
    private Locator locator;
    public static final int TAGLIB = 0;
    public static final int TAG = 1;
    public static final int ATTRIBUTE = 2;
    public static final int VARIABLE = 3;
    public static final int VALIDATOR = 4;
    public static final int INIT_PARAM = 5;
    public static final int VALIDATOR_INIT_PARAM = 6;
    public static final int LISTENER = 7;
    public static final int OTHER = 9;
    public static final int NONE = -1;
    private TagLibraryInfoData taglib;
    private static ClassLoader loader = null;
    public static final String TAGLIB_DTD_RESOURCE_1_1 = "org/netbeans/modules/web/taglibed/resources/web-jsptaglib_1_1.dtd";
    public static final String TAGLIB_DTD_RESOURCE_1_2 = "org/netbeans/modules/web/taglibed/resources/web-jsptaglibrary_1_2.dtd";
    public static final String TAGLIB_DTD_STANDARD_SYSTEMID_1_2 = "http://java.sun.com/dtd/web-jsptaglibrary_1_2.dtd";
    private Stack parentStack;
    private Stack parentTypeStack;
    private String dtdPublicId = null;
    private String dtdSystemId = null;
    private String fixedSystemId = null;
    private Vector outstandingCommentItems;
    private boolean commentItemsAreOutstanding = false;
    private static final boolean debugparse = false;
    private static final boolean debugcomments = false;
    private static final boolean debugparsedetails = false;
    private static final boolean debugdtd = false;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$TLDDataObject;

    public TaglibDocumentHandler(TagLibraryInfoData taglib) {
        this.taglib = taglib;
    }

    public TagLibraryInfoData getTaglib() {
        return this.taglib;
    }

    public void setTaglib(TagLibraryInfoData value) {
        this.taglib = value;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        this.isCorrect = false;
        this.inCDATASection = false;
        this.inParsedEntity = false;
        this.inOtherNode = false;
        this.inDtd = false;
        this.dtdPublicId = null;
        this.dtdSystemId = null;
        this.currentParent = this.taglib;
        this.currentParentType = 0;
        this.parentStack = new Stack();
        this.parentTypeStack = new Stack();
        this.parentStack.push(this.currentParent);
        this.parentTypeStack.push(new Integer(0));
        if (this.areCommentItemsOutstanding()) {
            this.associateOutstandingCommentItems(this.taglib.getCommentCache(), "_startdocument_");
        }
    }

    public void endDocument() throws SAXException {
        this.isCorrect = true;
        if (this.areCommentItemsOutstanding()) {
            this.associateOutstandingCommentItems(this.taglib.getCommentCache(), "_after_");
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String nameSpaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        String name = qualifiedName;
        this.currentNodeType = this.getNodeType(name);
        switch (this.currentNodeType) {
            case 0: {
                if (!this.areCommentItemsOutstanding()) break;
                this.associateOutstandingCommentItems(this.taglib.getCommentCache(), "_before_");
                break;
            }
            case 1: {
                TagInfoData tag = new TagInfoData(this.taglib);
                this.taglib.addTag(tag);
                if (this.areCommentItemsOutstanding()) {
                    this.associateOutstandingCommentItems(tag.getCommentCache(), "_before_");
                }
                this.parentStack.push(this.currentParent);
                this.parentTypeStack.push(new Integer(this.currentParentType));
                this.currentParent = tag;
                this.currentParentType = 1;
                break;
            }
            case 4: {
                ValidatorData validator = new ValidatorData(this.taglib);
                this.taglib.setValidator(validator);
                if (this.areCommentItemsOutstanding()) {
                    this.associateOutstandingCommentItems(validator.getCommentCache(), "_before_");
                }
                this.parentStack.push(this.currentParent);
                this.parentTypeStack.push(new Integer(this.currentParentType));
                this.currentParent = validator;
                this.currentParentType = 4;
                break;
            }
            case 5: {
                if (this.currentParentType != 4) break;
                ValidatorData validatorParent = (ValidatorData)this.currentParent;
                ParamData param = new ParamData(validatorParent);
                validatorParent.addInitParam(param);
                if (this.areCommentItemsOutstanding()) {
                    this.associateOutstandingCommentItems(param.getCommentCache(), "_before_");
                }
                this.parentStack.push(this.currentParent);
                this.parentTypeStack.push(new Integer(this.currentParentType));
                this.currentParent = param;
                this.currentParentType = 6;
                break;
            }
            case 7: {
                ListenerData listener = new ListenerData(this.taglib);
                this.taglib.addTaglibListener(listener);
                if (this.areCommentItemsOutstanding()) {
                    this.associateOutstandingCommentItems(listener.getCommentCache(), "_before_");
                }
                this.parentStack.push(this.currentParent);
                this.parentTypeStack.push(new Integer(this.currentParentType));
                this.currentParent = listener;
                this.currentParentType = 7;
                break;
            }
            case 2: {
                if (this.currentParentType != 1) break;
                TagInfoData tagparent = (TagInfoData)this.currentParent;
                TagAttributeInfoData att = new TagAttributeInfoData(tagparent);
                tagparent.addAttribute(att);
                if (this.areCommentItemsOutstanding()) {
                    this.associateOutstandingCommentItems(att.getCommentCache(), "_before_");
                }
                this.parentStack.push(this.currentParent);
                this.parentTypeStack.push(new Integer(this.currentParentType));
                this.currentParent = att;
                this.currentParentType = 2;
                break;
            }
            case 3: {
                if (this.currentParentType != 1) break;
                TagInfoData tagparent = (TagInfoData)this.currentParent;
                TagVariableInfoData var = new TagVariableInfoData(tagparent);
                tagparent.addVariable(var);
                if (this.areCommentItemsOutstanding()) {
                    this.associateOutstandingCommentItems(var.getCommentCache(), "_before_");
                }
                this.parentStack.push(this.currentParent);
                this.parentTypeStack.push(new Integer(this.currentParentType));
                this.currentParent = var;
                this.currentParentType = 3;
                break;
            }
            case 9: {
                this.inOtherNode = true;
                this.otherNodeName = name;
                this.otherNodeChars = "";
                if (!this.areCommentItemsOutstanding()) break;
                if (this.currentParentType == 0) {
                    this.associateOutstandingCommentItems(this.taglib.getCommentCache(), name);
                    break;
                }
                if (this.currentParentType == 1) {
                    TagInfoData tagParent = (TagInfoData)this.currentParent;
                    this.associateOutstandingCommentItems(tagParent.getCommentCache(), name);
                    break;
                }
                if (this.currentParentType != 2) break;
                TagAttributeInfoData tagattParent = (TagAttributeInfoData)this.currentParent;
                this.associateOutstandingCommentItems(tagattParent.getCommentCache(), name);
            }
        }
    }

    public void endElement(String nameSpaceURI, String localName, String qualifiedName) throws SAXException {
        String name = qualifiedName;
        int nodeType = this.getNodeType(name);
        if (nodeType == 9) {
            this.setOtherValue(this.currentParent, this.currentParentType, name, this.otherNodeChars);
            this.associateOutstandingCommentItems(this.getCommentCache(this.currentParent, this.currentParentType), name);
            this.inOtherNode = false;
        } else {
            this.associateOutstandingCommentItems(this.getCommentCache(this.currentParent, this.currentParentType), "_end_");
            this.currentParent = this.parentStack.pop();
            this.currentParentType = (Integer)this.parentTypeStack.pop();
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String chars = new String(ch, start, length);
        this.addChars(this.currentParent, this.currentParentType, chars);
        if (this.inParsedEntity) {
            return;
        }
        if (this.inCDATASection) {
            // empty if block
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        String chars = new String(ch, start, length);
        this.addChars(this.currentParent, this.currentParentType, chars);
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void comment(char[] chars, int start, int length) {
        String cmt = new String(chars, start, length);
        this.addComment(this.currentParent, this.currentParentType, cmt);
    }

    public void endCDATA() {
        this.inCDATASection = false;
    }

    public void endEntity(String name) {
        this.inParsedEntity = false;
    }

    public void startCDATA() {
        this.inCDATASection = true;
    }

    public void startEntity(String n) {
        this.inParsedEntity = true;
    }

    public void startDTD(String name, String publicId, String systemId) {
        this.inDtd = true;
    }

    public void endDTD() {
        this.inDtd = false;
    }

    public void notationDecl(String name, String publicId, String systemId) {
        if (name != null) {
            this.taglib.setDtdName(name);
        }
        if (publicId != null) {
            this.taglib.setDtdPublicId(publicId);
        }
        if (this.fixedSystemId != null) {
            this.taglib.setDtdSystemId(this.fixedSystemId);
            this.fixedSystemId = null;
        } else if (systemId != null) {
            this.taglib.setDtdSystemId(systemId);
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
    }

    public void attributeDecl(String n, String a, String t, String[] o, String v, boolean f, boolean r) {
    }

    public void elementDecl(String e, String m) {
    }

    public void externalDtdDecl(String p, String s) {
    }

    public void externalEntityDecl(String n, String p, String s) {
    }

    public void internalDtdDecl(String s) {
    }

    public void internalEntityDecl(String n, String v) {
    }

    public String getDtdPublicId() {
        return this.dtdPublicId;
    }

    public String getDtdSystemId() {
        return this.dtdSystemId;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        this.dtdPublicId = publicId;
        this.taglib.setDtdPublicId(publicId);
        this.dtdSystemId = systemId;
        this.taglib.setDtdSystemId(systemId);
        InputSource in = null;
        if (systemId.endsWith(".dtd")) {
            String taglibDtdResource;
            if (systemId.endsWith("web-jsptaglib_1_1.dtd") || systemId.endsWith("web-jsptaglibrary_1_1.dtd")) {
                taglibDtdResource = TAGLIB_DTD_RESOURCE_1_1;
            } else if (systemId.endsWith("web-jsptaglibrary_1_2.dtd") || systemId.endsWith("web-jsptaglib_1_2.dtd")) {
                taglibDtdResource = TAGLIB_DTD_RESOURCE_1_2;
            } else if (systemId.endsWith("1_2.dtd") || systemId.endsWith("1.2.dtd")) {
                taglibDtdResource = TAGLIB_DTD_RESOURCE_1_2;
                this.fixedSystemId = TAGLIB_DTD_STANDARD_SYSTEMID_1_2;
            } else {
                taglibDtdResource = systemId.endsWith("1_1.dtd") || systemId.endsWith("1.1.dtd") ? TAGLIB_DTD_RESOURCE_1_1 : systemId;
            }
            try {
                in = this.getResourceAsInputSource(taglibDtdResource);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (in == null) {
            try {
                in = this.getResourceAsInputSource(TAGLIB_DTD_RESOURCE_1_2);
            }
            catch (Exception ex1) {
                // empty catch block
            }
        }
        return in;
    }

    private InputSource getResourceAsInputSource(String taglibDtdResource) {
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        URL dtdURL = loader.getResource(taglibDtdResource);
        InputStream dtdStream = loader.getResourceAsStream(taglibDtdResource);
        if (dtdStream != null) {
            return new InputSource(dtdStream);
        }
        return null;
    }

    public Vector getOutstandingCommentItems() {
        return this.outstandingCommentItems;
    }

    public boolean areCommentItemsOutstanding() {
        return this.commentItemsAreOutstanding;
    }

    public void clearOutstandingCommentItems() {
        if (this.outstandingCommentItems != null) {
            this.outstandingCommentItems = new Vector();
        }
        this.commentItemsAreOutstanding = false;
    }

    public void addOutstandingCommentItem(int type, String contents) {
        CommentItem citem = new CommentItem(type, contents);
        this.addOutstandingCommentItem(citem);
    }

    public void addOutstandingCommentItem(CommentItem citem) {
        if (this.outstandingCommentItems == null) {
            this.outstandingCommentItems = new Vector();
        }
        this.outstandingCommentItems.addElement(citem);
        this.commentItemsAreOutstanding = true;
    }

    public void associateOutstandingCommentItems(CommentCache cache, String key) {
        if (this.areCommentItemsOutstanding()) {
            this.associateCommentItems(cache, key, this.outstandingCommentItems);
            this.clearOutstandingCommentItems();
        }
    }

    public void associateCommentItems(CommentCache cache, String key, Vector commentItems) {
        if (commentItems != null) {
            Enumeration en = commentItems.elements();
            while (en.hasMoreElements()) {
                CommentItem citem = (CommentItem)en.nextElement();
                cache.addCommentItem(key, citem);
            }
        }
    }

    public Vector saltOutstandingCommentItems() {
        Vector pemmican = this.outstandingCommentItems;
        this.clearOutstandingCommentItems();
        return pemmican;
    }

    public CommentCache getCommentCache(Object parent, int parentType) {
        switch (parentType) {
            case 0: {
                return ((TagLibraryInfoData)parent).getCommentCache();
            }
            case 1: {
                return ((TagInfoData)parent).getCommentCache();
            }
            case 2: {
                return ((TagAttributeInfoData)parent).getCommentCache();
            }
            case 3: {
                return ((TagVariableInfoData)parent).getCommentCache();
            }
            case 7: {
                return ((ListenerData)parent).getCommentCache();
            }
            case 4: {
                return ((ValidatorData)parent).getCommentCache();
            }
            case 6: {
                return ((ParamData)parent).getCommentCache();
            }
        }
        return null;
    }

    public int getNodeType(String name) {
        if (name.equals("taglib")) {
            return 0;
        }
        if (name.equals("tag")) {
            return 1;
        }
        if (name.equals("attribute")) {
            return 2;
        }
        if (name.equals("variable")) {
            return 3;
        }
        if (name.equals("validator")) {
            return 4;
        }
        if (name.equals("init-param")) {
            return 5;
        }
        if (name.equals("listener")) {
            return 7;
        }
        return 9;
    }

    public void setOtherValue(Object parent, int parentType, String name, String value) {
        switch (parentType) {
            case 0: {
                this.setOtherValueOnTaglib((TagLibraryInfoData)parent, name, value);
                break;
            }
            case 1: {
                this.setOtherValueOnTag((TagInfoData)parent, name, value);
                break;
            }
            case 2: {
                this.setOtherValueOnTagAttribute((TagAttributeInfoData)parent, name, value);
                break;
            }
            case 3: {
                this.setOtherValueOnTagVariable((TagVariableInfoData)parent, name, value);
                break;
            }
            case 4: {
                this.setOtherValueOnValidator((ValidatorData)parent, name, value);
                break;
            }
            case 6: {
                this.setOtherValueOnValidatorInitParam((ParamData)parent, name, value);
                break;
            }
            case 7: {
                this.setOtherValueOnListener((ListenerData)parent, name, value);
            }
        }
    }

    public void setOtherValueOnTaglib(TagLibraryInfoData taglib, String name, String value) {
        if (name == null || name.equals("")) {
            return;
        }
        if (name.equalsIgnoreCase("uri")) {
            taglib.setURI(value);
        } else if (name.equalsIgnoreCase("urn")) {
            taglib.setURI(value);
        } else if (name.equalsIgnoreCase("tlib-version") || name.equalsIgnoreCase("tlibversion")) {
            taglib.setTLibVersion(value);
        } else if (name.equalsIgnoreCase("jsp-version") || name.equalsIgnoreCase("jspversion")) {
            taglib.setJspVersion(value);
        } else if (name.equalsIgnoreCase("short-name") || name.equalsIgnoreCase("shortname")) {
            taglib.setShortName(value);
        } else if (name.equalsIgnoreCase("display-name")) {
            taglib.setDisplayName(value);
        } else if (name.equalsIgnoreCase("small-icon")) {
            taglib.setSmallIcon(value);
        } else if (name.equalsIgnoreCase("large-icon")) {
            taglib.setLargeIcon(value);
        } else if (name.equalsIgnoreCase("description") || name.equalsIgnoreCase("info")) {
            taglib.setDescription(value);
        } else if (name.equalsIgnoreCase("tagHandlerGenerationRoot")) {
            taglib.setTagHandlerGenerationRoot(value);
        } else if (name.equalsIgnoreCase("JarFile")) {
            taglib.setJarFile(value);
        }
    }

    public void setOtherValueOnTag(TagInfoData tag, String name, String value) {
        if (name == null || name.equals("")) {
            return;
        }
        if (name.equals("name")) {
            tag.setTagName(value);
        } else if (name.equals("display-name")) {
            tag.setDisplayName(value);
        } else if (name.equals("tag-class") || name.equals("tagclass")) {
            tag.setTagClassName(value);
        } else if (name.equals("tei-class") || name.equals("teiclass")) {
            tag.setTeiClassName(value);
        } else if (name.equals("body-content") || name.equals("bodycontent")) {
            tag.setBodyContent(value);
        } else if (name.equals("small-icon")) {
            tag.setSmallIcon(value);
        } else if (name.equals("large-icon")) {
            tag.setLargeIcon(value);
        } else if (name.equals("info")) {
            tag.setDescription(value);
        } else if (name.equals("description")) {
            tag.setDescription(value);
        } else if (name.equals("example")) {
            tag.setExample(value);
        } else if (name.equalsIgnoreCase("teiclass")) {
            tag.setTeiClassName(value);
        } else if (name.equalsIgnoreCase("packagename")) {
            tag.setPackageName(value);
        } else if (name.equalsIgnoreCase("implementsInterface")) {
            tag.setImplementsInterface(value);
        } else if (name.equalsIgnoreCase("extendsSupportClass")) {
            tag.setExtendsSupportClass(value);
        } else if (name.equalsIgnoreCase("supportClass")) {
            tag.setSupportClass(value);
        } else if (name.equalsIgnoreCase("implementsTryCatchFinally")) {
            tag.setImplementsTryCatchFinally(value);
        } else if (name.equalsIgnoreCase("findparent")) {
            tag.setFindParent(value);
        } else if (name.equalsIgnoreCase("parenttype")) {
            tag.setParentType(value);
        } else if (name.equalsIgnoreCase("parentvariable")) {
            tag.setParentVariable(value);
        }
    }

    public void setOtherValueOnTagAttribute(TagAttributeInfoData tagatt, String name, String value) {
        if (name == null || name.equals("")) {
            return;
        }
        if (name.equals("name")) {
            tagatt.setName(value);
        }
        if (name.equals("required")) {
            tagatt.setRequired(value);
        }
        if (name.equals("rtexprvalue")) {
            tagatt.setRequestTime(value);
        }
        if (name.equals("reqTime")) {
            tagatt.setRequestTime(value);
        }
        if (name.equals("type")) {
            tagatt.setTypeName(value);
        } else if (name.equalsIgnoreCase("javaVariable")) {
            tagatt.setJavaVariableName(value);
        } else if (name.equalsIgnoreCase("defaultValue")) {
            tagatt.setDefaultValue(value);
        } else if (name.equalsIgnoreCase("isreferenceid")) {
            tagatt.setIsReferenceID(value);
        } else if (name.equalsIgnoreCase("referencestag")) {
            tagatt.setReferencesTag(value);
        } else if (name.equalsIgnoreCase("referenceScope")) {
            tagatt.setReferenceScopeString(value);
        } else if (name.equalsIgnoreCase("referencestagtype")) {
            tagatt.setReferencesTagType(value);
        } else if (name.equalsIgnoreCase("referencestagvariable")) {
            tagatt.setReferencesTagVariable(value);
        } else if (name.equalsIgnoreCase("referencestagreferentfirst")) {
            tagatt.setReferencesTagReferentFirst(value);
        }
    }

    public void setOtherValueOnTagVariable(TagVariableInfoData tagvar, String name, String value) {
        if (name == null || name.equals("")) {
            return;
        }
        if (name.equals("name")) {
            tagvar.setName(value);
        } else if (name.equalsIgnoreCase("nametype")) {
            tagvar.setNameType(value);
        } else if (name.equalsIgnoreCase("name-type")) {
            tagvar.setNameType(value);
        } else if (name.equalsIgnoreCase("nameAttribute")) {
            tagvar.setNameAttribute(value);
        } else if (name.equalsIgnoreCase("name-given")) {
            tagvar.setName(value);
            tagvar.setNameType(0);
        } else if (name.equalsIgnoreCase("name-from-attribute")) {
            tagvar.setNameAttribute(value);
            tagvar.setNameType(1);
        } else if (name.equalsIgnoreCase("variable-class")) {
            tagvar.setType(value);
        } else if (name.equalsIgnoreCase("type")) {
            tagvar.setType(value);
        } else if (name.equalsIgnoreCase("scope")) {
            tagvar.setScope(value);
        } else if (name.equalsIgnoreCase("declare")) {
            tagvar.setDeclare(value);
        }
    }

    public void setOtherValueOnValidator(ValidatorData validator, String name, String value) {
        if (name == null || name.equals("")) {
            return;
        }
        if (name.equalsIgnoreCase("validator-class")) {
            validator.setValidatorClass(value);
        }
    }

    public void setOtherValueOnValidatorInitParam(ParamData param, String name, String value) {
        if (name == null || name.equals("")) {
            return;
        }
        if (name.equalsIgnoreCase("param-name")) {
            param.setParamName(value);
        } else if (name.equalsIgnoreCase("param-value")) {
            param.setParamValue(value);
        } else if (name.equalsIgnoreCase("description")) {
            param.setDescription(value);
        }
    }

    public void setOtherValueOnListener(ListenerData listener, String name, String value) {
        if (name == null || name.equals("")) {
            return;
        }
        if (name.equalsIgnoreCase("listener-class")) {
            listener.setListenerClass(value);
        }
    }

    public void addChars(Object parent, int parentType, String chars) {
        if (this.inDtd) {
            return;
        }
        if (this.currentNodeType == 9) {
            if (this.inOtherNode) {
                this.otherNodeChars = this.otherNodeChars + chars;
            } else {
                this.addOutstandingCommentItem(new CommentItem(1, chars));
            }
        } else {
            this.addOutstandingCommentItem(new CommentItem(1, chars));
        }
    }

    public void addComment(Object parent, int parentType, String chars) {
        if (this.inDtd) {
            return;
        }
        int tldxPrefixIndex = chars.indexOf("Forte4J_TLDX:");
        if (tldxPrefixIndex >= 0) {
            int nl = chars.indexOf(10, tldxPrefixIndex + "Forte4J_TLDX:".length());
            int commentSize = chars.length();
            int parseSize = commentSize - nl;
            char[] charArray = new char[parseSize];
            chars.getChars(nl, commentSize, charArray, 0);
            CharArrayReader chReader = new CharArrayReader(charArray);
            Document doc = null;
            try {
                doc = XMLUtil.parseXMLDoc(new InputSource(chReader));
            }
            catch (Exception ex) {
                ResourceBundle resBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDDataObject == null ? (class$org$netbeans$modules$web$taglibed$TLDDataObject = TaglibDocumentHandler.class$("org.netbeans.modules.web.taglibed.TLDDataObject")) : class$org$netbeans$modules$web$taglibed$TLDDataObject));
                MessageFormat msg = new MessageFormat(resBundle.getString("TLD_TaglibDocumentHandler.jasper_exception"));
                Object[] obj = new Object[]{ex.getLocalizedMessage(), doc};
                System.err.println(msg.format(obj));
                ex.printStackTrace();
            }
            if (doc != null) {
                this.extractTLDXData(parent, parentType, doc);
            }
        } else {
            this.addOutstandingCommentItem(new CommentItem(0, chars));
            if (this.currentNodeType == 9 || this.currentNodeType == 0) {
                // empty if block
            }
        }
    }

    public void extractTLDXData(Object parent, int parentType, Document doc) {
        NodeList tagliblist = doc.getElementsByTagName("tldx");
        Element tldx = (Element)tagliblist.item(0);
        this.extractTLDXData(parent, parentType, tldx);
    }

    public void extractTLDXData(Object parent, int parentType, Element elem) {
        Vector preservedCommentItems = this.saltOutstandingCommentItems();
        NodeList childlist = elem.getChildNodes();
        boolean gotVariables = false;
        int i = 0;
        while (i < childlist.getLength()) {
            Node item = childlist.item(i);
            if (item instanceof Text) {
                Text t = (Text)item;
                this.addChars(this.currentParent, this.currentParentType, t.getData());
            } else if (item instanceof Element) {
                Element e = (Element)item;
                String tname = e.getTagName();
                if (tname.equals("variable")) {
                    this.extractVariable(parent, parentType, e, preservedCommentItems);
                    gotVariables = true;
                } else {
                    Text t = (Text)e.getFirstChild();
                    if (t != null) {
                        String value = t.getData();
                        this.setOtherValue(parent, parentType, tname, value);
                        this.associateOutstandingCommentItems(this.getCommentCache(this.currentParent, this.currentParentType), tname);
                    }
                }
            }
            ++i;
        }
        if (!gotVariables) {
            this.associateCommentItems(this.getCommentCache(parent, parentType), "_beforetldx_", preservedCommentItems);
        }
        this.clearOutstandingCommentItems();
    }

    public void extractVariable(Object parent, int parentType, Element elem, Vector preservedCommentItems) {
        if (parentType != 1) {
            ResourceBundle resBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDDataObject == null ? (class$org$netbeans$modules$web$taglibed$TLDDataObject = TaglibDocumentHandler.class$("org.netbeans.modules.web.taglibed.TLDDataObject")) : class$org$netbeans$modules$web$taglibed$TLDDataObject));
            System.out.println(resBundle.getString("TLD_TaglibDocumentHandler.TaglibDocumentHandler_found_variable_not_a_child_of_a_tag"));
        } else {
            TagInfoData tagparent = (TagInfoData)parent;
            TagVariableInfoData var = new TagVariableInfoData(tagparent);
            this.associateCommentItems(var.getCommentCache(), "_before_", preservedCommentItems);
            this.associateOutstandingCommentItems(var.getCommentCache(), "_insidebefore_");
            tagparent.addVariable(var);
            this.parentStack.push(parent);
            this.parentTypeStack.push(new Integer(parentType));
            this.currentParent = var;
            this.currentParentType = 3;
            this.extractTLDXData(this.currentParent, this.currentParentType, elem);
            this.currentParent = this.parentStack.pop();
            this.currentParentType = (Integer)this.parentTypeStack.pop();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

