/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglibed.view;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import org.netbeans.modules.web.taglibed.TLDDataObject;
import org.netbeans.modules.web.taglibed.model.TagAttributeInfoData;
import org.netbeans.modules.web.taglibed.model.TagInfoData;
import org.netbeans.modules.web.taglibed.model.TagLibraryInfoData;
import org.netbeans.modules.web.taglibed.model.TagVariableInfoData;
import org.netbeans.modules.web.taglibed.view.TLDHelperNode;
import org.netbeans.modules.web.taglibed.view.TagAttributeNode;
import org.netbeans.modules.web.taglibed.view.TagNode;
import org.netbeans.modules.web.taglibed.view.TagVariableNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class TLDHelperChildren
extends Children.Keys {
    int type;
    TagLibraryInfoData taglib;
    TagInfoData tag;
    Node parentNode;
    TLDDataObject tldDo;
    private static final boolean debug = false;

    public TLDHelperChildren(int type, TLDDataObject tldDo) {
        this.setup(type, tldDo, null, null);
    }

    public TLDHelperChildren(int type, TLDDataObject tldDo, TagLibraryInfoData taglib, TagInfoData tag) {
        this.setup(type, tldDo, taglib, tag);
    }

    private void setup(int type, TLDDataObject tldDo, TagLibraryInfoData taglib, TagInfoData tag) {
        this.type = type;
        this.tldDo = tldDo;
        this.taglib = taglib;
        this.tag = tag;
    }

    public TagLibraryInfoData getTaglib() {
        if (this.taglib == null) {
            this.taglib = this.tldDo.getTaglib();
        }
        return this.taglib;
    }

    public void setTaglib(TagLibraryInfoData value) {
        this.taglib = value;
    }

    Node getParentNode() {
        if (this.parentNode == null) {
            this.parentNode = this.getNode();
        }
        return this.parentNode;
    }

    protected void addNotify() {
        this.refreshHelperChildren();
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
    }

    public void refreshHelperChildren() {
        Vector newKeys = null;
        if (this.type == 0) {
            TagLibraryInfoData taglib = this.getTaglib();
            if (taglib != null) {
                Vector tagsVector;
                newKeys = tagsVector = taglib.getTagsVector();
            }
        } else if (this.type == 2) {
            TagNode tagNode = (TagNode)this.getParentNode();
            newKeys = new Vector();
            if (!tagNode.hasHelperChildren()) {
                TagLibraryInfoData taglib = this.getTaglib();
                TLDHelperNode atts = new TLDHelperNode(3, this.tldDo, taglib, this.tag);
                tagNode.setCookieTldHelperNode_Attributes(atts);
                newKeys.addElement(atts);
                atts.refreshChildren();
                tagNode.setHasHelperChildren(true);
                TLDHelperNode vars = new TLDHelperNode(5, this.tldDo, taglib, this.tag);
                tagNode.setCookieTldHelperNode_Variables(vars);
                newKeys.addElement(vars);
                vars.refreshChildren();
            } else {
                TLDHelperNode atts = tagNode.getCookieTldHelperNode_Attributes();
                newKeys.addElement(atts);
                atts.refreshChildren();
                TLDHelperNode vars = tagNode.getCookieTldHelperNode_Variables();
                newKeys.addElement(vars);
                vars.refreshChildren();
            }
        } else if (this.type == 3) {
            Vector attributesVector;
            newKeys = attributesVector = this.tag.getAttributesVector();
        } else if (this.type == 5) {
            Vector variablesVector;
            newKeys = variablesVector = this.tag.getVariablesVector();
        }
        if (newKeys == null || newKeys.size() == 0) {
            this.setKeys(Collections.EMPTY_SET);
        } else {
            this.setKeys(newKeys);
        }
    }

    public TagNode findTagNodeInChildren(TagInfoData tag, Children keys) {
        Enumeration nodes = keys.nodes();
        while (nodes.hasMoreElements()) {
            TagNode tn = (TagNode)((Object)nodes.nextElement());
            if (tn.getTag() != tag) continue;
            return tn;
        }
        return null;
    }

    public TagAttributeNode findTagAttributeNodeInChildren(TagAttributeInfoData tagatt, Children keys) {
        Node[] nodes = keys.getNodes();
        int i = 0;
        while (i < nodes.length) {
            TagAttributeNode tn = (TagAttributeNode)nodes[i];
            if (tn.getTagAttribute() == tagatt) {
                return tn;
            }
            ++i;
        }
        return null;
    }

    public TagVariableNode findTagVariableNodeInChildren(TagVariableInfoData tagvar, Children keys) {
        Node[] nodes = keys.getNodes();
        int i = 0;
        while (i < nodes.length) {
            TagVariableNode tn = (TagVariableNode)nodes[i];
            if (tn.getTagVariable() == tagvar) {
                return tn;
            }
            ++i;
        }
        return null;
    }

    public void refreshChildren() {
        super.refresh();
    }

    protected Node[] createNodes(Object key) {
        TagLibraryInfoData taglib = this.getTaglib();
        Node[] nodes = null;
        if (key instanceof TagInfoData) {
            nodes = new Node[]{new TagNode(this.tldDo, taglib, (TagInfoData)key)};
        }
        if (key instanceof TagAttributeInfoData) {
            nodes = new Node[]{new TagAttributeNode(this.tldDo, taglib, this.tag, (TagAttributeInfoData)key)};
        }
        if (key instanceof TagVariableInfoData) {
            nodes = new Node[]{new TagVariableNode(this.tldDo, taglib, this.tag, (TagVariableInfoData)key)};
        }
        if (key instanceof TLDHelperNode) {
            nodes = new Node[]{(Node)key};
        }
        return nodes;
    }
}

