/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglibed.view;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Vector;
import org.netbeans.modules.web.taglibed.control.IDEHelper;
import org.netbeans.modules.web.taglibed.control.TagLibraryCookie;
import org.netbeans.modules.web.taglibed.control.TldActionSupport;
import org.netbeans.modules.web.taglibed.model.TagAttributeInfoData;
import org.netbeans.modules.web.taglibed.view.TagAttPanel;
import org.netbeans.modules.web.taglibed.view.TldCustomizer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class TagAttributeCustomizer
extends TldCustomizer {
    TagAttPanel tagattPanel;
    private NameChangeListener nameChangeListener;
    private TagAttributeInfoData theTagAttribute;
    static TagAttributeCustomizer sharedCustomizer;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$TLDLoader;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$control$TldActionSupport;

    public TagAttributeCustomizer(String title, Component component, boolean global, boolean isModal, int isCustomizerOrAddDialog) {
        super(title, component, global, isModal, isCustomizerOrAddDialog);
        this.tagattPanel = (TagAttPanel)component;
        this.initWindowListener();
    }

    public static TagAttributeCustomizer createCustomizerDialog(String title, TagAttributeInfoData tagatt, boolean global, boolean modal) {
        if (tagatt != null) {
            if (title == null) {
                title = IDEHelper.getString("TLD_TagAttributeCustomizer.title", tagatt.getName());
            }
            TagAttPanel panel = new TagAttPanel(tagatt);
            TagAttributeCustomizer dialog = new TagAttributeCustomizer(title, panel, global, modal, 0);
            dialog.tagattPanel.load(tagatt);
            dialog.previousChangesDiscarded = false;
            dialog.theTagAttribute = tagatt;
            dialog.nameChangeListener = dialog.createNameChangeListener();
            tagatt.addPropertyChangeListener(dialog.nameChangeListener);
            return dialog;
        }
        return null;
    }

    public static TagAttributeCustomizer createAddDialog(String title, TagAttributeInfoData tagatt) {
        if (tagatt != null) {
            if (title == null) {
                title = IDEHelper.getString("TLD_TagAttributeCustomizer.addTagAttributeTitle", tagatt.getName());
            }
            TagAttPanel panel = new TagAttPanel(tagatt);
            boolean global = false;
            boolean modal = true;
            TagAttributeCustomizer dialog = new TagAttributeCustomizer(title, panel, global, modal, 1);
            dialog.tagattPanel.load(tagatt);
            dialog.previousChangesDiscarded = false;
            dialog.theTagAttribute = tagatt;
            dialog.nameChangeListener = dialog.createNameChangeListener();
            tagatt.addPropertyChangeListener(dialog.nameChangeListener);
            return dialog;
        }
        return null;
    }

    public HelpCtx getHelpCtx() {
        String helpID = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDLoader == null ? (class$org$netbeans$modules$web$taglibed$TLDLoader = TagAttributeCustomizer.class$("org.netbeans.modules.web.taglibed.TLDLoader")) : class$org$netbeans$modules$web$taglibed$TLDLoader)).getString("TLD_TagAttributeCustomizer.Help_ID");
        return new HelpCtx(helpID);
    }

    void initWindowListener() {
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TagAttributeCustomizer.this.ensureNoUnappliedChanges();
                ((Component)TagAttributeCustomizer.this.dialog).setVisible(false);
                TagAttributeCustomizer.this.dialog.dispose();
            }

            public void windowClosed(WindowEvent e) {
                if (TagAttributeCustomizer.this.theTagAttribute != null && TagAttributeCustomizer.this.nameChangeListener != null) {
                    TagAttributeCustomizer.this.theTagAttribute.removePropertyChangeListener(TagAttributeCustomizer.this.nameChangeListener);
                }
                if (TagAttributeCustomizer.this.tagattPanel != null) {
                    TagAttributeCustomizer.this.tagattPanel.removePropertyChangeListener();
                }
                if (TagAttributeCustomizer.this.global && sharedCustomizer != null) {
                    sharedCustomizer = null;
                }
            }
        });
    }

    public boolean load(TldActionSupport cookie, Node n) {
        if (cookie != null && cookie.getType() == 4) {
            TagAttributeInfoData newTagatt = cookie.getTagAttribute();
            if (this.theTagAttribute != newTagatt && (this.previousChangesDiscarded || this.ensureNoUnappliedChanges(this.theTagAttribute))) {
                this.tagattPanel.load(cookie.getTagAttribute());
                this.previousChangesDiscarded = false;
                this.updateTitle(n);
                if (this.theTagAttribute != null && this.nameChangeListener != null) {
                    this.theTagAttribute.removePropertyChangeListener(this.nameChangeListener);
                }
                this.theTagAttribute = newTagatt;
                this.initListener();
                this.theTagAttribute.addPropertyChangeListener(this.nameChangeListener);
            }
            return true;
        }
        return false;
    }

    public boolean ensureNoUnappliedChanges() {
        return this.ensureNoUnappliedChanges(this.theTagAttribute);
    }

    public boolean ensureNoUnappliedChanges(TagAttributeInfoData theTagatt) {
        Vector unappliedChangeList = this.tagattPanel.getUnappliedChangeList(theTagatt);
        if (unappliedChangeList == null) {
            return true;
        }
        String name = theTagatt.getName();
        String title = IDEHelper.getString("TLD_TagAttributeCustomizer.Apply_or_discard_title", name);
        String preamble = IDEHelper.getString("TLD_TagAttributeCustomizer.Apply_or_discard_preamble", name);
        boolean applyUnappliedChanges = IDEHelper.askWhetherToApplyUnappliedChanges(unappliedChangeList, preamble, title);
        if (applyUnappliedChanges) {
            if (this.validate()) {
                this.tagattPanel.apply();
                return true;
            }
            this.bringUpStaticCustomizer(theTagatt);
            return true;
        }
        this.previousChangesDiscarded = true;
        return true;
    }

    public void bringUpStaticCustomizer(TagAttributeInfoData tagatt) {
        String title = IDEHelper.getString("TLD_TagAttributeCustomizer.UnappliedChange_Invalid_Title", tagatt.getName());
        boolean isModal = true;
        boolean isGlobal = false;
        TagAttributeCustomizer staticCustomizer = TagAttributeCustomizer.createCustomizerDialog(title, tagatt, isGlobal, isModal);
        this.tagattPanel.transferValuesTo((TagAttPanel)staticCustomizer.getComponent());
        staticCustomizer.open(isModal);
    }

    public static TagAttributeCustomizer getDefault(TagLibraryCookie cookie) {
        return TagAttributeCustomizer.getDefault(cookie.getTagAttribute());
    }

    public static TagAttributeCustomizer getDefault(TagAttributeInfoData tagatt) {
        if (sharedCustomizer == null) {
            boolean global = true;
            boolean modal = false;
            sharedCustomizer = TagAttributeCustomizer.createCustomizerDialog(null, tagatt, global, modal);
        }
        TagAttributeInfoData oldatt = sharedCustomizer.getTagAttribute();
        NameChangeListener l = sharedCustomizer.getListener();
        if (oldatt != null && l != null) {
            oldatt.removePropertyChangeListener(l);
        }
        TagAttPanel p = (TagAttPanel)sharedCustomizer.getComponent();
        p.load(tagatt);
        TagAttributeCustomizer.sharedCustomizer.previousChangesDiscarded = false;
        sharedCustomizer.initListener();
        l = sharedCustomizer.getListener();
        tagatt.addPropertyChangeListener(l);
        sharedCustomizer.setTagAttribute(tagatt);
        sharedCustomizer.updateTitle(tagatt);
        return sharedCustomizer;
    }

    private void updateTitle(Node node) {
        MessageFormat msgFormat = new MessageFormat(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDLoader == null ? (class$org$netbeans$modules$web$taglibed$TLDLoader = TagAttributeCustomizer.class$("org.netbeans.modules.web.taglibed.TLDLoader")) : class$org$netbeans$modules$web$taglibed$TLDLoader)).getString("TLD_TagAttributeCustomizer.title"));
        Object[] obj = new Object[]{node.getName()};
        this.dialog.setTitle(msgFormat.format(obj));
    }

    private void updateTitle(TagAttributeInfoData tagatt) {
        String title = IDEHelper.getString("TLD_TagAttributeCustomizer.title", tagatt.getName());
        this.dialog.setTitle(title);
    }

    private void updateTitle() {
        MessageFormat msgFormat = new MessageFormat(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDLoader == null ? (class$org$netbeans$modules$web$taglibed$TLDLoader = TagAttributeCustomizer.class$("org.netbeans.modules.web.taglibed.TLDLoader")) : class$org$netbeans$modules$web$taglibed$TLDLoader)).getString("TLD_TagAttributeCustomizer.title"));
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (nodes != null && nodes.length > 0) {
            int i = 0;
            while (i < nodes.length) {
                TldActionSupport cookie = (TldActionSupport)nodes[i].getCookie(class$org$netbeans$modules$web$taglibed$control$TldActionSupport == null ? TagAttributeCustomizer.class$("org.netbeans.modules.web.taglibed.control.TldActionSupport") : class$org$netbeans$modules$web$taglibed$control$TldActionSupport);
                if (cookie != null && cookie.getType() == 4) {
                    Object[] obj = new Object[]{nodes[i].getName()};
                    this.dialog.setTitle(msgFormat.format(obj));
                    break;
                }
                ++i;
            }
        }
    }

    protected void notifyClosing() {
        if (this.global) {
            TagAttPanel p = (TagAttPanel)sharedCustomizer.getComponent();
            p.removePropertyChangeListener();
            this.removePropertyChangeListener();
            sharedCustomizer = null;
        }
    }

    protected boolean validate() {
        TagAttPanel p = (TagAttPanel)this.getComponent();
        return p.validateProperties();
    }

    protected void createObject() {
    }

    TagAttributeInfoData getTagAttribute() {
        return this.theTagAttribute;
    }

    void setTagAttribute(TagAttributeInfoData att) {
        this.theTagAttribute = att;
    }

    NameChangeListener getListener() {
        return this.nameChangeListener;
    }

    void initListener() {
        if (this.nameChangeListener == null) {
            this.nameChangeListener = new NameChangeListener();
        }
    }

    public NameChangeListener createNameChangeListener() {
        return new NameChangeListener();
    }

    public static TagAttributeCustomizer getCustomizer() {
        return sharedCustomizer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class NameChangeListener
    implements PropertyChangeListener {
        NameChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String pname = evt.getPropertyName();
            if (pname.equals("AttributeName")) {
                String title = TagAttributeCustomizer.this.global ? IDEHelper.getString("TLD_TagAttributeCustomizer.title", evt.getNewValue()) : IDEHelper.getString("TLD_TagAttributeCustomizer.title", evt.getNewValue());
                TagAttributeCustomizer.this.dialog.setTitle(title);
            }
        }
    }
}

