/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglibed.view;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import org.netbeans.modules.web.taglibed.TLDDataObject;
import org.netbeans.modules.web.taglibed.control.PropertyView;
import org.netbeans.modules.web.taglibed.control.TldActionSupport;
import org.netbeans.modules.web.taglibed.model.TagAttributeInfoData;
import org.netbeans.modules.web.taglibed.model.TagInfoData;
import org.netbeans.modules.web.taglibed.model.TagLibraryInfoData;
import org.netbeans.modules.web.taglibed.view.TLDHelperChildren;
import org.netbeans.modules.web.taglibed.view.TLDHelperNode;
import org.netbeans.modules.web.taglibed.view.TLDNode;
import org.netbeans.modules.web.taglibed.view.TLDTransferable;
import org.netbeans.modules.web.taglibed.view.TagAttributeCustomizer;
import org.netbeans.modules.web.taglibed.view.TagNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class TagAttributeNode
extends AbstractNode {
    private int tagIndex;
    private TLDDataObject tldDo;
    private TagLibraryInfoData taglib;
    private TagInfoData tag;
    private TagAttributeInfoData tagatt;
    private NameChangeListener nameChangeListener;
    private TagNode tagNode;
    private TLDNode tldNode;
    private TLDHelperNode parentNode;
    private static final boolean debug = false;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$TLDLoader;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$control$GlobalTaglibAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;

    public TagAttributeNode(TLDDataObject tldDo, TagLibraryInfoData taglib, TagInfoData tag, TagAttributeInfoData tagatt) {
        super(Children.LEAF);
        this.tldDo = tldDo;
        this.taglib = taglib;
        this.tag = tag;
        this.tagatt = tagatt;
        this.initialize();
    }

    public TagNode getTagNode() {
        if (this.tagNode == null) {
            this.findParentNodes();
        }
        return this.tagNode;
    }

    public TLDNode getTLDNode() {
        if (this.tldNode == null) {
            this.findParentNodes();
        }
        return this.tldNode;
    }

    public void findParentNodes() {
        this.parentNode = (TLDHelperNode)this.getParentNode();
        if (this.parentNode != null) {
            this.tagNode = (TagNode)this.parentNode.getParentNode();
            if (this.tagNode != null) {
                this.tldNode = (TLDNode)this.tagNode.getParentNode();
            }
        }
    }

    private void initialize() {
        this.setIconBase(this.getIconBase());
        this.findParentNodes();
        this.refreshName();
        TldActionSupport cookie = new TldActionSupport(4, this.tldDo, this.taglib, this.tag, this.tagatt);
        cookie.setTagAttributeNode(this);
        this.getCookieSet().add((Node.Cookie)cookie);
        PropertyView.getInstance().getSupport().updateTagAttributeCustomizer(this.taglib, this.tagatt);
        this.nameChangeListener = new NameChangeListener(this, this.tagatt);
        this.tagatt.addPropertyChangeListener(this.nameChangeListener);
        this.addNodeListener((NodeListener)new NodeAdapter(){

            public void nodeDestroyed(NodeEvent ev) {
                if (TagAttributeNode.this.parentNode != null) {
                    TLDHelperChildren siblings = (TLDHelperChildren)TagAttributeNode.this.parentNode.getChildren();
                    siblings.refreshHelperChildren();
                }
                if (TagAttributeNode.this.tagNode != null) {
                    TagAttributeNode.this.tagNode.refreshName();
                }
            }
        });
        TopComponent.getRegistry().addPropertyChangeListener(new PropertyChangeListener(){
            static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$control$TldActionSupport;

            public void propertyChange(PropertyChangeEvent evt) {
                Node[] nodes;
                if ("activatedNodes".equals(evt.getPropertyName()) && (nodes = TopComponent.getRegistry().getActivatedNodes()) != null) {
                    int i = 0;
                    while (i < nodes.length) {
                        TldActionSupport ck = (TldActionSupport)nodes[i].getCookie(class$org$netbeans$modules$web$taglibed$control$TldActionSupport == null ? 2.class$("org.netbeans.modules.web.taglibed.control.TldActionSupport") : class$org$netbeans$modules$web$taglibed$control$TldActionSupport);
                        if (ck != null && ck.getTagAttributeNode() == TagAttributeNode.this) {
                            TagAttributeNode.this.findParentNodes();
                            break;
                        }
                        ++i;
                    }
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
    }

    public TagAttributeInfoData getTagAttribute() {
        return this.tagatt;
    }

    public void refreshName() {
        String name = this.tagatt.getName();
        this.setName(name);
        this.setToolTip(this.getToolTip(name));
        TagNode tagNode = this.getTagNode();
        if (tagNode != null) {
            tagNode.refreshName();
        }
    }

    void setToolTip(String tip) {
        this.setShortDescription(tip);
    }

    String getToolTip(String name) {
        String tooltipResource = "TLD_TagAttributeNode.ToolTip";
        MessageFormat msgFormat = new MessageFormat(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDLoader == null ? (class$org$netbeans$modules$web$taglibed$TLDLoader = TagAttributeNode.class$("org.netbeans.modules.web.taglibed.TLDLoader")) : class$org$netbeans$modules$web$taglibed$TLDLoader)).getString(tooltipResource));
        Object[] obj = new Object[]{name};
        return msgFormat.format(obj);
    }

    protected String getIconBase() {
        return TLDNode.getIconBase(4);
    }

    public SystemAction getDefaultAction() {
        return SystemAction.get((Class)(class$org$netbeans$modules$web$taglibed$control$GlobalTaglibAction == null ? (class$org$netbeans$modules$web$taglibed$control$GlobalTaglibAction = TagAttributeNode.class$("org.netbeans.modules.web.taglibed.control.GlobalTaglibAction")) : class$org$netbeans$modules$web$taglibed$control$GlobalTaglibAction));
    }

    protected SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = TagAttributeNode.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = TagAttributeNode.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = TagAttributeNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$web$taglibed$control$GlobalTaglibAction == null ? (class$org$netbeans$modules$web$taglibed$control$GlobalTaglibAction = TagAttributeNode.class$("org.netbeans.modules.web.taglibed.control.GlobalTaglibAction")) : class$org$netbeans$modules$web$taglibed$control$GlobalTaglibAction))};
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        if (this.tag != null && this.tagatt != null) {
            this.tag.deleteAttribute(this.tagatt);
        }
        super.destroy();
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        TagAttributeCustomizer c = TagAttributeCustomizer.getDefault(this.tagatt);
        return c.getDialog();
    }

    public Transferable clipboardCopy() throws IOException {
        return new TLDTransferable(TLDTransferable.tldAttributeCopyFlavor, (Node)this);
    }

    public Transferable clipboardCut() throws IOException {
        return new TLDTransferable(TLDTransferable.tldAttributeCutFlavor, (Node)this);
    }

    public boolean canCut() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("ctx_tagattcust");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class NameChangeListener
    implements PropertyChangeListener {
        TagAttributeNode tagattNode;
        TagAttributeInfoData tagatt;

        public NameChangeListener(TagAttributeNode tagattNode, TagAttributeInfoData tagatt) {
            this.tagattNode = tagattNode;
            this.tagatt = tagatt;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.tagattNode.refreshName();
        }
    }
}

