/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglibed.view;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import org.netbeans.modules.web.taglibed.control.IDEHelper;
import org.netbeans.modules.web.taglibed.control.TagLibraryCookie;
import org.netbeans.modules.web.taglibed.control.TldActionSupport;
import org.netbeans.modules.web.taglibed.model.TagInfoData;
import org.netbeans.modules.web.taglibed.view.TagPanel;
import org.netbeans.modules.web.taglibed.view.TldCustomizer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class TagCustomizer
extends TldCustomizer {
    TagPanel tagPanel;
    private TagInfoData theTag;
    private NameChangeListener nameChangeListener;
    static TagCustomizer sharedCustomizer;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$TLDLoader;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$control$TldActionSupport;

    public TagCustomizer(String title, Component component, boolean global, boolean isModal, int isCustomizerOrAddDialog) {
        super(title, component, global, isModal, isCustomizerOrAddDialog);
        this.tagPanel = (TagPanel)component;
        this.initWindowListener();
    }

    public static TagCustomizer createCustomizerDialog(String title, TagInfoData tag, boolean global, boolean modal) {
        if (tag != null) {
            if (title == null) {
                title = IDEHelper.getString("TLD_TagCustomizer.title", tag.getTagName());
            }
            TagPanel panel = new TagPanel(tag);
            TagCustomizer cust = new TagCustomizer(title, panel, global, modal, 0);
            cust.tagPanel.load(tag);
            cust.previousChangesDiscarded = false;
            cust.theTag = tag;
            cust.nameChangeListener = cust.createNameChangeListener();
            tag.addPropertyChangeListener(cust.nameChangeListener);
            ResourceBundle resBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDLoader == null ? (class$org$netbeans$modules$web$taglibed$TLDLoader = TagCustomizer.class$("org.netbeans.modules.web.taglibed.TLDLoader")) : class$org$netbeans$modules$web$taglibed$TLDLoader));
            Dialog dialog = cust.getDialog();
            dialog.getAccessibleContext().setAccessibleDescription(resBundle.getString("ACS_TLD_TagPanel.DialogA11yDesc"));
            dialog.getAccessibleContext().setAccessibleName(resBundle.getString("ACS_TLD_TagPanel.DialogA11yName"));
            return cust;
        }
        return null;
    }

    public static TagCustomizer createAddDialog(String title, TagInfoData tag) {
        if (tag != null) {
            if (title == null) {
                title = IDEHelper.getString("TLD_TagCustomizer.addTagTitle", tag.getTagName());
            }
            TagPanel panel = new TagPanel(tag);
            boolean global = false;
            boolean modal = true;
            TagCustomizer addDialog = new TagCustomizer(title, panel, global, modal, 1);
            addDialog.tagPanel.load(tag);
            addDialog.previousChangesDiscarded = false;
            addDialog.theTag = tag;
            addDialog.nameChangeListener = addDialog.createNameChangeListener();
            tag.addPropertyChangeListener(addDialog.nameChangeListener);
            return addDialog;
        }
        return null;
    }

    public HelpCtx getHelpCtx() {
        String helpID = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDLoader == null ? (class$org$netbeans$modules$web$taglibed$TLDLoader = TagCustomizer.class$("org.netbeans.modules.web.taglibed.TLDLoader")) : class$org$netbeans$modules$web$taglibed$TLDLoader)).getString("TLD_TagCustomizer.Help_ID");
        return new HelpCtx(helpID);
    }

    void initWindowListener() {
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TagCustomizer.this.ensureNoUnappliedChanges();
                ((Component)TagCustomizer.this.dialog).setVisible(false);
                TagCustomizer.this.dialog.dispose();
            }

            public void windowClosed(WindowEvent e) {
                TagPanel panel = (TagPanel)TagCustomizer.this.getComponent();
                if (TagCustomizer.this.theTag != null && TagCustomizer.this.nameChangeListener != null) {
                    TagCustomizer.this.theTag.removePropertyChangeListener(TagCustomizer.this.nameChangeListener);
                }
                if (panel != null) {
                    panel.removePropertyChangeListener();
                }
                if (TagCustomizer.this.global && sharedCustomizer != null) {
                    panel = (TagPanel)sharedCustomizer.getComponent();
                    if (panel != null) {
                        panel.removePropertyChangeListener();
                    }
                    sharedCustomizer = null;
                }
            }
        });
    }

    public boolean load(TldActionSupport cookie, Node n) {
        if (cookie != null && cookie.getType() == 2) {
            TagInfoData newTag = cookie.getTag();
            if (this.theTag != newTag && (this.previousChangesDiscarded || this.ensureNoUnappliedChanges(this.theTag))) {
                this.tagPanel.load(newTag);
                this.previousChangesDiscarded = false;
                this.updateTitle(cookie);
                if (this.theTag != null && this.nameChangeListener != null) {
                    this.theTag.removePropertyChangeListener(this.nameChangeListener);
                }
                this.theTag = newTag;
                this.initListener();
                this.theTag.addPropertyChangeListener(this.nameChangeListener);
            }
            return true;
        }
        return false;
    }

    public boolean ensureNoUnappliedChanges() {
        return this.ensureNoUnappliedChanges(this.theTag);
    }

    public boolean ensureNoUnappliedChanges(TagInfoData tag) {
        Vector unappliedChangeList = this.tagPanel.getUnappliedChangeList(tag);
        if (unappliedChangeList == null) {
            return true;
        }
        String tagName = tag.getTagName();
        String title = IDEHelper.getString("TLD_TagCustomizer.Apply_or_discard_title", tagName);
        String preamble = IDEHelper.getString("TLD_TagCustomizer.Apply_or_discard_preamble", tagName);
        boolean applyUnappliedChanges = IDEHelper.askWhetherToApplyUnappliedChanges(unappliedChangeList, preamble, title);
        if (applyUnappliedChanges) {
            if (this.validate()) {
                this.tagPanel.apply();
                return true;
            }
            this.bringUpStaticCustomizer(tag);
            return true;
        }
        this.previousChangesDiscarded = true;
        return true;
    }

    public void bringUpStaticCustomizer(TagInfoData tag) {
        String title = IDEHelper.getString("TLD_TagCustomizer.UnappliedChange_Invalid_Title", tag.getTagName());
        boolean isModal = true;
        boolean isGlobal = false;
        TagCustomizer staticCustomizer = TagCustomizer.createCustomizerDialog(title, tag, isGlobal, isModal);
        this.tagPanel.transferValuesTo((TagPanel)staticCustomizer.getComponent());
        staticCustomizer.open(isModal);
    }

    public static TagCustomizer getDefault(TagLibraryCookie cookie) {
        return TagCustomizer.getDefault(cookie.getTag());
    }

    public static TagCustomizer getDefault(TagInfoData tag) {
        if (sharedCustomizer == null) {
            boolean global = true;
            boolean modal = false;
            sharedCustomizer = TagCustomizer.createCustomizerDialog(null, tag, global, modal);
        }
        NameChangeListener l = sharedCustomizer.getListener();
        TagInfoData oldtag = sharedCustomizer.getTag();
        if (oldtag != null && l != null) {
            oldtag.removePropertyChangeListener(l);
        }
        TagPanel p = (TagPanel)sharedCustomizer.getComponent();
        p.load(tag);
        TagCustomizer.sharedCustomizer.previousChangesDiscarded = false;
        sharedCustomizer.initListener();
        l = sharedCustomizer.getListener();
        tag.addPropertyChangeListener(l);
        sharedCustomizer.setTag(tag);
        sharedCustomizer.updateTitle(tag);
        return sharedCustomizer;
    }

    private void updateTitle(TldActionSupport cookie) {
        MessageFormat msgFormat = new MessageFormat(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDLoader == null ? (class$org$netbeans$modules$web$taglibed$TLDLoader = TagCustomizer.class$("org.netbeans.modules.web.taglibed.TLDLoader")) : class$org$netbeans$modules$web$taglibed$TLDLoader)).getString("TLD_TagCustomizer.title"));
        Object[] obj = new Object[]{cookie.getTag().getTagName()};
        this.dialog.setTitle(msgFormat.format(obj));
    }

    private void updateTitle(TagInfoData tag) {
        String title = IDEHelper.getString("TLD_TagCustomizer.title", tag.getTagName());
        this.dialog.setTitle(title);
    }

    private void updateTitle() {
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (nodes != null && nodes.length > 0) {
            int i = 0;
            while (i < nodes.length) {
                TldActionSupport cookie = (TldActionSupport)nodes[i].getCookie(class$org$netbeans$modules$web$taglibed$control$TldActionSupport == null ? TagCustomizer.class$("org.netbeans.modules.web.taglibed.control.TldActionSupport") : class$org$netbeans$modules$web$taglibed$control$TldActionSupport);
                if (cookie != null && cookie.getType() == 2) {
                    String title = IDEHelper.getString("TLD_TagCustomizer.title", cookie.getTag().getTagName());
                    this.dialog.setTitle(title);
                    break;
                }
                ++i;
            }
        }
    }

    protected void notifyClosing() {
        if (this.global) {
            TagPanel p = (TagPanel)sharedCustomizer.getComponent();
            p.removePropertyChangeListener();
            this.removePropertyChangeListener();
            sharedCustomizer = null;
        }
    }

    protected boolean validate() {
        TagPanel p = (TagPanel)this.getComponent();
        return p.validateProperties();
    }

    protected void createObject() {
    }

    TagInfoData getTag() {
        return this.theTag;
    }

    void setTag(TagInfoData tag) {
        this.theTag = tag;
    }

    NameChangeListener getListener() {
        return this.nameChangeListener;
    }

    void initListener() {
        if (this.nameChangeListener == null) {
            this.nameChangeListener = new NameChangeListener();
        }
    }

    public NameChangeListener createNameChangeListener() {
        return new NameChangeListener();
    }

    public static TagCustomizer getCustomizer() {
        return sharedCustomizer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class NameChangeListener
    implements PropertyChangeListener {
        NameChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String pname = evt.getPropertyName();
            if (pname.equals("TagName")) {
                String title = TagCustomizer.this.global ? IDEHelper.getString("TLD_TagCustomizer.title", evt.getNewValue()) : IDEHelper.getString("TLD_TagCustomizer.title", evt.getNewValue());
                TagCustomizer.this.dialog.setTitle(title);
            }
        }
    }
}

