/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglibed.view;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Vector;
import org.netbeans.modules.web.taglibed.control.IDEHelper;
import org.netbeans.modules.web.taglibed.control.TagLibraryCookie;
import org.netbeans.modules.web.taglibed.control.TldActionSupport;
import org.netbeans.modules.web.taglibed.model.TagVariableInfoData;
import org.netbeans.modules.web.taglibed.view.TagVariablePanel;
import org.netbeans.modules.web.taglibed.view.TldCustomizer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class TagVariableCustomizer
extends TldCustomizer {
    TagVariablePanel tagvarPanel;
    private NameChangeListener nameChangeListener;
    private TagVariableInfoData theTagVariable;
    static TagVariableCustomizer sharedCustomizer;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$TLDLoader;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$control$TldActionSupport;

    public TagVariableCustomizer(String title, Component component, boolean global, boolean isModal, int isCustomizerOrAddDialog) {
        super(title, component, global, isModal, isCustomizerOrAddDialog);
        this.tagvarPanel = (TagVariablePanel)component;
        this.initWindowListener();
    }

    public static TagVariableCustomizer createCustomizerDialog(String title, TagVariableInfoData tagvar, boolean global, boolean modal) {
        if (tagvar != null) {
            if (title == null) {
                title = IDEHelper.getString("TLD_TagVariableCustomizer.title", tagvar.getName());
            }
            TagVariablePanel panel = new TagVariablePanel(tagvar);
            TagVariableCustomizer dialog = new TagVariableCustomizer(title, panel, global, modal, 0);
            dialog.tagvarPanel.load(tagvar);
            dialog.previousChangesDiscarded = false;
            dialog.theTagVariable = tagvar;
            dialog.nameChangeListener = dialog.createNameChangeListener();
            tagvar.addPropertyChangeListener(dialog.nameChangeListener);
            return dialog;
        }
        return null;
    }

    public static TagVariableCustomizer createAddDialog(String title, TagVariableInfoData tagvar) {
        if (tagvar != null) {
            if (title == null) {
                title = IDEHelper.getString("TLD_TagVariableCustomizer.addTagVariableTitle", tagvar.getName());
            }
            TagVariablePanel panel = new TagVariablePanel(tagvar);
            boolean global = false;
            boolean modal = true;
            TagVariableCustomizer dialog = new TagVariableCustomizer(title, panel, global, modal, 1);
            dialog.tagvarPanel.load(tagvar);
            dialog.previousChangesDiscarded = false;
            dialog.theTagVariable = tagvar;
            dialog.nameChangeListener = dialog.createNameChangeListener();
            tagvar.addPropertyChangeListener(dialog.nameChangeListener);
            return dialog;
        }
        return null;
    }

    public HelpCtx getHelpCtx() {
        String helpID = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDLoader == null ? (class$org$netbeans$modules$web$taglibed$TLDLoader = TagVariableCustomizer.class$("org.netbeans.modules.web.taglibed.TLDLoader")) : class$org$netbeans$modules$web$taglibed$TLDLoader)).getString("TLD_TagVariableCustomizer.Help_ID");
        return new HelpCtx(helpID);
    }

    void initWindowListener() {
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TagVariableCustomizer.this.ensureNoUnappliedChanges();
                ((Component)TagVariableCustomizer.this.dialog).setVisible(false);
                TagVariableCustomizer.this.dialog.dispose();
            }

            public void windowClosed(WindowEvent e) {
                TagVariablePanel panel;
                if (TagVariableCustomizer.this.theTagVariable != null && TagVariableCustomizer.this.nameChangeListener != null) {
                    TagVariableCustomizer.this.theTagVariable.removePropertyChangeListener(TagVariableCustomizer.this.nameChangeListener);
                }
                if ((panel = (TagVariablePanel)TagVariableCustomizer.this.getComponent()) != null) {
                    panel.removePropertyChangeListener();
                }
                if (TagVariableCustomizer.this.global && sharedCustomizer != null) {
                    sharedCustomizer = null;
                }
            }
        });
    }

    public boolean load(TldActionSupport cookie, Node n) {
        if (cookie != null && cookie.getType() == 6) {
            TagVariableInfoData newTagvar = cookie.getTagVariable();
            if (this.theTagVariable != newTagvar && (this.previousChangesDiscarded || this.ensureNoUnappliedChanges(this.theTagVariable))) {
                this.tagvarPanel.load(newTagvar);
                this.previousChangesDiscarded = false;
                this.updateTitle(n);
                if (this.theTagVariable != null && this.nameChangeListener != null) {
                    this.theTagVariable.removePropertyChangeListener(this.nameChangeListener);
                }
                this.theTagVariable = newTagvar;
                this.initListener();
                this.theTagVariable.addPropertyChangeListener(this.nameChangeListener);
            }
            return true;
        }
        return false;
    }

    public boolean ensureNoUnappliedChanges() {
        return this.ensureNoUnappliedChanges(this.theTagVariable);
    }

    public boolean ensureNoUnappliedChanges(TagVariableInfoData theTagvar) {
        Vector unappliedChangeList = this.tagvarPanel.getUnappliedChangeList(theTagvar);
        if (unappliedChangeList == null) {
            return true;
        }
        String name = theTagvar.getName();
        String title = IDEHelper.getString("TLD_TagVariableCustomizer.Apply_or_discard_title", name);
        String preamble = IDEHelper.getString("TLD_TagVariableCustomizer.Apply_or_discard_preamble", name);
        boolean applyUnappliedChanges = IDEHelper.askWhetherToApplyUnappliedChanges(unappliedChangeList, preamble, title);
        if (applyUnappliedChanges) {
            if (this.validate()) {
                this.tagvarPanel.apply();
                return true;
            }
            this.bringUpStaticCustomizer(theTagvar);
            return true;
        }
        this.previousChangesDiscarded = true;
        return true;
    }

    public void bringUpStaticCustomizer(TagVariableInfoData tagvar) {
        String title = IDEHelper.getString("TLD_TagVariableCustomizer.UnappliedChange_Invalid_Title", tagvar.getName());
        boolean isModal = true;
        boolean isGlobal = false;
        TagVariableCustomizer staticCustomizer = TagVariableCustomizer.createCustomizerDialog(title, tagvar, isGlobal, isModal);
        this.tagvarPanel.transferValuesTo((TagVariablePanel)staticCustomizer.getComponent());
        staticCustomizer.open(isModal);
    }

    public static TagVariableCustomizer getDefault(TagLibraryCookie cookie) {
        return TagVariableCustomizer.getDefault(cookie.getTagVariable());
    }

    public static TagVariableCustomizer getDefault(TagVariableInfoData tagvar) {
        if (sharedCustomizer == null) {
            boolean global = true;
            boolean modal = false;
            sharedCustomizer = TagVariableCustomizer.createCustomizerDialog(null, tagvar, global, modal);
        }
        TagVariableInfoData oldvar = sharedCustomizer.getTagVariable();
        NameChangeListener l = sharedCustomizer.getListener();
        if (oldvar != null && l != null) {
            oldvar.removePropertyChangeListener(l);
        }
        TagVariablePanel p = (TagVariablePanel)sharedCustomizer.getComponent();
        p.load(tagvar);
        TagVariableCustomizer.sharedCustomizer.previousChangesDiscarded = false;
        sharedCustomizer.initListener();
        l = sharedCustomizer.getListener();
        tagvar.addPropertyChangeListener(l);
        sharedCustomizer.setTagVariable(tagvar);
        sharedCustomizer.updateTitle(tagvar);
        return sharedCustomizer;
    }

    private void updateTitle(Node node) {
        MessageFormat msgFormat = new MessageFormat(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDLoader == null ? (class$org$netbeans$modules$web$taglibed$TLDLoader = TagVariableCustomizer.class$("org.netbeans.modules.web.taglibed.TLDLoader")) : class$org$netbeans$modules$web$taglibed$TLDLoader)).getString("TLD_TagVariableCustomizer.title"));
        Object[] obj = new Object[]{node.getName()};
        this.dialog.setTitle(msgFormat.format(obj));
    }

    private void updateTitle(TagVariableInfoData tagvar) {
        String title = IDEHelper.getString("TLD_TagVariableCustomizer.title", tagvar.getName());
        this.dialog.setTitle(title);
    }

    private void updateTitle() {
        MessageFormat msgFormat = new MessageFormat(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDLoader == null ? (class$org$netbeans$modules$web$taglibed$TLDLoader = TagVariableCustomizer.class$("org.netbeans.modules.web.taglibed.TLDLoader")) : class$org$netbeans$modules$web$taglibed$TLDLoader)).getString("TLD_TagVariableCustomizer.title"));
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (nodes != null && nodes.length > 0) {
            int i = 0;
            while (i < nodes.length) {
                TldActionSupport cookie = (TldActionSupport)nodes[i].getCookie(class$org$netbeans$modules$web$taglibed$control$TldActionSupport == null ? TagVariableCustomizer.class$("org.netbeans.modules.web.taglibed.control.TldActionSupport") : class$org$netbeans$modules$web$taglibed$control$TldActionSupport);
                if (cookie != null && cookie.getType() == 6) {
                    Object[] obj = new Object[]{nodes[i].getName()};
                    this.dialog.setTitle(msgFormat.format(obj));
                    break;
                }
                ++i;
            }
        }
    }

    protected void notifyClosing() {
        if (this.global) {
            TagVariablePanel p = (TagVariablePanel)sharedCustomizer.getComponent();
            p.removePropertyChangeListener();
            this.removePropertyChangeListener();
            sharedCustomizer = null;
        }
    }

    protected boolean validate() {
        TagVariablePanel p = (TagVariablePanel)this.getComponent();
        return p.validateProperties();
    }

    protected void createObject() {
    }

    TagVariableInfoData getTagVariable() {
        return this.theTagVariable;
    }

    void setTagVariable(TagVariableInfoData attvar) {
        this.theTagVariable = attvar;
    }

    NameChangeListener getListener() {
        return this.nameChangeListener;
    }

    void initListener() {
        if (this.nameChangeListener == null) {
            this.nameChangeListener = new NameChangeListener();
        }
    }

    public NameChangeListener createNameChangeListener() {
        return new NameChangeListener();
    }

    public static TagVariableCustomizer getCustomizer() {
        return sharedCustomizer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class NameChangeListener
    implements PropertyChangeListener {
        NameChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String pname = evt.getPropertyName();
            if (pname.equals("VariableName")) {
                String title = TagVariableCustomizer.this.global ? IDEHelper.getString("TLD_TagVariableCustomizer.title", evt.getNewValue()) : IDEHelper.getString("TLD_TagVariableCustomizer.title", evt.getNewValue());
                TagVariableCustomizer.this.dialog.setTitle(title);
            }
        }
    }
}

